/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.func.biz.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.data.api.dto.request.ConfigQueryReq;
import com.dtyunxi.yundt.cube.center.func.api.constants.AbilityConstants;
import com.dtyunxi.yundt.cube.center.func.api.dto.TreeDtoBase;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.BizExtImplValueReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.BizSpaceAbilityDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.BizSpaceAppInstanceRelationReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.BizSpaceConfigReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.BizSpaceConfigValueReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.BizSpaceCreateReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.BizSpaceModifyReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.BizSpaceQueryReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.BizSpaceReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.BizSpaceTreeReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.ConfigReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.SysParamValueReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.BizSpaceConfigValueRespDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.BizSpaceRespDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.BizSpaceTreeDto;
import com.dtyunxi.yundt.cube.center.func.api.exception.CenterDataExceptionCode;
import com.dtyunxi.yundt.cube.center.func.biz.service.IAbilityGroupService;
import com.dtyunxi.yundt.cube.center.func.biz.service.IBizExtensionService;
import com.dtyunxi.yundt.cube.center.func.biz.service.IBizSpaceService;
import com.dtyunxi.yundt.cube.center.func.biz.service.ISysParamService;
import com.dtyunxi.yundt.cube.center.func.biz.util.AssertUtil;
import com.dtyunxi.yundt.cube.center.func.biz.vo.BizSpaceAbilityVo;
import com.dtyunxi.yundt.cube.center.func.biz.vo.BizSpaceConfigVo;
import com.dtyunxi.yundt.cube.center.func.dao.das.AbilityConfigRelationDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.AbilityDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.AbilityGroupDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.BizExtImplDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.BizExtImplScopeDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.BizExtImplValueDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.BizExtensionDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.BizSpaceAbilityRelationDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.BizSpaceAppInstanceRelationDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.BizSpaceDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.ConfigScopeDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.GroupAbilityRelationDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.RBizSpaceAppInstanceDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.SysParamDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.SysParamItemDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.SysParamItemScopeDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.SysParamValueDas;
import com.dtyunxi.yundt.cube.center.func.dao.eo.AbilityConfigRelationEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.AbilityEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.AbilityGroupEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.BizExtImplEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.BizExtImplValueEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.BizExtensionEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.BizSpaceAbilityRelationEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.BizSpaceAppInstanceRelationEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.BizSpaceEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.ConfigScopeEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.GroupAbilityRelationEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.RBizSpaceAppInstanceEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.StdAbilityConfigRelationEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.StdBizExtImplEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.StdBizSpaceAbilityRelationEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.StdConfigScopeEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.StdGroupAbilityRelationEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.StdSysParamItemEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.SysParamEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.SysParamItemEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.SysParamValueEo;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class BizSpaceServiceImpl
implements IBizSpaceService {
    private final Logger logger = LoggerFactory.getLogger(BizSpaceServiceImpl.class);
    private static final String FORMAT = "[^\\u4E00-\\u9FA5\\uF900-\\uFA2D\\w-_]";
    @Resource
    private BizSpaceDas bizSpaceDas;
    @Resource
    private AbilityDas abilityDas;
    @Resource
    private SysParamDas sysParamDas;
    @Resource
    private SysParamItemDas sysParamItemDas;
    @Resource
    private BizExtensionDas bizExtensionDas;
    @Resource
    private BizExtImplDas bizExtImplDas;
    @Resource
    private BizSpaceAbilityRelationDas bizSpaceAbilityRelationDas;
    @Resource
    private ConfigScopeDas configScopeDas;
    @Resource
    private GroupAbilityRelationDas groupAbilityRelationDas;
    @Resource
    private AbilityConfigRelationDas abilityConfigRelationDas;
    @Resource
    private AbilityGroupDas abilityGroupDas;
    @Autowired
    private SysParamItemScopeDas sysParamItemScopeDas;
    @Resource
    private BizExtImplScopeDas bizExtImplScopeDas;
    @Resource
    private IAbilityGroupService iAbilityGroupService;
    @Resource
    private SysParamValueDas sysParamValueDas;
    @Resource
    private BizExtImplValueDas bizExtImplValueDas;
    @Resource
    private ISysParamService sysParamService;
    @Autowired
    private IBizExtensionService bizExtensionService;
    @Autowired
    private RBizSpaceAppInstanceDas rBizSpaceAppInstanceDas;
    @Resource
    private BizSpaceAppInstanceRelationDas bizSpaceAppInstanceRelationDas;
    @Resource
    private IContext context;
    @Resource
    private ICacheService cacheService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String addBizSpace(BizSpaceCreateReqDto bizSpaceCreateReqDto) {
        BizSpaceEo bizSpaceEo = new BizSpaceEo();
        bizSpaceEo.setCode(bizSpaceCreateReqDto.getCode());
        if (null != bizSpaceCreateReqDto.getTenantId()) {
            bizSpaceEo.setTenantId(bizSpaceCreateReqDto.getTenantId());
        } else {
            bizSpaceEo.setTenantId(this.context.tenantId());
        }
        AssertUtil.isTrue(this.bizSpaceDas.count((BaseEo)bizSpaceEo) == 0, CenterDataExceptionCode.DATA_DUPLICATE_ERROR.getMsg() + ": \u4e1a\u52a1\u7a7a\u95f4\u7f16\u7801\u91cd\u590d,\u8bf7\u91cd\u8f93");
        bizSpaceEo.setCode(null);
        bizSpaceEo.setName(bizSpaceCreateReqDto.getName());
        AssertUtil.isTrue(this.bizSpaceDas.count((BaseEo)bizSpaceEo) == 0, CenterDataExceptionCode.DATA_DUPLICATE_ERROR.getMsg() + ": \u4e1a\u52a1\u7a7a\u95f4\u540d\u79f0\u91cd\u590d,\u8bf7\u91cd\u8f93");
        DtoHelper.dto2Eo((BaseVo)bizSpaceCreateReqDto, (BaseEo)bizSpaceEo);
        if (null == bizSpaceCreateReqDto.getStatus()) {
            bizSpaceEo.setStatus(AbilityConstants.ENABLE);
        }
        if (StringUtils.isNotBlank((CharSequence)bizSpaceCreateReqDto.getExtension())) {
            bizSpaceEo.setExtension("");
        }
        this.bizSpaceDas.insert((BaseEo)bizSpaceEo);
        return bizSpaceEo.getCode();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyBizSpace(BizSpaceModifyReqDto bizSpaceModifyReqDto) {
        BizSpaceEo bizSpaceEo = new BizSpaceEo();
        List bizSpaceEos = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)bizSpaceModifyReqDto.getName())) {
            BizSpaceEo bizSpaceName = new BizSpaceEo();
            bizSpaceName.setName(bizSpaceModifyReqDto.getName());
            bizSpaceName.setTenantId(this.context.tenantId());
            bizSpaceEos = this.bizSpaceDas.select((BaseEo)bizSpaceName);
            if (CollectionUtils.isNotEmpty(bizSpaceEos)) {
                AssertUtil.isTrue(bizSpaceEos.size() == 1, CenterDataExceptionCode.DATA_DUPLICATE_ERROR.getMsg() + ":\u671f\u5f85\u6570\u636e\u4e00\u822c\u6709\u4e14\u53ea\u6709\u4e00\u6761");
                if (!((BizSpaceEo)bizSpaceEos.get(0)).getCode().equals(bizSpaceModifyReqDto.getCode())) {
                    throw new BizException(CenterDataExceptionCode.DATA_DUPLICATE_ERROR.getCode(), CenterDataExceptionCode.DATA_DUPLICATE_ERROR.getMsg() + ": \u4e1a\u52a1\u7a7a\u95f4\u540d\u79f0\u91cd\u590d,\u8bf7\u91cd\u8f93");
                }
            }
        }
        bizSpaceEo.setTenantId(this.context.tenantId());
        bizSpaceEo.setCode(bizSpaceModifyReqDto.getCode());
        bizSpaceEos = this.bizSpaceDas.select((BaseEo)bizSpaceEo);
        if (!CollectionUtils.isNotEmpty(bizSpaceEos)) {
            throw new BizException(CenterDataExceptionCode.RECORD_NOT_EXISTS.getCode(), CenterDataExceptionCode.RECORD_NOT_EXISTS.getMsg());
        }
        AssertUtil.isTrue(bizSpaceEos.size() == 1, CenterDataExceptionCode.DATA_DUPLICATE_ERROR.getMsg() + ":\u671f\u5f85\u6570\u636e\u4e00\u822c\u6709\u4e14\u53ea\u6709\u4e00\u6761");
        bizSpaceEo.setId(((BizSpaceEo)bizSpaceEos.get(0)).getId());
        DtoHelper.dto2Eo((BaseVo)bizSpaceModifyReqDto, (BaseEo)bizSpaceEo, (String[])new String[]{"code", "id"});
        this.bizSpaceDas.updateSelective((BaseEo)bizSpaceEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeBizSpace(BizSpaceReqDto bizSpaceReqDto) {
        AssertUtil.isTrue(null != bizSpaceReqDto.getCode(), CenterDataExceptionCode.PARAM_INVALID.getMsg() + "\uff1a\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        BizSpaceEo bizSpaceEo = new BizSpaceEo();
        DtoHelper.dto2Eo((BaseVo)bizSpaceReqDto, (BaseEo)bizSpaceEo);
        this.bizSpaceDas.logicDelete((BaseEo)bizSpaceEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void setBizSpaceConfig(BizSpaceConfigReqDto bizSpaceConfigReqDto) {
        bizSpaceConfigReqDto.setTenantId(this.context.tenantId());
        this.checkBizSpaceConfig(bizSpaceConfigReqDto);
        String bizSpaceCode = bizSpaceConfigReqDto.getBizSpaceCode();
        this.sysParamItemScopeDas.deleteByTenantId(bizSpaceConfigReqDto.getTenantId());
        this.bizExtImplScopeDas.deleteByTenantId(bizSpaceConfigReqDto.getTenantId());
        String bizSpaceCodeJson = "{\"tenantId\":" + bizSpaceConfigReqDto.getTenantId() + ",\"bizSpaceCode\":\"" + bizSpaceCode + "\"}";
        ConfigScopeEo deleteEo = new ConfigScopeEo();
        deleteEo.setBizIdCode(bizSpaceCodeJson);
        this.configScopeDas.delete((BaseEo)deleteEo);
        deleteEo.packBizIdCodeByTenantId(bizSpaceConfigReqDto.getTenantId());
        deleteEo.setBizSpaceCode(bizSpaceCode);
        this.configScopeDas.delete((BaseEo)deleteEo);
        String bizIdCode = deleteEo.getBizIdCode();
        BizSpaceAbilityRelationEo removeEo = new BizSpaceAbilityRelationEo();
        removeEo.setBizSpaceCode(bizSpaceCode);
        this.bizSpaceAbilityRelationDas.delete((BaseEo)removeEo);
        if (CollectionUtils.isNotEmpty((Collection)bizSpaceConfigReqDto.getAbilityList())) {
            List abilityList = bizSpaceConfigReqDto.getAbilityList();
            for (BizSpaceAbilityDto ability : abilityList) {
                AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)ability.getCode()), CenterDataExceptionCode.PARAM_INVALID.getMsg() + ":\u80fd\u529b\u7f16\u7801\u4e0d\u80fd\u4e3aNull");
                BizSpaceAbilityRelationEo bizSpaceAbilityRelationEo = new BizSpaceAbilityRelationEo();
                bizSpaceAbilityRelationEo.setBizSpaceCode(bizSpaceCode);
                bizSpaceAbilityRelationEo.setAbilityCode(ability.getCode());
                this.bizSpaceAbilityRelationDas.insert((BaseEo)bizSpaceAbilityRelationEo);
                if (!CollectionUtils.isNotEmpty((Collection)ability.getConfigList())) continue;
                List configReqDtos = ability.getConfigList();
                ArrayList sysParamItemScopeEos = new ArrayList();
                ArrayList bizExtImplScopeEos = new ArrayList();
                ArrayList<ConfigScopeEo> configScopeEos = new ArrayList<ConfigScopeEo>();
                for (ConfigReqDto configReqDto : configReqDtos) {
                    Object queryEo;
                    String configCode = configReqDto.getCode();
                    List<Object> childrenCodes = new ArrayList();
                    if (CollectionUtils.isNotEmpty((Collection)configReqDto.getConfigItemCodes())) {
                        childrenCodes = configReqDto.getConfigItemCodes();
                    } else if (configReqDto.getType().equals(AbilityConstants.PARAM)) {
                        queryEo = new SysParamItemEo();
                        queryEo.setParamCode(configCode);
                        List sysParamItemEos = this.sysParamItemDas.select((BaseEo)queryEo);
                        if (CollectionUtils.isNotEmpty((Collection)sysParamItemEos)) {
                            childrenCodes = sysParamItemEos.stream().map(StdSysParamItemEo::getItemCode).collect(Collectors.toList());
                        }
                    } else if (configReqDto.getType().equals(AbilityConstants.EXTENSION)) {
                        queryEo = new BizExtImplEo();
                        queryEo.setBextCode(configCode);
                        List bizExtImplEos = this.bizExtImplDas.select((BaseEo)queryEo);
                        if (CollectionUtils.isNotEmpty((Collection)bizExtImplEos)) {
                            childrenCodes = bizExtImplEos.stream().map(StdBizExtImplEo::getBextImplCode).collect(Collectors.toList());
                        }
                    }
                    if (CollectionUtils.isNotEmpty(childrenCodes)) {
                        for (String configItemCode : childrenCodes) {
                            ConfigScopeEo configScopeEo = new ConfigScopeEo();
                            configScopeEo.setBizIdCode(bizIdCode);
                            configScopeEo.setConfigCode(configCode);
                            configScopeEo.setBizSpaceCode(bizSpaceCode);
                            configScopeEo.setType(configReqDto.getType());
                            configScopeEo.setParamValue(configReqDto.getParamValue());
                            configScopeEo.setExtension("");
                            configScopeEo.setConfigItemCode(configItemCode);
                            configScopeEo.setId(null);
                            configScopeEos.add(configScopeEo);
                        }
                        continue;
                    }
                    ConfigScopeEo configScopeEo = new ConfigScopeEo();
                    configScopeEo.setBizIdCode(bizIdCode);
                    configScopeEo.setConfigCode(configCode);
                    configScopeEo.setBizSpaceCode(bizSpaceCode);
                    configScopeEo.setType(configReqDto.getType());
                    configScopeEo.setParamValue(configReqDto.getParamValue());
                    configScopeEo.setExtension("");
                    configScopeEo.setId(null);
                    configScopeEos.add(configScopeEo);
                }
                this.configScopeDas.insertBatch(configScopeEos);
                this.sysParamItemScopeDas.insertBatch(sysParamItemScopeEos);
                this.bizExtImplScopeDas.insertBatch(bizExtImplScopeEos);
            }
        }
    }

    private void checkBizSpaceConfig(BizSpaceConfigReqDto bizSpaceConfigReqDto) {
        BizSpaceEo bizSpaceEo = new BizSpaceEo();
        bizSpaceEo.setCode(bizSpaceConfigReqDto.getBizSpaceCode());
        bizSpaceEo.setTenantId(bizSpaceConfigReqDto.getTenantId());
        List bizSpaceEos = this.bizSpaceDas.select((BaseEo)bizSpaceEo);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)bizSpaceEos) && bizSpaceEos.size() == 1, CenterDataExceptionCode.DATA_DUPLICATE_ERROR.getMsg() + "\u6216\u6570\u636e\u4e0d\u5b58\u5728:\u671f\u5f85\u6570\u636e\u4e00\u822c\u6709\u4e14\u53ea\u6709\u4e00\u6761");
        if (CollectionUtils.isNotEmpty((Collection)bizSpaceConfigReqDto.getAbilityList())) {
            List abilityList = bizSpaceConfigReqDto.getAbilityList();
            List abilityCodes = abilityList.stream().filter(r -> StringUtils.isNotBlank((CharSequence)r.getCode())).map(ability -> {
                List configList = ability.getConfigList();
                if (CollectionUtils.isNotEmpty((Collection)configList)) {
                    configList.stream().map(config -> {
                        String configCode = config.getCode();
                        List configItemCodes = config.getConfigItemCodes();
                        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)configCode) && null != config.getType(), CenterDataExceptionCode.PARAM_INVALID.getMsg() + ":\u914d\u7f6e\u9879\u7f16\u7801\u6216\u7c7b\u578b\u4e0d\u80fd\u4e3anull");
                        if (AbilityConstants.PARAM.equals(config.getType())) {
                            AssertUtil.isTrue(null != this.sysParamDas.selectByParamCode(configCode), CenterDataExceptionCode.RECORD_NOT_EXISTS.getMsg());
                            if (CollectionUtils.isNotEmpty((Collection)configItemCodes)) {
                                AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)this.sysParamItemDas.selectByCodes(configCode, configItemCodes)), CenterDataExceptionCode.RECORD_NOT_EXISTS.getMsg());
                            }
                        }
                        if (AbilityConstants.EXTENSION.equals(config.getType())) {
                            BizExtensionEo bizExtensionEo = new BizExtensionEo();
                            bizExtensionEo.setBextCode(configCode);
                            AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)this.bizExtensionDas.select((BaseEo)bizExtensionEo)), CenterDataExceptionCode.RECORD_NOT_EXISTS.getMsg());
                            if (CollectionUtils.isNotEmpty((Collection)configItemCodes)) {
                                AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)this.bizExtImplDas.selectByCodes(configCode, config.getConfigItemCodes())), CenterDataExceptionCode.RECORD_NOT_EXISTS.getMsg());
                            }
                        }
                        return null;
                    });
                }
                return ability.getCode();
            }).collect(Collectors.toList());
            AssertUtil.isTrue(CollectionUtils.isNotEmpty(abilityCodes), CenterDataExceptionCode.PARAM_INVALID.getMsg());
            List abilityEos = this.abilityDas.selectByCodes(abilityCodes, null);
            AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)abilityEos) && abilityCodes.size() == abilityEos.size(), CenterDataExceptionCode.RECORD_NOT_EXISTS.getMsg());
        }
    }

    @Override
    public BizSpaceRespDto queryByCode(BizSpaceReqDto bizSpaceReqDto) {
        bizSpaceReqDto.setTenantId(this.context.tenantId());
        AssertUtil.isTrue(null != bizSpaceReqDto.getCode(), CenterDataExceptionCode.PARAM_INVALID.getMsg() + "\uff1a\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        BizSpaceEo bizSpaceEo = new BizSpaceEo();
        DtoHelper.dto2Eo((BaseVo)bizSpaceReqDto, (BaseEo)bizSpaceEo);
        List bizSpaceEoList = this.bizSpaceDas.select((BaseEo)bizSpaceEo);
        BizSpaceRespDto bizSpaceRespDto = new BizSpaceRespDto();
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)bizSpaceEoList) && bizSpaceEoList.size() == 1, CenterDataExceptionCode.DATA_DUPLICATE_ERROR.getMsg() + ":\u671f\u5f85\u6570\u636e\u4e00\u822c\u53ea\u6709\u4e00\u6761");
        DtoHelper.eo2Dto((BaseEo)((BaseEo)bizSpaceEoList.get(0)), (BaseVo)bizSpaceRespDto);
        return bizSpaceRespDto;
    }

    @Override
    public PageInfo<BizSpaceRespDto> queryByPage(BizSpaceQueryReqDto bizSpaceQueryReqDto, Integer pageNum, Integer pageSize) {
        BizSpaceEo bizSpaceEo = new BizSpaceEo();
        DtoHelper.dto2Eo((BaseVo)bizSpaceQueryReqDto, (BaseEo)bizSpaceEo);
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        if (StringUtils.isNotBlank((CharSequence)bizSpaceQueryReqDto.getName())) {
            sqlFilters.add(SqlFilter.like((String)"name", (Object)("%" + bizSpaceQueryReqDto.getName() + "%")));
            bizSpaceEo.setName(null);
        }
        if (StringUtils.isNotBlank((CharSequence)bizSpaceQueryReqDto.getCode())) {
            sqlFilters.add(SqlFilter.like((String)"code", (Object)("%" + bizSpaceQueryReqDto.getCode() + "%")));
            bizSpaceEo.setCode(null);
        }
        bizSpaceEo.setSqlFilters(sqlFilters);
        bizSpaceEo.setTenantId(this.context.tenantId());
        bizSpaceEo.setOrderByDesc("create_time");
        PageInfo eoPageInfo = this.bizSpaceDas.selectPage((BaseEo)bizSpaceEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)eoPageInfo.getList())) {
            List bizSpaceEoList = eoPageInfo.getList();
            bizSpaceEoList.stream().filter(r -> StringUtils.isNotBlank((CharSequence)r.getCode())).map(eo -> {
                BizSpaceRespDto bizSpaceRespDto = new BizSpaceRespDto();
                DtoHelper.eo2Dto((BaseEo)eo, (BaseVo)bizSpaceRespDto);
                BizSpaceAbilityRelationEo bizSpaceAbilityRelationEo = new BizSpaceAbilityRelationEo();
                bizSpaceAbilityRelationEo.setBizSpaceCode(eo.getCode());
                List abilityRelationEos = this.bizSpaceAbilityRelationDas.select((BaseEo)bizSpaceAbilityRelationEo);
                if (CollectionUtils.isNotEmpty((Collection)abilityRelationEos)) {
                    List abilityCodes = abilityRelationEos.stream().map(StdBizSpaceAbilityRelationEo::getAbilityCode).collect(Collectors.toList());
                    if (CollectionUtils.isNotEmpty(abilityCodes)) {
                        GroupAbilityRelationEo groupAbilityRelationEo = new GroupAbilityRelationEo();
                        groupAbilityRelationEo.setType(AbilityConstants.SCENE);
                        ArrayList<SqlFilter> filters = new ArrayList<SqlFilter>();
                        filters.add(SqlFilter.in((String)"ability_code", (Object)StringUtils.join(abilityCodes, (String)",")));
                        groupAbilityRelationEo.setSqlFilters(filters);
                        Integer sceneNum = this.groupAbilityRelationDas.count((BaseEo)groupAbilityRelationEo);
                        bizSpaceRespDto.setSceneNum(sceneNum);
                    } else {
                        bizSpaceRespDto.setSceneNum(Integer.valueOf(0));
                    }
                } else {
                    bizSpaceRespDto.setSceneNum(Integer.valueOf(0));
                }
                BizSpaceAppInstanceRelationEo bizSpaceAppInstanceRelationEo = new BizSpaceAppInstanceRelationEo();
                bizSpaceAppInstanceRelationEo.setBizSpaceCode(eo.getCode());
                Integer appInstanceNum = this.bizSpaceAppInstanceRelationDas.count((BaseEo)bizSpaceAppInstanceRelationEo);
                bizSpaceRespDto.setAppInstanceNum(appInstanceNum);
                dtoList.add(bizSpaceRespDto);
                return null;
            }).collect(Collectors.toList());
        }
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public BizSpaceTreeDto getBizSpaceTree(BizSpaceTreeReqDto bizSpaceTreeReqDto) {
        bizSpaceTreeReqDto.setTenantId(this.context.tenantId());
        BizSpaceTreeDto bizSpaceDto = new BizSpaceTreeDto();
        String bizSpaceCode = bizSpaceTreeReqDto.getBizSpaceCode();
        BizSpaceReqDto bizSpaceReqDto = new BizSpaceReqDto();
        bizSpaceReqDto.setCode(bizSpaceCode);
        bizSpaceReqDto.setTenantId(this.context.tenantId());
        BizSpaceRespDto bizSpaceRespDto = this.queryByCode(bizSpaceReqDto);
        CubeBeanUtils.copyProperties((Object)bizSpaceDto, (Object)bizSpaceRespDto, (String[])new String[0]);
        bizSpaceDto.setCode(bizSpaceRespDto.getCode());
        bizSpaceDto.setName(bizSpaceRespDto.getName());
        BizSpaceAbilityVo bizSpaceAbilityVo = this.getBizSpaceAbility(bizSpaceCode);
        List configScopeEos = new ArrayList();
        ConfigScopeEo configScopeEo = new ConfigScopeEo();
        String bizSpaceCodeJson = "{\"tenantId\":" + this.context.tenantId() + ",\"bizSpaceCode\":\"" + bizSpaceCode + "\"}";
        configScopeEo.setBizIdCode(bizSpaceCodeJson);
        BizSpaceConfigVo bizSpaceConfigVo = new BizSpaceConfigVo();
        configScopeEos = this.configScopeDas.select((BaseEo)configScopeEo);
        if (CollectionUtils.isEmpty(configScopeEos)) {
            String bizIdStr = "tenantId=" + this.context.tenantId();
            configScopeEo.setBizIdCode(bizIdStr);
            configScopeEo.setBizSpaceCode(bizSpaceCode);
            configScopeEos = this.configScopeDas.select((BaseEo)configScopeEo);
        }
        if (CollectionUtils.isNotEmpty(configScopeEos)) {
            bizSpaceConfigVo = this.getBizSpaceConfig(configScopeEos);
        }
        List<BizSpaceTreeDto> sceneTreeDtos = this.getSceneTreeDtos(bizSpaceAbilityVo, bizSpaceConfigVo);
        bizSpaceDto.setChildren(sceneTreeDtos);
        this.logger.info("\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u8f93\u51fa\u4e1a\u52a1\u7a7a\u95f4\u5bf9\u5e94\u7684\u573a\u666f\u4fe1\u606f\uff1a" + JSONObject.toJSONString(sceneTreeDtos));
        return bizSpaceDto;
    }

    @Override
    public BizSpaceTreeDto getBizSpaceRelation(BizSpaceTreeReqDto bizSpaceTreeReqDto) {
        bizSpaceTreeReqDto.setTenantId(this.context.tenantId());
        BizSpaceTreeDto bizSpaceDto = new BizSpaceTreeDto();
        String bizSpaceCode = bizSpaceTreeReqDto.getBizSpaceCode();
        BizSpaceReqDto bizSpaceReqDto = new BizSpaceReqDto();
        bizSpaceReqDto.setCode(bizSpaceCode);
        bizSpaceReqDto.setTenantId(bizSpaceTreeReqDto.getTenantId());
        BizSpaceRespDto bizSpaceRespDto = this.queryByCode(bizSpaceReqDto);
        CubeBeanUtils.copyProperties((Object)bizSpaceDto, (Object)bizSpaceRespDto, (String[])new String[0]);
        bizSpaceDto.setCode(bizSpaceRespDto.getCode());
        bizSpaceDto.setName(bizSpaceRespDto.getName());
        BizSpaceAbilityRelationEo bizSpaceAbilityRelationEo = new BizSpaceAbilityRelationEo();
        bizSpaceAbilityRelationEo.setBizSpaceCode(bizSpaceCode);
        List<Object> abilityQueryCodes = new ArrayList();
        List bizSpaceAbilityRelationEos = this.bizSpaceAbilityRelationDas.select((BaseEo)bizSpaceAbilityRelationEo);
        if (CollectionUtils.isNotEmpty((Collection)bizSpaceAbilityRelationEos)) {
            abilityQueryCodes = bizSpaceAbilityRelationEos.stream().filter(r -> StringUtils.isNotBlank((CharSequence)r.getAbilityCode())).map(StdBizSpaceAbilityRelationEo::getAbilityCode).collect(Collectors.toList());
        }
        List configScopeEos = new ArrayList();
        ConfigScopeEo configScopeEo = new ConfigScopeEo();
        String bizSpaceCodeJson = "{\"tenantId\":" + bizSpaceTreeReqDto.getTenantId() + ",\"bizSpaceCode\":\"" + bizSpaceCode + "\"}";
        configScopeEo.setBizIdCode(bizSpaceCodeJson);
        BizSpaceConfigVo bizSpaceConfigVo = new BizSpaceConfigVo();
        configScopeEos = this.configScopeDas.select((BaseEo)configScopeEo);
        if (CollectionUtils.isEmpty(configScopeEos)) {
            String bizIdStr = "tenantId=" + bizSpaceTreeReqDto.getTenantId();
            configScopeEo.setBizIdCode(bizIdStr);
            configScopeEo.setBizSpaceCode(bizSpaceCode);
            configScopeEos = this.configScopeDas.select((BaseEo)configScopeEo);
        }
        if (CollectionUtils.isNotEmpty(configScopeEos)) {
            bizSpaceConfigVo = this.getBizSpaceConfig(configScopeEos);
        }
        if (CollectionUtils.isNotEmpty(abilityQueryCodes)) {
            Map<String, List<String>> abilityParamMap = bizSpaceConfigVo.getAbilityParamMap();
            Map<String, BizSpaceTreeDto> sysParamTree = bizSpaceConfigVo.getSysParamTreeDto();
            Map<String, List<String>> abilityBextMap = bizSpaceConfigVo.getAbilityBextMap();
            Map<String, BizSpaceTreeDto> bizExtensionTree = bizSpaceConfigVo.getBizExtensionTreeDto();
            ArrayList<BizSpaceTreeDto> abilityCodeChildren = new ArrayList<BizSpaceTreeDto>();
            for (String string : abilityQueryCodes) {
                ArrayList<BizSpaceTreeDto> children = new ArrayList<BizSpaceTreeDto>();
                this.logger.info("\u5f53\u524d\u80fd\u529b\u5173\u8054\u7684\u4e1a\u52a1\u53c2\u6570code" + JSONObject.toJSONString(abilityParamMap));
                this.getConfigTree(string, abilityParamMap, sysParamTree, children);
                this.getConfigTree(string, abilityBextMap, bizExtensionTree, children);
                this.logger.info("\u5f53\u524d\u80fd\u529b\u5173\u8054\u7684\u4e1a\u52a1\u53c2\u6570code" + JSONObject.toJSONString(abilityParamMap));
                abilityCodeChildren.addAll(children);
            }
            bizSpaceDto.setChildren(abilityCodeChildren);
        }
        return bizSpaceDto;
    }

    private BizSpaceAbilityVo getBizSpaceAbility(String bizSpaceCode) {
        BizSpaceAbilityVo bizSpaceAbilityVo = new BizSpaceAbilityVo();
        BizSpaceAbilityRelationEo bizSpaceAbilityRelationEo = new BizSpaceAbilityRelationEo();
        bizSpaceAbilityRelationEo.setBizSpaceCode(bizSpaceCode);
        List bizSpaceAbilityRelationEos = new ArrayList();
        PageInfo bizSpaceAbilityPageInfo = this.bizSpaceAbilityRelationDas.selectPage((BaseEo)bizSpaceAbilityRelationEo, Integer.valueOf(1), Integer.valueOf(1000));
        if (null != bizSpaceAbilityPageInfo && CollectionUtils.isNotEmpty((Collection)bizSpaceAbilityPageInfo.getList())) {
            bizSpaceAbilityRelationEos = bizSpaceAbilityPageInfo.getList();
        }
        if (CollectionUtils.isNotEmpty(bizSpaceAbilityRelationEos)) {
            List groupAbilityRelationEos;
            List abilityQueryCodes = bizSpaceAbilityRelationEos.stream().filter(r -> StringUtils.isNotBlank((CharSequence)r.getAbilityCode())).map(StdBizSpaceAbilityRelationEo::getAbilityCode).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(abilityQueryCodes)) {
                List abilityEos = this.abilityDas.selectByCodes(abilityQueryCodes, null);
                HashMap<String, AbilityEo> abilityEoMap = new HashMap<String, AbilityEo>();
                if (CollectionUtils.isEmpty((Collection)abilityEos)) {
                    return bizSpaceAbilityVo;
                }
                for (AbilityEo eo : abilityEos) {
                    abilityEoMap.put(eo.getCode(), eo);
                }
                bizSpaceAbilityVo.setAbilityEoMap(abilityEoMap);
            }
            if (CollectionUtils.isNotEmpty((Collection)(groupAbilityRelationEos = this.groupAbilityRelationDas.selectByAbilityCodes(abilityQueryCodes)))) {
                List sceneCodes = groupAbilityRelationEos.stream().filter(r -> r.getType().equals(AbilityConstants.SCENE) && StringUtils.isNotBlank((CharSequence)r.getAbilityGroupCode())).map(StdGroupAbilityRelationEo::getAbilityGroupCode).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(sceneCodes)) {
                    List sceneEos = this.abilityGroupDas.selectByCodes(sceneCodes, null, AbilityConstants.SCENE);
                    bizSpaceAbilityVo.setSceneEos(sceneEos);
                }
                HashMap<String, List<String>> sceneAbilityMap = new HashMap<String, List<String>>();
                for (GroupAbilityRelationEo eo : groupAbilityRelationEos) {
                    ArrayList<String> abilityCode = new ArrayList<String>();
                    if (CollectionUtils.isNotEmpty((Collection)((Collection)sceneAbilityMap.get(eo.getAbilityGroupCode())))) {
                        abilityCode.addAll((Collection)sceneAbilityMap.get(eo.getAbilityGroupCode()));
                    }
                    abilityCode.add(eo.getAbilityCode());
                    sceneAbilityMap.put(eo.getAbilityGroupCode(), abilityCode);
                }
                bizSpaceAbilityVo.setSceneAbilityMap(sceneAbilityMap);
            }
        }
        return bizSpaceAbilityVo;
    }

    private BizSpaceConfigVo getBizSpaceConfig(List<ConfigScopeEo> configScopeEos) {
        BizSpaceConfigVo bizSpaceConfigVo = new BizSpaceConfigVo();
        this.getParam(configScopeEos, bizSpaceConfigVo);
        this.getExtension(configScopeEos, bizSpaceConfigVo);
        List<AbilityConfigRelationEo> abilityConfigRelationEos = this.getAbilityConfigRelation(configScopeEos);
        this.logger.info("\u2014\u2014\u2014\u2014\u8f93\u51faabilityConfigRelationEos\u4fe1\u606f:" + JSONObject.toJSONString(abilityConfigRelationEos));
        this.getAbilityConfigMap(abilityConfigRelationEos, bizSpaceConfigVo);
        this.logger.info("\u2014\u2014\u2014\u2014\u8f93\u51fa\u4e1a\u52a1\u7a7a\u95f4\u914d\u7f6e\u4fe1\u606f:" + JSONObject.toJSONString((Object)((Object)bizSpaceConfigVo)));
        return bizSpaceConfigVo;
    }

    private void getParam(List<ConfigScopeEo> configScopeEos, BizSpaceConfigVo bizSpaceConfigVo) {
        List sysParamCodes = configScopeEos.stream().filter(r -> r.getType().equals(AbilityConstants.PARAM) && StringUtils.isNotBlank((CharSequence)r.getConfigCode())).map(StdConfigScopeEo::getConfigCode).collect(Collectors.toList());
        Map<String, String> configValueMap = configScopeEos.stream().filter(r -> StringUtils.isNotBlank((CharSequence)r.getParamValue()) && r.getType().equals(AbilityConstants.PARAM)).collect(Collectors.toMap(StdConfigScopeEo::getConfigCode, StdConfigScopeEo::getParamValue, (k1, k2) -> k1));
        HashMap<String, BizSpaceTreeDto> sysParamTree = new HashMap<String, BizSpaceTreeDto>();
        if (CollectionUtils.isNotEmpty(sysParamCodes)) {
            List sysParamItemEos;
            List sysParamEos = this.sysParamDas.selectByCodeList(sysParamCodes);
            this.logger.info("\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u8f93\u51fa\u4e1a\u52a1\u53c2\u6570\u4fe1\u606f\uff1a" + JSONObject.toJSONString((Object)sysParamEos));
            if (CollectionUtils.isNotEmpty((Collection)sysParamEos)) {
                for (SysParamEo eo : sysParamEos) {
                    String paramValue;
                    String paramCode = eo.getCode();
                    BizSpaceTreeDto sysParamTreeDto = new BizSpaceTreeDto();
                    DtoHelper.eo2Dto((BaseEo)eo, (BaseVo)sysParamTreeDto);
                    sysParamTreeDto.setType(AbilityConstants.PARAM);
                    if (configValueMap != null && configValueMap.size() > 0 && StringUtils.isNotBlank((CharSequence)(paramValue = configValueMap.get(paramCode)))) {
                        sysParamTreeDto.setParamValue(paramValue);
                    }
                    sysParamTree.put(paramCode, sysParamTreeDto);
                }
            }
            this.logger.info("\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u8f93\u51fa\u4e1a\u52a1\u53c2\u6570\u4fe1\u606fMap\uff1a" + JSONObject.toJSONString(sysParamTree));
            List sysParamItemCodes = configScopeEos.stream().filter(r -> r.getType().equals(AbilityConstants.PARAM) && StringUtils.isNotBlank((CharSequence)r.getConfigItemCode())).map(StdConfigScopeEo::getConfigItemCode).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(sysParamItemCodes) && CollectionUtils.isNotEmpty((Collection)(sysParamItemEos = this.sysParamItemDas.selectByParamCodes(sysParamCodes, sysParamItemCodes)))) {
                ArrayList<BizSpaceTreeDto> sysParamTreeDtos = new ArrayList<BizSpaceTreeDto>();
                for (SysParamItemEo sysParamItemEo : sysParamItemEos) {
                    BizSpaceTreeDto sysParamItemTreeDto = new BizSpaceTreeDto();
                    DtoHelper.eo2Dto((BaseEo)sysParamItemEo, (BaseVo)sysParamItemTreeDto);
                    sysParamItemTreeDto.setCode(sysParamItemEo.getItemCode());
                    sysParamItemTreeDto.setParentCode(sysParamItemEo.getParamCode());
                    sysParamItemTreeDto.setName(sysParamItemEo.getValueDesc());
                    sysParamTreeDtos.add(sysParamItemTreeDto);
                }
                Map<String, List<BizSpaceTreeDto>> sysParamItemMap = sysParamTreeDtos.stream().collect(Collectors.groupingBy(TreeDtoBase::getParentCode));
                this.logger.info("\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u8f93\u51fa\u4e1a\u52a1\u53c2\u6570\u9009\u9879\u4fe1\u606fMap\uff1a" + JSONObject.toJSONString(sysParamItemMap));
                for (String paramCode : sysParamTree.keySet()) {
                    BizSpaceTreeDto param = (BizSpaceTreeDto)sysParamTree.get(paramCode);
                    List<BizSpaceTreeDto> items = sysParamItemMap.get(paramCode);
                    if (CollectionUtils.isEmpty(items)) {
                        items = new ArrayList<BizSpaceTreeDto>();
                    }
                    param.setChildren(items);
                }
            }
            bizSpaceConfigVo.setSysParamTreeDto(sysParamTree);
        }
    }

    private void getExtension(List<ConfigScopeEo> configScopeEos, BizSpaceConfigVo bizSpaceConfigVo) {
        List bizExtensionEos;
        List bextCodes = configScopeEos.stream().filter(r -> r.getType().equals(AbilityConstants.EXTENSION) && StringUtils.isNotBlank((CharSequence)r.getConfigCode())).map(StdConfigScopeEo::getConfigCode).collect(Collectors.toList());
        HashMap<String, BizSpaceTreeDto> bizExtensionTreeDto = new HashMap<String, BizSpaceTreeDto>();
        if (CollectionUtils.isNotEmpty(bextCodes) && CollectionUtils.isNotEmpty((Collection)(bizExtensionEos = this.bizExtensionDas.selectByCodeList(bextCodes)))) {
            List bizExtImplEos;
            for (BizExtensionEo eo : bizExtensionEos) {
                BizSpaceTreeDto bizExtensionTree = new BizSpaceTreeDto();
                DtoHelper.eo2Dto((BaseEo)eo, (BaseVo)bizExtensionTree);
                bizExtensionTree.setCode(eo.getBextCode());
                bizExtensionTree.setName(eo.getBextName());
                bizExtensionTree.setType(AbilityConstants.EXTENSION);
                bizExtensionTree.setSelectType(eo.getBextType());
                bizExtensionTreeDto.put(eo.getBextCode(), bizExtensionTree);
            }
            List bizExtImplCodes = configScopeEos.stream().filter(r -> r.getType().equals(AbilityConstants.EXTENSION) && StringUtils.isNotBlank((CharSequence)r.getConfigItemCode())).map(StdConfigScopeEo::getConfigItemCode).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(bizExtImplCodes) && CollectionUtils.isNotEmpty((Collection)(bizExtImplEos = this.bizExtImplDas.selectByBextCodesAndBextImplCodes(bextCodes, bizExtImplCodes)))) {
                ArrayList<BizSpaceTreeDto> bizExtImplTreeDtos = new ArrayList<BizSpaceTreeDto>();
                for (BizExtImplEo bizExtImplEo : bizExtImplEos) {
                    BizSpaceTreeDto bizExtImplEoTreeDto = new BizSpaceTreeDto();
                    DtoHelper.eo2Dto((BaseEo)bizExtImplEo, (BaseVo)bizExtImplEoTreeDto);
                    bizExtImplEoTreeDto.setCode(bizExtImplEo.getBextImplCode());
                    bizExtImplEoTreeDto.setParentCode(bizExtImplEo.getBextCode());
                    bizExtImplEoTreeDto.setName(bizExtImplEo.getBextImplName());
                    bizExtImplTreeDtos.add(bizExtImplEoTreeDto);
                }
                Map<String, List<BizSpaceTreeDto>> bizExtImplMap = bizExtImplTreeDtos.stream().filter(r -> StringUtils.isNotBlank((CharSequence)r.getParentCode())).collect(Collectors.groupingBy(TreeDtoBase::getParentCode));
                for (String bextCode : bizExtensionTreeDto.keySet()) {
                    BizSpaceTreeDto bizExtension = (BizSpaceTreeDto)bizExtensionTreeDto.get(bextCode);
                    List<BizSpaceTreeDto> bizExtImpl = bizExtImplMap.get(bextCode);
                    if (CollectionUtils.isEmpty(bizExtImpl)) {
                        bizExtImpl = new ArrayList<BizSpaceTreeDto>();
                    }
                    bizExtension.setChildren(bizExtImpl);
                }
            }
            bizSpaceConfigVo.setBizExtensionTreeDto(bizExtensionTreeDto);
        }
    }

    private List<AbilityConfigRelationEo> getAbilityConfigRelation(List<ConfigScopeEo> configScopeEos) {
        ArrayList<AbilityConfigRelationEo> abilityConfigRelationEos = new ArrayList<AbilityConfigRelationEo>();
        Map<Integer, List<ConfigScopeEo>> typeMap = configScopeEos.stream().collect(Collectors.groupingBy(StdConfigScopeEo::getType));
        for (Integer type : typeMap.keySet()) {
            List configCodes = typeMap.get(type).stream().filter(r -> StringUtils.isNotBlank((CharSequence)r.getConfigCode())).map(StdConfigScopeEo::getConfigCode).collect(Collectors.toList());
            if (AbilityConstants.PARAM.equals(type)) {
                abilityConfigRelationEos.addAll(this.abilityConfigRelationDas.selectByConfigCodes(configCodes, AbilityConstants.PARAM));
                this.logger.info("\u2014\u2014\u2014\u2014\u8f93\u51fa\u80fd\u529b\u4e0e\u914d\u7f6e\u9879\u5173\u8054\u4fe1\u606f:" + JSONObject.toJSONString(abilityConfigRelationEos));
            }
            if (!AbilityConstants.EXTENSION.equals(type)) continue;
            abilityConfigRelationEos.addAll(this.abilityConfigRelationDas.selectByConfigCodes(configCodes, AbilityConstants.EXTENSION));
        }
        return abilityConfigRelationEos;
    }

    private void getAbilityConfigMap(List<AbilityConfigRelationEo> abilityConfigRelationEos, BizSpaceConfigVo bizSpaceConfigVo) {
        Map<Integer, List<AbilityConfigRelationEo>> typeRelationMap = abilityConfigRelationEos.stream().collect(Collectors.groupingBy(StdAbilityConfigRelationEo::getType));
        HashMap<String, List<String>> abilityParamMap = new HashMap<String, List<String>>();
        if (CollectionUtils.isNotEmpty((Collection)typeRelationMap.get(AbilityConstants.PARAM))) {
            for (AbilityConfigRelationEo eo : typeRelationMap.get(AbilityConstants.PARAM)) {
                ArrayList<String> paramCode = new ArrayList<String>();
                if (CollectionUtils.isNotEmpty((Collection)((Collection)abilityParamMap.get(eo.getAbilityCode())))) {
                    paramCode.addAll((Collection)abilityParamMap.get(eo.getAbilityCode()));
                }
                paramCode.add(eo.getConfigCode());
                abilityParamMap.put(eo.getAbilityCode(), paramCode);
            }
            bizSpaceConfigVo.setAbilityParamMap(abilityParamMap);
        }
        this.logger.info("\u2014\u2014\u2014\u2014\u8f93\u51faabilityParamMap\u4fe1\u606f:" + JSONObject.toJSONString(abilityParamMap));
        HashMap<String, List<String>> abilityBextMap = new HashMap<String, List<String>>();
        if (CollectionUtils.isNotEmpty((Collection)typeRelationMap.get(AbilityConstants.EXTENSION))) {
            for (AbilityConfigRelationEo eo : typeRelationMap.get(AbilityConstants.EXTENSION)) {
                ArrayList<String> bextCode = new ArrayList<String>();
                if (CollectionUtils.isNotEmpty((Collection)((Collection)abilityBextMap.get(eo.getAbilityCode())))) {
                    bextCode.addAll((Collection)abilityBextMap.get(eo.getAbilityCode()));
                }
                bextCode.add(eo.getConfigCode());
                abilityBextMap.put(eo.getAbilityCode(), bextCode);
            }
            bizSpaceConfigVo.setAbilityBextMap(abilityBextMap);
        }
        this.logger.info("\u2014\u2014\u2014\u2014\u8f93\u51faabilityBextMap\u4fe1\u606f:" + JSONObject.toJSONString(abilityBextMap));
    }

    private List<BizSpaceTreeDto> getSceneTreeDtos(BizSpaceAbilityVo bizSpaceAbilityVo, BizSpaceConfigVo bizSpaceConfigVo) {
        List<AbilityGroupEo> sceneEos = bizSpaceAbilityVo.getSceneEos();
        Map<String, List<String>> sceneAbilityMap = bizSpaceAbilityVo.getSceneAbilityMap();
        Map<String, AbilityEo> abilityEoMap = bizSpaceAbilityVo.getAbilityEoMap();
        Map<String, List<String>> abilityParamMap = bizSpaceConfigVo.getAbilityParamMap();
        Map<String, BizSpaceTreeDto> sysParamTree = bizSpaceConfigVo.getSysParamTreeDto();
        Map<String, List<String>> abilityBextMap = bizSpaceConfigVo.getAbilityBextMap();
        Map<String, BizSpaceTreeDto> bizExtensionTree = bizSpaceConfigVo.getBizExtensionTreeDto();
        ArrayList<BizSpaceTreeDto> sceneTreeDtos = new ArrayList<BizSpaceTreeDto>();
        if (CollectionUtils.isEmpty(sceneEos)) {
            return sceneTreeDtos;
        }
        for (AbilityGroupEo sceneEo : sceneEos) {
            BizSpaceTreeDto sceneTree = new BizSpaceTreeDto();
            DtoHelper.eo2Dto((BaseEo)sceneEo, (BaseVo)sceneTree);
            ArrayList<BizSpaceTreeDto> abilityTreeDtos = new ArrayList<BizSpaceTreeDto>();
            List<String> abilityCodes = sceneAbilityMap.get(sceneEo.getCode());
            if (CollectionUtils.isNotEmpty(abilityCodes)) {
                for (String abilityCode : abilityCodes) {
                    AbilityEo abilityEo = abilityEoMap.get(abilityCode);
                    BizSpaceTreeDto abilityTree = new BizSpaceTreeDto();
                    DtoHelper.eo2Dto((BaseEo)abilityEo, (BaseVo)abilityTree);
                    abilityTree.setParentCode(sceneEo.getCode());
                    ArrayList<BizSpaceTreeDto> children = new ArrayList<BizSpaceTreeDto>();
                    this.logger.info("\u5f53\u524d\u80fd\u529b\u5173\u8054\u7684\u4e1a\u52a1\u53c2\u6570code" + JSONObject.toJSONString(abilityParamMap));
                    this.getConfigTree(abilityCode, abilityParamMap, sysParamTree, children);
                    this.getConfigTree(abilityCode, abilityBextMap, bizExtensionTree, children);
                    this.logger.info("\u5f53\u524d\u80fd\u529b\u5173\u8054\u7684\u4e1a\u52a1\u53c2\u6570code" + JSONObject.toJSONString(abilityParamMap));
                    abilityTree.setChildren(children);
                    abilityTreeDtos.add(abilityTree);
                }
            }
            sceneTree.setChildren(abilityTreeDtos);
            sceneTreeDtos.add(sceneTree);
        }
        return sceneTreeDtos;
    }

    private void getConfigTree(String abilityCode, Map<String, List<String>> abilityRelationMap, Map<String, BizSpaceTreeDto> relationTree, List<BizSpaceTreeDto> children) {
        List<String> configCodes;
        if (null != abilityRelationMap && abilityRelationMap.size() > 0 && CollectionUtils.isNotEmpty(configCodes = abilityRelationMap.get(abilityCode))) {
            for (String configCode : configCodes) {
                BizSpaceTreeDto configTree = relationTree.get(configCode);
                if (configTree == null) continue;
                configTree.setParentCode(abilityCode);
                children.add(configTree);
            }
        }
    }

    @Override
    public List<BizSpaceConfigValueRespDto> queryConfigValue(BizSpaceReqDto bizSpaceReqDto) {
        Long tenantId = this.context.tenantId();
        AssertUtil.isTrue(tenantId != null, "tenantId\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)bizSpaceReqDto.getCode()), (String)"\u4e1a\u52a1\u7a7a\u95f4\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList<BizSpaceConfigValueRespDto> dtoList = new ArrayList<BizSpaceConfigValueRespDto>();
        String bizIdCode = "tenantId=" + tenantId;
        ArrayList sysParamValueList = new ArrayList();
        List sysParamValueEoList = this.sysParamValueDas.selectByBizIdCodeAndBizSpaceCode(bizIdCode, bizSpaceReqDto.getCode());
        List newSysParamValueEoList = this.sysParamValueDas.selectByParamCodeAndBizSpace(null, bizSpaceReqDto.getCode());
        if (CollectionUtils.isNotEmpty((Collection)sysParamValueEoList)) {
            sysParamValueList.addAll(sysParamValueEoList);
        }
        if (CollectionUtils.isNotEmpty((Collection)newSysParamValueEoList)) {
            sysParamValueList.addAll(newSysParamValueEoList);
        }
        if (CollectionUtils.isNotEmpty(sysParamValueList)) {
            for (SysParamValueEo eo : sysParamValueList) {
                BizSpaceConfigValueRespDto dto = new BizSpaceConfigValueRespDto();
                dto.setParentCode(eo.getParamCode());
                dto.setCode(eo.getItemCode());
                dto.setType(AbilityConstants.PARAM);
                dto.setValue(eo.getParamValue());
                dtoList.add(dto);
            }
        }
        ArrayList bizExtImplValueList = new ArrayList();
        List bizExtImplValueEoList = this.bizExtImplValueDas.selectByBizIdCodeAndBizSpaceCode(bizIdCode, bizSpaceReqDto.getCode());
        List newBizExtImplValueEoList = this.bizExtImplValueDas.selectByBextCodeAndBizSpace(null, bizSpaceReqDto.getCode());
        if (CollectionUtils.isNotEmpty((Collection)bizExtImplValueEoList)) {
            bizExtImplValueList.addAll(bizExtImplValueEoList);
        }
        if (CollectionUtils.isNotEmpty((Collection)newBizExtImplValueEoList)) {
            bizExtImplValueList.addAll(newBizExtImplValueEoList);
        }
        if (CollectionUtils.isNotEmpty(bizExtImplValueList)) {
            for (BizExtImplValueEo eo : bizExtImplValueList) {
                BizSpaceConfigValueRespDto dto = new BizSpaceConfigValueRespDto();
                dto.setParentCode(eo.getBextCode());
                dto.setCode(eo.getBextImplCode());
                dto.setType(AbilityConstants.EXTENSION);
                dtoList.add(dto);
            }
        }
        return dtoList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void setBizSpaceConfigValue(String code, List<BizSpaceConfigValueReqDto> bizSpaceConfigValueReqDtoList) {
        Long tenantId = this.context.tenantId();
        AssertUtil.isTrue(tenantId != null, "tenantId\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)code), (String)"\u4e1a\u52a1\u7a7a\u95f4\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)CollectionUtils.isNotEmpty(bizSpaceConfigValueReqDtoList), (String)"\u914d\u7f6e\u9879\u503c\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        Map<Integer, List<BizSpaceConfigValueReqDto>> configValueMap = bizSpaceConfigValueReqDtoList.stream().filter(dto -> dto.getType() != null).collect(Collectors.groupingBy(BizSpaceConfigValueReqDto::getType));
        ArrayList<SysParamValueReqDto> sysParamValueDtoList = new ArrayList<SysParamValueReqDto>();
        List<BizSpaceConfigValueReqDto> paramValueList = configValueMap.get(AbilityConstants.PARAM);
        if (CollectionUtils.isNotEmpty(paramValueList)) {
            for (BizSpaceConfigValueReqDto dto2 : paramValueList) {
                SysParamValueReqDto paramValue = new SysParamValueReqDto();
                paramValue.setBizSpaceCode(code);
                paramValue.setParamCode(dto2.getParentCode());
                paramValue.setItemCode(dto2.getCode());
                paramValue.setParamValue(dto2.getValue());
                sysParamValueDtoList.add(paramValue);
            }
        }
        ArrayList<BizExtImplValueReqDto> extImplValueDtoList = new ArrayList<BizExtImplValueReqDto>();
        List<BizSpaceConfigValueReqDto> extImplValueList = configValueMap.get(AbilityConstants.EXTENSION);
        if (CollectionUtils.isNotEmpty(extImplValueList)) {
            for (BizSpaceConfigValueReqDto dto3 : extImplValueList) {
                BizExtImplValueReqDto extImplValue = new BizExtImplValueReqDto();
                extImplValue.setBizSpaceCode(code);
                extImplValue.setBextCode(dto3.getParentCode());
                extImplValue.setBextImplCode(dto3.getCode());
                extImplValueDtoList.add(extImplValue);
            }
        }
        if (CollectionUtils.isNotEmpty(sysParamValueDtoList)) {
            this.sysParamService.setSysParamValueForTenant(code, sysParamValueDtoList);
        }
        if (CollectionUtils.isNotEmpty(extImplValueDtoList)) {
            this.bizExtensionService.setBizExtImplValue(code, extImplValueDtoList);
        }
    }

    @Override
    public String getSpaceCodeByInstanceId(Long instanceId) {
        if (instanceId == null) {
            return null;
        }
        String redisKey = "BizSpaceService:getSpaceCodeByInstanceId:instanceId:" + instanceId;
        String cache = (String)this.cacheService.getCache(redisKey, String.class);
        if (!StringUtils.isEmpty((CharSequence)cache)) {
            return cache;
        }
        RBizSpaceAppInstanceEo selectParam = new RBizSpaceAppInstanceEo();
        selectParam.setAppInstanceId(instanceId);
        List list = this.rBizSpaceAppInstanceDas.select((BaseEo)selectParam, Integer.valueOf(0), Integer.valueOf(1));
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        String result = ((RBizSpaceAppInstanceEo)list.get(0)).getBizSpaceCode();
        this.cacheService.setCache(redisKey, (Object)result);
        return result;
    }

    @Override
    public Long addBizSpaceAppInstanceRelation(BizSpaceAppInstanceRelationReqDto addReqDto) {
        addReqDto.setTenantId(this.context.tenantId());
        BizSpaceAppInstanceRelationEo bizSpaceAppInstanceRelationEo = new BizSpaceAppInstanceRelationEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)bizSpaceAppInstanceRelationEo);
        this.bizSpaceAppInstanceRelationDas.insert((BaseEo)bizSpaceAppInstanceRelationEo);
        return bizSpaceAppInstanceRelationEo.getId();
    }

    @Override
    public String readBizSpaceCode(ConfigQueryReq configQueryReq) {
        Long requestInstanceId = ServiceContext.getContext().getRequestInstanceId();
        if (requestInstanceId == null && configQueryReq.getBizIdContext() != null) {
            requestInstanceId = configQueryReq.getBizIdContext().getReqInstanceId();
            this.logger.info("\u8bf7\u6c42header\u4e2d\u6ca1\u6709instanceId,\u5c1d\u8bd5\u4f7f\u7528\u8bf7\u6c42\u4e2d\u7684instanceId:{}", (Object)requestInstanceId);
        }
        if (requestInstanceId != null) {
            String bizSpaceCode = this.getSpaceCodeByInstanceId(requestInstanceId);
            if (StringUtils.isBlank((CharSequence)bizSpaceCode)) {
                throw new BizException("\u8be5\u5b9e\u4f8b\u5c1a\u672a\u5173\u8054\u4efb\u4f55\u4e1a\u52a1\u7a7a\u95f4");
            }
            return bizSpaceCode;
        }
        this.logger.info("\u8bf7\u6c42header\u4e2d\u6ca1\u6709instanceId\u548c\u53c2\u6570\u4e2d\u90fd\u6ca1\u6709instanceId,\u4f7f\u7528\u5168\u5c40\u7684\u914d\u7f6e.");
        return null;
    }
}

