/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.func.biz.service.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.starter.bundle.materiel.consumer.service.impl.DtoUpdateServiceImpl;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.util.IdGenrator;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.data.api.dto.response.AppBundleRespDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.DtoAttributeQueryReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.DtoQueryReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.DtoAttributeQueryRespDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.DtoQueryRespDto;
import com.dtyunxi.yundt.cube.center.func.biz.service.IAppBundleService;
import com.dtyunxi.yundt.cube.center.func.biz.service.IBundleService;
import com.dtyunxi.yundt.cube.center.func.biz.service.ICapabilityDomainService;
import com.dtyunxi.yundt.cube.center.func.biz.service.IDtoService;
import com.dtyunxi.yundt.cube.center.func.biz.util.QueryUtil;
import com.dtyunxi.yundt.cube.center.func.dao.das.DtoAttributeDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.DtoAttributeHistoryDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.DtoDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.DtoHistoryDas;
import com.dtyunxi.yundt.cube.center.func.dao.eo.DtoAttributeEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.DtoAttributeHistoryEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.DtoEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.DtoHistoryEo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;

@Service
@RefreshScope
public class DtoServiceImpl
extends DtoUpdateServiceImpl
implements IDtoService {
    @Resource
    private DtoDas dtoDas;
    @Resource
    private DtoAttributeDas dtoAttributeDas;
    @Resource
    private DtoHistoryDas dtoHistoryDas;
    @Resource
    private DtoAttributeHistoryDas dtoAttributeHistoryDas;
    @Resource
    private IBundleService bundleService;
    @Resource
    private ICapabilityDomainService capabilityDomainService;
    @Autowired
    private IAppBundleService appBundleService;

    @Override
    public PageInfo<DtoQueryRespDto> queryDtoByPage(DtoQueryReqDto queryReqDto, Integer pageNum, Integer pageSize) {
        PageInfo<DtoQueryRespDto> dtoPageInfo;
        block15: {
            PageInfo eoPageInfo;
            block14: {
                DtoEo dtoEo = new DtoEo();
                DtoHelper.dto2Eo((BaseVo)queryReqDto, (BaseEo)dtoEo);
                ArrayList<SqlFilter> filters = new ArrayList<SqlFilter>();
                if (StringUtils.isNotEmpty((CharSequence)queryReqDto.getCode())) {
                    filters.add(SqlFilter.like((String)"code", (Object)("%" + queryReqDto.getCode() + "%")));
                    dtoEo.setCode(null);
                }
                if (StringUtils.isNotEmpty((CharSequence)queryReqDto.getName())) {
                    filters.add(SqlFilter.like((String)"name", (Object)("%" + queryReqDto.getName() + "%")));
                    dtoEo.setName(null);
                }
                if (StringUtils.isNotEmpty((CharSequence)queryReqDto.getBundleCode())) {
                    List<String> codeList = this.bundleService.getBundleCodeList(queryReqDto.getBundleCode());
                    if (CollectionUtils.isNotEmpty(codeList)) {
                        filters.add(SqlFilter.in((String)"bundle_code", (Object)StringUtils.join(codeList, (String)",")));
                        dtoEo.setBundleCode(null);
                    } else {
                        return new PageInfo();
                    }
                }
                if (StringUtils.isNotEmpty((CharSequence)queryReqDto.getDomain())) {
                    filters.add(SqlFilter.in((String)"domain", (Object)queryReqDto.getDomain()));
                    dtoEo.setDomain(null);
                }
                dtoEo.setSqlFilters(filters);
                dtoEo.setOrderBy("domain,code");
                eoPageInfo = this.dtoDas.selectPage((BaseEo)dtoEo, pageNum, pageSize);
                dtoPageInfo = new PageInfo<DtoQueryRespDto>();
                if (null != eoPageInfo && !CollectionUtils.isEmpty((Collection)eoPageInfo.getList())) break block14;
                DtoHistoryEo dtoHistoryEo = new DtoHistoryEo();
                CubeBeanUtils.copyProperties((Object)dtoHistoryEo, (Object)dtoEo, (String[])new String[0]);
                dtoHistoryEo.setSqlFilters(filters);
                dtoHistoryEo.setOrderBy("domain,code");
                PageInfo eoHistoryPageInfo = this.dtoHistoryDas.selectPage((BaseEo)dtoHistoryEo, pageNum, pageSize);
                if (null == eoHistoryPageInfo || CollectionUtils.isEmpty((Collection)eoHistoryPageInfo.getList())) {
                    return new PageInfo();
                }
                dtoPageInfo = QueryUtil.eoPage2DtoPage((PageInfo<? extends BaseEo>)eoHistoryPageInfo, DtoQueryRespDto.class);
                if (!CollectionUtils.isNotEmpty((Collection)dtoPageInfo.getList())) break block15;
                for (DtoQueryRespDto respDto : dtoPageInfo.getList()) {
                    List attributeHistoryEos;
                    if (StringUtils.isNotEmpty((CharSequence)respDto.getDomain())) {
                        respDto.setDomainName(this.capabilityDomainService.getDomainNameByDomainCode(respDto.getDomain()));
                    }
                    if (CollectionUtils.isNotEmpty((Collection)(attributeHistoryEos = this.dtoAttributeHistoryDas.select(respDto.getId())))) {
                        respDto.setAttributeCount(attributeHistoryEos.size());
                        ArrayList attributeList = new ArrayList();
                        DtoHelper.eoList2DtoList((Collection)attributeHistoryEos, attributeList, DtoAttributeQueryRespDto.class);
                        respDto.setAttributeList(attributeList);
                    }
                    respDto.setName(this.getDtoSimpleName(respDto.getName()));
                }
                break block15;
            }
            dtoPageInfo = QueryUtil.eoPage2DtoPage((PageInfo<? extends BaseEo>)eoPageInfo, DtoQueryRespDto.class);
            if (CollectionUtils.isNotEmpty((Collection)dtoPageInfo.getList())) {
                for (DtoQueryRespDto respDto : dtoPageInfo.getList()) {
                    List attributeEoList;
                    if (StringUtils.isNotEmpty((CharSequence)respDto.getDomain())) {
                        respDto.setDomainName(this.capabilityDomainService.getDomainNameByDomainCode(respDto.getDomain()));
                    }
                    if (CollectionUtils.isNotEmpty((Collection)(attributeEoList = this.dtoAttributeDas.select(respDto.getId())))) {
                        respDto.setAttributeCount(attributeEoList.size());
                        ArrayList attributeList = new ArrayList();
                        DtoHelper.eoList2DtoList((Collection)attributeEoList, attributeList, DtoAttributeQueryRespDto.class);
                        respDto.setAttributeList(attributeList);
                    }
                    respDto.setName(this.getDtoSimpleName(respDto.getName()));
                }
            }
        }
        return dtoPageInfo;
    }

    @Override
    public PageInfo<DtoAttributeQueryRespDto> queryDtoAttributeByPage(DtoAttributeQueryReqDto queryReqDto, Integer pageNum, Integer pageSize) {
        DtoAttributeEo dtoAttributeEo = new DtoAttributeEo();
        DtoHelper.dto2Eo((BaseVo)queryReqDto, (BaseEo)dtoAttributeEo);
        PageInfo eoPageInfo = this.dtoAttributeDas.selectPage((BaseEo)dtoAttributeEo, pageNum, pageSize);
        if (null == eoPageInfo || CollectionUtils.isEmpty((Collection)eoPageInfo.getList())) {
            DtoAttributeHistoryEo dtoAttributeHistoryEo = new DtoAttributeHistoryEo();
            DtoHelper.dto2Eo((BaseVo)queryReqDto, (BaseEo)dtoAttributeHistoryEo);
            PageInfo dtoAttributeEoPageInfo = this.dtoAttributeHistoryDas.selectPage((BaseEo)dtoAttributeHistoryEo, pageNum, pageSize);
            return QueryUtil.eoPage2DtoPage((PageInfo<? extends BaseEo>)dtoAttributeEoPageInfo, DtoAttributeQueryRespDto.class);
        }
        return QueryUtil.eoPage2DtoPage((PageInfo<? extends BaseEo>)eoPageInfo, DtoAttributeQueryRespDto.class);
    }

    public void backupDtoAndAttribute(String bundleCode, String version, List<com.dtyunxi.cube.starter.bundle.materiel.consumer.eo.DtoEo> dbDtoEoList) {
        String dtoDbVersion = dbDtoEoList.get(0).getBundleVersion();
        List dbDtoHistorys = this.dtoHistoryDas.select(bundleCode, dtoDbVersion);
        if (CollectionUtils.isNotEmpty((Collection)dbDtoHistorys)) {
            this.dtoHistoryDas.logicDeleteBatch(dbDtoHistorys);
            List dtoIds = dbDtoHistorys.stream().map(BaseEo::getId).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(dtoIds)) {
                this.dtoAttributeHistoryDas.logicDelete(dtoIds);
            }
        }
        ArrayList insertDtoHistoryEos = new ArrayList();
        ArrayList dtoAttributeHistoryEos = new ArrayList();
        if (CollectionUtils.isNotEmpty(dbDtoEoList)) {
            ArrayList dtoIds = new ArrayList();
            dbDtoEoList.forEach(dbDto -> {
                DtoHistoryEo dtoHistoryEo = new DtoHistoryEo();
                CubeBeanUtils.copyProperties((Object)dtoHistoryEo, (Object)dbDto, (String[])new String[]{"id", "create_time", "update_time"});
                insertDtoHistoryEos.add(dtoHistoryEo);
                dtoIds.add(dbDto.getId());
            });
            List attributeEos = this.dtoAttributeDas.select(dtoIds);
            if (CollectionUtils.isNotEmpty((Collection)attributeEos)) {
                attributeEos.forEach(attr -> {
                    DtoAttributeHistoryEo dtoAttributeHistoryEo = new DtoAttributeHistoryEo();
                    CubeBeanUtils.copyProperties((Object)dtoAttributeHistoryEo, (Object)attr, (String[])new String[]{"id", "create_time", "update_time"});
                    dtoAttributeHistoryEos.add(dtoAttributeHistoryEo);
                });
            }
        }
        if (CollectionUtils.isNotEmpty(insertDtoHistoryEos)) {
            this.dtoHistoryDas.insertBatch(insertDtoHistoryEos);
        }
        if (CollectionUtils.isNotEmpty(dtoAttributeHistoryEos)) {
            this.dtoAttributeHistoryDas.insertBatch(dtoAttributeHistoryEos);
        }
        List versionBackDtoHistoryEos = this.dtoHistoryDas.select(bundleCode, version);
        this.dtoHistoryDas.logicDeleteBatch(versionBackDtoHistoryEos);
        List versionBackDtoIds = versionBackDtoHistoryEos.stream().map(BaseEo::getId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(versionBackDtoIds)) {
            this.dtoAttributeHistoryDas.logicDelete(versionBackDtoIds);
        }
    }

    private Long getId() {
        return IdGenrator.getDistributedId();
    }

    private void deleteAttribute(DtoEo dtoEo) {
        DtoAttributeEo attributeEo = new DtoAttributeEo();
        attributeEo.setDtoId(dtoEo.getId());
        this.dtoAttributeDas.logicDelete((BaseEo)attributeEo);
    }

    private String getDtoSimpleName(String dtoName) {
        if (StringUtils.isNotBlank((CharSequence)dtoName) && dtoName.length() - dtoName.replace(".", "").length() > 1) {
            return dtoName.substring(dtoName.lastIndexOf("."));
        }
        return dtoName;
    }

    @Override
    public List<DtoQueryRespDto> queryByAppCodeAndVersion(String code, String version) {
        List<AppBundleRespDto> appBundleRespDtos = this.appBundleService.queryByAppCodeAndVersion(code, version);
        if (appBundleRespDtos.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<DtoQueryRespDto> result = new ArrayList<DtoQueryRespDto>();
        appBundleRespDtos.forEach(appBundleRespDto -> {
            List<DtoQueryRespDto> dtoQueryRespDtos = this.queryByBundleCodeAndVersion(appBundleRespDto.getBundleCode(), appBundleRespDto.getVersion());
            result.addAll(dtoQueryRespDtos);
        });
        return result;
    }

    private List<DtoQueryRespDto> queryByBundleCodeAndVersion(String bundleCode, String version) {
        DtoEo eo = new DtoEo();
        eo.setBundleCode(bundleCode);
        eo.setBundleVersion(version);
        List dtoEos = this.dtoDas.selectList((BaseEo)eo, Integer.valueOf(1), Integer.valueOf(9999));
        ArrayList<DtoQueryRespDto> result = new ArrayList<DtoQueryRespDto>();
        if (dtoEos.isEmpty()) {
            DtoHistoryEo dtoHistoryEo = new DtoHistoryEo();
            dtoHistoryEo.setBundleCode(bundleCode);
            dtoHistoryEo.setBundleVersion(version);
            List historyEoList = this.dtoHistoryDas.selectList((BaseEo)dtoHistoryEo, Integer.valueOf(1), Integer.valueOf(9999));
            if (!historyEoList.isEmpty()) {
                CubeBeanUtils.copyCollection(result, (Collection)historyEoList, DtoQueryRespDto.class);
            }
        } else {
            CubeBeanUtils.copyCollection(result, (Collection)dtoEos, DtoQueryRespDto.class);
        }
        if (!result.isEmpty()) {
            for (DtoQueryRespDto dto : result) {
                dto.setAttributeList(this.queryDtoAttributesByDtoId(dto.getId()));
            }
        }
        return result;
    }

    private List<DtoAttributeQueryRespDto> queryDtoAttributesByDtoId(Long dtoId) {
        List eoList = this.dtoAttributeDas.select(dtoId);
        ArrayList<DtoAttributeQueryRespDto> result = new ArrayList<DtoAttributeQueryRespDto>();
        if (eoList != null) {
            DtoHelper.eoList2DtoList((Collection)eoList, result, DtoAttributeQueryRespDto.class);
        } else {
            DtoHelper.eoList2DtoList((Collection)this.dtoAttributeHistoryDas.select(dtoId), result, DtoAttributeQueryRespDto.class);
        }
        return result;
    }
}

