/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.func.biz.service.impl;

import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.yundt.cube.center.func.api.constants.Constants;
import com.dtyunxi.yundt.cube.center.func.api.constants.SettingValueType;
import com.dtyunxi.yundt.cube.center.func.biz.service.IROptionSettingService;
import com.dtyunxi.yundt.cube.center.func.dao.das.OptionSettingRelationDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.SettingDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.SettingValueDas;
import com.dtyunxi.yundt.cube.center.func.dao.eo.OptionSettingRelationEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.SettingEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.SettingValueEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.StdOptionSettingRelationEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.StdSettingEo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class ROptionSettingServiceImpl
implements IROptionSettingService {
    @Resource
    private OptionSettingRelationDas optionSettingRelationDas;
    @Resource
    private SettingValueDas settingValueDas;
    @Resource
    private SettingDas settingDas;

    @Override
    public List<SettingEo> getRemoveParamSetting(List<SettingEo> settingEos) {
        Map code2Setting = settingEos.stream().filter(setting -> !setting.getValueType().equals(SettingValueType.SPIEXTPT.getCode()) && !setting.getValueType().equals(SettingValueType.DOMAINEVENT_EXTPT.getCode())).collect(Collectors.toMap(StdSettingEo::getCode, Function.identity(), (k1, k2) -> k1));
        ArrayList<SqlFilter> filters = new ArrayList<SqlFilter>();
        filters.add(SqlFilter.in((String)"depd_setting_code", (Object)StringUtils.join(code2Setting.keySet(), (String)",")));
        OptionSettingRelationEo relationQueryEo = new OptionSettingRelationEo();
        relationQueryEo.setSqlFilters(filters);
        List optionSettingRelationEos = this.optionSettingRelationDas.select((BaseEo)relationQueryEo, Integer.valueOf(1), Integer.valueOf(2000));
        ArrayList<SettingEo> removeSettingEos = new ArrayList<SettingEo>();
        if (CollectionUtils.isNotEmpty((Collection)optionSettingRelationEos)) {
            Map<String, List<OptionSettingRelationEo>> depd2ParentSetting = optionSettingRelationEos.stream().collect(Collectors.groupingBy(StdOptionSettingRelationEo::getDepdSettingCode));
            for (String depdCode : depd2ParentSetting.keySet()) {
                if (null == depd2ParentSetting.get(depdCode) || 1 != depd2ParentSetting.get(depdCode).size()) continue;
                removeSettingEos.add((SettingEo)code2Setting.get(depdCode));
            }
        }
        return removeSettingEos;
    }

    @Override
    public Integer getParamSettingSubType(String settingCode, boolean needValidParam, String parentSettingCode, String parentOptionCode) {
        boolean isParam;
        if (needValidParam && StringUtils.isNotBlank((CharSequence)parentOptionCode) && StringUtils.isNotBlank((CharSequence)parentOptionCode) && (isParam = this.optionSettingRelationDas.isParam(settingCode, parentSettingCode, parentOptionCode))) {
            return Constants.TRUE;
        }
        return Constants.FALSE;
    }

    @Override
    public Integer isRefForOtherSetting(String settingCode) {
        if (this.optionSettingRelationDas.isRefForOtherSetting(settingCode)) {
            return Constants.TRUE;
        }
        return Constants.FALSE;
    }

    @Override
    public void selectAndUpdateParamSettingIsCtrl(String settingCode, Integer isCtrl, Long currentTenantId, String bizSpaceCode, String bizIdCode) {
        OptionSettingRelationEo queryEo = new OptionSettingRelationEo();
        queryEo.setSettingCode(settingCode);
        List relationEos = this.optionSettingRelationDas.select((BaseEo)queryEo, Integer.valueOf(1), Integer.valueOf(1000));
        if (CollectionUtils.isNotEmpty((Collection)relationEos)) {
            Set depdSettingCodes = relationEos.stream().map(StdOptionSettingRelationEo::getDepdSettingCode).collect(Collectors.toSet());
            queryEo = new OptionSettingRelationEo();
            ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
            sqlFilters.add(SqlFilter.in((String)"depd_setting_code", (Object)StringUtils.join(depdSettingCodes, (String)",")));
            queryEo.setSqlFilters(sqlFilters);
            List otherSettingDepdRelations = this.optionSettingRelationDas.select((BaseEo)queryEo, Integer.valueOf(1), Integer.valueOf(3000));
            Map<String, List<OptionSettingRelationEo>> depd2SettingOptionMap = otherSettingDepdRelations.stream().collect(Collectors.groupingBy(StdOptionSettingRelationEo::getDepdSettingCode));
            HashSet<String> paramSettingDepdCodes = new HashSet<String>();
            for (String key : depd2SettingOptionMap.keySet()) {
                List<OptionSettingRelationEo> values = depd2SettingOptionMap.get(key);
                if (values.size() != 1) continue;
                paramSettingDepdCodes.add(key);
            }
            SettingEo querySettingEo = new SettingEo();
            sqlFilters = new ArrayList();
            sqlFilters.add(SqlFilter.in((String)"code", (Object)StringUtils.join(paramSettingDepdCodes, (String)",")));
            querySettingEo.setSqlFilters(sqlFilters);
            List settingEos = this.settingDas.select((BaseEo)querySettingEo, Integer.valueOf(1), Integer.valueOf(paramSettingDepdCodes.size()));
            for (SettingEo setting : settingEos) {
                if (setting.getValueType().equals(SettingValueType.SPIEXTPT.getCode()) || setting.getValueType().equals(SettingValueType.DOMAINEVENT_EXTPT.getCode())) continue;
                SettingValueEo settingValueEo = new SettingValueEo();
                settingValueEo.setSettingCode(setting.getCode());
                settingValueEo.setTenantId(currentTenantId);
                settingValueEo.setBizSpaceCode(bizSpaceCode);
                settingValueEo.setBizId(bizIdCode);
                List settingValueEos = this.settingValueDas.select((BaseEo)settingValueEo, Integer.valueOf(1), Integer.valueOf(1));
                if (!CollectionUtils.isNotEmpty((Collection)settingValueEos)) continue;
                SettingValueEo updateEo = new SettingValueEo();
                updateEo.setId(((SettingValueEo)settingValueEos.get(0)).getId());
                updateEo.setIsControlled(isCtrl);
                this.settingValueDas.updateSelective((BaseEo)updateEo);
            }
        }
    }
}

