/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.func.biz.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.yundt.cube.center.data.dto.LocalCacheUpdaterDto;
import com.dtyunxi.yundt.cube.center.func.api.constants.Constants;
import com.dtyunxi.yundt.cube.center.func.api.constants.SettingEditType;
import com.dtyunxi.yundt.cube.center.func.biz.service.ISettingValueService;
import com.dtyunxi.yundt.cube.center.func.biz.service.IUserTenantService;
import com.dtyunxi.yundt.cube.center.func.biz.service.domain.SettingCandidateValue;
import com.dtyunxi.yundt.cube.center.func.biz.service.impl.BizConfCacheService;
import com.dtyunxi.yundt.cube.center.func.biz.service.impl.BizIdServiceImpl;
import com.dtyunxi.yundt.cube.center.func.dao.das.RBizSpaceAppInstanceDas;
import com.dtyunxi.yundt.cube.center.func.dao.das.SettingValueDas;
import com.dtyunxi.yundt.cube.center.func.dao.eo.RBizSpaceAppInstanceEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.SettingEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.SettingOptionEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.SettingValueEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.StdSettingEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.StdSettingOptionEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.StdSettingValueEo;
import com.dtyunxi.yundt.cube.center.func.dao.mapper.SettingValueMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class SettingValueServiceImpl
implements ISettingValueService {
    private Logger logger = LoggerFactory.getLogger(SettingValueServiceImpl.class);
    @Resource
    private SettingValueDas settingValueDas;
    @Resource
    private IUserTenantService userTenantService;
    @Autowired
    private BizConfCacheService bizConfCacheService;
    @Resource
    private BizIdServiceImpl bizIdService;
    @Resource
    private RBizSpaceAppInstanceDas rBizSpaceAppInstanceDas;
    @Resource
    private SettingValueMapper settingValueMapper;

    @Override
    public List<SettingValueEo> getSettingValueByCondition(List<String> settingCodes, Long tenantId, String bizSpaceCode, String bizIdCode) {
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        if (!CollectionUtils.isEmpty(settingCodes)) {
            sqlFilters.add(SqlFilter.in((String)"setting_code", (Object)StringUtils.join(settingCodes, (String)",")));
        }
        SettingValueEo settingValueEo = new SettingValueEo();
        if (bizIdCode == null) {
            sqlFilters.add(SqlFilter.isNull((String)"biz_id"));
        } else if (bizIdCode.equals("")) {
            sqlFilters.add(SqlFilter.eq((String)"biz_id", (Object)""));
        } else {
            settingValueEo.setBizId(bizIdCode);
        }
        if (bizSpaceCode == null) {
            sqlFilters.add(SqlFilter.isNull((String)"biz_space_code"));
        } else if (bizSpaceCode.equals("")) {
            sqlFilters.add(SqlFilter.eq((String)"biz_space_code", (Object)""));
        } else {
            settingValueEo.setBizSpaceCode(bizSpaceCode);
        }
        settingValueEo.setTenantId(tenantId);
        settingValueEo.setSqlFilters(sqlFilters);
        return this.settingValueDas.select((BaseEo)settingValueEo, Integer.valueOf(1), Integer.valueOf(5000));
    }

    @Override
    public void createSettingValue(List<SettingValueEo> settingValueEos) {
        this.settingValueDas.insertBatch(settingValueEos);
        for (SettingValueEo settingValueEo : settingValueEos) {
            this.removeSettingCache(settingValueEo);
        }
        this.bizIdService.clearBizIdMapCache();
    }

    @Override
    public void updateSettingValue(SettingValueEo settingValueEo) {
        this.settingValueDas.updateSelective((BaseEo)settingValueEo);
        this.removeSettingCache(settingValueEo);
        this.bizIdService.clearBizIdMapCache();
    }

    private void removeSettingCache(SettingValueEo settingValueEo) {
        LocalCacheUpdaterDto localCacheUpdaterDto = this.createLocalCacheUpdate(settingValueEo);
        this.bizConfCacheService.removeGlobalSetting(localCacheUpdaterDto);
        if (localCacheUpdaterDto.getBizId() != null) {
            this.bizConfCacheService.removeIdSetting(localCacheUpdaterDto);
        }
        if (localCacheUpdaterDto.getTenantId() != null) {
            this.bizConfCacheService.removeTenantSetting(localCacheUpdaterDto);
        }
        if (settingValueEo.getBizSpaceCode() != null) {
            CompletableFuture.runAsync(() -> {
                RBizSpaceAppInstanceEo selectParam = new RBizSpaceAppInstanceEo();
                selectParam.setBizSpaceCode(settingValueEo.getBizSpaceCode());
                List instanceId4SpaceList = this.rBizSpaceAppInstanceDas.select((BaseEo)selectParam);
                if (!CollectionUtils.isEmpty((Collection)instanceId4SpaceList)) {
                    LocalCacheUpdaterDto spaceUpdate = new LocalCacheUpdaterDto();
                    spaceUpdate.setSettingCode(settingValueEo.getSettingCode());
                    instanceId4SpaceList.forEach(item -> {
                        spaceUpdate.setInstanceId(item.getAppInstanceId());
                        this.bizConfCacheService.removeSpaceSetting(spaceUpdate);
                    });
                }
            }).exceptionally(e -> {
                this.logger.warn("\u66f4\u65b0[{}]\u4e1a\u52a1\u7a7a\u95f4\u4e0b\u5b9e\u4f8b\u7684[{}]\u914d\u7f6e\u9879\u7f13\u5b58\u5f02\u5e38:", new Object[]{settingValueEo.getBizSpaceCode(), settingValueEo.getSettingCode(), e});
                return null;
            });
        }
    }

    private LocalCacheUpdaterDto createLocalCacheUpdate(SettingValueEo settingValueEo) {
        LocalCacheUpdaterDto localCacheUpdaterDto = new LocalCacheUpdaterDto();
        localCacheUpdaterDto.setBizId(settingValueEo.getBizId());
        localCacheUpdaterDto.setSettingCode(settingValueEo.getSettingCode());
        localCacheUpdaterDto.setTenantId(settingValueEo.getTenantId());
        return localCacheUpdaterDto;
    }

    @Override
    public void removeSettingValue(SettingValueEo settingValueEo) {
        this.settingValueDas.delete((BaseEo)settingValueEo);
        this.removeSettingCache(settingValueEo);
    }

    @Override
    public void removeSettingValue(List<SettingValueEo> settingValueEos) {
        for (SettingValueEo removeEo : settingValueEos) {
            this.removeSettingValue(removeEo);
        }
    }

    @Override
    public void setSettingValue(List<SettingEo> settingEos, List<SettingOptionEo> settingOptionEos, Long tenantId) {
        List<String> settingCodes = settingEos.stream().map(StdSettingEo::getCode).collect(Collectors.toList());
        Map<Object, Object> settingCode2Options = new HashMap();
        if (!CollectionUtils.isEmpty(settingOptionEos)) {
            settingCode2Options = settingOptionEos.stream().collect(Collectors.groupingBy(StdSettingOptionEo::getSettingCode));
        }
        List<SettingValueEo> settingValueEos = this.getSettingValueByCondition(settingCodes, tenantId, null, null);
        HashMap<String, SettingValueEo> settingCodesInValue = new HashMap<String, SettingValueEo>();
        for (SettingValueEo s : settingValueEos) {
            if (StringUtils.isNotBlank((CharSequence)s.getOptionCode())) {
                settingCodesInValue.put(s.getSettingCode() + s.getOptionCode(), s);
                continue;
            }
            settingCodesInValue.put(s.getSettingCode(), s);
        }
        ArrayList<SettingValueEo> processedEos = new ArrayList<SettingValueEo>();
        ArrayList<SettingValueEo> insertValues = new ArrayList<SettingValueEo>();
        for (SettingEo eo : settingEos) {
            if (eo.getEditType().equals(SettingEditType.INPUT.getCode()) && StringUtils.isNotBlank((CharSequence)eo.getDefaultValue())) {
                SettingValueEo e = (SettingValueEo)settingCodesInValue.get(eo.getCode());
                if (e == null) {
                    SettingValueEo settingValueEo = new SettingValueEo();
                    settingValueEo.setSettingCode(eo.getCode());
                    settingValueEo.setSettingValue(eo.getDefaultValue());
                    settingValueEo.setIsControlled(eo.getIsControlled());
                    settingValueEo.setDisplayLevel(eo.getDisplayLevel());
                    settingValueEo.setTenantId(tenantId);
                    settingValueEo.setExtension("");
                    insertValues.add(settingValueEo);
                    continue;
                }
                processedEos.add(e);
                continue;
            }
            if (!eo.getEditType().equals(SettingEditType.CHOICE.getCode()) || CollectionUtils.isEmpty(settingCode2Options) || CollectionUtils.isEmpty((Collection)((Collection)settingCode2Options.get(eo.getCode())))) continue;
            List optionEos = (List)settingCode2Options.get(eo.getCode());
            for (SettingOptionEo o : optionEos) {
                SettingValueEo e = (SettingValueEo)settingCodesInValue.get(eo.getCode() + o.getCode());
                if (e == null && o.getIsDefault() != null && o.getIsDefault().equals(Constants.TRUE)) {
                    SettingValueEo settingValueEo = new SettingValueEo();
                    settingValueEo.setSettingCode(eo.getCode());
                    settingValueEo.setOptionCode(o.getCode());
                    settingValueEo.setSettingValue(o.getOptionValue());
                    settingValueEo.setIsControlled(eo.getIsControlled());
                    settingValueEo.setDisplayLevel(eo.getDisplayLevel());
                    settingValueEo.setTenantId(tenantId);
                    settingValueEo.setExtension("");
                    insertValues.add(settingValueEo);
                    continue;
                }
                processedEos.add(e);
            }
        }
        this.createSettingValue(insertValues);
        settingValueEos.removeAll(processedEos);
        this.removeSettingValue(settingValueEos);
    }

    @Override
    public SettingCandidateValue queryCandidateValue(String settingCode) {
        Long tenantId = ServiceContext.getContext().getRequestTenantId();
        List values = this.settingValueDas.queryAvailableByCode(settingCode, tenantId);
        return SettingCandidateValue.build(values);
    }

    @Override
    public boolean validateSettingWithValue(String settingCode, String settingOptionCode, String optionValue) {
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)settingCode), (String)"\u53c2\u6570\u9519\u8bef");
        SettingValueEo settingValueEo = new SettingValueEo();
        settingValueEo.setOptionCode(settingOptionCode);
        settingValueEo.setSettingCode(settingCode);
        List settingValueEos = this.settingValueDas.select((BaseEo)settingValueEo);
        if (CollectionUtils.isEmpty((Collection)settingValueEos)) {
            return false;
        }
        if (StringUtils.isNotBlank((CharSequence)settingOptionCode) && StringUtils.isNotBlank((CharSequence)optionValue)) {
            SettingValueEo valueOption = (SettingValueEo)settingValueEos.get(0);
            return null != valueOption && StringUtils.isNotBlank((CharSequence)valueOption.getSettingValue()) && !valueOption.getSettingValue().equals(optionValue);
        }
        return true;
    }

    @Override
    public boolean validateIsCtrlWithChildValue(String settingCode, Long currentId, String bizSpaceCode, String bizIdCode) {
        Long globalTenantId = this.userTenantService.getGlobalTenantId();
        if (globalTenantId.equals(currentId)) {
            return this.settingValueDas.queryGlobalTenantSettingValueCount(settingCode, globalTenantId) > 0;
        }
        if (!globalTenantId.equals(currentId) && StringUtils.isBlank((CharSequence)bizSpaceCode) && StringUtils.isBlank((CharSequence)bizIdCode)) {
            return this.settingValueDas.queryChildTenantSettingValueCount(settingCode, currentId) > 0;
        }
        if (!globalTenantId.equals(currentId) && StringUtils.isNotBlank((CharSequence)bizSpaceCode) && StringUtils.isBlank((CharSequence)bizIdCode)) {
            return this.settingValueDas.queryChildBizSpaceSettingValueCount(settingCode, currentId, bizSpaceCode) > 0;
        }
        if (StringUtils.isNotBlank((CharSequence)bizIdCode)) {
            return false;
        }
        return false;
    }

    @Override
    public Set<String> getOptionCodeListBySettingInValue(String settingCode) {
        SettingValueEo settingValueEo = new SettingValueEo();
        settingValueEo.setSettingCode(settingCode);
        List settingValueEos = this.settingValueDas.select((BaseEo)settingValueEo);
        if (CollectionUtils.isEmpty((Collection)settingValueEos)) {
            return new HashSet<String>();
        }
        return settingValueEos.stream().filter(eo -> StringUtils.isNotBlank((CharSequence)eo.getOptionCode())).map(StdSettingValueEo::getOptionCode).collect(Collectors.toSet());
    }

    @Override
    public Boolean isExsitChoiceValue(String settingCode, String optionCode) {
        if (StringUtils.isBlank((CharSequence)settingCode)) {
            return false;
        }
        SettingValueEo settingValueEo = new SettingValueEo();
        settingValueEo.setSettingCode(settingCode);
        if (StringUtils.isNotBlank((CharSequence)optionCode)) {
            settingValueEo.setOptionCode(optionCode);
        }
        return this.settingValueDas.count((BaseEo)settingValueEo) > 0;
    }

    @Override
    public Boolean isExistGlobalChoiceValue(String settingCode, String optionCode) {
        if (StringUtils.isBlank((CharSequence)settingCode)) {
            return false;
        }
        return this.settingValueMapper.selectCount((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(StdSettingValueEo::getSettingCode, (Object)settingCode)).eq(StrUtil.isNotBlank((CharSequence)optionCode), StdSettingValueEo::getOptionCode, (Object)optionCode)).eq(BaseEo::getTenantId, (Object)1L)).isNull(StdSettingValueEo::getBizSpaceCode)).isNull(StdSettingValueEo::getBizId)) > 0;
    }
}

