/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.func.biz.support;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.func.api.constants.AbilityConstants;
import com.dtyunxi.yundt.cube.center.func.biz.support.identitys.BizIdentityDto;
import com.dtyunxi.yundt.cube.center.func.dao.das.BizSpaceDas;
import com.dtyunxi.yundt.cube.center.func.dao.eo.BizSpaceEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.StdBizRuleEo;
import com.dtyunxi.yundt.cube.center.func.dao.eo.extend.BizRuleExtendEo;
import com.dtyunxi.yundt.cube.center.func.dao.mapper.BizRuleMapper;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class BusinessIdentityLoadService {
    private static final Logger logger = LoggerFactory.getLogger(BusinessIdentityLoadService.class);
    @Resource
    private BizSpaceDas bizSpaceDas;
    @Resource
    private BizRuleMapper bizRuleMapper;

    public Collection<BizIdentityDto> load(Long instanceId) {
        BizSpaceEo selectParam = new BizSpaceEo();
        selectParam.setInstanceId(instanceId);
        selectParam.setStatus(AbilityConstants.ENABLE);
        List bizSpaceEos = this.bizSpaceDas.select((BaseEo)selectParam);
        if (CollectionUtils.isEmpty((Collection)bizSpaceEos)) {
            logger.warn("\u5f53\u524d\u5b9e\u4f8b\u672a\u914d\u7f6e\u4e1a\u52a1\u7a7a\u95f4:{}", (Object)instanceId);
            throw new BizException("\u5f53\u524d\u5b9e\u4f8b\u672a\u914d\u7f6e\u4e1a\u52a1\u7a7a\u95f4");
        }
        String bizSpaceCode = ((BizSpaceEo)bizSpaceEos.get(0)).getCode();
        LinkedList bizIdentityCodes = new LinkedList();
        if (CollectionUtils.isEmpty(bizIdentityCodes)) {
            return Collections.emptyList();
        }
        LinkedList<BizIdentityDto> list = new LinkedList<BizIdentityDto>();
        List bizRuleExtendEos = this.bizRuleMapper.selectByParam(bizIdentityCodes, bizSpaceCode);
        if (CollectionUtils.isNotEmpty((Collection)bizRuleExtendEos)) {
            bizRuleExtendEos.stream().collect(Collectors.groupingBy(BizRuleExtendEo::getBizIdentityCode, Collectors.toList())).forEach((groupKey, groupList) -> {
                BizIdentityDto bizIdentityDto = new BizIdentityDto();
                bizIdentityDto.setCode((String)groupKey);
                bizIdentityDto.setExpressions(groupList.stream().map(StdBizRuleEo::getCodeExpression).collect(Collectors.toList()));
                list.add(bizIdentityDto);
            });
        }
        return list;
    }
}

