/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.func.dao.das;

import com.dtyunxi.cube.starter.bundle.materiel.consumer.das.AbstractBaseDas;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.yundt.cube.center.func.dao.eo.SettingOptionEo;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SettingOptionDas
extends AbstractBaseDas<SettingOptionEo, String> {
    public List<SettingOptionEo> selectBySettingCode(String settingCode) {
        SettingOptionEo querySettingOptionEo = new SettingOptionEo();
        querySettingOptionEo.setSettingCode(settingCode);
        return this.select((BaseEo)querySettingOptionEo);
    }

    public List<SettingOptionEo> selectBySettingCodeList(List<String> settingCodes, List<String> bundleCodes) {
        SettingOptionEo querySettingOptionEo = new SettingOptionEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        if (!CollectionUtils.isEmpty(settingCodes)) {
            sqlFilters.add(SqlFilter.in((String)"setting_code", (Object)StringUtils.join(settingCodes, (String)",")));
        }
        if (!CollectionUtils.isEmpty(bundleCodes)) {
            sqlFilters.add(SqlFilter.in((String)"bundle", (Object)StringUtils.join(bundleCodes, (String)",")));
        }
        querySettingOptionEo.setSqlFilters(sqlFilters);
        return this.select((BaseEo)querySettingOptionEo);
    }

    public List<SettingOptionEo> select(String settingCode, List<String> optionCodes) {
        if (StringUtils.isBlank((CharSequence)settingCode) && CollectionUtils.isEmpty(optionCodes)) {
            return new ArrayList<SettingOptionEo>();
        }
        SettingOptionEo querySettingOptionEo = new SettingOptionEo();
        querySettingOptionEo.setSettingCode(settingCode);
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        if (!CollectionUtils.isEmpty(optionCodes)) {
            sqlFilters.add(SqlFilter.in((String)"code", (Object)StringUtils.join(optionCodes, (String)",")));
        }
        querySettingOptionEo.setSqlFilters(sqlFilters);
        return this.select((BaseEo)querySettingOptionEo);
    }

    public void logicDelete(String bundleCode) {
        SettingOptionEo optionEo = new SettingOptionEo();
        optionEo.setBundle(bundleCode);
        int count = this.count((BaseEo)optionEo);
        List deleteEos = this.select((BaseEo)optionEo, 1, count);
        for (SettingOptionEo deleteEo : deleteEos) {
            this.logicDeleteById(deleteEo.getId());
        }
    }

    public List<SettingOptionEo> getOptionByCondition(List<String> settingCodes, String bundleCode, String version) {
        SettingOptionEo querySettingOptionEo = new SettingOptionEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        if (!CollectionUtils.isEmpty(settingCodes)) {
            sqlFilters.add(SqlFilter.in((String)"setting_code", (Object)StringUtils.join(settingCodes, (String)",")));
        }
        querySettingOptionEo.setBundle(bundleCode);
        querySettingOptionEo.setVersion(version);
        querySettingOptionEo.setSqlFilters(sqlFilters);
        return this.select((BaseEo)querySettingOptionEo);
    }
}

