
CREATE TABLE IF NOT EXISTS `bd_ability`  (
  `id` bigint(20) NOT NULL COMMENT '主键id',
  `code` varchar(50)  NULL DEFAULT NULL COMMENT '编码',
  `name` varchar(50)  NULL DEFAULT NULL COMMENT '名称',
  `status` tinyint(4) NULL DEFAULT NULL COMMENT '0 禁用  1启用',
  `remark` varchar(200)  NULL DEFAULT NULL COMMENT '备注',
  `extension` varchar(1024)  NOT NULL DEFAULT '' COMMENT '业务扩展字段',
  `instance_id` bigint(20) NOT NULL DEFAULT 0 COMMENT '应用实例id',
  `tenant_id` bigint(20) NOT NULL DEFAULT 0 COMMENT '租户id',
  `dr` tinyint(2) NOT NULL DEFAULT 0 COMMENT '逻辑删除字段',
  `create_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '创建人',
  `create_time` datetime(0) NOT NULL DEFAULT '1000-01-01 00:00:00' COMMENT '创建时间',
  `update_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '修改人',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '能力信息' ROW_FORMAT = Dynamic;


CREATE TABLE IF NOT EXISTS `bd_ability_group`  (
  `id` bigint(20) NOT NULL COMMENT '主键id',
  `code` varchar(50)  NULL DEFAULT NULL COMMENT '编码',
  `parent_code` varchar(50)  NULL DEFAULT NULL COMMENT '父编码',
  `type` tinyint(4) NULL DEFAULT NULL COMMENT '1 领域 2 场景',
  `sort` tinyint(4) NULL DEFAULT NULL COMMENT '排序',
  `name` varchar(50)  NULL DEFAULT NULL COMMENT '名称',
  `status` tinyint(4) NULL DEFAULT NULL COMMENT '0 禁用  1启用',
  `remark` varchar(200)  NULL DEFAULT NULL COMMENT '备注',
  `extension` varchar(1024)  NOT NULL DEFAULT '' COMMENT '业务扩展字段',
  `instance_id` bigint(20) NOT NULL DEFAULT 0 COMMENT '应用实例id',
  `tenant_id` bigint(20) NOT NULL DEFAULT 0 COMMENT '租户id',
  `dr` tinyint(2) NOT NULL DEFAULT 0 COMMENT '逻辑删除字段',
  `create_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '创建人',
  `create_time` datetime(0) NOT NULL DEFAULT '1000-01-01 00:00:00' COMMENT '创建时间',
  `update_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '修改人',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '能力分类信息，包含领域信息、场景信息' ROW_FORMAT = Dynamic;


CREATE TABLE IF NOT EXISTS `bd_api`  (
  `id` bigint(20) NOT NULL COMMENT '主键id',
  `api_name` varchar(255)  NULL DEFAULT NULL COMMENT 'API名称',
  `api_desc` text  NULL COMMENT '接口描述',
  `path` varchar(255)  NULL DEFAULT NULL COMMENT 'API路径',
  `method` varchar(32)  NULL DEFAULT NULL COMMENT '请求方式',
  `request_param` text  NULL COMMENT '请求参数',
  `request_demo` text  NULL COMMENT '请求示例',
  `response_param` text  NULL COMMENT '响应参数',
  `response_demo` text  NULL COMMENT '响应示例',
  `deprecate` int(11) NULL DEFAULT 0 COMMENT '是否作废：0=否、1=是',
  `group_code` varchar(128)  NULL DEFAULT NULL COMMENT 'API归属的interface编码，类全限定名',
  `group_name` varchar(255)  NULL DEFAULT NULL COMMENT '分组名',
  `group_desc` varchar(255)  NULL DEFAULT NULL COMMENT '分组描述',
  `module_code` varchar(128)  NULL DEFAULT NULL COMMENT '所属应用',
  `version` varchar(32)  NULL DEFAULT '' COMMENT '版本号',
  `status` int(11) NULL DEFAULT NULL COMMENT '状态：0=下架、1=上架',
  `bundle_code` varchar(200)  NULL DEFAULT NULL COMMENT '功能包编码',
  `capability_code` varchar(256)  NULL DEFAULT NULL COMMENT '能力编码',
  `artifact_id` varchar(64)  NULL DEFAULT NULL COMMENT '功能包项目名',
  `group_id` varchar(64)  NULL DEFAULT NULL COMMENT '功能包分组名',
  `extension` varchar(1024)  NULL DEFAULT NULL COMMENT '扩展信息',
  `instance_id` bigint(20) NOT NULL COMMENT '实例ID',
  `tenant_id` bigint(20) NOT NULL COMMENT '租户ID',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '修改时间',
  `create_person` varchar(60)  NULL DEFAULT NULL COMMENT '创建人',
  `update_person` varchar(60)  NULL DEFAULT NULL COMMENT '修改人',
  `dr` tinyint(4) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志,0表示未删除，1表示删除',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = 'API' ROW_FORMAT = Dynamic;


CREATE TABLE IF NOT EXISTS `bd_api_group`  (
  `id` bigint(20) NOT NULL COMMENT '主键id',
  `group_name` varchar(255)  NULL DEFAULT NULL COMMENT '分组',
  `parent_group_name` varchar(255)  NULL DEFAULT NULL COMMENT '父分组',
  `description` text  NULL COMMENT '分组描述',
  `error_code` text  NULL COMMENT '错误码',
  `status` int(11) NULL DEFAULT NULL COMMENT '状态：0=下架、1=上架',
  `extension` varchar(1024)  NULL DEFAULT NULL COMMENT '扩展信息',
  `instance_id` bigint(20) NOT NULL COMMENT '实例ID',
  `tenant_id` bigint(20) NOT NULL COMMENT '租户ID',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '修改时间',
  `create_person` varchar(60)  NULL DEFAULT NULL COMMENT '创建人',
  `update_person` varchar(60)  NULL DEFAULT NULL COMMENT '修改人',
  `dr` tinyint(4) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志,0表示未删除，1表示删除',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = 'API分组' ROW_FORMAT = Dynamic;


CREATE TABLE IF NOT EXISTS `bd_api_history`  (
  `id` bigint(20) NOT NULL COMMENT '主键id',
  `api_name` varchar(255)  NULL DEFAULT NULL COMMENT 'API名称',
  `api_desc` text  NULL COMMENT '接口描述',
  `path` varchar(255)  NULL DEFAULT NULL COMMENT 'API路径',
  `method` varchar(32)  NULL DEFAULT NULL COMMENT '请求方式',
  `request_param` text  NULL COMMENT '请求参数',
  `request_demo` text  NULL COMMENT '请求示例',
  `response_param` text  NULL COMMENT '响应参数',
  `response_demo` text  NULL COMMENT '响应示例',
  `deprecate` int(11) NULL DEFAULT 0 COMMENT '是否作废：0=否、1=是',
  `group_code` varchar(128)  NULL DEFAULT NULL COMMENT 'API归属的interface编码，类全限定名',
  `group_name` varchar(255)  NULL DEFAULT NULL COMMENT '分组名',
  `group_desc` varchar(255)  NULL DEFAULT NULL COMMENT '分组描述',
  `module_code` varchar(128)  NULL DEFAULT NULL COMMENT '所属应用',
  `version` varchar(32)  NULL DEFAULT '' COMMENT '版本号',
  `status` int(11) NULL DEFAULT NULL COMMENT '状态：0=下架、1=上架',
  `extension` varchar(1024)  NULL DEFAULT NULL COMMENT '扩展信息',
  `instance_id` bigint(20) NOT NULL COMMENT '实例ID',
  `tenant_id` bigint(20) NOT NULL COMMENT '租户ID',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '修改时间',
  `create_person` varchar(60)  NULL DEFAULT NULL COMMENT '创建人',
  `update_person` varchar(60)  NULL DEFAULT NULL COMMENT '修改人',
  `dr` tinyint(4) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志,0表示未删除，1表示删除',
  `group_id` varchar(64)  NULL DEFAULT NULL COMMENT '功能包分组名',
  `artifact_id` varchar(64)  NULL DEFAULT NULL COMMENT '功能包项目名',
  `capability_code` varchar(256)  NULL DEFAULT NULL COMMENT '能力编码',
  `bundle_code` varchar(200)  NULL DEFAULT NULL COMMENT '功能包编码',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = 'API备份表' ROW_FORMAT = Dynamic;


CREATE TABLE IF NOT EXISTS `bd_api_prop_permission`  (
  `id` bigint(20) NOT NULL COMMENT '主键id',
  `dto_code` varchar(255)  NULL DEFAULT NULL COMMENT 'API响应DTO编码[DTO全限定名]',
  `property_code` varchar(50)  NULL DEFAULT NULL COMMENT 'API响应DTO属性编码[属性名称]',
  `parent_id` bigint(20) NOT NULL DEFAULT 0 COMMENT '父权限id',
  `hierarchy` int(11) NULL DEFAULT NULL COMMENT '属性层级',
  `create_op` tinyint(1) NULL DEFAULT NULL COMMENT '创建操作权限[0:无 1:有 ]',
  `read_op` tinyint(1) NULL DEFAULT NULL COMMENT '读操作权限[0:无 1:有 ]',
  `update_op` tinyint(1) NULL DEFAULT NULL COMMENT '更新操作权限[0:无 1:有 ]',
  `delete_op` tinyint(1) NULL DEFAULT NULL COMMENT '删除操作权限[0:无 1:有 ]',
  `holder_type` tinyint(4) NULL DEFAULT NULL COMMENT '权限持有者类型[0:业务空间、1:业务身份、2:应用（多个实例对应一个应用）]',
  `holder_code` varchar(255)  NULL DEFAULT NULL COMMENT '权限持有者编码',
  `status` tinyint(1) NULL DEFAULT NULL COMMENT '0 禁用  1启用',
  `remark` varchar(200)  NULL DEFAULT NULL COMMENT '备注',
  `extension` varchar(1024)  NOT NULL DEFAULT '' COMMENT '业务扩展字段',
  `instance_id` bigint(20) NOT NULL DEFAULT 0 COMMENT '应用实例id',
  `tenant_id` bigint(20) NOT NULL DEFAULT 0 COMMENT '租户id',
  `dr` tinyint(2) NOT NULL DEFAULT 0 COMMENT '逻辑删除字段',
  `create_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '创建人',
  `create_time` datetime(0) NOT NULL DEFAULT '1000-01-01 00:00:00' COMMENT '创建时间',
  `update_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '修改人',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `dto_prop_code`(`dto_code`, `property_code`) USING BTREE COMMENT 'dto加属性联合索引',
  INDEX `holder_code_type`(`holder_code`, `holder_type`) USING BTREE COMMENT '持有者编码和持有者类型联合索引'
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = 'API属性权限' ROW_FORMAT = Dynamic;


CREATE TABLE IF NOT EXISTS `bd_biz_ext_impl`  (
  `id` bigint(20) NOT NULL COMMENT '主键id',
  `bext_code` varchar(255)  NULL DEFAULT NULL COMMENT '扩展点代码',
  `bext_impl_code` varchar(255)  NULL DEFAULT NULL COMMENT '扩展点实现代码',
  `bext_impl_name` varchar(50)  NULL DEFAULT NULL COMMENT '扩展点实现名称',
  `bext_impl_desc` varchar(2048)  NULL DEFAULT NULL COMMENT '扩展点实现描述',
  `sort_no` int(11) NULL DEFAULT NULL COMMENT '排序号',
  `effect_app` varchar(512)  NULL DEFAULT NULL COMMENT '影响的应用系统\r\n            提供扩展点实现的系统,多个有英文半角逗号分隔',
  `cur_ver` varchar(32)  NULL DEFAULT NULL COMMENT '当前版本',
  `cur_ver_release_time` datetime(0) NULL DEFAULT NULL COMMENT '当前版本注册时间',
  `remark` varchar(2048)  NULL DEFAULT NULL COMMENT '备注',
  `extension` varchar(1024)  NULL DEFAULT NULL COMMENT '扩展信息',
  `instance_id` bigint(20) NOT NULL COMMENT '实例ID',
  `tenant_id` bigint(20) NOT NULL COMMENT '租户ID',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '修改时间',
  `create_person` varchar(60)  NULL DEFAULT NULL COMMENT '创建人',
  `update_person` varchar(60)  NULL DEFAULT NULL COMMENT '修改人',
  `dr` tinyint(4) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志,0表示未删除，1表示删除',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_bext_code`(`bext_code`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '业务扩展点实现' ROW_FORMAT = Dynamic;


CREATE TABLE IF NOT EXISTS `bd_biz_ext_impl_scope`  (
  `id` bigint(20) NOT NULL COMMENT '主键id',
  `biz_id_code` varchar(128)  NULL DEFAULT NULL COMMENT '业务身份',
  `bext_code` varchar(255)  NULL DEFAULT NULL COMMENT '扩展点代码',
  `bext_impl_code` varchar(255)  NULL DEFAULT NULL COMMENT '扩展点实现代码',
  `extension` varchar(1024)  NULL DEFAULT NULL COMMENT '扩展信息',
  `instance_id` bigint(20) NOT NULL COMMENT '实例ID',
  `tenant_id` bigint(20) NOT NULL COMMENT '租户ID',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '修改时间',
  `create_person` varchar(60)  NULL DEFAULT NULL COMMENT '创建人',
  `update_person` varchar(60)  NULL DEFAULT NULL COMMENT '修改人',
  `dr` tinyint(4) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志,0表示未删除，1表示删除',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_bext_code`(`bext_code`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '业务扩展点范围\r\n' ROW_FORMAT = Dynamic;


CREATE TABLE IF NOT EXISTS `bd_biz_ext_impl_value`  (
  `id` bigint(20) NOT NULL COMMENT '主键id',
  `biz_space_code` varchar(255)  NOT NULL DEFAULT '' COMMENT '业务空间编码',
  `biz_id_code` varchar(128)  NULL DEFAULT NULL COMMENT '业务身份',
  `bext_code` varchar(255)  NULL DEFAULT NULL COMMENT '扩展点代码',
  `bext_impl_code` varchar(255)  NULL DEFAULT NULL COMMENT '采用的实现',
  `extension` varchar(1024)  NULL DEFAULT NULL COMMENT '扩展信息',
  `instance_id` bigint(20) NOT NULL COMMENT '实例ID',
  `tenant_id` bigint(20) NOT NULL COMMENT '租户ID',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '修改时间',
  `create_person` varchar(60)  NULL DEFAULT NULL COMMENT '创建人',
  `update_person` varchar(60)  NULL DEFAULT NULL COMMENT '修改人',
  `dr` tinyint(4) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志,0表示未删除，1表示删除',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_bext_code`(`bext_code`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '扩展点的执行的具体实例' ROW_FORMAT = Dynamic;


CREATE TABLE IF NOT EXISTS `bd_biz_extension`  (
  `id` bigint(20) NOT NULL COMMENT '主键id',
  `bext_code` varchar(255)  NULL DEFAULT NULL COMMENT '扩展点代码',
  `bext_name` varchar(50)  NULL DEFAULT NULL COMMENT '扩展点简称',
  `bext_desc` varchar(2048)  NULL DEFAULT NULL COMMENT '扩展点简介',
  `bext_type` tinyint(2) NULL DEFAULT 1 COMMENT '扩展点类型\r\n            0: 单实现生效 1: 链式实现生效  2:并行实现生效',
  `priority` tinyint(4) NULL DEFAULT NULL COMMENT '优先级',
  `grade` tinyint(4) NULL DEFAULT NULL COMMENT '级别(0:全局;1:租户;2:应用)',
  `effect_apps` varchar(512)  NULL DEFAULT NULL COMMENT '影响的应用系统\r\n            扩展点可能影响的系统,多个有英文半角逗号分隔',
  `source` varchar(256)  NOT NULL DEFAULT '' COMMENT '来源',
  `cur_ver` varchar(32)  NULL DEFAULT NULL COMMENT '当前版本',
  `cur_ver_release_time` datetime(0) NULL DEFAULT NULL COMMENT '当前版本注册时间',
  `remark` varchar(2048)  NULL DEFAULT NULL COMMENT '备注',
  `extension` varchar(1024)  NULL DEFAULT NULL COMMENT '扩展信息',
  `instance_id` bigint(20) NOT NULL COMMENT '实例ID',
  `tenant_id` bigint(20) NOT NULL COMMENT '租户ID',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '修改时间',
  `create_person` varchar(60)  NULL DEFAULT NULL COMMENT '创建人',
  `update_person` varchar(60)  NULL DEFAULT NULL COMMENT '修改人',
  `dr` tinyint(4) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志,0表示未删除，1表示删除',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_bext_code`(`bext_code`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '收集业务扩展点信息.\r\n' ROW_FORMAT = Dynamic;


CREATE TABLE IF NOT EXISTS `bd_biz_id`  (
  `id` bigint(20) NOT NULL COMMENT '主键id',
  `code` varchar(255)  NOT NULL DEFAULT '' COMMENT '编码',
  `name` varchar(50)  NOT NULL DEFAULT '' COMMENT '名称',
  `priority` int(11) NOT NULL DEFAULT 0 COMMENT '优先级',
  `status` tinyint(4) NOT NULL DEFAULT 0 COMMENT '状态：0 禁用  1启用',
  `remark` varchar(255)  NOT NULL DEFAULT '' COMMENT '备注',
  `extension` varchar(1024)  NOT NULL DEFAULT '' COMMENT '业务定义扩展值',
  `instance_id` bigint(20) NOT NULL DEFAULT 0 COMMENT '应用实例ID',
  `tenant_id` bigint(20) NOT NULL DEFAULT 0 COMMENT '租户ID',
  `dr` tinyint(2) NOT NULL DEFAULT 0 COMMENT '逻辑删除标记',
  `create_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '创建人',
  `create_time` datetime(0) NOT NULL DEFAULT '1000-01-01 00:00:00' COMMENT '创建时间',
  `update_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '修改人',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  `type` tinyint(4) NULL DEFAULT 0 COMMENT '类型:0动态  1静态',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_code`(`code`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '业务身份' ROW_FORMAT = Dynamic;


CREATE TABLE IF NOT EXISTS `bd_biz_obj`  (
  `id` bigint(20) NOT NULL COMMENT '主键id',
  `code` varchar(255)  NOT NULL DEFAULT '' COMMENT '编码',
  `name` varchar(50)  NOT NULL DEFAULT '' COMMENT '名称',
  `ability_group_code` varchar(50)  NOT NULL DEFAULT '' COMMENT '领域编码',
  `status` tinyint(4) NOT NULL DEFAULT 0 COMMENT '状态：0 禁用  1启用',
  `remark` varchar(255)  NULL DEFAULT NULL COMMENT '备注',
  `extension` varchar(1024)  NOT NULL DEFAULT '' COMMENT '业务定义扩展值',
  `instance_id` bigint(20) NOT NULL DEFAULT 0 COMMENT '应用实例ID',
  `tenant_id` bigint(20) NOT NULL DEFAULT 0 COMMENT '租户ID',
  `dr` tinyint(2) NOT NULL DEFAULT 0 COMMENT '逻辑删除标记',
  `create_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '创建人',
  `create_time` datetime(0) NOT NULL DEFAULT '1000-01-01 00:00:00' COMMENT '创建时间',
  `update_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '修改人',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_code`(`code`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '业务对象' ROW_FORMAT = Dynamic;


CREATE TABLE IF NOT EXISTS `bd_biz_obj_property`  (
  `id` bigint(20) NOT NULL COMMENT '主键id',
  `biz_obj_code` varchar(255)  NOT NULL DEFAULT '' COMMENT '业务对象编码',
  `code` varchar(255)  NOT NULL DEFAULT '' COMMENT '编码',
  `name` varchar(50)  NOT NULL DEFAULT '' COMMENT '名称',
  `data_type` tinyint(4) NOT NULL DEFAULT 0 COMMENT '数据类型:1布尔、2字符、3整数、4小数、5日期、6时间、7精准搜索',
  `data_length` int(11) NOT NULL DEFAULT 0 COMMENT '数据长度',
  `edit_type` tinyint(4) NOT NULL DEFAULT 0 COMMENT '编辑类型(0:输入;1:单选;2:多选)',
  `option_value` varchar(1024)  NOT NULL DEFAULT '{}' COMMENT '可选值',
  `extension` varchar(1024)  NOT NULL DEFAULT '' COMMENT '业务定义扩展值',
  `instance_id` bigint(20) NOT NULL DEFAULT 0 COMMENT '应用实例ID',
  `tenant_id` bigint(20) NOT NULL DEFAULT 0 COMMENT '租户ID',
  `dr` tinyint(2) NOT NULL DEFAULT 0 COMMENT '逻辑删除标记',
  `create_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '创建人',
  `create_time` datetime(0) NOT NULL DEFAULT '1000-01-01 00:00:00' COMMENT '创建时间',
  `update_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '修改人',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_code`(`code`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '业务对象属性' ROW_FORMAT = Dynamic;


CREATE TABLE IF NOT EXISTS `bd_biz_rule`  (
  `id` bigint(20) NOT NULL COMMENT '主键id',
  `name` varchar(20)  NOT NULL DEFAULT '' COMMENT '规则名称',
  `text_expression` varchar(1024)  NOT NULL COMMENT '文字表达式',
  `code_expression` varchar(1024)  NOT NULL COMMENT '规则表达式',
  `status` tinyint(2) NOT NULL DEFAULT 0 COMMENT '状态(0:新建 1:启用 2:禁用)',
  `extension` varchar(1024)  NOT NULL DEFAULT '',
  `instance_id` bigint(20) NOT NULL DEFAULT 0,
  `tenant_id` bigint(20) NOT NULL DEFAULT 0,
  `dr` tinyint(2) NOT NULL DEFAULT 0,
  `create_person` varchar(50)  NOT NULL DEFAULT '',
  `create_time` datetime(0) NOT NULL DEFAULT '1000-01-01 00:00:00',
  `update_person` varchar(50)  NOT NULL DEFAULT '',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0),
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '业务规则表' ROW_FORMAT = Dynamic;


CREATE TABLE IF NOT EXISTS `bd_biz_space`  (
  `id` bigint(20) NOT NULL COMMENT '主键id',
  `code` varchar(200)  NULL DEFAULT NULL COMMENT '编码',
  `name` varchar(50)  NULL DEFAULT NULL COMMENT '名称',
  `status` tinyint(4) NULL DEFAULT NULL COMMENT '状态：0 禁用  1启用',
  `remark` varchar(200)  NULL DEFAULT NULL COMMENT '备注',
  `biz_space_temp_code` varchar(50)  NULL DEFAULT NULL COMMENT '业务空间模板编码',
  `extension` varchar(1024)  NOT NULL DEFAULT '' COMMENT '业务扩展字段',
  `instance_id` bigint(20) NOT NULL DEFAULT 0 COMMENT '应用实例id',
  `tenant_id` bigint(20) NOT NULL DEFAULT 0 COMMENT '租户id',
  `dr` tinyint(2) NOT NULL DEFAULT 0 COMMENT '逻辑删除字段',
  `create_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '创建人',
  `create_time` datetime(0) NOT NULL DEFAULT '1000-01-01 00:00:00' COMMENT '创建时间',
  `update_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '修改人',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '业务空间' ROW_FORMAT = Dynamic;


CREATE TABLE IF NOT EXISTS `bd_config_scope`  (
  `id` bigint(20) NOT NULL COMMENT '主键id',
  `biz_id_code` varchar(128)  NULL DEFAULT NULL COMMENT '业务身份 json格式',
  `biz_space_code` varchar(50)  NULL DEFAULT '0' COMMENT '业务空间编码',
  `config_code` varchar(128)  NULL DEFAULT NULL COMMENT '配置项编码',
  `config_item_code` varchar(128)  NULL DEFAULT NULL COMMENT '配置项选项编码',
  `param_value` varchar(2048)  NULL DEFAULT NULL COMMENT '参数值',
  `type` tinyint(4) NULL DEFAULT NULL COMMENT '1 业务参数 2 扩展点',
  `extension` varchar(1024)  NOT NULL DEFAULT '' COMMENT '业务扩展字段',
  `instance_id` bigint(20) NOT NULL DEFAULT 0 COMMENT '应用实例id',
  `tenant_id` bigint(20) NOT NULL DEFAULT 0 COMMENT '租户id',
  `dr` tinyint(2) NOT NULL DEFAULT 0 COMMENT '逻辑删除字段',
  `create_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '创建人',
  `create_time` datetime(0) NOT NULL DEFAULT '1000-01-01 00:00:00' COMMENT '创建时间',
  `update_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '修改人',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '业务身份配置项范围关联' ROW_FORMAT = Dynamic;



CREATE TABLE IF NOT EXISTS `bd_doc`  (
  `id` bigint(20) NOT NULL COMMENT '主键id',
  `doc_type` int(11) NULL DEFAULT NULL COMMENT '文档类别：1=领域文档、2=场景文档',
  `ability_group_code` varchar(50)  NULL DEFAULT NULL COMMENT '能力分类编码',
  `doc_name` varchar(50)  NULL DEFAULT NULL COMMENT '文档名称',
  `brief` text  NULL COMMENT '文档简介',
  `content` text  NULL COMMENT '文档正文',
  `status` int(11) NULL DEFAULT NULL COMMENT '状态：0=下架、1=上架',
  `extension` varchar(1024)  NULL DEFAULT NULL COMMENT '扩展信息',
  `instance_id` bigint(20) NOT NULL COMMENT '实例ID',
  `tenant_id` bigint(20) NOT NULL COMMENT '租户ID',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '修改时间',
  `create_person` varchar(60)  NULL DEFAULT NULL COMMENT '创建人',
  `update_person` varchar(60)  NULL DEFAULT NULL COMMENT '修改人',
  `dr` tinyint(4) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志,0表示未删除，1表示删除',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_doc_type_capability_code`(`doc_type`, `ability_group_code`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '领域场景文档' ROW_FORMAT = Dynamic;


CREATE TABLE IF NOT EXISTS `bd_error_code`  (
  `id` bigint(20) NOT NULL COMMENT '主键id',
  `module_code` varchar(128)  NULL DEFAULT NULL COMMENT '所属应用',
  `code` varchar(255)  NULL DEFAULT NULL COMMENT '错误码',
  `message` varchar(1024)  NULL DEFAULT NULL COMMENT '错误描述',
  `extension` varchar(1024)  NULL DEFAULT NULL COMMENT '扩展信息',
  `instance_id` bigint(20) NOT NULL COMMENT '实例ID',
  `tenant_id` bigint(20) NOT NULL COMMENT '租户ID',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '修改时间',
  `create_person` varchar(60)  NULL DEFAULT NULL COMMENT '创建人',
  `update_person` varchar(60)  NULL DEFAULT NULL COMMENT '修改人',
  `dr` tinyint(4) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志,0表示未删除，1表示删除'
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '错误码' ROW_FORMAT = Dynamic;

-- ----------------------------

CREATE TABLE IF NOT EXISTS `bd_module`  (
  `id` bigint(20) NOT NULL COMMENT '主键id',
  `module_code` varchar(128)  NULL DEFAULT NULL COMMENT '应用编码',
  `module_name` varchar(255)  NULL DEFAULT NULL COMMENT '应用名称',
  `module_desc` varchar(1024)  NULL DEFAULT NULL COMMENT '应用描述',
  `extension` varchar(1024)  NULL DEFAULT NULL COMMENT '扩展信息',
  `instance_id` bigint(20) NOT NULL COMMENT '实例ID',
  `tenant_id` bigint(20) NOT NULL COMMENT '租户ID',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '修改时间',
  `create_person` varchar(60)  NULL DEFAULT NULL COMMENT '创建人',
  `update_person` varchar(60)  NULL DEFAULT NULL COMMENT '修改人',
  `dr` tinyint(4) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志,0表示未删除，1表示删除',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = 'API所属应用' ROW_FORMAT = Dynamic;


CREATE TABLE IF NOT EXISTS `bd_r_ability_config`  (
  `id` bigint(20) NOT NULL COMMENT '主键id',
  `ability_code` varchar(50)  NULL DEFAULT NULL COMMENT '能力编码',
  `config_code` varchar(128)  NULL DEFAULT NULL COMMENT '配置项编码',
  `type` tinyint(4) NULL DEFAULT NULL COMMENT '1 业务参数  2  扩展点',
  `extension` varchar(1024)  NOT NULL DEFAULT '' COMMENT '业务扩展字段',
  `instance_id` bigint(20) NOT NULL DEFAULT 0 COMMENT '应用实例id',
  `tenant_id` bigint(20) NOT NULL DEFAULT 0 COMMENT '租户id',
  `dr` tinyint(2) NOT NULL DEFAULT 0 COMMENT '逻辑删除字段',
  `create_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '创建人',
  `create_time` datetime(0) NOT NULL DEFAULT '1000-01-01 00:00:00' COMMENT '创建时间',
  `update_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '修改人',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '能力配置项关联关系' ROW_FORMAT = Dynamic;


CREATE TABLE IF NOT EXISTS `bd_r_api_scene`  (
  `id` bigint(20) NOT NULL COMMENT '主键id',
  `api_id` bigint(20) NULL DEFAULT NULL COMMENT 'API id',
  `scene_code` varchar(50)  NULL DEFAULT NULL COMMENT '场景编码',
  `extension` varchar(1024)  NULL DEFAULT NULL COMMENT '扩展信息',
  `instance_id` bigint(20) NOT NULL COMMENT '实例ID',
  `tenant_id` bigint(20) NOT NULL COMMENT '租户ID',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '修改时间',
  `create_person` varchar(60)  NULL DEFAULT NULL COMMENT '创建人',
  `update_person` varchar(60)  NULL DEFAULT NULL COMMENT '修改人',
  `dr` tinyint(4) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志,0表示未删除，1表示删除',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '场景API关联' ROW_FORMAT = Dynamic;


CREATE TABLE IF NOT EXISTS `bd_r_app_inst_api`  (
  `id` bigint(20) NOT NULL COMMENT '主键id',
  `app_code` varchar(64)  NOT NULL COMMENT '应用编码',
  `domain_code` varchar(64)  NOT NULL COMMENT '领域编码',
  `path` varchar(1024)  NOT NULL COMMENT 'API路径',
  `method` varchar(32)  NOT NULL COMMENT '请求方式',
  `extension` varchar(1024)  NULL DEFAULT '' COMMENT '扩展信息',
  `instance_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '实例ID',
  `tenant_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '租户ID',
  `create_time` datetime(0) NOT NULL DEFAULT '1000-01-01 00:00:00' COMMENT '创建时间',
  `update_time` datetime(0) NOT NULL ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  `create_person` varchar(60)  NOT NULL DEFAULT '' COMMENT '创建人',
  `update_person` varchar(60)  NOT NULL DEFAULT '' COMMENT '修改人',
  `dr` tinyint(4) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志，0 表示未删除，1 表示删除',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '应用模板和API关联关系表' ROW_FORMAT = Dynamic;


CREATE TABLE IF NOT EXISTS `bd_r_biz_rule_obj_property`  (
  `id` bigint(20) NOT NULL COMMENT '主键id',
  `biz_rule_id` bigint(20) NOT NULL COMMENT '业务规则id',
  `biz_obj_code` varchar(255)  NOT NULL COMMENT '业务对象编码',
  `biz_obj_property_code` varchar(255)  NULL DEFAULT NULL COMMENT '业务对象属性编码',
  `extension` varchar(1024)  NULL DEFAULT '',
  `instance_id` bigint(20) NOT NULL DEFAULT 0,
  `tenant_id` bigint(20) NOT NULL DEFAULT 0,
  `dr` tinyint(2) NOT NULL DEFAULT 0,
  `create_person` varchar(50)  NOT NULL DEFAULT '',
  `create_time` datetime(0) NOT NULL DEFAULT '1000-01-01 00:00:00',
  `update_person` varchar(50)  NOT NULL DEFAULT '',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0),
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '业务规则-业务对象关系表' ROW_FORMAT = Dynamic;


CREATE TABLE IF NOT EXISTS `bd_r_biz_rule_space_identity`  (
  `id` bigint(20) NOT NULL COMMENT '主键id',
  `biz_rule_id` bigint(20) NOT NULL COMMENT '业务规则id',
  `biz_identity_code` varchar(50)  NOT NULL COMMENT '业务身份编码',
  `biz_space_code` varchar(50)  NOT NULL COMMENT '业务空间编码',
  `extension` varchar(1024)  NOT NULL DEFAULT '',
  `instance_id` bigint(20) NOT NULL DEFAULT 0,
  `tenant_id` bigint(20) NOT NULL DEFAULT 0,
  `dr` tinyint(2) NOT NULL DEFAULT 0,
  `create_person` varchar(50)  NOT NULL DEFAULT '',
  `create_time` datetime(0) NOT NULL DEFAULT '1000-01-01 00:00:00',
  `update_person` varchar(50)  NOT NULL DEFAULT '',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0),
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_biz_rule_id`(`biz_rule_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '规则-空间-身份关系表' ROW_FORMAT = Dynamic;


CREATE TABLE IF NOT EXISTS `bd_r_biz_space_ability`  (
  `id` bigint(20) NOT NULL COMMENT '主键id',
  `biz_space_code` varchar(50)  NULL DEFAULT NULL COMMENT '业务空间编码',
  `ability_code` varchar(50)  NULL DEFAULT NULL COMMENT '能力编码',
  `extension` varchar(1024)  NOT NULL DEFAULT '' COMMENT '业务扩展字段',
  `instance_id` bigint(20) NOT NULL DEFAULT 0 COMMENT '应用实例id',
  `tenant_id` bigint(20) NOT NULL DEFAULT 0 COMMENT '租户id',
  `dr` tinyint(2) NOT NULL DEFAULT 0 COMMENT '逻辑删除字段',
  `create_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '创建人',
  `create_time` datetime(0) NOT NULL DEFAULT '1000-01-01 00:00:00' COMMENT '创建时间',
  `update_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '修改人',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '业务空间能力关联关系' ROW_FORMAT = Dynamic;


CREATE TABLE IF NOT EXISTS `bd_r_biz_space_app_instance`  (
  `id` bigint(20) NOT NULL COMMENT '主键id',
  `biz_space_code` varchar(1024)  NOT NULL COMMENT '业务空间编码',
  `app_instance_id` bigint(20) NOT NULL COMMENT '应用实例id',
  `extension` varchar(1024)  NOT NULL DEFAULT '',
  `instance_id` bigint(20) NOT NULL DEFAULT 0,
  `tenant_id` bigint(20) NOT NULL DEFAULT 0,
  `dr` tinyint(2) NOT NULL DEFAULT 0,
  `create_person` varchar(50)  NOT NULL DEFAULT '',
  `create_time` datetime(0) NOT NULL DEFAULT '1000-01-01 00:00:00',
  `update_person` varchar(50)  NOT NULL DEFAULT '',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0),
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '业务空间-应用实例关系表' ROW_FORMAT = Dynamic;


CREATE TABLE IF NOT EXISTS `bd_r_group_ability`  (
  `id` bigint(20) NOT NULL COMMENT '主键id',
  `ability_code` varchar(50)  NULL DEFAULT NULL COMMENT '能力编码',
  `ability_group_code` varchar(50)  NULL DEFAULT NULL COMMENT '能力分类编码：场景编码',
  `type` tinyint(4) NULL DEFAULT NULL COMMENT '1 领域 2 场景',
  `extension` varchar(1024)  NOT NULL DEFAULT '' COMMENT '业务扩展字段',
  `instance_id` bigint(20) NOT NULL DEFAULT 0 COMMENT '应用实例id',
  `tenant_id` bigint(20) NOT NULL DEFAULT 0 COMMENT '租户id',
  `dr` tinyint(2) NOT NULL DEFAULT 0 COMMENT '逻辑删除字段',
  `create_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '创建人',
  `create_time` datetime(0) NOT NULL DEFAULT '1000-01-01 00:00:00' COMMENT '创建时间',
  `update_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '修改人',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '能力分组关联关系' ROW_FORMAT = Dynamic;


CREATE TABLE IF NOT EXISTS `bd_r_space_id`  (
  `id` bigint(20) NOT NULL COMMENT '主键id',
  `space_code` varchar(255)  NOT NULL DEFAULT '' COMMENT '业务空间编码',
  `id_code` varchar(255)  NOT NULL DEFAULT '' COMMENT '业务身份编码',
  `extension` varchar(1024)  NOT NULL DEFAULT '' COMMENT '业务定义扩展值',
  `instance_id` bigint(20) NOT NULL DEFAULT 0 COMMENT '应用实例ID',
  `tenant_id` bigint(20) NOT NULL DEFAULT 0 COMMENT '租户ID',
  `dr` tinyint(2) NOT NULL DEFAULT 0 COMMENT '逻辑删除标记',
  `create_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '创建人',
  `create_time` datetime(0) NOT NULL DEFAULT '1000-01-01 00:00:00' COMMENT '创建时间',
  `update_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '修改人',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_code`(`space_code`, `id_code`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '业务空间和业务身份关系' ROW_FORMAT = Dynamic;


CREATE TABLE IF NOT EXISTS `bd_sys_param`  (
  `id` bigint(20) NOT NULL COMMENT '主键id',
  `code` varchar(200)  NULL DEFAULT NULL COMMENT '编码',
  `name` varchar(256)  NULL DEFAULT NULL COMMENT '名称',
  `description` varchar(1024)  NULL DEFAULT NULL COMMENT '简介',
  `grade` tinyint(4) NULL DEFAULT NULL COMMENT '级别(0:租户;1:应用)',
  `select_type` tinyint(4) NULL DEFAULT NULL COMMENT '选择类型(0:单行;1:单选;2:多选)',
  `default_value` varchar(1024)  NULL DEFAULT NULL COMMENT '默认值',
  `value_type` tinyint(4) NULL DEFAULT NULL COMMENT '值类型(0:文本;1:数值;2:布尔;3:日期)',
  `group_code` varchar(128)  NULL DEFAULT NULL COMMENT '参数组',
  `remark` varchar(2048)  NULL DEFAULT NULL COMMENT '备注',
  `reversion` varchar(50)  NULL DEFAULT NULL COMMENT '版本',
  `source` varchar(256)  NOT NULL DEFAULT '' COMMENT '来源',
  `extension` varchar(1024)  NOT NULL DEFAULT '',
  `instance_id` bigint(20) NOT NULL DEFAULT 0,
  `tenant_id` bigint(20) NOT NULL DEFAULT 0,
  `dr` tinyint(2) NOT NULL DEFAULT 0,
  `create_person` varchar(50)  NOT NULL DEFAULT '',
  `create_time` datetime(0) NOT NULL DEFAULT '1000-01-01 00:00:00',
  `update_person` varchar(50)  NOT NULL DEFAULT '',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0),
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;


CREATE TABLE IF NOT EXISTS `bd_sys_param_item`  (
  `id` bigint(20) NOT NULL COMMENT '主键id',
  `param_code` varchar(128)  NULL DEFAULT NULL COMMENT '所属参数编码',
  `item_code` varchar(128)  NULL DEFAULT NULL COMMENT '选项编码',
  `sort_no` int(11) NULL DEFAULT NULL COMMENT '排序号',
  `value_desc` varchar(128)  NULL DEFAULT NULL COMMENT '参数值描述',
  `param_value` varchar(2048)  NULL DEFAULT NULL COMMENT '参数值',
  `remark` varchar(2048)  NULL DEFAULT NULL COMMENT '备注',
  `extension` varchar(1024)  NOT NULL DEFAULT '',
  `instance_id` bigint(20) NOT NULL DEFAULT 0,
  `tenant_id` bigint(20) NOT NULL DEFAULT 0,
  `dr` tinyint(2) NOT NULL DEFAULT 0,
  `create_person` varchar(50)  NOT NULL DEFAULT '',
  `create_time` datetime(0) NOT NULL DEFAULT '1000-01-01 00:00:00',
  `update_person` varchar(50)  NOT NULL DEFAULT '',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0),
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;


CREATE TABLE IF NOT EXISTS `bd_sys_param_item_scope`  (
  `id` bigint(20) NOT NULL COMMENT '主键id',
  `biz_id_code` varchar(128)  NULL DEFAULT NULL COMMENT '业务身份',
  `param_code` varchar(128)  NULL DEFAULT NULL COMMENT '所属参数编码',
  `item_code` varchar(128)  NULL DEFAULT NULL COMMENT '选项编码',
  `tenant_id` bigint(20) NOT NULL COMMENT '租户ID',
  `instance_id` bigint(20) NOT NULL COMMENT '应用实例ID',
  `create_person` varchar(60)  NOT NULL COMMENT '创建人',
  `create_time` datetime(0) NOT NULL COMMENT '创建时间',
  `update_person` varchar(60)  NOT NULL COMMENT '修改人',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  `dr` smallint(6) NOT NULL DEFAULT 0 COMMENT '逻辑删除标记',
  `extension` varchar(1024)  NULL DEFAULT NULL COMMENT '扩展字段',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '参数选项范围' ROW_FORMAT = Dynamic;


CREATE TABLE IF NOT EXISTS `bd_sys_param_value`  (
  `id` bigint(20) NOT NULL COMMENT '主键id',
  `biz_space_code` varchar(255)  NOT NULL DEFAULT '' COMMENT '业务空间编码',
  `biz_id_code` varchar(128)  NULL DEFAULT NULL COMMENT '业务身份',
  `param_code` varchar(128)  NULL DEFAULT NULL COMMENT '所属参数编码',
  `item_code` varchar(128)  NULL DEFAULT NULL COMMENT '所属选项编码',
  `param_value` varchar(2048)  NULL DEFAULT NULL COMMENT '参数值',
  `extension` varchar(1024)  NOT NULL DEFAULT '',
  `instance_id` bigint(20) NOT NULL DEFAULT 0,
  `tenant_id` bigint(20) NOT NULL DEFAULT 0,
  `dr` tinyint(2) NOT NULL DEFAULT 0,
  `create_person` varchar(50)  NOT NULL DEFAULT '',
  `create_time` datetime(0) NOT NULL DEFAULT '1000-01-01 00:00:00',
  `update_person` varchar(50)  NOT NULL DEFAULT '',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0),
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_biz_code`(`biz_id_code`, `param_code`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;


CREATE TABLE IF NOT EXISTS `fn_app`  (
  `id` bigint(20) NOT NULL COMMENT '主键id',
  `code` varchar(128)  NOT NULL DEFAULT '' COMMENT '应用编码',
  `name` varchar(255)  NULL DEFAULT NULL COMMENT '应用名称',
  `version` varchar(50)  NULL DEFAULT NULL COMMENT '应用版本号',
  `descr` varchar(1024)  NULL DEFAULT NULL COMMENT '应用描述',
  `extension` varchar(1024)  NULL DEFAULT NULL COMMENT '扩展信息',
  `instance_id` bigint(20) NOT NULL COMMENT '实例ID',
  `tenant_id` bigint(20) NOT NULL COMMENT '租户ID',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '修改时间',
  `create_person` varchar(60)  NULL DEFAULT NULL COMMENT '创建人',
  `update_person` varchar(60)  NULL DEFAULT NULL COMMENT '修改人',
  `dr` tinyint(4) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志,0表示未删除，1表示删除',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '应用信息' ROW_FORMAT = Dynamic;


CREATE TABLE IF NOT EXISTS `fn_app_started_data_type`  (
  `id` bigint(20) NOT NULL COMMENT '主键id',
  `app_started_record_id` bigint(20) NOT NULL COMMENT 'fn_app_started_record表主键',
  `type` int(4) NOT NULL COMMENT '类型[1:base 2:api 3:dto 4:flow]用于处理功能包上报的数据类型是否已处理',
  `status` varchar(16)  NULL DEFAULT NULL COMMENT '应用启动时物料拉取的处理状态，DOING/FAILED/DONE',
  `extension` varchar(1024)  NOT NULL DEFAULT '' COMMENT '扩展字段',
  `instance_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '应用实例ID',
  `tenant_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '租户ID',
  `create_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '创建人',
  `create_time` datetime(0) NOT NULL DEFAULT '1000-01-01 00:00:00' COMMENT '创建时间',
  `update_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '修改人',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  `dr` tinyint(1) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志，0 表示未删除，1 表示删除',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '应用启动上报数据类型表，用于处理功能包上报的数据类型是否已处理' ROW_FORMAT = Dynamic;


CREATE TABLE IF NOT EXISTS `fn_app_started_record`  (
  `id` bigint(20) NOT NULL COMMENT '主键id',
  `code` varchar(64)  NOT NULL COMMENT '应用编码，例如yundt-cube-center-user',
  `version` varchar(64)  NULL DEFAULT NULL COMMENT '应用Maven版本号，例如3.0.7.0-CUBE-SNAPSHOT',
  `package_time` datetime(3) NOT NULL DEFAULT '1000-01-01 00:00:00.000' COMMENT '应用打包时间',
  `boot_time` datetime(3) NOT NULL DEFAULT '1000-01-01 00:00:00.000' COMMENT '应用启动时间',
  `ip` varchar(64)  NOT NULL COMMENT '应用部署的IP地址，例如192.168.33.12',
  `port` int(11) NOT NULL COMMENT '应用部署的端口号，例如18090',
  `STATUS` varchar(16)  NOT NULL COMMENT '应用启动时物料拉取的处理状态，DOING/FAILED/DONE',
  `extension` varchar(1024)  NOT NULL DEFAULT '' COMMENT '扩展字段',
  `instance_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '应用实例ID',
  `tenant_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '租户ID',
  `create_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '创建人',
  `create_time` datetime(0) NOT NULL DEFAULT '1000-01-01 00:00:00' COMMENT '创建时间',
  `update_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '修改人',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  `dr` tinyint(1) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志，0 表示未删除，1 表示删除',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '应用启动记录表' ROW_FORMAT = Dynamic;


CREATE TABLE IF NOT EXISTS `fn_bundle`  (
  `id` bigint(20) NOT NULL COMMENT '主键id',
  `code` varchar(200)  NOT NULL COMMENT '全局唯一，推荐使用maven的groupId+artifactId',
  `name` varchar(64)  NOT NULL COMMENT '功能包名称，全局唯一',
  `status` tinyint(2) NULL DEFAULT 1 COMMENT '状态：0 禁用 1启用',
  `frontend_flag` tinyint(1) NOT NULL DEFAULT 0 COMMENT '前端应用标志，0不是前端应用，1是前端应用，默认值0',
  `backend_flag` tinyint(1) NOT NULL DEFAULT 0 COMMENT '后端应用标志，0不是后端应用，1是后端应用，默认值0',
  `center_flag` tinyint(1) NOT NULL DEFAULT 0 COMMENT '能力中心标志，0不是能力中心，1是能力中心，默认值0',
  `provider` varchar(64)  NOT NULL COMMENT '功能包提供者',
  `parent_code` varchar(200)  NOT NULL COMMENT '父功能包代码，一级功能包填写ROOT_NODE',
  `descr` varchar(200)  NULL DEFAULT NULL COMMENT '功能包描述',
  `release_time` datetime(0) NULL DEFAULT NULL COMMENT '发布时间',
  `application` varchar(64)  NULL DEFAULT NULL COMMENT '所属应用',
  `module` varchar(64)  NULL DEFAULT NULL COMMENT '所属模块',
  `version` varchar(64)  NULL DEFAULT NULL COMMENT '版本号',
  `artifact_id` varchar(64)  NULL DEFAULT NULL COMMENT '功能包项目名',
  `group_id` varchar(64)  NULL DEFAULT NULL COMMENT '功能包分组名',
  `extension` varchar(1024)  NOT NULL DEFAULT '' COMMENT '扩展字段',
  `instance_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '应用实例ID',
  `tenant_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '租户ID',
  `dr` tinyint(1) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志，0 表示未删除，1 表示删除',
  `create_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '创建人',
  `create_time` datetime(0) NOT NULL DEFAULT '1000-01-01 00:00:00' COMMENT '创建时间',
  `update_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '修改人',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `idx_code_version`(`code`, `version`) USING BTREE,
  INDEX `idx_code`(`code`) USING BTREE,
  INDEX `idx_parent_code`(`parent_code`) USING BTREE,
  INDEX `idx_groupId_artifactId_version`(`version`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '功能包信息' ROW_FORMAT = Dynamic;


CREATE TABLE IF NOT EXISTS `fn_bundle_dependency`  (
  `id` bigint(20) NOT NULL COMMENT '主键id',
  `code` varchar(200)  NULL DEFAULT NULL COMMENT '功能包编码',
  `group_id` varchar(64)  NULL DEFAULT NULL COMMENT '功能包分组名',
  `artifact_id` varchar(64)  NULL DEFAULT NULL COMMENT '功能包项目名',
  `version` varchar(64)  NULL DEFAULT NULL COMMENT '功能包版本号',
  `dependent_code` varchar(200)  NULL DEFAULT NULL COMMENT '依赖功能包编码',
  `dependent_group_id` varchar(64)  NULL DEFAULT NULL COMMENT '依赖功能包分组名',
  `dependent_artifact_id` varchar(64)  NULL DEFAULT NULL COMMENT '依赖功能包项目名',
  `dependent_version` varchar(64)  NULL DEFAULT NULL COMMENT '依赖功能包版本号',
  `extension` varchar(1024)  NOT NULL DEFAULT '' COMMENT '扩展字段',
  `instance_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '应用实例ID',
  `tenant_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '租户ID',
  `dr` tinyint(1) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志，0 表示未删除，1 表示删除',
  `create_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '创建人',
  `create_time` datetime(0) NOT NULL DEFAULT '1000-01-01 00:00:00' COMMENT '创建时间',
  `update_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '修改人',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '功能包依赖' ROW_FORMAT = Dynamic;


CREATE TABLE IF NOT EXISTS `fn_bundle_dependency_history`  (
  `id` bigint(20) NOT NULL COMMENT '主键id',
  `code` varchar(200)  NULL DEFAULT NULL COMMENT '功能包编码',
  `group_id` varchar(64)  NULL DEFAULT NULL COMMENT '功能包分组名',
  `artifact_id` varchar(64)  NULL DEFAULT NULL COMMENT '功能包项目名',
  `version` varchar(64)  NULL DEFAULT NULL COMMENT '功能包版本号',
  `dependent_code` varchar(200)  NULL DEFAULT NULL COMMENT '依赖功能包编码',
  `dependent_group_id` varchar(64)  NULL DEFAULT NULL COMMENT '依赖功能包分组名',
  `dependent_artifact_id` varchar(64)  NULL DEFAULT NULL COMMENT '依赖功能包项目名',
  `dependent_version` varchar(64)  NULL DEFAULT NULL COMMENT '依赖功能包版本号',
  `extension` varchar(1024)  NOT NULL DEFAULT '' COMMENT '扩展字段',
  `instance_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '应用实例ID',
  `tenant_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '租户ID',
  `dr` tinyint(1) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志，0 表示未删除，1 表示删除',
  `create_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '创建人',
  `create_time` datetime(0) NOT NULL DEFAULT '1000-01-01 00:00:00' COMMENT '创建时间',
  `update_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '修改人',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '功能包依赖历史版本' ROW_FORMAT = Dynamic;


CREATE TABLE IF NOT EXISTS `fn_bundle_history`  (
  `id` bigint(20) NOT NULL COMMENT '主键id',
  `code` varchar(200)  NOT NULL COMMENT '全局唯一，推荐使用maven的groupId+artifactId',
  `NAME` varchar(64)  NULL DEFAULT NULL COMMENT '功能包名称，全局唯一',
  `frontend_flag` tinyint(1) NOT NULL DEFAULT 0 COMMENT '前端应用标志，0不是前端应用，1是前端应用，默认值0',
  `backend_flag` tinyint(1) NOT NULL DEFAULT 0 COMMENT '后端应用标志，0不是后端应用，1是后端应用，默认值0',
  `center_flag` tinyint(1) NOT NULL DEFAULT 0 COMMENT '能力中心标志，0不是能力中心，1是能力中心，默认值0',
  `provider` varchar(64)  NOT NULL COMMENT '功能包提供者',
  `parent_code` varchar(200)  NOT NULL COMMENT '父功能包代码，一级功能包填写ROOT_NODE',
  `descr` varchar(200)  NULL DEFAULT NULL COMMENT '功能包描述',
  `group_id` varchar(64)  NULL DEFAULT NULL COMMENT '功能包分组名',
  `artifact_id` varchar(64)  NULL DEFAULT NULL COMMENT '功能包项目名',
  `version` varchar(64)  NULL DEFAULT NULL COMMENT '版本号',
  `module` varchar(64)  NULL DEFAULT NULL COMMENT '所属模块',
  `application` varchar(64)  NULL DEFAULT NULL COMMENT '所属应用',
  `release_time` datetime(0) NULL DEFAULT NULL COMMENT '发布时间',
  `profile_settings` text  NULL COMMENT '配置项描述信息',
  `profile_api` text  NULL COMMENT 'API描述信息',
  `profile_eo` text  NULL COMMENT 'EO描述信息',
  `profile_dto` text  NULL COMMENT 'DTO描述信息',
  `status` tinyint(2) NULL DEFAULT 1 COMMENT '状态：0 禁用 1启用',
  `extension` varchar(1024)  NOT NULL DEFAULT '' COMMENT '扩展字段',
  `instance_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '应用实例ID',
  `tenant_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '租户ID',
  `dr` tinyint(1) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志，0 表示未删除，1 表示删除',
  `create_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '创建人',
  `create_time` datetime(0) NOT NULL DEFAULT '1000-01-01 00:00:00' COMMENT '创建时间',
  `update_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '修改人',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_code`(`code`) USING BTREE,
  INDEX `idx_groupId_artifactId_version`(`version`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '功能包历史版本' ROW_FORMAT = Dynamic;


CREATE TABLE IF NOT EXISTS `fn_capability`  (
  `id` bigint(20) NOT NULL COMMENT '主键id',
  `code` varchar(256)  NULL DEFAULT NULL COMMENT '能力编码',
  `parent_code` varchar(50)  NULL DEFAULT NULL COMMENT '能力父编码',
  `name` varchar(20)  NULL DEFAULT NULL COMMENT '能力名称',
  `status` tinyint(2) NULL DEFAULT 1 COMMENT '状态：0 禁用 1启用',
  `domain` varchar(64)  NULL DEFAULT NULL COMMENT '领域编码',
  `sort` int(11) NULL DEFAULT NULL COMMENT '排序',
  `view_id` bigint(20) NULL DEFAULT NULL COMMENT '配置视图ID',
  `descr` varchar(200)  NULL DEFAULT NULL COMMENT '简介',
  `bundle` varchar(200)  NULL DEFAULT NULL COMMENT '来源功能包编码',
  `extension` varchar(1024)  NOT NULL DEFAULT '' COMMENT '扩展字段',
  `instance_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '应用实例ID',
  `tenant_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '租户ID',
  `dr` tinyint(1) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志，0 表示未删除，1 表示删除',
  `create_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '创建人',
  `create_time` datetime(0) NOT NULL DEFAULT '1000-01-01 00:00:00' COMMENT '创建时间',
  `update_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '修改人',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_bext_code`(`code`) USING BTREE,
  INDEX `idx_domain`(`domain`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '能力信息' ROW_FORMAT = Dynamic;


CREATE TABLE IF NOT EXISTS `fn_dto`  (
  `id` bigint(20) NOT NULL COMMENT '主键id',
  `code` varchar(128)  NULL DEFAULT NULL COMMENT 'DTO编码',
  `name` varchar(128)  NULL DEFAULT NULL COMMENT 'DTO名称',
  `descr` varchar(1024)  NULL DEFAULT NULL COMMENT 'DTO描述',
  `domain` varchar(32)  NULL DEFAULT NULL COMMENT '领域编码',
  `bundle_code` varchar(256)  NULL DEFAULT NULL COMMENT '功能包编码',
  `group_id` varchar(64)  NULL DEFAULT NULL COMMENT '功能包分组名',
  `artifact_id` varchar(64)  NULL DEFAULT NULL COMMENT '功能包项目名',
  `version` varchar(64)  NULL DEFAULT NULL COMMENT '功能包版本号',
  `extension` varchar(1024)  NOT NULL DEFAULT '' COMMENT '扩展字段',
  `instance_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '应用实例ID',
  `tenant_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '租户ID',
  `create_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '创建人',
  `create_time` datetime(0) NOT NULL DEFAULT '1000-01-01 00:00:00' COMMENT '创建时间',
  `update_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '修改人',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  `dr` tinyint(1) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志，0 表示未删除，1 表示删除',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_code`(`code`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '功能包DTO' ROW_FORMAT = Dynamic;


CREATE TABLE IF NOT EXISTS `fn_dto_attribute`  (
  `id` bigint(20) NOT NULL COMMENT '主键id',
  `dto_id` bigint(20) NULL DEFAULT NULL COMMENT '所属DTO',
  `code` varchar(128)  NULL DEFAULT NULL COMMENT '属性编码',
  `name` varchar(256)  NULL DEFAULT NULL COMMENT '属性名称',
  `data_type` varchar(512)  NULL DEFAULT NULL COMMENT '数据类型',
  `length` int(11) NULL DEFAULT NULL COMMENT '数据长度',
  `is_nullable` int(11) NULL DEFAULT 1 COMMENT '是否允许为空（0=否 1=是）',
  `extension` varchar(1024)  NOT NULL DEFAULT '' COMMENT '扩展字段',
  `instance_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '应用实例ID',
  `tenant_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '租户ID',
  `create_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '创建人',
  `create_time` datetime(0) NOT NULL DEFAULT '1000-01-01 00:00:00' COMMENT '创建时间',
  `update_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '修改人',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  `dr` tinyint(1) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志，0 表示未删除，1 表示删除',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_dto_id`(`dto_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '功能包DTO属性' ROW_FORMAT = Dynamic;


CREATE TABLE IF NOT EXISTS `fn_dto_attribute_history`  (
  `id` bigint(20) NOT NULL COMMENT '主键id',
  `dto_id` bigint(20) NULL DEFAULT NULL COMMENT '所属DTO',
  `code` varchar(128)  NULL DEFAULT NULL COMMENT '属性编码',
  `name` varchar(256)  NULL DEFAULT NULL COMMENT '属性名称',
  `data_type` varchar(512)  NULL DEFAULT NULL COMMENT '数据类型',
  `length` int(11) NULL DEFAULT NULL COMMENT '数据长度',
  `is_nullable` int(11) NULL DEFAULT 1 COMMENT '是否允许为空（0=否 1=是）',
  `extension` varchar(1024)  NOT NULL DEFAULT '' COMMENT '扩展字段',
  `instance_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '应用实例ID',
  `tenant_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '租户ID',
  `create_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '创建人',
  `create_time` datetime(0) NOT NULL DEFAULT '1000-01-01 00:00:00' COMMENT '创建时间',
  `update_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '修改人',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  `dr` tinyint(1) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志，0 表示未删除，1 表示删除',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_dto_id`(`dto_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '功能包DTO属性备份表' ROW_FORMAT = Dynamic;


CREATE TABLE IF NOT EXISTS `fn_dto_history`  (
  `id` bigint(20) NOT NULL COMMENT '主键id',
  `code` varchar(128)  NULL DEFAULT NULL COMMENT 'DTO编码',
  `name` varchar(128)  NULL DEFAULT NULL COMMENT 'DTO名称',
  `descr` varchar(1024)  NULL DEFAULT NULL COMMENT 'DTO描述',
  `domain` varchar(32)  NULL DEFAULT NULL COMMENT '领域编码',
  `bundle_code` varchar(256)  NULL DEFAULT NULL COMMENT '功能包编码',
  `group_id` varchar(64)  NULL DEFAULT NULL COMMENT '功能包分组名',
  `artifact_id` varchar(64)  NULL DEFAULT NULL COMMENT '功能包项目名',
  `version` varchar(64)  NULL DEFAULT NULL COMMENT '功能包版本号',
  `extension` varchar(1024)  NOT NULL DEFAULT '' COMMENT '扩展字段',
  `instance_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '应用实例ID',
  `tenant_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '租户ID',
  `create_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '创建人',
  `create_time` datetime(0) NOT NULL DEFAULT '1000-01-01 00:00:00' COMMENT '创建时间',
  `update_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '修改人',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  `dr` tinyint(1) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志，0 表示未删除，1 表示删除',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_code`(`code`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '功能包DTO备份表' ROW_FORMAT = Dynamic;


CREATE TABLE IF NOT EXISTS `fn_r_app_bundle`  (
  `id` bigint(20) NOT NULL COMMENT '主键id',
  `code` varchar(64)  NOT NULL COMMENT '应用编码，例如yundt-cube-center-user',
  `version` varchar(64)  NOT NULL COMMENT '应用Maven版本号，例如3.0.7.0-CUBE-SNAPSHOT',
  `bundle_code` varchar(200)  NOT NULL COMMENT '功能包编码',
  `bundle_version` varchar(64)  NOT NULL COMMENT '功能包版本号，例如1.0.0.0-CUBE-SNAPSHOT',
  `extension` varchar(1024)  NOT NULL DEFAULT '' COMMENT '扩展字段',
  `instance_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '应用实例ID',
  `tenant_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '租户ID',
  `create_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '创建人',
  `create_time` datetime(0) NOT NULL DEFAULT '1000-01-01 00:00:00' COMMENT '创建时间',
  `update_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '修改人',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  `dr` tinyint(1) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志，0 表示未删除，1 表示删除',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '应用和功能包关系表' ROW_FORMAT = Dynamic;


CREATE TABLE IF NOT EXISTS `fn_r_app_instance_api`  (
  `id` bigint(20) NOT NULL COMMENT '主键id',
  `app_instance_id` bigint(20) NOT NULL COMMENT '应用id',
  `api_name` varchar(255)  NULL DEFAULT NULL COMMENT 'API名称',
  `path` varchar(255)  NULL DEFAULT NULL COMMENT 'API路径',
  `method` varchar(8)  NULL DEFAULT NULL COMMENT '请求方式，GET/PUT/POST/DELETE',
  `module_code` varchar(128)  NULL DEFAULT NULL COMMENT '所属应用',
  `status` tinyint(1) NULL DEFAULT NULL COMMENT '授权状态，0未授权，1授权',
  `extension` varchar(1024)  NOT NULL DEFAULT '' COMMENT '扩展字段',
  `instance_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '应用实例ID',
  `tenant_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '租户ID',
  `create_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '创建人',
  `create_time` datetime(0) NOT NULL DEFAULT '1000-01-01 00:00:00' COMMENT '创建时间',
  `update_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '修改人',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  `dr` tinyint(1) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志，0 表示未删除，1 表示删除',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '应用实例-API关系表' ROW_FORMAT = Dynamic;


CREATE TABLE IF NOT EXISTS `fn_r_container_bundle`  (
  `id` bigint(20) NOT NULL COMMENT '主键id',
  `type` tinyint(2) NULL DEFAULT NULL COMMENT '部署容器类型',
  `bundle_id` bigint(20) NULL DEFAULT NULL COMMENT '应用ID',
  `container_id` bigint(20) NULL DEFAULT NULL COMMENT '模块ID',
  `extension` varchar(1024)  NOT NULL DEFAULT '' COMMENT '扩展字段',
  `instance_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '应用实例ID',
  `tenant_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '租户ID',
  `create_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '创建人',
  `create_time` datetime(0) NOT NULL DEFAULT '1000-01-01 00:00:00' COMMENT '创建时间',
  `update_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '修改人',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  `dr` tinyint(1) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志（0 表示未删除，1 表示删除）',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '可使用功能包的部署容器' ROW_FORMAT = Dynamic;


CREATE TABLE IF NOT EXISTS `fn_r_domain_app`  (
  `id` bigint(20) NOT NULL COMMENT '主键id',
  `domain` varchar(64)  NOT NULL COMMENT '领域编码',
  `application` varchar(64)  NULL DEFAULT NULL COMMENT '微服务名称',
  `extension` varchar(1024)  NOT NULL DEFAULT '' COMMENT '扩展字段',
  `instance_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '应用实例ID',
  `tenant_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '租户ID',
  `create_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '创建人',
  `create_time` datetime(0) NOT NULL DEFAULT '1000-01-01 00:00:00' COMMENT '创建时间',
  `update_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '修改人',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  `dr` tinyint(1) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志，0 表示未删除，1 表示删除',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '领域-微服务关系表' ROW_FORMAT = Dynamic;


CREATE TABLE IF NOT EXISTS `fn_r_option_setting`  (
  `id` bigint(20) NOT NULL COMMENT '主键id',
  `setting_code` varchar(200)  NOT NULL COMMENT '配置项编码',
  `option_code` varchar(200)  NOT NULL COMMENT '配置项选项编码',
  `depd_setting_code` varchar(200)  NOT NULL COMMENT '依赖的配置项编码',
  `extension` varchar(1024)  NOT NULL DEFAULT '' COMMENT '扩展字段',
  `instance_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '应用实例ID',
  `tenant_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '租户ID',
  `dr` tinyint(1) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志，0 表示未删除，1 表示删除',
  `create_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '创建人',
  `create_time` datetime(0) NOT NULL DEFAULT '1000-01-01 00:00:00' COMMENT '创建时间',
  `update_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '修改人',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '配置项联动关系' ROW_FORMAT = Dynamic;


CREATE TABLE IF NOT EXISTS `fn_r_view_capability`  (
  `id` bigint(20) NOT NULL COMMENT '主键id',
  `capability_code` varchar(256)  NULL DEFAULT NULL COMMENT '能力编码',
  `view_id` bigint(20) NULL DEFAULT NULL COMMENT '配置视图ID',
  `extension` varchar(1024)  NOT NULL DEFAULT '' COMMENT '业务扩展字段',
  `instance_id` bigint(20) NOT NULL DEFAULT 0 COMMENT '应用实例id',
  `tenant_id` bigint(20) NOT NULL DEFAULT 0 COMMENT '租户id',
  `dr` tinyint(2) NOT NULL DEFAULT 0 COMMENT '逻辑删除字段',
  `create_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '创建人',
  `create_time` datetime(0) NOT NULL DEFAULT '1000-01-01 00:00:00' COMMENT '创建时间',
  `update_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '修改人',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '配置视图与能力关联' ROW_FORMAT = Dynamic;


CREATE TABLE IF NOT EXISTS `fn_setting`  (
  `id` bigint(20) NOT NULL COMMENT '主键id',
  `code` varchar(200)  NULL DEFAULT NULL COMMENT '配置项编码',
  `name` varchar(20)  NULL DEFAULT NULL COMMENT '配置项名称',
  `descr` varchar(200)  NULL DEFAULT NULL COMMENT '简介',
  `option_source_type` tinyint(2) NULL DEFAULT 1 COMMENT '1:静态的配置项选项,2从基础数据中心字典表bd_dict获取配置项选项,3由使用功能包的应用提供配置项选项',
  `display_level` tinyint(2) NULL DEFAULT 3 COMMENT '级别(0:全局;1:租户;2:业务空间；3业务身份)',
  `edit_type` tinyint(2) NULL DEFAULT 1 COMMENT '值编辑类型 (1： 输入 ；2： 选择)',
  `value_type` tinyint(2) NULL DEFAULT NULL COMMENT '值类型 ( 11: 整型; 12: 数值; 13: 日期;14:布尔; 15:字符串;16:时间段; 20:枚举; 31: SPI扩展; 32 领域事件扩展)',
  `is_multi_choice` tinyint(2) NULL DEFAULT NULL COMMENT '是否允许多选  0 不允许  1 允许',
  `is_controlled` tinyint(2) NULL DEFAULT 1 COMMENT '表示是否允许下级修改，如果为 1，则下级允许修改；0 否 1 是',
  `exec_mechanism` tinyint(2) NULL DEFAULT 0 COMMENT '执行机制(0顺序执行，1为使用线程池执行)',
  `abort_policy` tinyint(2) NULL DEFAULT 0 COMMENT '抛异常时中止策略:0跳出并抛出异常,1继续执行下一个',
  `default_value` varchar(4096)  NULL DEFAULT NULL COMMENT '记录值编辑类型为 【输入:整型默认值、数值默认值、日期默认值】 、【选择:表格默认值】的默认值',
  `value_scope` varchar(256)  NULL DEFAULT NULL COMMENT '范围值，记录整型有效区间、数值有效区间',
  `capability_code` varchar(256)  NULL DEFAULT NULL COMMENT '能力编码',
  `bundle` varchar(200)  NULL DEFAULT NULL COMMENT '来源功能包编码',
  `group_id` varchar(64)  NULL DEFAULT NULL COMMENT '功能包分组名',
  `artifact_id` varchar(64)  NULL DEFAULT NULL COMMENT '功能包项目名',
  `sort` int(11) NULL DEFAULT NULL COMMENT '排序',
  `view_visible` tinyint(2) NULL DEFAULT 1 COMMENT '配置视图可见 : 1 可见  0 不可见',
  `version` varchar(50)  NULL DEFAULT NULL COMMENT '记录当前配置项来源的版本',
  `source` varchar(256)  NULL DEFAULT NULL COMMENT '记录当前配置项来源的jar包',
  `parameter` varchar(1024)  NULL DEFAULT '' COMMENT '配置项参数，JSON格式',
  `extension` varchar(1024)  NOT NULL DEFAULT '' COMMENT '扩展字段',
  `instance_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '应用实例ID',
  `tenant_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '租户ID',
  `dr` tinyint(1) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志，0 表示未删除，1 表示删除',
  `create_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '创建人',
  `create_time` datetime(0) NOT NULL DEFAULT '1000-01-01 00:00:00' COMMENT '创建时间',
  `update_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '修改人',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_bext_code`(`code`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '配置项信息' ROW_FORMAT = Dynamic;


CREATE TABLE IF NOT EXISTS `fn_setting_history`  (
  `id` bigint(20) NOT NULL COMMENT '主键id',
  `code` varchar(200)  NULL DEFAULT NULL COMMENT '配置项编码',
  `name` varchar(20)  NULL DEFAULT NULL COMMENT '配置项名称',
  `descr` varchar(200)  NULL DEFAULT NULL COMMENT '简介',
  `option_source_type` tinyint(2) NULL DEFAULT 1 COMMENT '1:静态的配置项选项,2从基础数据中心字典表bd_dict获取配置项选项,3由使用功能包的应用提供配置项选项',
  `display_level` tinyint(2) NULL DEFAULT 3 COMMENT '级别(0:全局  1 租户  2 业务空间 3业务身份)',
  `edit_type` tinyint(2) NULL DEFAULT NULL COMMENT '值编辑类型 (1： 输入 ；2： 选择)',
  `value_type` tinyint(2) NULL DEFAULT NULL COMMENT '值类型 ( 11: 整型; 12: 数值; 13: 日期;14:布尔; 15:字符串;20:枚举; 31: SPI扩展; 32 领域事件扩展)',
  `is_multi_choice` tinyint(2) NULL DEFAULT NULL COMMENT '是否允许多选  0 不允许  1 允许',
  `is_controlled` tinyint(2) NULL DEFAULT 1 COMMENT '表示是否允许下级修改，如果为 1，则下级允许修改；0 否 1 是',
  `exec_mechanism` tinyint(2) NULL DEFAULT 0 COMMENT '执行机制(0顺序执行，1为使用线程池执行)',
  `abort_policy` tinyint(2) NULL DEFAULT 0 COMMENT '抛异常时中止策略:0跳出并抛出异常,1继续执行下一个',
  `default_value` varchar(4096)  NULL DEFAULT NULL,
  `value_scope` varchar(256)  NULL DEFAULT NULL COMMENT '范围值，记录整型有效区间、数值有效区间',
  `capability_code` varchar(256)  NULL DEFAULT NULL COMMENT '能力编码',
  `bundle` varchar(200)  NULL DEFAULT NULL COMMENT '来源功能包编码',
  `group_Id` varchar(64)  NULL DEFAULT NULL COMMENT '来源功能包分组名',
  `artifact_Id` varchar(64)  NULL DEFAULT NULL COMMENT '来源功能包项目名',
  `view_visible` tinyint(2) NULL DEFAULT 1 COMMENT '配置视图可见 : 1 可见  0 不可见',
  `sort` int(11) NULL DEFAULT 0 COMMENT '排序',
  `version` varchar(50)  NULL DEFAULT NULL COMMENT '记录当前配置项来源的版本',
  `source` varchar(256)  NULL DEFAULT NULL COMMENT '记录当前配置项来源的jar包',
  `parameter` varchar(1024)  NULL DEFAULT '' COMMENT '配置项参数，JSON格式',
  `extension` varchar(1024)  NOT NULL DEFAULT '' COMMENT '扩展字段',
  `instance_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '应用实例ID',
  `tenant_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '租户ID',
  `dr` tinyint(1) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志，0 表示未删除，1 表示删除',
  `create_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '创建人',
  `create_time` datetime(0) NOT NULL DEFAULT '1000-01-01 00:00:00' COMMENT '创建时间',
  `update_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '修改人',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_bext_code`(`code`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '配置项历史版本' ROW_FORMAT = Dynamic;


CREATE TABLE IF NOT EXISTS `fn_setting_option`  (
  `id` bigint(20) NOT NULL COMMENT '主键id',
  `setting_code` varchar(200)  NULL DEFAULT NULL COMMENT '所属配置项编码',
  `code` varchar(512)  NULL DEFAULT NULL COMMENT '配置项选项编码，唯一标识当前配置项选项；保存 配置项 选用的option时, 存储本字段的值, 这样name和value的修改不影响已经选定的选项',
  `name` varchar(50)  NULL DEFAULT NULL COMMENT '显示值',
  `option_value` varchar(512)  NULL DEFAULT NULL COMMENT '存储值',
  `is_default` tinyint(2) NULL DEFAULT NULL COMMENT '表示当前选项的存储值是否是默认值，0 表示否 ；1 表示 是',
  `descr` varchar(200)  NULL DEFAULT NULL COMMENT '简介',
  `bundle` varchar(200)  NULL DEFAULT NULL COMMENT '来源功能包编码',
  `sort` int(11) NULL DEFAULT NULL COMMENT '排序号',
  `group_id` varchar(64)  NULL DEFAULT NULL COMMENT '功能包分组名',
  `artifact_id` varchar(64)  NULL DEFAULT NULL COMMENT '功能包项目名',
  `version` varchar(50)  NULL DEFAULT NULL COMMENT '记录当前配置项来源的版本',
  `source` varchar(256)  NULL DEFAULT NULL COMMENT '记录当前配置项来源的jar包',
  `extension` varchar(1024)  NOT NULL DEFAULT '' COMMENT '扩展字段',
  `instance_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '应用实例ID',
  `tenant_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '租户ID',
  `dr` tinyint(1) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志，0 表示未删除，1 表示删除',
  `create_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '创建人',
  `create_time` datetime(0) NOT NULL DEFAULT '1000-01-01 00:00:00' COMMENT '创建时间',
  `update_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '修改人',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_bext_code`(`code`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '配置项选项信息' ROW_FORMAT = Dynamic;


CREATE TABLE IF NOT EXISTS `fn_setting_option_history`  (
  `id` bigint(20) NOT NULL COMMENT '主键id',
  `setting_code` varchar(200)  NULL DEFAULT NULL COMMENT '所属配置项编码',
  `code` varchar(200)  NULL DEFAULT NULL COMMENT '配置项选项编码，唯一标识当前配置项选项；保存 配置项 选用的option时, 存储本字段的值, 这样name和value的修改不影响已经选定的选项',
  `name` varchar(20)  NULL DEFAULT NULL COMMENT '显示值',
  `option_value` varchar(200)  NULL DEFAULT NULL COMMENT '存储值',
  `is_default` tinyint(2) NULL DEFAULT 0 COMMENT '表示当前选项的存储值是否是默认值，0 表示否 ；1 表示 是',
  `descr` varchar(200)  NULL DEFAULT NULL COMMENT '简介',
  `bundle` varchar(200)  NULL DEFAULT NULL COMMENT '来源功能包编码',
  `group_Id` varchar(64)  NULL DEFAULT NULL COMMENT '来源功能包分组名',
  `artifact_Id` varchar(64)  NULL DEFAULT NULL COMMENT '来源功能包项目名',
  `sort` int(11) NULL DEFAULT 0 COMMENT '排序号',
  `version` varchar(50)  NULL DEFAULT NULL COMMENT '记录当前配置项来源的版本',
  `source` varchar(256)  NULL DEFAULT NULL COMMENT '记录当前配置项来源的jar包',
  `extension` varchar(1024)  NOT NULL DEFAULT '' COMMENT '扩展字段',
  `instance_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '应用实例ID',
  `tenant_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '租户ID',
  `dr` tinyint(1) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志，0 表示未删除，1 表示删除',
  `create_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '创建人',
  `create_time` datetime(0) NOT NULL DEFAULT '1000-01-01 00:00:00' COMMENT '创建时间',
  `update_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '修改人',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_bext_code`(`code`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '配置项选项历史版本' ROW_FORMAT = Dynamic;


CREATE TABLE IF NOT EXISTS `fn_setting_value`  (
  `id` bigint(20) NOT NULL COMMENT '主键id',
  `tenant_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '租户ID',
  `setting_code` varchar(200)  NULL DEFAULT NULL COMMENT '配置项编码',
  `option_code` varchar(512)  NULL DEFAULT NULL COMMENT '值编辑类型为选择的配置项的 选项，只记录选择类型配置项的候选值，多个即多条数据',
  `setting_value` varchar(4096)  NULL DEFAULT NULL COMMENT '配置项的设定值',
  `biz_space_code` varchar(50)  NULL DEFAULT NULL COMMENT '业务空间编码：配置视图设定级别为业务空间时，需保存业务空间编码标识',
  `biz_id` varchar(200)  NULL DEFAULT NULL COMMENT '业务身份编码：配置视图设定级别为业务身份时，需要保存业务身份编码标识',
  `is_controlled` tinyint(2) NULL DEFAULT 1 COMMENT '是否允许下级修改 ，1 是 0 否',
  `display_level` tinyint(2) NULL DEFAULT 3 COMMENT '显示级别：0 全局 1 租户 2 业务空间 3 业务身份',
  `remark` varchar(200)  NULL DEFAULT NULL COMMENT '简介',
  `extension` varchar(1024)  NOT NULL DEFAULT '' COMMENT '扩展字段',
  `instance_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '应用实例ID',
  `dr` tinyint(1) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志，0 表示未删除，1 表示删除',
  `create_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '创建人',
  `create_time` datetime(0) NOT NULL DEFAULT '1000-01-01 00:00:00' COMMENT '创建时间',
  `update_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '修改人',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '配置项设定值' ROW_FORMAT = Dynamic;


CREATE TABLE IF NOT EXISTS `fn_setting_view`  (
  `id` bigint(20) NOT NULL COMMENT '主键id',
  `code` varchar(20)  NULL DEFAULT NULL COMMENT '配置视图编码',
  `name` varchar(20)  NULL DEFAULT NULL COMMENT '配置视图名称',
  `status` tinyint(2) NULL DEFAULT 1 COMMENT '状态：0 禁用 1启用',
  `remark` varchar(200)  NULL DEFAULT NULL COMMENT '简介',
  `extension` varchar(1024)  NOT NULL DEFAULT '' COMMENT '扩展字段',
  `instance_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '应用实例ID',
  `tenant_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '租户ID',
  `dr` tinyint(1) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志，0 表示未删除，1 表示删除',
  `create_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '创建人',
  `create_time` datetime(0) NOT NULL DEFAULT '1000-01-01 00:00:00' COMMENT '创建时间',
  `update_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '修改人',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '配置视图' ROW_FORMAT = Dynamic;

CREATE TABLE IF NOT EXISTS `meta_domain`  (
  `id` bigint(20) NOT NULL COMMENT '主键id',
  `code` varchar(64)  NULL DEFAULT NULL COMMENT '领域编码',
  `sort` int(11) NULL DEFAULT NULL COMMENT '排序',
  `name` varchar(64)  NULL DEFAULT NULL COMMENT '领域名称',
  `url_path` varchar(32)  NOT NULL COMMENT '获取领域实体信息的网关访问路径，例如/api/user',
  `remark` varchar(1024)  NULL DEFAULT NULL COMMENT '领域描述',
  `version` varchar(64)  NULL DEFAULT NULL COMMENT '版本号',
  `project` varchar(64)  NULL DEFAULT NULL COMMENT '所属项目',
  `extension` varchar(1024)  NULL DEFAULT NULL COMMENT '扩展信息',
  `instance_id` bigint(20) NOT NULL COMMENT '实例ID',
  `tenant_id` bigint(20) NOT NULL COMMENT '租户ID',
  `dr` tinyint(4) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志,0表示未删除，1表示删除',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '修改时间',
  `create_person` varchar(60)  NULL DEFAULT NULL COMMENT '创建人',
  `update_person` varchar(60)  NULL DEFAULT NULL COMMENT '修改人',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '领域' ROW_FORMAT = Dynamic;


CREATE TABLE IF NOT EXISTS `meta_app`  (
  `id` bigint(20) NOT NULL COMMENT '主键id',
  `type` int(11) NULL DEFAULT NULL COMMENT '应用类型（1=能力中心 2=前端应用 3=后端应用）',
  `code` varchar(64)  NULL DEFAULT NULL COMMENT '应用编码',
  `name` varchar(64)  NULL DEFAULT NULL COMMENT '应用名称',
  `remark` varchar(1024)  NULL DEFAULT NULL COMMENT '应用描述',
  `extension` varchar(1024)  NOT NULL DEFAULT '' COMMENT '扩展字段',
  `instance_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '应用实例ID',
  `tenant_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '租户ID',
  `create_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '创建人',
  `create_time` datetime(0) NOT NULL DEFAULT '1000-01-01 00:00:00' COMMENT '创建时间',
  `update_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '修改人',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  `dr` tinyint(1) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志（0 表示未删除，1 表示删除）',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '应用' ROW_FORMAT = Dynamic;


CREATE TABLE IF NOT EXISTS `meta_module`  (
  `id` bigint(20) NOT NULL COMMENT '主键id',
  `type` int(11) NULL DEFAULT NULL COMMENT '模块类型（1=能力中心 2=前端应用 3=后端应用）',
  `code` varchar(64)  NULL DEFAULT NULL COMMENT '模块编码',
  `name` varchar(64)  NULL DEFAULT NULL COMMENT '模块名称',
  `remark` varchar(1024)  NULL DEFAULT NULL COMMENT '模块描述',
  `extension` varchar(1024)  NOT NULL DEFAULT '' COMMENT '扩展字段',
  `instance_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '应用实例ID',
  `tenant_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '租户ID',
  `create_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '创建人',
  `create_time` datetime(0) NOT NULL DEFAULT '1000-01-01 00:00:00' COMMENT '创建时间',
  `update_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '修改人',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  `dr` tinyint(1) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志（0 表示未删除，1 表示删除）',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '模块' ROW_FORMAT = Dynamic;


CREATE TABLE IF NOT EXISTS `meta_r_app_module`  (
  `id` bigint(20) NOT NULL COMMENT '主键id',
  `app_id` bigint(20) NULL DEFAULT NULL COMMENT '应用ID',
  `module_id` bigint(20) NULL DEFAULT NULL COMMENT '模块ID',
  `extension` varchar(1024)  NOT NULL DEFAULT '' COMMENT '扩展字段',
  `instance_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '应用实例ID',
  `tenant_id` bigint(20) NOT NULL DEFAULT -1 COMMENT '租户ID',
  `create_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '创建人',
  `create_time` datetime(0) NOT NULL DEFAULT '1000-01-01 00:00:00' COMMENT '创建时间',
  `update_person` varchar(50)  NOT NULL DEFAULT '' COMMENT '修改人',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0) ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  `dr` tinyint(1) NOT NULL DEFAULT 0 COMMENT '逻辑删除标志（0 表示未删除，1 表示删除）',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '应用模块关系' ROW_FORMAT = Dynamic;


