package com.dtyunxi.yundt.cube.center.transform.api.dto.response;

import java.util.Date;
import com.dtyunxi.dto.ResponseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import com.dtyunxi.dto.BaseRespDto;
import lombok.Data;

/**
* 平台订单商品Eo对象
*
* @author zimu
* @since 2022-05-18
*/
@Data
@ApiModel(value = "PlatformOrderItemRespDto", description = "平台订单商品Eo对象")
public class PlatformOrderItemRespDto extends BaseRespDto{
    /**
    *  主键
    */
    @ApiModelProperty(name = "id", value = "主键")
    private Long id;
    /**
    *  组织id
    */
    @ApiModelProperty(name = "organizationId", value = "组织id")
    private Long organizationId;
    /**
    *  组织code
    */
    @ApiModelProperty(name = "organizationCode", value = "组织code")
    private String organizationCode;
    /**
    *  组织名称
    */
    @ApiModelProperty(name = "organizationName", value = "组织名称")
    private String organizationName;
    /**
    *  订单id
    */
    @ApiModelProperty(name = "orderId", value = "订单id")
    private Long orderId;
    /**
    *  商品名称
    */
    @ApiModelProperty(name = "itemName", value = "商品名称")
    private String itemName;
    /**
    *  商品ID
    */
    @ApiModelProperty(name = "itemId", value = "商品ID")
    private Long itemId;
    /**
    *  商品编码
    */
    @ApiModelProperty(name = "itemCode", value = "商品编码")
    private String itemCode;
    /**
    *  商品数量
    */
    @ApiModelProperty(name = "itemNum", value = "商品数量")
    private BigDecimal itemNum;
    /**
    *  商品批次号
    */
    @ApiModelProperty(name = "batchNo", value = "商品批次号")
    private String batchNo;
    /**
    *  单价
    */
    @ApiModelProperty(name = "price", value = "单价")
    private BigDecimal price;
    /**
    *  skuId
    */
    @ApiModelProperty(name = "skuId", value = "skuId")
    private Long skuId;
    /**
    *  sku编码
    */
    @ApiModelProperty(name = "skuCode", value = "sku编码")
    private String skuCode;
    /**
    *  规格名称
    */
    @ApiModelProperty(name = "skuName", value = "规格名称")
    private String skuName;
    /**
    *  是否赠品：0否，1是
    */
    @ApiModelProperty(name = "gift", value = "是否赠品：0否，1是")
    private Integer gift;
    /**
    *  产品销售单价（含税单价）
    */
    @ApiModelProperty(name = "salePrice", value = "产品销售单价（含税单价）")
    private BigDecimal salePrice;
    /**
    *  行金额（税价合计）
    */
    @ApiModelProperty(name = "lineAmount", value = "行金额（税价合计）")
    private BigDecimal lineAmount;
    /**
    *  csp销售单商品扩展字段
    */
    @ApiModelProperty(name = "cspItemExtendJson", value = "csp销售单商品扩展字段")
    private String cspItemExtendJson;

    /**
     *  是否积分商品:0否，1是
     */
    @ApiModelProperty(name = "integral", value = "是否积分商品:0否，1是")
    private Integer integral;

    /**
     *  应付金额
     */
    @ApiModelProperty(name = "orderTotalAmount", value = "应付金额")
    private BigDecimal orderTotalAmount;
    /**
     *  实付金额
     */
    @ApiModelProperty(name = "payAmount", value = "实付金额")
    private BigDecimal payAmount;

    @ApiModelProperty(name = "rdc", value = "来发货仓库标识, 珠海:RDC_ZH,天津:RDC_TJ")
    private String rdc;

    @ApiModelProperty(name = "oldItemId", value = "合单前的旧订单明细id")
    private Long oldItemId;

    /**
     * 税码
     */
    @ApiModelProperty(name = "taxCode",value = "税码")
    private String taxCode;

    /**
     * 税率
     */
    @ApiModelProperty(name = "taxRate",value = "税率")
    private BigDecimal taxRate;
    /**
     * 行税额
     */
    @ApiModelProperty(name = "lineTaxAmount",value = "行税额")
    private BigDecimal lineTaxAmount;
    /**
     * 扣率
     */
    @ApiModelProperty(name = "settleRate",value = "扣率")
    private BigDecimal settleRate;
    /**
     * 折扣额
     */
    @ApiModelProperty(name = "settleAmount",value = "折扣额")
    private BigDecimal settleAmount;
    /**
     * 积分值
     */
    @ApiModelProperty(name = "totalScore",value = "积分值")
    private BigDecimal totalScore;


    /**
     * 商品单位
     */
    @ApiModelProperty(name = "itemUom",value = "商品单位")
    private String itemUom;

    /**
     * 是否补发商品 0 否，1 是，默认 0；
     */
    @ApiModelProperty(name = "replacementFlag",value = "是否补发商品 0 否，1 是，默认 0；")
    private Integer replacementFlag;

    public void setId(Long id){
    this.id = id;
    }
    public Long getId(){
    return this.id;
    }
    public void setOrganizationId(Long organizationId){
    this.organizationId = organizationId;
    }
    public Long getOrganizationId(){
    return this.organizationId;
    }
    public void setOrganizationCode(String organizationCode){
    this.organizationCode = organizationCode;
    }
    public String getOrganizationCode(){
    return this.organizationCode;
    }
    public void setOrganizationName(String organizationName){
    this.organizationName = organizationName;
    }
    public String getOrganizationName(){
    return this.organizationName;
    }
    public void setOrderId(Long orderId){
    this.orderId = orderId;
    }
    public Long getOrderId(){
    return this.orderId;
    }
    public void setItemName(String itemName){
    this.itemName = itemName;
    }
    public String getItemName(){
    return this.itemName;
    }
    public void setItemId(Long itemId){
    this.itemId = itemId;
    }
    public Long getItemId(){
    return this.itemId;
    }
    public void setItemCode(String itemCode){
    this.itemCode = itemCode;
    }
    public String getItemCode(){
    return this.itemCode;
    }
    public void setItemNum(BigDecimal itemNum){
    this.itemNum = itemNum;
    }
    public BigDecimal getItemNum(){
    return this.itemNum;
    }
    public void setBatchNo(String batchNo){
    this.batchNo = batchNo;
    }
    public String getBatchNo(){
    return this.batchNo;
    }
    public void setPrice(BigDecimal price){
    this.price = price;
    }
    public BigDecimal getPrice(){
    return this.price;
    }
    public void setSkuId(Long skuId){
    this.skuId = skuId;
    }
    public Long getSkuId(){
    return this.skuId;
    }
    public void setSkuCode(String skuCode){
    this.skuCode = skuCode;
    }
    public String getSkuCode(){
    return this.skuCode;
    }
    public void setSkuName(String skuName){
    this.skuName = skuName;
    }
    public String getSkuName(){
    return this.skuName;
    }
    public void setGift(Integer gift){
    this.gift = gift;
    }
    public Integer getGift(){
    return this.gift;
    }

    public BigDecimal getSalePrice() {
        return salePrice;
    }

    public void setSalePrice(BigDecimal salePrice) {
        this.salePrice = salePrice;
    }

    public void setLineAmount(BigDecimal lineAmount){
    this.lineAmount = lineAmount;
    }
    public BigDecimal getLineAmount(){
    return this.lineAmount;
    }
    public void setCspItemExtendJson(String cspItemExtendJson){
    this.cspItemExtendJson = cspItemExtendJson;
    }
    public String getCspItemExtendJson(){
    return this.cspItemExtendJson;
    }

    public Integer getIntegral() {
        return integral;
    }

    public void setIntegral(Integer integral) {
        this.integral = integral;
    }

    public BigDecimal getOrderTotalAmount() {
        return orderTotalAmount;
    }

    public void setOrderTotalAmount(BigDecimal orderTotalAmount) {
        this.orderTotalAmount = orderTotalAmount;
    }

    public BigDecimal getPayAmount() {
        return payAmount;
    }

    public void setPayAmount(BigDecimal payAmount) {
        this.payAmount = payAmount;
    }

    public String getRdc() {
        return rdc;
    }

    public void setRdc(String rdc) {
        this.rdc = rdc;
    }

    public Long getOldItemId() {
        return oldItemId;
    }

    public void setOldItemId(Long oldItemId) {
        this.oldItemId = oldItemId;
    }

    public String getTaxCode() {
        return taxCode;
    }

    public void setTaxCode(String taxCode) {
        this.taxCode = taxCode;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public BigDecimal getLineTaxAmount() {
        return lineTaxAmount;
    }

    public void setLineTaxAmount(BigDecimal lineTaxAmount) {
        this.lineTaxAmount = lineTaxAmount;
    }

    public BigDecimal getSettleRate() {
        return settleRate;
    }

    public void setSettleRate(BigDecimal settleRate) {
        this.settleRate = settleRate;
    }

    public BigDecimal getSettleAmount() {
        return settleAmount;
    }

    public void setSettleAmount(BigDecimal settleAmount) {
        this.settleAmount = settleAmount;
    }

    public BigDecimal getTotalScore() {
        return totalScore;
    }

    public void setTotalScore(BigDecimal totalScore) {
        this.totalScore = totalScore;
    }

    public String getItemUom() {
        return itemUom;
    }

    public void setItemUom(String itemUom) {
        this.itemUom = itemUom;
    }

    public Integer getReplacementFlag() {
        return replacementFlag;
    }

    public void setReplacementFlag(Integer replacementFlag) {
        this.replacementFlag = replacementFlag;
    }
}
