package com.dtyunxi.yundt.cube.center.transform.api.constant;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 平台订单状态的枚举类型
 * @author xiuji
 */
public enum PlatformOrderStatusEnum {
    /**
     * submit:提交订单;audit_pass:审核成功;audit_not_pass:审核不通过;cancel:取消订单;
     */
    SUBMIT("submit","提交订单"),
    AUDIT_PASS("audit_pass","审核通过"),
    AUDIT_NOT_PASS("audit_not_pass","审核不通过"),
    CANCEL("cancel","取消订单"),

    ;


    private String code;

    private String desc;

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    PlatformOrderStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static final Map<String, PlatformOrderStatusEnum> CODE_LOOKUP = Arrays.stream(values()).collect(Collectors.toMap(thisEnum -> thisEnum.code, thisEnum -> thisEnum));
    public static final Map<String, String> CODE_DESC_MAP = Arrays.stream(values()).collect(Collectors.toMap(thisEnum -> thisEnum.code, thisEnum -> thisEnum.desc));

    public static PlatformOrderStatusEnum forCode(String code) {
        return CODE_LOOKUP.get(code);
    }

    public Map<String, String> getCodeAndDesc() {
        return CODE_DESC_MAP;
    }
}
