package com.dtyunxi.yundt.cube.center.transform.api.dto.request;

import java.util.Date;
import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.List;

/**
* PCP订单渠道表Eo对象
*
* @author yuangui
* @since 2022-04-01
*/
@Data
@ApiModel(value = "PcpOrderChannelReqDto", description = "PCP订单渠道表Eo对象")
public class PcpOrderChannelReqDto extends RequestDto{
    /**
    *  主键ID
    */
    @ApiModelProperty(name = "id", value = "主键ID")
    @NotNull(message = "主键ID(id)不能为空",groups = {Edit.class})
    private Long id;
    /**
    *  渠道编码
    */
    @ApiModelProperty(name = "channelCode", value = "渠道编码")
    @NotBlank(message = "渠道编码(channelCode)不能为空",groups = {Edit.class})
    private String channelCode;
    /**
    *  渠道名称
    */
    @ApiModelProperty(name = "channelName", value = "渠道名称")
    @NotBlank(message = "渠道名称(channelName)不能为空",groups = {Add.class,Edit.class})
    private String channelName;
    /**
    *  渠道状态（ENABLED：启用、DIABLED：禁用）
    */
    @ApiModelProperty(name = "status", value = "渠道状态（ENABLED：启用、DIABLED：禁用）")
    @NotBlank(message = "渠道状态(status)不能为空",groups = {Add.class,Edit.class})
    private String status;
    /**
    *  备注
    */
    @ApiModelProperty(name = "description", value = "备注")
    private String description;
    /**
     * 创建开始时间
     */
    @ApiModelProperty(name="createTimeStart",value = "创建开始时间")
    private String createTimeStart;
    /**
     * 创建结束时间
     */
    @ApiModelProperty(name="createTimeEnd",value = "创建结束时间")
    private String createTimeEnd;
    /**
     * 排序，默认按照create_time降序
     */
    @ApiModelProperty(name = "orderByDesc", value = "排序，默认按照create_time降序")
    private String orderByDesc = "create_time";
    /**
     *  渠道编码列表
     */
    @ApiModelProperty(name = "channelCodes", value = "渠道编码列表")
    private List<String> channelCodes;
    /**
     *  主键ID列表
     */
    @ApiModelProperty(name = "ids", value = "主键ID列表")
    private List<Long> ids;

    @ApiModelProperty(name = "outIds", value = "排除ID列表")
    private List<Long> outIds;

    public interface Add{}
    public interface Edit{}
}
