/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.workflow.center.user.biz.service.impl;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserGroupDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.UserRoleReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.UserRoleRespDto;
import com.dtyunxi.yundt.cube.center.user.biz.service.IAccessService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IUserGroupService;
import com.dtyunxi.yundt.cube.center.user.biz.service.IUserService;
import com.dtyunxi.yundt.cube.center.user.biz.util.QueryUtil;
import com.dtyunxi.yundt.cube.center.user.dao.das.AppInstanceDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.RoleDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.UserDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.UserRoleRelationDas;
import com.dtyunxi.yundt.cube.center.user.dao.eo.AppInstanceEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.RoleEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.StdUserRoleRelationEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.UserEo;
import com.dtyunxi.yundt.cube.center.workflow.queryapi.bo.RoleBo;
import com.dtyunxi.yundt.cube.center.workflow.queryapi.bo.UserInfoBo;
import com.dtyunxi.yundt.cube.workflow.center.user.biz.service.IUserRoleService;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class UserRoleServiceImpl
implements IUserRoleService {
    @Resource
    private IAccessService accessService;
    @Resource
    private UserRoleRelationDas userRoleRelationDas;
    @Resource
    private UserDas userDas;
    @Resource
    private IUserService userService;
    @Resource
    private IUserGroupService userGroupService;
    @Resource
    private AppInstanceDas appInstanceDas;
    @Resource
    private RoleDas roleDas;

    @Override
    public List<String> getUserIdsByRoles(String tenantId, List<String> roleIds) {
        Set userIdSet;
        List userEoList;
        List rodeIdList;
        List userRoleRelationEoList;
        List<Object> userIdList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(roleIds) && CollectionUtils.isNotEmpty((Collection)(userRoleRelationEoList = this.userRoleRelationDas.selectByRodeIdList(rodeIdList = roleIds.stream().map(s -> Long.valueOf(s)).collect(Collectors.toList())))) && CollectionUtils.isNotEmpty((Collection)(userEoList = this.userDas.findByIds(userIdSet = userRoleRelationEoList.stream().map(StdUserRoleRelationEo::getUserId).collect(Collectors.toSet()))))) {
            List idList = userEoList.stream().map(BaseEo::getId).collect(Collectors.toList());
            userIdList = idList.stream().map(id -> String.valueOf(id)).collect(Collectors.toList());
        }
        return userIdList;
    }

    @Override
    public List<String> getRoleIdsByUser(String tenantId, String userId) {
        List<Object> rodeIdList = Lists.newArrayList();
        if (userId != null) {
            UserRoleReqDto userRoleReqDto = new UserRoleReqDto();
            userRoleReqDto.setUserId(Long.valueOf(userId));
            List userRoleRespDtoList = this.accessService.queryUserRole(userRoleReqDto);
            if (CollectionUtils.isNotEmpty((Collection)userRoleRespDtoList)) {
                List idList = userRoleRespDtoList.stream().map(UserRoleRespDto::getRoleId).collect(Collectors.toList());
                rodeIdList = idList.stream().map(id -> String.valueOf(id)).collect(Collectors.toList());
            }
        }
        return rodeIdList;
    }

    @Override
    public List<UserInfoBo> queryByUserIds(Set<String> userIds) {
        ArrayList userInfoBoList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(userIds)) {
            Set userIdList = userIds.stream().map(s -> Long.valueOf(s)).collect(Collectors.toSet());
            List userEoList = this.userDas.findByIds(userIdList);
            this.handleUserData(userInfoBoList, userEoList);
        }
        return userInfoBoList;
    }

    private void handleUserData(List<UserInfoBo> userInfoBoList, List<UserEo> userEoList) {
        if (CollectionUtils.isNotEmpty(userEoList)) {
            for (UserEo userEo : userEoList) {
                UserInfoBo userInfoBo = new UserInfoBo();
                userInfoBo.setUserId(String.valueOf(userEo.getId()));
                userInfoBo.setUserName(userEo.getUserName());
                userInfoBo.setMobile(userEo.getPhone());
                userInfoBoList.add(userInfoBo);
            }
        }
    }

    @Override
    public Set<String> queryIdsByName(String userName) {
        Long instanceId;
        UserDto userDto;
        HashSet userIdList = Sets.newHashSet();
        if (StringUtils.isNotEmpty((CharSequence)userName) && (userDto = this.userService.queryByLoginStr(userName, instanceId = ServiceContext.getContext().getRequestInstanceId(), null)) != null) {
            userIdList.add(userDto.getId().toString());
        }
        return userIdList;
    }

    @Override
    public List<Long> getDirectSuperiorIdsByUser(String tenantId, Long orgId, Long deptId, Long userId) {
        return null;
    }

    @Override
    public List<Long> getDirectReportIdsByUser(String tenantId, Long orgId, Long deptId, Long userId) {
        return null;
    }

    @Override
    public List<Long> getDirectSubordinateIdsByUser(String tenantId, Long orgId, Long deptId, Long userId) {
        return null;
    }

    @Override
    public Set<String> getUserGroupIdsByUserId(String userId) {
        List userGroupDtoList;
        Set<Object> userGroupIdSet = Sets.newHashSet();
        if (StringUtils.isNotEmpty((CharSequence)userId) && CollectionUtils.isNotEmpty((Collection)(userGroupDtoList = this.userGroupService.findUserGroupOfUser(Long.valueOf(userId))))) {
            Set idSet = userGroupDtoList.stream().map(UserGroupDto::getId).collect(Collectors.toSet());
            userGroupIdSet = idSet.stream().map(id -> String.valueOf(id)).collect(Collectors.toSet());
        }
        return userGroupIdSet;
    }

    @Override
    public List<UserInfoBo> queryByRoleIds(Set<String> roleIds) {
        List rodeIdList;
        List userRoleRelationEoList;
        ArrayList userInfoBoList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(roleIds) && CollectionUtils.isNotEmpty((Collection)(userRoleRelationEoList = this.userRoleRelationDas.selectByRodeIdList(rodeIdList = roleIds.stream().map(s -> Long.valueOf(s)).collect(Collectors.toList()))))) {
            Set userIdSet = userRoleRelationEoList.stream().map(StdUserRoleRelationEo::getUserId).collect(Collectors.toSet());
            List userEoList = this.userDas.findByIds(userIdSet);
            this.handleUserData(userInfoBoList, userEoList);
        }
        return userInfoBoList;
    }

    @Override
    public PageInfo<RoleBo> queryRole(RoleBo roleBo, Integer pageNum, Integer pageSize) {
        Assert.notNull((Object)ServiceContext.getContext().getRequestTenantId(), (String)"\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AppInstanceEo appInstanceEo = new AppInstanceEo();
        appInstanceEo.setTenantId(ServiceContext.getContext().getRequestTenantId());
        appInstanceEo.setCode("xproc.running");
        List appInstanceEoList = this.appInstanceDas.select((BaseEo)appInstanceEo);
        Assert.notEmpty((Collection)appInstanceEoList, (String)"\u8be5\u79df\u6237\u4e0b\u4e0d\u5b58\u5728\u7f16\u7801\u4e3axproc.running\u7684xproc\u8fd0\u884c\u6001\u5e94\u7528\uff0c\u65e0\u6cd5\u67e5\u8be2\u89d2\u8272\u5217\u8868");
        RoleEo roleEo = new RoleEo();
        roleEo.setInstanceId(((AppInstanceEo)appInstanceEoList.get(0)).getId());
        if (StringUtils.isNotBlank((CharSequence)roleBo.getName())) {
            ArrayList sqlFilters = Lists.newArrayList();
            sqlFilters.add(SqlFilter.like((String)"name", (Object)("%" + roleBo.getName() + "%")));
            roleEo.setSqlFilters((List)sqlFilters);
        }
        roleEo.setOrderByDesc("create_time");
        PageInfo page = this.roleDas.selectPage((BaseEo)roleEo, pageNum, pageSize);
        return QueryUtil.eoPage2DtoPage((PageInfo)page, RoleBo.class);
    }
}

