/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.payment.service.gateway.account;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.account.api.ITransactionApi;
import com.dtyunxi.yundt.cube.center.account.api.dto.request.tran.PayReqDto;
import com.dtyunxi.yundt.cube.center.payment.constant.Constant;
import com.dtyunxi.yundt.cube.center.payment.constant.enums.status.CheckStatus;
import com.dtyunxi.yundt.cube.center.payment.constant.enums.status.GwStatus;
import com.dtyunxi.yundt.cube.center.payment.constant.enums.status.OrderStatus;
import com.dtyunxi.yundt.cube.center.payment.service.exception.OrderProcessorException;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.account.AbstractAccountGatewayService;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.bean.BaseGatewayResult;
import com.dtyunxi.yundt.cube.center.settlement.dao.das.AppDas;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.AppEo;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.PayOrderEo;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="accountNotifyFailGatewayService")
public class AccountNotifyFailGatewayServiceImpl
extends AbstractAccountGatewayService<PayOrderEo, RestResponse> {
    @Resource
    private ITransactionApi iTransactionApi;
    @Resource
    private AppDas payAppsDas;

    public BaseGatewayResult rechargeResult(PayOrderEo payOrderEo, RestResponse restResponse) throws Exception {
        return null;
    }

    public RestResponse _execute(PayOrderEo payOrderEo) throws Exception {
        RestResponse restResponse = new RestResponse();
        PayOrderEo order = (PayOrderEo)this.payOrderDas.selectByLogicKey((Object)payOrderEo.getTradeId());
        if (order.getPayType().equals("800")) {
            JSONObject jsonObject = JSONObject.parseObject((String)JSON.toJSONString((Object)order));
            AppEo app = (AppEo)this.payAppsDas.selectByLogicKey((Object)jsonObject.getString("appCode"));
            if (!Constant.IS_CLOSE_ORDER.equals(app.getIsCloseOrder())) {
                this.logger.info("\u4e0d\u9700\u8981\u5173\u95ed\u8ba2\u5355(\u8ba2\u5355\u7f6e\u4e3a\u5931\u8d25)");
            }
            if (null == order) {
                this.logger.error("\u6e20\u9053\u8ba2\u5355\u4e0d\u5b58\u5728 tradeId: {}", (Object)order.getTradeId());
                throw new OrderProcessorException("\u6e20\u9053\u8ba2\u5355\u4e0d\u5b58\u5728");
            }
            if (OrderStatus.isFailStatus((String)order.getStatus())) {
                this.logger.info("\u8ba2\u5355\u72b6\u6001\u5df2\u7ecf\u662f\u5931\u8d25\u72b6\u6001\uff0c\u4e0d\u9700\u8981\u66f4\u65b0");
            } else {
                jsonObject.put("error_code", jsonObject.get((Object)"errorCode"));
                jsonObject.put("error_msg", jsonObject.get((Object)"errorMsg"));
                jsonObject.put("status", (Object)OrderStatus.FAIL.getStatus());
                jsonObject.put("gw_status", (Object)GwStatus.FAIL.getStatus());
                if (null == jsonObject.getString("finishTime")) {
                    jsonObject.put("finishTime", (Object)new Date());
                }
                PayOrderEo payOrder = (PayOrderEo)JSON.parseObject((String)jsonObject.toJSONString(), order.getClass());
                if (CheckStatus.isSuccStatus((String)order.getCheckStatus())) {
                    this.logger.warn("\u8ba2\u5355 tradeId:{},\u539f\u672c\u5df2\u7ecf\u6838\u5b9e,\u63a5\u5230\u6e20\u9053\u5931\u8d25\u901a\u77e5,\u4fee\u6539\u8ba2\u5355\u72b6\u6001,\u6b64\u540e\u8be5\u8ba2\u5355\u4e0d\u4f1a\u8fdb\u884c\u8ba2\u5355\u6838\u5bf9", (Object)order.getTradeId());
                }
                this.payOrderDas.updateSelective((BaseEo)payOrder);
                this.payOrderDas.updateSubOrder(payOrder.getTradeId(), OrderStatus.FAIL.getStatus(), GwStatus.FAIL.getStatus());
            }
            this.logger.info("\u8ba2\u5355\u72b6\u6001\u5df2\u7ecf\u66f4\u65b0\u4e3a\u5931\u8d25\uff01\u5f00\u59cb\u8d26\u6237\u51b2\u6b63");
            Long accountId = Long.valueOf(order.getAccountId());
            BigDecimal amount = order.getAmount();
            Long instanceId = order.getInstanceId();
            Long tenantId = order.getTenantId();
            PayReqDto payReqDto = new PayReqDto();
            payReqDto.setAccountId(accountId);
            payReqDto.setTranAmt(amount);
            payReqDto.setInstanceId(instanceId);
            payReqDto.setTenantId(tenantId);
            payReqDto.setTradeId(order.getTradeId());
            payReqDto.setInstanceId(order.getInstanceId());
            payReqDto.setTenantId(order.getTenantId());
            Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)payReqDto), Map.class);
            this.iTransactionApi.modifyTransaction("RECHARGEBACK", map);
            restResponse.setResultCode("0");
            return restResponse;
        }
        restResponse.setResultCode("ERROR_PAY_TYPE");
        return restResponse;
    }

    public void validate(PayOrderEo payOrderEo, RestResponse restResponse) throws Exception {
    }
}

