/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.payment.service.gateway.account.impl.trade;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.account.api.dto.request.tran.PayReqDto;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.account.AbstractAccountGatewayService;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.bean.BaseGatewayResult;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.bean.GatewayResult;
import com.dtyunxi.yundt.cube.center.payment.service.trade.helper.OrderAssistant;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.PayOrderEo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="accountOrderCreateGatewayService")
@Transactional(transactionManager="dataSourceTransactionManager", rollbackFor={Exception.class})
public class AccountOrderCreateGatewayServiceImpl
extends AbstractAccountGatewayService<PayOrderEo, RestResponse> {
    public BaseGatewayResult rechargeResult(PayOrderEo payOrder, RestResponse paymentResponse) throws Exception {
        PayOrderEo partnerOrder = OrderAssistant.createPayOrder((String)payOrder.getTradeId());
        GatewayResult result = new GatewayResult(false, payOrder.getTradeId());
        partnerOrder.setAmount(payOrder.getAmount());
        if (paymentResponse.getResultCode().equals("0")) {
            result = new GatewayResult(true, payOrder.getTradeId());
            this.payOrderProcessorService.handleSuccOrder((Object)partnerOrder);
        } else {
            partnerOrder.setErrorCode(paymentResponse.getResultCode());
            partnerOrder.setErrorMsg(paymentResponse.getResultMsg());
            this.payOrderProcessorService.handleFailOrder((Object)partnerOrder);
        }
        return result;
    }

    public RestResponse _execute(PayOrderEo payOrder) throws Exception {
        if (StringUtils.isBlank((CharSequence)payOrder.getUserId())) {
            throw new Exception("\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PayReqDto placeRequest = new PayReqDto();
        placeRequest.setAccountId(Long.valueOf(payOrder.getAccountId()));
        placeRequest.setTranType("PAY");
        placeRequest.setTranAmt(payOrder.getAmount());
        placeRequest.setTradeId(payOrder.getTradeId());
        return (RestResponse)this.accountPartnerService.placeOrder(placeRequest);
    }

    public void validate(PayOrderEo payOrder, RestResponse paymentResponse) throws Exception {
    }
}

