/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.payment.service.gateway.account.impl.trade;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.account.api.dto.request.tran.RefundReqDto;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.account.AbstractAccountGatewayService;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.bean.BaseGatewayResult;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.bean.GatewayResult;
import com.dtyunxi.yundt.cube.center.payment.service.trade.helper.OrderAssistant;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.RefundOrderEo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="accountOrderRefundCreateGatewayService")
@Transactional(transactionManager="dataSourceTransactionManager", rollbackFor={Exception.class})
public class AccountOrderRefundCreateGatewayServiceImpl
extends AbstractAccountGatewayService<RefundOrderEo, RestResponse> {
    public BaseGatewayResult rechargeResult(RefundOrderEo payOrder, RestResponse paymentResponse) throws Exception {
        RefundOrderEo partnerOrder = OrderAssistant.createRefundOrder((String)payOrder.getTradeId());
        GatewayResult result = new GatewayResult(false, payOrder.getTradeId());
        partnerOrder.setAmount(payOrder.getAmount());
        partnerOrder.setRefundId(payOrder.getRefundId());
        if (paymentResponse.getResultCode().equals("0")) {
            result = new GatewayResult(true, payOrder.getTradeId());
            this.payRefundOrderProcessorService.handleSuccOrder((Object)partnerOrder);
        } else {
            partnerOrder.setErrorCode(paymentResponse.getResultCode());
            partnerOrder.setErrorMsg(paymentResponse.getResultMsg());
            this.payRefundOrderProcessorService.handleFailOrder((Object)partnerOrder);
        }
        return result;
    }

    public RestResponse _execute(RefundOrderEo payOrder) throws Exception {
        if (StringUtils.isBlank((CharSequence)payOrder.getUserId())) {
            throw new Exception("\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        RefundReqDto placeRequest = new RefundReqDto();
        placeRequest.setAccountId(Long.valueOf(payOrder.getAccountId()));
        placeRequest.setTranType("REFUND");
        placeRequest.setTranAmt(payOrder.getAmount());
        placeRequest.setTradeId(payOrder.getTradeId());
        return (RestResponse)this.accountPartnerService.refundOrder(placeRequest);
    }

    public void validate(RefundOrderEo payOrder, RestResponse paymentResponse) throws Exception {
    }
}

