/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.payment.service.notify.ctrl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.account.api.ITransactionApi;
import com.dtyunxi.yundt.cube.center.account.api.dto.request.tran.RechargeReqDto;
import com.dtyunxi.yundt.cube.center.account.api.dto.request.tran.WithDrawConfirmReqDto;
import com.dtyunxi.yundt.cube.center.payment.constant.enums.status.OrderStatus;
import com.dtyunxi.yundt.cube.center.payment.dto.notify.PayOrderNotifyRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.notify.base.TradeOrderNotifyRequest;
import com.dtyunxi.yundt.cube.center.payment.notify.ctrl.BaseNotifyCtrl;
import com.dtyunxi.yundt.cube.center.payment.notify.ctrl.INotifyCtrl;
import com.dtyunxi.yundt.cube.center.settlement.dao.das.EnterpriseOrderAttachInfoDas;
import com.dtyunxi.yundt.cube.center.settlement.dao.das.PartnerConfigDas;
import com.dtyunxi.yundt.cube.center.settlement.dao.das.PayOrderAttachInfoDas;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.EnterpriseOrderAttachInfoEo;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.PartnerConfigEo;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.PayOrderAttachInfoEo;
import java.math.BigDecimal;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/center/account/notify"})
public class CenterAccountNotifyCtrl
extends BaseNotifyCtrl
implements INotifyCtrl {
    private static Logger logger = LoggerFactory.getLogger(CenterAccountNotifyCtrl.class);
    @Resource
    protected PartnerConfigDas partnerConfigDas;
    @Resource
    protected PayOrderAttachInfoDas payOrderAttachInfoDas;
    @Resource
    protected EnterpriseOrderAttachInfoDas enterpriseOrderAttachInfoDas;
    @Resource
    ITransactionApi transactionApi;

    @RequestMapping(value={"/recharge"})
    public String accountNotifyOrder(HttpServletRequest request) throws Exception {
        try {
            Map map = this.getReqData(request);
            PayOrderNotifyRequest baseOrderNotifyRequest = (PayOrderNotifyRequest)JSON.parseObject((String)JSON.toJSONString((Object)map), PayOrderNotifyRequest.class);
            logger.info("\u6536\u5230\u8d26\u6237\u5145\u503c\u56de\u8c03:{}", (Object)JSON.toJSONString((Object)baseOrderNotifyRequest));
            RechargeReqDto placeRequest = new RechargeReqDto();
            placeRequest.setAccountId(Long.valueOf(baseOrderNotifyRequest.getAccountId()));
            placeRequest.setTranType("RECHARGE");
            placeRequest.setTranAmt(new BigDecimal(baseOrderNotifyRequest.getOrderAmt()));
            placeRequest.setTradeId(baseOrderNotifyRequest.getTradeId());
            placeRequest.setStoreOrderId(baseOrderNotifyRequest.getStoreOrderId());
            if (OrderStatus.isSuccStatus((String)baseOrderNotifyRequest.getOrderStatus())) {
                placeRequest.setResultFlag(Boolean.valueOf(true));
            } else {
                placeRequest.setResultFlag(Boolean.valueOf(false));
            }
            RestResponse baseTranRespDtoRestResponse = this.transactionApi.doTransaction(placeRequest.getTranType(), (Map)JSON.parseObject((String)JSON.toJSONString((Object)placeRequest), Map.class));
            return JSON.toJSONString((Object)baseTranRespDtoRestResponse);
        }
        catch (Exception e) {
            return e.toString();
        }
    }

    @RequestMapping(value={"/reimbursement"})
    public String accountReimbursementNotifyOrder(HttpServletRequest request) throws Exception {
        try {
            PayOrderAttachInfoEo attach;
            Map map = this.getReqData(request);
            TradeOrderNotifyRequest baseOrderNotifyRequest = (TradeOrderNotifyRequest)JSON.parseObject((String)JSON.toJSONString((Object)map), TradeOrderNotifyRequest.class);
            logger.info("\u6536\u5230\u8d26\u6237\u8fd8\u6b3e\u56de\u8c03:{}", (Object)JSON.toJSONString((Object)baseOrderNotifyRequest));
            PartnerConfigEo pConfig = PartnerConfigEo.newInstance();
            pConfig.setPayType(baseOrderNotifyRequest.getPayTypeId());
            pConfig.setPartnerCode(baseOrderNotifyRequest.getPartnerOrderId());
            PartnerConfigEo partnerConfig = (PartnerConfigEo)this.partnerConfigDas.selectOne((BaseEo)pConfig);
            if (StringUtils.isBlank((CharSequence)partnerConfig.getEnterType())) {
                attach = PayOrderAttachInfoEo.newInstance();
                attach.setTradeId(baseOrderNotifyRequest.getTradeId());
                PayOrderAttachInfoEo payOrderAttachInfoEo = (PayOrderAttachInfoEo)this.payOrderAttachInfoDas.selectOne((BaseEo)attach);
                if (StringUtils.isBlank((CharSequence)payOrderAttachInfoEo.getRemark6())) {
                    throw new Exception("\u8be5\u8ba2\u5355\u4e0d\u662f\u8fd8\u6b3e\u8ba2\u5355");
                }
                if (!payOrderAttachInfoEo.getRemark6().equals("1")) {
                    throw new Exception("\u8be5\u8ba2\u5355\u5df2\u7ecf\u5ba1\u6279");
                }
                payOrderAttachInfoEo.setRemark6("0");
                this.payOrderAttachInfoDas.updateSelective((BaseEo)payOrderAttachInfoEo);
            } else {
                attach = EnterpriseOrderAttachInfoEo.newInstance();
                attach.setTradeId(baseOrderNotifyRequest.getTradeId());
                EnterpriseOrderAttachInfoEo enterpriseOrderAttachInfoEo = (EnterpriseOrderAttachInfoEo)this.enterpriseOrderAttachInfoDas.selectOne((BaseEo)attach);
                if (StringUtils.isBlank((CharSequence)enterpriseOrderAttachInfoEo.getRemark6())) {
                    throw new Exception("\u8be5\u8ba2\u5355\u4e0d\u662f\u8fd8\u6b3e\u8ba2\u5355");
                }
                if (!enterpriseOrderAttachInfoEo.getRemark6().equals("1")) {
                    throw new Exception("\u8be5\u8ba2\u5355\u5df2\u7ecf\u5ba1\u6279");
                }
                enterpriseOrderAttachInfoEo.setRemark6("0");
                this.enterpriseOrderAttachInfoDas.updateSelective((BaseEo)enterpriseOrderAttachInfoEo);
            }
            RestResponse baseTranRespDtoRestResponse = null;
            if (StringUtils.isEmpty((CharSequence)baseOrderNotifyRequest.getFailCode())) {
                RechargeReqDto placeRequest = new RechargeReqDto();
                placeRequest.setAccountId(Long.valueOf(baseOrderNotifyRequest.getAccountId()));
                placeRequest.setTranType("RECHARGE");
                placeRequest.setTranAmt(new BigDecimal(baseOrderNotifyRequest.getOrderAmt()));
                placeRequest.setTradeId(baseOrderNotifyRequest.getTradeId());
                baseTranRespDtoRestResponse = this.transactionApi.doTransaction(placeRequest.getTranType(), (Map)JSON.parseObject((String)JSON.toJSONString((Object)placeRequest), Map.class));
            }
            return JSON.toJSONString(baseTranRespDtoRestResponse);
        }
        catch (Exception e) {
            return e.toString();
        }
    }

    @RequestMapping(value={"/withdrawal"})
    public String accountNotifyWithdrawalOrder(HttpServletRequest request) throws Exception {
        try {
            Map map = this.getReqData(request);
            PayOrderNotifyRequest baseOrderNotifyRequest = (PayOrderNotifyRequest)JSON.parseObject((String)JSON.toJSONString((Object)map), PayOrderNotifyRequest.class);
            logger.info("\u6536\u5230\u8d44\u91d1\u63d0\u73b0\u56de\u8c03:{}", (Object)JSON.toJSONString((Object)baseOrderNotifyRequest));
            RestResponse baseTranRespDtoRestResponse = null;
            WithDrawConfirmReqDto req = new WithDrawConfirmReqDto();
            CubeBeanUtils.copyProperties((Object)req, (Object)request, (String[])new String[0]);
            req.setAccountId(Long.valueOf(baseOrderNotifyRequest.getAccountId()));
            req.setTranType("WITHDRAW");
            req.setTranAmt(new BigDecimal(baseOrderNotifyRequest.getOrderAmt()));
            req.setTradeId(baseOrderNotifyRequest.getRemark());
            if (StringUtils.isEmpty((CharSequence)baseOrderNotifyRequest.getFailCode())) {
                req.setWithDrawStep("SUCC");
            } else {
                req.setWithDrawStep("FAIL");
            }
            baseTranRespDtoRestResponse = this.transactionApi.modifyTransaction(req.getTranType(), (Map)JSON.parseObject((String)JSON.toJSONString((Object)req), Map.class));
            return JSON.toJSONString((Object)baseTranRespDtoRestResponse);
        }
        catch (Exception e) {
            return e.toString();
        }
    }
}

