/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.b2b.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.item.api.b2b.constants.AuthItemRuleTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.b2b.constants.ItemAuthEnum;
import com.dtyunxi.yundt.cube.center.item.api.b2b.constants.ProhibiteItemOptEnum;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.CustomerAuthItemPageReqDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.response.AuthItemRuleRespDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.response.BlackAuthItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.response.CustomerAuthItemNumRespDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.response.CustomerAuthItemRespDto;
import com.dtyunxi.yundt.cube.center.item.biz.b2b.service.IAuthItemRuleService;
import com.dtyunxi.yundt.cube.center.item.biz.b2b.service.ICustomerAuthItemService;
import com.dtyunxi.yundt.cube.center.item.biz.b2b.service.IProhibiteSaleItemService;
import com.dtyunxi.yundt.cube.center.item.dao.b2b.das.CustomerAuthItemDas;
import com.dtyunxi.yundt.cube.center.item.dao.b2b.das.ItemAuthDas;
import com.dtyunxi.yundt.cube.center.item.dao.b2b.vo.AuthItemQueryVo;
import com.dtyunxi.yundt.cube.center.item.dao.b2b.vo.CustomerAuthItemVo;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemMediasDas;
import com.dtyunxi.yundt.cube.center.item.dao.eo.b2b.ItemAuthEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.b2b.ProhibiteSaleItemEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemMediasEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StdItemMediasEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CustomerAuthItemServiceImpl
implements ICustomerAuthItemService {
    private static Logger logger = LoggerFactory.getLogger(CustomerAuthItemServiceImpl.class);
    @Resource
    private CustomerAuthItemDas customerAuthItemDas;
    @Autowired
    private IAuthItemRuleService authItemRuleService;
    @Autowired
    private IProhibiteSaleItemService prohibiteSaleItemService;
    @Autowired
    private ItemAuthDas itemAuthDas;
    @Autowired
    private ItemMediasDas itemMediasDas;

    @Override
    public PageInfo<CustomerAuthItemRespDto> queryAuthItemPage(CustomerAuthItemPageReqDto customerAuthItemPageReqDto) {
        PageInfo resultPageInfo = new PageInfo();
        AuthItemRuleRespDto authItemRuleRespDto = this.authItemRuleService.queryByCustomerId(customerAuthItemPageReqDto.getCustomerId());
        if (Objects.equals(customerAuthItemPageReqDto.getSelectType(), 1)) {
            if (authItemRuleRespDto == null) {
                return resultPageInfo;
            }
            if (Objects.equals(AuthItemRuleTypeEnum.UN_AUTH.getRuleType(), authItemRuleRespDto.getAuthType())) {
                return resultPageInfo;
            }
            if (Objects.equals(AuthItemRuleTypeEnum.ITEM.getRuleType(), authItemRuleRespDto.getAuthType()) && CollectionUtil.isEmpty((Collection)authItemRuleRespDto.getCustomerAuthItemRespDtos())) {
                return resultPageInfo;
            }
        } else if (authItemRuleRespDto != null && AuthItemRuleTypeEnum.ALL_ITEM.getRuleType().equals(authItemRuleRespDto.getAuthType())) {
            return resultPageInfo;
        }
        Set<Object> prohibiteSaleSkuIds = Sets.newHashSet();
        if (Objects.equals(customerAuthItemPageReqDto.getSelectType(), 1)) {
            List<ProhibiteSaleItemEo> prohibiteSaleItemEos = this.prohibiteSaleItemService.queryByCustomerId(customerAuthItemPageReqDto.getCustomerId());
            if (ProhibiteItemOptEnum.PROHIBITE_SALE.getOptType().equals(customerAuthItemPageReqDto.getProhibiteStatus()) && CollectionUtil.isEmpty(prohibiteSaleItemEos)) {
                return resultPageInfo;
            }
            prohibiteSaleSkuIds = prohibiteSaleItemEos.stream().map(ProhibiteSaleItemEo::getSkuId).collect(Collectors.toSet());
        }
        PageInfo<CustomerAuthItemVo> pageInfo = this.getAuthItemVoPageInfo(customerAuthItemPageReqDto, authItemRuleRespDto, (Set<Long>)prohibiteSaleSkuIds);
        CubeBeanUtils.copyProperties((Object)resultPageInfo, pageInfo, (String[])new String[]{"list"});
        if (pageInfo != null && CollectionUtil.isNotEmpty((Collection)pageInfo.getList())) {
            List itemIds = pageInfo.getList().stream().map(CustomerAuthItemVo::getItemId).collect(Collectors.toList());
            List itemMediasEos = this.itemMediasDas.selectByItemIds(itemIds);
            Map<Long, ItemMediasEo> itemMediasEoMap = itemMediasEos.stream().collect(Collectors.toMap(StdItemMediasEo::getItemId, e -> e, (e1, e2) -> e1));
            ArrayList customerAuthItemRespDtos = Lists.newArrayList();
            for (CustomerAuthItemVo customerAuthItemVo : pageInfo.getList()) {
                ItemMediasEo itemMediasEo;
                CustomerAuthItemRespDto customerAuthItemRespDto = new CustomerAuthItemRespDto();
                BeanUtil.copyProperties((Object)customerAuthItemVo, (Object)customerAuthItemRespDto, (String[])new String[0]);
                if (customerAuthItemPageReqDto.getSelectType() == 1) {
                    Integer prohibiteStatus = 1;
                    if (prohibiteSaleSkuIds.contains(customerAuthItemVo.getSkuId())) {
                        prohibiteStatus = 2;
                    }
                    customerAuthItemRespDto.setProhibiteStatus(prohibiteStatus);
                }
                if ((itemMediasEo = itemMediasEoMap.get(customerAuthItemVo.getItemId())) != null) {
                    customerAuthItemRespDto.setImgPath(itemMediasEo.getPath1());
                }
                customerAuthItemRespDtos.add(customerAuthItemRespDto);
            }
            resultPageInfo.setList((List)customerAuthItemRespDtos);
        }
        return resultPageInfo;
    }

    private PageInfo<CustomerAuthItemVo> getAuthItemVoPageInfo(CustomerAuthItemPageReqDto customerAuthItemPageReqDto, AuthItemRuleRespDto authItemRuleRespDto, Set<Long> prohibiteSaleSkuIds) {
        PageInfo pageInfo = new PageInfo();
        if (customerAuthItemPageReqDto.getSelectType() == 1) {
            pageInfo = this.queryAuthItem(customerAuthItemPageReqDto, authItemRuleRespDto, prohibiteSaleSkuIds, customerAuthItemPageReqDto.getNeedLimit());
        } else {
            customerAuthItemPageReqDto.setSelectType(Integer.valueOf(1));
            if (authItemRuleRespDto != null) {
                if (AuthItemRuleTypeEnum.ALL_ITEM.getRuleType().equals(authItemRuleRespDto.getAuthType())) {
                    return pageInfo;
                }
                pageInfo = this.queryAuthItem(customerAuthItemPageReqDto, authItemRuleRespDto, prohibiteSaleSkuIds, 2);
            }
            AuthItemQueryVo authItemQueryVo = this.buildBaseQueryVo(customerAuthItemPageReqDto);
            authItemQueryVo.setNeedLimit(Integer.valueOf(1));
            if (pageInfo != null && CollectionUtil.isNotEmpty((Collection)pageInfo.getList())) {
                authItemQueryVo.setExcludeSkuIds(pageInfo.getList().stream().map(CustomerAuthItemVo::getSkuId).distinct().collect(Collectors.toList()));
            }
            pageInfo = this.customerAuthItemDas.queryAuthItemPage(authItemQueryVo);
        }
        return pageInfo;
    }

    @Override
    public CustomerAuthItemNumRespDto queryAuthItemNum(CustomerAuthItemPageReqDto customerAuthItemPageReqDto) {
        customerAuthItemPageReqDto.setPageSize(Integer.valueOf(1));
        AuthItemRuleRespDto authItemRuleRespDto = this.authItemRuleService.queryByCustomerId(customerAuthItemPageReqDto.getCustomerId());
        if (authItemRuleRespDto == null || Objects.equals(customerAuthItemPageReqDto.getSelectType(), 2) && CollectionUtil.isEmpty((Collection)authItemRuleRespDto.getCustomerAuthItemRespDtos())) {
            ItemAuthEo itemAuthEo = new ItemAuthEo();
            itemAuthEo.setTargetType(ItemAuthEnum.TargetType.SHOP.getCode());
            itemAuthEo.setBusinessType(ItemAuthEnum.BusinessType.SKU.getCode());
            itemAuthEo.setTargetId(customerAuthItemPageReqDto.getShopId());
            int unAuthItemNum = this.itemAuthDas.count((BaseEo)itemAuthEo);
            return new CustomerAuthItemNumRespDto(Long.valueOf(0L), Long.valueOf(unAuthItemNum));
        }
        Set<Object> prohibiteSaleSkuIds = Sets.newHashSet();
        if (Objects.equals(customerAuthItemPageReqDto.getSelectType(), 1)) {
            List<ProhibiteSaleItemEo> prohibiteSaleItemEos = this.prohibiteSaleItemService.queryByCustomerId(customerAuthItemPageReqDto.getCustomerId());
            if (ProhibiteItemOptEnum.PROHIBITE_SALE.getOptType().equals(customerAuthItemPageReqDto.getProhibiteStatus()) && CollectionUtil.isEmpty(prohibiteSaleItemEos)) {
                return new CustomerAuthItemNumRespDto(Long.valueOf(0L), Long.valueOf(0L));
            }
            prohibiteSaleSkuIds = prohibiteSaleItemEos.stream().map(ProhibiteSaleItemEo::getSkuId).collect(Collectors.toSet());
        }
        customerAuthItemPageReqDto.setSelectType(Integer.valueOf(1));
        PageInfo<CustomerAuthItemVo> pageInfo = this.getAuthItemVoPageInfo(customerAuthItemPageReqDto, authItemRuleRespDto, prohibiteSaleSkuIds);
        customerAuthItemPageReqDto.setSelectType(Integer.valueOf(2));
        PageInfo<CustomerAuthItemVo> unAuthPageInfo = this.getAuthItemVoPageInfo(customerAuthItemPageReqDto, authItemRuleRespDto, prohibiteSaleSkuIds);
        return new CustomerAuthItemNumRespDto(Long.valueOf(pageInfo.getTotal()), Long.valueOf(unAuthPageInfo.getTotal()));
    }

    private PageInfo<CustomerAuthItemVo> queryAuthItem(CustomerAuthItemPageReqDto customerAuthItemPageReqDto, AuthItemRuleRespDto authItemRuleRespDto, Set<Long> prohibiteSaleSkuIds, Integer needLimit) {
        AuthItemQueryVo authItemQueryVo = this.buildQueryVo(customerAuthItemPageReqDto, authItemRuleRespDto, prohibiteSaleSkuIds);
        authItemQueryVo.setNeedLimit(needLimit);
        if (AuthItemRuleTypeEnum.CATEGORY.getRuleType().equals(authItemRuleRespDto.getAuthType())) {
            if (customerAuthItemPageReqDto.getSubType() != null && CollectionUtil.isEmpty((Collection)authItemQueryVo.getSubTypes())) {
                return new PageInfo();
            }
            if (customerAuthItemPageReqDto.getBrandId() != null && CollectionUtil.isEmpty((Collection)authItemQueryVo.getBrandIds())) {
                return new PageInfo();
            }
        }
        return this.customerAuthItemDas.queryAuthItemPage(authItemQueryVo);
    }

    private AuthItemQueryVo buildQueryVo(CustomerAuthItemPageReqDto customerAuthItemPageReqDto, AuthItemRuleRespDto authItemRuleRespDto, Set<Long> prohibiteSaleSkuIds) {
        AuthItemQueryVo authItemQueryVo = this.buildBaseQueryVo(customerAuthItemPageReqDto);
        logger.info("\u5546\u54c1\u6388\u6743\u89c4\u5219\u8fd4\u56de:{}", (Object)JSONObject.toJSONString((Object)authItemRuleRespDto));
        Set<Object> blackSkuIds = Sets.newHashSet();
        Set<Object> skuIds = Sets.newHashSet();
        if (Objects.nonNull(authItemRuleRespDto)) {
            if (AuthItemRuleTypeEnum.ALL_ITEM.getRuleType().equals(authItemRuleRespDto.getAuthType())) {
                if (ProhibiteItemOptEnum.PROHIBITE_SALE.getOptType().equals(customerAuthItemPageReqDto.getProhibiteStatus())) {
                    skuIds.addAll(prohibiteSaleSkuIds);
                }
                if (ProhibiteItemOptEnum.REV_SALE.getOptType().equals(customerAuthItemPageReqDto.getProhibiteStatus())) {
                    authItemQueryVo.setExcludeSkuIds((List)com.google.common.collect.Lists.newArrayList(prohibiteSaleSkuIds));
                }
            } else if (AuthItemRuleTypeEnum.CATEGORY.getRuleType().equals(authItemRuleRespDto.getAuthType())) {
                HashSet brandIds;
                ArrayList subTypes = StringUtils.isNotEmpty((String)authItemRuleRespDto.getSubType()) ? Arrays.stream(authItemRuleRespDto.getSubType().split(",")).map(Integer::valueOf).collect(Collectors.toList()) : Lists.newArrayList();
                Set<Object> set = brandIds = StringUtils.isNotEmpty((String)authItemRuleRespDto.getBrandId()) ? Arrays.stream(authItemRuleRespDto.getBrandId().split(",")).map(Long::valueOf).collect(Collectors.toSet()) : Sets.newHashSet();
                if (CollectionUtil.isNotEmpty((Collection)authItemRuleRespDto.getBlackAuthItemRespDtos())) {
                    blackSkuIds = authItemRuleRespDto.getBlackAuthItemRespDtos().stream().map(BlackAuthItemRespDto::getSkuId).collect(Collectors.toSet());
                }
                if (Objects.equals(customerAuthItemPageReqDto.getSelectType(), 1)) {
                    if (ProhibiteItemOptEnum.REV_SALE.getOptType().equals(customerAuthItemPageReqDto.getProhibiteStatus())) {
                        blackSkuIds.addAll(prohibiteSaleSkuIds);
                        if (CollectionUtils.isNotEmpty((Collection)customerAuthItemPageReqDto.getMatchSkuIds())) {
                            skuIds = new HashSet(customerAuthItemPageReqDto.getMatchSkuIds());
                        }
                    } else if (ProhibiteItemOptEnum.PROHIBITE_SALE.getOptType().equals(customerAuthItemPageReqDto.getProhibiteStatus())) {
                        skuIds = prohibiteSaleSkuIds;
                    }
                    if (customerAuthItemPageReqDto.getSubType() != null && CollectionUtil.isNotEmpty((Collection)subTypes) && !subTypes.contains(customerAuthItemPageReqDto.getSubType())) {
                        subTypes = Lists.newArrayList();
                    }
                    if (customerAuthItemPageReqDto.getBrandId() != null && CollectionUtil.isNotEmpty((Collection)brandIds) && !brandIds.contains(customerAuthItemPageReqDto.getBrandId())) {
                        brandIds = Sets.newHashSet();
                    }
                }
                authItemQueryVo.setSubTypes((List)subTypes);
                authItemQueryVo.setBrandIds((Set)brandIds);
            } else {
                skuIds = authItemRuleRespDto.getCustomerAuthItemRespDtos().stream().map(CustomerAuthItemRespDto::getSkuId).collect(Collectors.toSet());
                if (Objects.equals(customerAuthItemPageReqDto.getSelectType(), 1)) {
                    if (ProhibiteItemOptEnum.REV_SALE.getOptType().equals(customerAuthItemPageReqDto.getProhibiteStatus())) {
                        skuIds.removeAll(prohibiteSaleSkuIds);
                        if (CollectionUtils.isNotEmpty((Collection)customerAuthItemPageReqDto.getMatchSkuIds())) {
                            skuIds.retainAll(customerAuthItemPageReqDto.getMatchSkuIds());
                        }
                    } else if (ProhibiteItemOptEnum.PROHIBITE_SALE.getOptType().equals(customerAuthItemPageReqDto.getProhibiteStatus())) {
                        skuIds.retainAll(prohibiteSaleSkuIds);
                    }
                }
                if (CollectionUtil.isEmpty((Collection)skuIds)) {
                    skuIds.add(-1L);
                }
            }
        }
        logger.info("skuIds:{}", (Object)skuIds);
        authItemQueryVo.setBlackSkuIds((Set)blackSkuIds);
        authItemQueryVo.setSkuIds((Set)skuIds);
        return authItemQueryVo;
    }

    private AuthItemQueryVo buildBaseQueryVo(CustomerAuthItemPageReqDto customerAuthItemPageReqDto) {
        AuthItemQueryVo authItemQueryVo = new AuthItemQueryVo();
        authItemQueryVo.setShopId(customerAuthItemPageReqDto.getShopId());
        authItemQueryVo.setItemName(customerAuthItemPageReqDto.getItemName());
        authItemQueryVo.setItemCode(customerAuthItemPageReqDto.getItemCode());
        authItemQueryVo.setSkuCode(customerAuthItemPageReqDto.getSkuCode());
        authItemQueryVo.setDirIds(customerAuthItemPageReqDto.getDirIds());
        authItemQueryVo.setPageNum(customerAuthItemPageReqDto.getPageNum());
        authItemQueryVo.setPageSize(customerAuthItemPageReqDto.getPageSize());
        if (customerAuthItemPageReqDto.getSubType() != null) {
            ArrayList subTypes = Lists.newArrayList();
            subTypes.add(customerAuthItemPageReqDto.getSubType());
            authItemQueryVo.setSubTypes((List)subTypes);
        }
        if (customerAuthItemPageReqDto.getBrandId() != null) {
            HashSet brandIds = Sets.newHashSet();
            brandIds.add(customerAuthItemPageReqDto.getBrandId());
            authItemQueryVo.setBrandIds((Set)brandIds);
        }
        return authItemQueryVo;
    }
}

