/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.b2b.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.bean.ObjectHelper;
import com.dtyunxi.huieryun.opensearch.api.ISearchIndexService;
import com.dtyunxi.huieryun.opensearch.vo.FilterFieldVo;
import com.dtyunxi.huieryun.opensearch.vo.IndexDocContentVo;
import com.dtyunxi.huieryun.opensearch.vo.IndexDocumentVo;
import com.dtyunxi.huieryun.opensearch.vo.SearchConditionVo;
import com.dtyunxi.huieryun.opensearch.vo.SearchResultVo;
import com.dtyunxi.util.IdGenrator;
import com.dtyunxi.yundt.cube.center.item.api.b2b.constants.AuthItemRuleTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.AuthItemRuleEsDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.MatchAuthItemRuleReqDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.response.AuthItemRuleRespDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.response.BlackAuthItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.response.CustomerAuthItemRespDto;
import com.dtyunxi.yundt.cube.center.item.biz.b2b.service.IAuthItemRuleService;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class SyncAuthRuleService {
    private static Logger logger = LoggerFactory.getLogger(SyncAuthRuleService.class);
    private static final String WILDCARD_VALUE_FORMAT = "*%s*";
    @Autowired
    private IAuthItemRuleService authItemRuleService;
    @Resource
    private ISearchIndexService searchIndexService;
    @Value(value="${cube.global.profile:}")
    private String globalProfile;
    @Autowired
    private RestHighLevelClient client;

    public void syncRule2Es(Long ruleId) {
        logger.info("[\u540c\u6b65\u6388\u6743\u89c4\u5219es]:{}", (Object)ruleId);
        AuthItemRuleRespDto authItemRuleRespDto = this.authItemRuleService.queryById(ruleId);
        if (AuthItemRuleTypeEnum.UN_AUTH.getRuleType().equals(authItemRuleRespDto.getAuthType())) {
            logger.info("[\u540c\u6b65\u6388\u6743\u89c4\u5219es],\u65e0\u6388\u6743\u89c4\u5219\u4e0d\u540c\u6b65es,id\uff1a{}", (Object)authItemRuleRespDto.getId());
            return;
        }
        List<IndexDocContentVo> indexDocContentVos = this.buildRuleDocContents(authItemRuleRespDto);
        IndexDocumentVo documentVo = new IndexDocumentVo("auth_item_rule_" + this.globalProfile, "auth_item_rule");
        documentVo.setContents(indexDocContentVos);
        this.searchIndexService.addData(documentVo);
    }

    public void refreshEs(Long ruleId) {
        logger.info("[\u5220\u9664\u5ba2\u6237\u6388\u6743\u5546\u54c1\u89c4\u5219es\u4fe1\u606f]\uff1a{}", (Object)ruleId);
        SearchConditionVo searchConditionVo = new SearchConditionVo("auth_item_rule_" + this.globalProfile, "auth_item_rule");
        ArrayList list = Lists.newArrayList();
        list.add(FilterFieldVo.equal((String)"ruleId", (String)String.valueOf(ruleId)));
        searchConditionVo.setFilterFields((List)list);
        this.searchIndexService.deleteDataByCondition(searchConditionVo);
        this.syncRule2Es(ruleId);
    }

    private List<IndexDocContentVo> buildRuleDocContents(AuthItemRuleRespDto authItemRuleRespDto) {
        AuthItemRuleEsDto authItemRuleEsDto = this.dto2EsDto(authItemRuleRespDto);
        ArrayList contents = Lists.newArrayList();
        String id = IdGenrator.getDistributedId() + "";
        IndexDocContentVo contentVo = new IndexDocContentVo();
        Map docValueMap = ObjectHelper.bean2Map((Object)authItemRuleEsDto);
        contentVo.setIndexId(id);
        contentVo.setDocValueMap(docValueMap);
        contents.add(contentVo);
        return contents;
    }

    private AuthItemRuleEsDto dto2EsDto(AuthItemRuleRespDto authItemRuleRespDto) {
        List customerAuthItemRespDtos;
        AuthItemRuleEsDto authItemRuleEsDto = new AuthItemRuleEsDto();
        BeanUtil.copyProperties((Object)authItemRuleRespDto, (Object)authItemRuleEsDto, (String[])new String[0]);
        authItemRuleEsDto.setRuleId(authItemRuleRespDto.getId());
        if (AuthItemRuleTypeEnum.CATEGORY.getRuleType().equals(authItemRuleRespDto.getAuthType())) {
            String subType = authItemRuleRespDto.getSubType();
            String brandId = authItemRuleRespDto.getBrandId();
            List blackAuthItemRespDtos = authItemRuleRespDto.getBlackAuthItemRespDtos();
            if (StringUtils.isNotBlank((String)subType)) {
                authItemRuleEsDto.setSubTypes(Arrays.asList(subType.split(",")).stream().map(Integer::valueOf).collect(Collectors.toList()));
            }
            if (StringUtils.isNotBlank((String)brandId)) {
                authItemRuleEsDto.setBrandIds(Arrays.asList(brandId.split(",")).stream().map(Long::valueOf).collect(Collectors.toList()));
            }
            if (CollectionUtil.isNotEmpty((Collection)blackAuthItemRespDtos)) {
                authItemRuleEsDto.setBlackItemIds(blackAuthItemRespDtos.stream().map(BlackAuthItemRespDto::getItemId).collect(Collectors.toList()));
            }
        } else if (AuthItemRuleTypeEnum.ITEM.getRuleType().equals(authItemRuleRespDto.getAuthType()) && CollectionUtil.isNotEmpty((Collection)(customerAuthItemRespDtos = authItemRuleRespDto.getCustomerAuthItemRespDtos()))) {
            authItemRuleEsDto.setCustomerItemIds(customerAuthItemRespDtos.stream().map(CustomerAuthItemRespDto::getItemId).collect(Collectors.toList()));
        }
        return authItemRuleEsDto;
    }

    public SearchResultVo doQuery(BoolQueryBuilder boolQueryBuilder, int pageNum, int pageSize) {
        SearchResponse response;
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder().timeout(new TimeValue(3L, TimeUnit.SECONDS)).from(this.getStartIndex(pageNum, pageSize)).size(pageSize).explain(Boolean.valueOf(false)).fetchSource(true).query((QueryBuilder)boolQueryBuilder);
        logger.info("[es\u67e5\u8be2\u547d\u4ee4]{}", (Object)sourceBuilder);
        SearchRequest request = new SearchRequest(new String[]{"auth_item_rule_" + this.globalProfile}).source(sourceBuilder);
        logger.info("[searchRequest]>>>{}", (Object)request);
        try {
            response = this.client.search(request, RequestOptions.DEFAULT);
        }
        catch (IOException var7) {
            throw new RuntimeException("\u67e5\u8be2\u5f02\u5e38", var7);
        }
        logger.info("[\u547d\u4e2d\u6388\u6743\u89c4\u5219\u4fe1\u606f]{}", (Object)JSON.toJSONString((Object)response));
        return this.wrapSearchResultVo(response, pageNum, pageSize);
    }

    public BoolQueryBuilder buildConflictQuery(MatchAuthItemRuleReqDto matchAuthItemRuleReqDto) {
        String customerCode = matchAuthItemRuleReqDto.getCustomerCode();
        String customerName = matchAuthItemRuleReqDto.getCustomerName();
        Long itemId = matchAuthItemRuleReqDto.getItemId();
        Integer subType = matchAuthItemRuleReqDto.getSubType();
        Long brandId = matchAuthItemRuleReqDto.getBrandId();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)"organizationId", (String)matchAuthItemRuleReqDto.getOrganizationId().toString()));
        if (StringUtils.isNotBlank((String)customerCode)) {
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.wildcardQuery((String)"customerCode", (String)this.buildWildcardValue(customerCode)));
        }
        if (StringUtils.isNotBlank((String)customerName)) {
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.wildcardQuery((String)"customerName", (String)this.buildWildcardValue(customerName)));
        }
        BoolQueryBuilder shouldQuery = QueryBuilders.boolQuery();
        shouldQuery.should((QueryBuilder)QueryBuilders.termQuery((String)"authType", (String)"0"));
        shouldQuery.should((QueryBuilder)QueryBuilders.termQuery((String)"customerItemIds", (String)itemId.toString()));
        BoolQueryBuilder categoryQuery = QueryBuilders.boolQuery();
        categoryQuery.filter((QueryBuilder)QueryBuilders.termQuery((String)"authType", (String)AuthItemRuleTypeEnum.CATEGORY.getRuleType().toString()));
        if (subType != null) {
            BoolQueryBuilder subTypeQueryBool = QueryBuilders.boolQuery();
            BoolQueryBuilder existsSubTypeQueryBool = QueryBuilders.boolQuery();
            existsSubTypeQueryBool.mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"subTypes"));
            subTypeQueryBool.should((QueryBuilder)existsSubTypeQueryBool);
            subTypeQueryBool.should((QueryBuilder)QueryBuilders.termQuery((String)"subTypes", (String)subType.toString()));
            categoryQuery.filter((QueryBuilder)subTypeQueryBool);
        }
        if (brandId != null) {
            BoolQueryBuilder brandQueryBool = QueryBuilders.boolQuery();
            BoolQueryBuilder existsBrandQueryBool = QueryBuilders.boolQuery();
            existsBrandQueryBool.mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"brandIds"));
            brandQueryBool.should((QueryBuilder)existsBrandQueryBool);
            brandQueryBool.should((QueryBuilder)QueryBuilders.termQuery((String)"brandIds", (String)brandId.toString()));
            categoryQuery.filter((QueryBuilder)brandQueryBool);
        }
        BoolQueryBuilder itemIdQueryBool = QueryBuilders.boolQuery();
        itemIdQueryBool.mustNot((QueryBuilder)QueryBuilders.termQuery((String)"blackItemIds", (String)itemId.toString()));
        categoryQuery.filter((QueryBuilder)itemIdQueryBool);
        shouldQuery.should((QueryBuilder)categoryQuery);
        boolQueryBuilder.filter((QueryBuilder)shouldQuery);
        return boolQueryBuilder;
    }

    private SearchResultVo wrapSearchResultVo(SearchResponse response, Integer pageNum, Integer pageSize) {
        SearchHits hits = response.getHits();
        SearchResultVo result = new SearchResultVo();
        result.setTotalSize(hits.getTotalHits());
        result.setPageSize(pageSize.intValue());
        result.setStartIndex(this.getStartIndex(pageNum, pageSize));
        result.setDocValues(this.wrapDocValue(hits));
        return result;
    }

    private List<Map<String, Object>> wrapDocValue(SearchHits hits) {
        SearchHit[] searchHits = hits.getHits();
        ArrayList<Map<String, Object>> docValue = new ArrayList<Map<String, Object>>(searchHits.length);
        SearchHit[] var4 = searchHits;
        int var5 = searchHits.length;
        for (int var6 = 0; var6 < var5; ++var6) {
            SearchHit searchHit = var4[var6];
            Map highlightFields = searchHit.getHighlightFields();
            Map item = searchHit.getSourceAsMap();
            if (!highlightFields.isEmpty()) {
                StringBuilder highlightFieldStringBuilder = new StringBuilder();
                for (String key : highlightFields.keySet()) {
                    for (Text text : ((HighlightField)highlightFields.get(key)).fragments()) {
                        highlightFieldStringBuilder.append(text.string());
                    }
                    item.put(key, highlightFieldStringBuilder.toString());
                }
            }
            item.put("_score", Float.valueOf(searchHit.getScore()));
            docValue.add(item);
        }
        return docValue;
    }

    private String buildWildcardValue(String customerCode) {
        return String.format(WILDCARD_VALUE_FORMAT, customerCode);
    }

    private int getStartIndex(int page, int pageSize) {
        return page > 0 ? (page - 1) * pageSize : 0;
    }
}

