/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.b2b.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.core.util.JSON;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerSearchReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.BaseRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.b2b.constants.ItemAuthEnum;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.AuthItemRuleReqDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.CustomerAuthItemPageReqDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.ItemAuthConfigReqDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.ItemAuthPageReqDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.ItemAuthQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.ItemAuthReqDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.ItemAuthStateReqDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.ItemOnShelfListTobReqDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.OnItemTobReqDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.response.AuthItemRuleRespDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.response.CustomerAuthItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.response.ItemAuthAddBatchRespDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.response.ItemAuthConfigRespDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.response.ItemAuthQueryRespDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.response.ItemAuthRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemBusTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemStatus;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.DirectoryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.OffItemReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ShelfModifyShopAuthReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ShelfReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.exception.ItemBusinessRuntimeException;
import com.dtyunxi.yundt.cube.center.item.api.base.exception.ItemExceptionCode;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IDirectoryQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.cube.center.item.biz.b2b.service.IAuthItemRuleService;
import com.dtyunxi.yundt.cube.center.item.biz.b2b.service.ICustomerAuthItemService;
import com.dtyunxi.yundt.cube.center.item.biz.b2b.service.ItemAuthConfigService;
import com.dtyunxi.yundt.cube.center.item.biz.b2b.service.ItemAuthService;
import com.dtyunxi.yundt.cube.center.item.biz.base.mq.ItemShelfProducer;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemSearchService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemShelfService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemSkuService;
import com.dtyunxi.yundt.cube.center.item.dao.b2b.das.ItemAuthDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.DirDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.DirItemRelationDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemMediasDas;
import com.dtyunxi.yundt.cube.center.item.dao.eo.b2b.ItemAuthEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.DirEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.DirItemRelationEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StdDirEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StdItemMediasEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StdItemSkuEo;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.SellerQueryReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopQueryDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopToBQueryReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopToBListRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISellerQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopExtQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ItemAuthServiceImpl
implements ItemAuthService {
    private static Logger logger = LoggerFactory.getLogger(ItemAuthServiceImpl.class);
    @Resource
    private ItemAuthDas itemAuthDas;
    @Resource
    private IContext context;
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private IShopQueryApi shopQueryApi;
    @Resource
    private ISellerQueryApi sellerQueryApi;
    @Resource
    private IItemQueryApi itemQueryApi;
    @Resource
    private IOrganizationQueryApi organizationQueryApi;
    @Resource
    private IShopExtQueryApi shopExtQueryApi;
    @Resource(name="directoryItemQueryApi")
    private IDirectoryQueryApi directoryQueryApi;
    @Resource
    private IItemService itemService;
    @Resource
    private DirItemRelationDas dirItemRelationDas;
    @Resource
    private ItemShelfProducer itemShelfProducer;
    @Resource
    private IItemSearchService itemSearchService;
    @Resource
    private IItemShelfService iItemShelfService;
    @Resource
    private IItemShelfService itemShelfService;
    @Resource
    private IItemSkuService itemSkuService;
    @Resource
    private DirDas dirDas;
    @Resource
    private ItemMediasDas itemMediasDas;
    @Resource
    private ICacheService cacheService;
    @Resource
    private ICustomerAuthItemService customerAuthItemService;
    @Resource
    private ItemAuthConfigService itemAuthConfigService;
    @Resource
    private IAuthItemRuleService authItemRuleService;
    private static String authPre = "AUTH_CACHE_PRE:";

    private <T> PageInfo<T> page(ItemAuthQueryReqDto itemAuthQueryReqDto) {
        PageInfo pageInfo = new PageInfo();
        pageInfo.setPageNum(itemAuthQueryReqDto.getPageNum().intValue());
        pageInfo.setPageSize(itemAuthQueryReqDto.getPageSize().intValue());
        pageInfo.setPages(0);
        pageInfo.setTotal(0L);
        return pageInfo;
    }

    public Long getCurrentUserOrgId() {
        return (Long)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryCurrentUserOrgId());
    }

    @Override
    public PageInfo<ItemAuthQueryRespDto> queryItemAuthPage(ItemAuthQueryReqDto itemAuthQueryReqDto) {
        List shopDtos;
        List targetIds;
        logger.info("ItemAuthServiceImpl.queryItemAuthPage==>{}", (Object)JSON.toJsonString((Object)itemAuthQueryReqDto));
        if (Objects.isNull(itemAuthQueryReqDto.getTenantId())) {
            itemAuthQueryReqDto.setTenantId(this.context.tenantId());
        }
        if (Objects.isNull(itemAuthQueryReqDto.getInstanceId())) {
            itemAuthQueryReqDto.setInstanceId(this.context.instanceId());
        }
        List customerRespDtos = Lists.newArrayList();
        Map<Object, Object> customerMap = Maps.newHashMap();
        Map<Object, Object> customerOrgMap = Maps.newHashMap();
        List<Object> orgIdList = Lists.newArrayList();
        List organizationIdList = itemAuthQueryReqDto.getOrganizationIdList();
        Integer targetType = itemAuthQueryReqDto.getTargetType();
        Long userId = this.context.userId();
        Integer channel = itemAuthQueryReqDto.getChannel();
        List<Object> itemAuthConfigRespDtos = Lists.newArrayList();
        if (Objects.equals(targetType, ItemAuthEnum.TargetType.SHOP.getCode())) {
            List<Long> list = targetIds = CollUtil.isNotEmpty((Collection)itemAuthQueryReqDto.getTargetIdList()) ? itemAuthQueryReqDto.getTargetIdList() : this.getShopId(itemAuthQueryReqDto.getShopId(), organizationIdList, userId, channel);
            if (this.limitShop(itemAuthQueryReqDto, targetIds)) {
                return this.page(itemAuthQueryReqDto);
            }
        } else {
            targetIds = itemAuthQueryReqDto.getTargetIdList();
            if (CollUtil.isEmpty((Collection)itemAuthQueryReqDto.getTargetIdList())) {
                if (CollUtil.isNotEmpty((Collection)organizationIdList)) {
                    List customerRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.querySubCustomerListPostByOrgIds(organizationIdList));
                    targetIds = customerRespDtoList.stream().map(BaseRespDto::getId).collect(Collectors.toList());
                } else {
                    Long currentUserOrgId = this.getCurrentUserOrgId();
                    List<Object> orgIds = ListUtil.toList((Object[])new Long[]{currentUserOrgId});
                    List customerRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.querySubCustomerListPostByOrgIds((List)orgIds));
                    targetIds = customerRespDtoList.stream().map(BaseRespDto::getId).collect(Collectors.toList());
                    if (Objects.equals(channel, ItemAuthEnum.Channel.BRAND.getCode()) && Objects.equals(itemAuthQueryReqDto.getCustomerChannelSource(), 3)) {
                        orgIds = customerRespDtoList.stream().map(CustomerRespDto::getOrgInfoId).collect(Collectors.toList());
                        customerRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.querySubCustomerListPostByOrgIds((List)orgIds));
                        targetIds = customerRespDtoList.stream().map(BaseRespDto::getId).collect(Collectors.toList());
                    }
                }
            }
            if (this.limitCustomer(itemAuthQueryReqDto, targetIds)) {
                return this.page(itemAuthQueryReqDto);
            }
            if (this.limitSeller(itemAuthQueryReqDto)) {
                return this.page(itemAuthQueryReqDto);
            }
            customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryListOnPostByCustomerIds(targetIds));
            customerMap = customerRespDtos.stream().collect(Collectors.toMap(BaseRespDto::getId, Function.identity(), (o1, o2) -> o2));
            orgIdList = customerRespDtos.stream().map(CustomerRespDto::getMerchantId).distinct().collect(Collectors.toList());
            customerOrgMap = customerRespDtos.stream().collect(Collectors.toMap(CustomerRespDto::getMerchantId, e -> e, (e1, e2) -> e1));
            Set thirdParentPartyIdList = customerRespDtos.stream().map(CustomerRespDto::getThirdParentPartyId).collect(Collectors.toSet());
            ItemAuthConfigReqDto itemAuthConfigReqDto = new ItemAuthConfigReqDto();
            itemAuthConfigReqDto.setThirdPartyIdList(new ArrayList(thirdParentPartyIdList));
            itemAuthConfigRespDtos = this.itemAuthConfigService.queryParam(itemAuthConfigReqDto);
        }
        Long dirId = itemAuthQueryReqDto.getDirId();
        if (Objects.nonNull(dirId)) {
            DirectoryReqDto directoryReqDto = new DirectoryReqDto();
            directoryReqDto.setStatus(Integer.valueOf(1));
            directoryReqDto.setIds((List)ListUtil.toList((Object[])new Long[]{dirId}));
            List dirIdList = (List)RestResponseHelper.extractData((RestResponse)this.directoryQueryApi.queryLinkAndChildDirIdListByDirId(directoryReqDto));
            itemAuthQueryReqDto.setDirIdList(dirIdList);
        }
        List<ItemAuthQueryRespDto> list = Lists.newArrayList();
        if (Objects.equals(targetType, ItemAuthEnum.TargetType.CUSTOMER.getCode())) {
            List itemAuthQueryRespDtos;
            ItemAuthQueryReqDto customerItemAuthReqDto;
            ShopQueryDto shopQueryDto = new ShopQueryDto();
            shopQueryDto.setOrganizationIdList((List)orgIdList);
            shopDtos = (List)RestResponseHelper.extractData((RestResponse)this.shopQueryApi.queryShopListNew(shopQueryDto));
            Map<Long, Long> shopOrgIdMap = shopDtos.stream().collect(Collectors.toMap(ShopDto::getId, ShopDto::getOrganizationId, (e1, e2) -> e1));
            Map<Long, Long> orgIdShopIdMap = shopDtos.stream().collect(Collectors.toMap(ShopDto::getOrganizationId, ShopDto::getId, (e1, e2) -> e1));
            AuthItemRuleReqDto authItemRuleReqDto = new AuthItemRuleReqDto();
            authItemRuleReqDto.setCustomerIdList(itemAuthQueryReqDto.getTargetIdList());
            List<AuthItemRuleRespDto> authItemRuleRespDtos = this.authItemRuleService.queryParam(authItemRuleReqDto);
            List<Object> authRuleCustomerIdList = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty(authItemRuleRespDtos)) {
                authRuleCustomerIdList = authItemRuleRespDtos.stream().map(AuthItemRuleRespDto::getCustomerId).collect(Collectors.toList());
            }
            HashSet authSkuIds = Sets.newHashSet();
            boolean itemAuthConfigFlag = true;
            if (CollectionUtils.isNotEmpty((Collection)itemAuthConfigRespDtos)) {
                itemAuthConfigFlag = false;
                for (Long customerId : itemAuthQueryReqDto.getTargetIdList()) {
                    CustomerRespDto customerRespDto = (CustomerRespDto)customerMap.get(customerId);
                    if (customerRespDto == null) {
                        logger.info("[\u6388\u6743\u5546\u54c1]\uff1a\u5ba2\u6237\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c{}", (Object)customerId);
                        continue;
                    }
                    Long shopId = orgIdShopIdMap.get(customerRespDto.getMerchantId());
                    if (shopId == null) {
                        logger.info("[\u6388\u6743\u5546\u54c1]\uff1a\u65e0\u6cd5\u5339\u914d\u5230\u5e97\u94fa\u4fe1\u606f\uff0c{}", (Object)customerId);
                        continue;
                    }
                    if (CollectionUtils.isEmpty((Collection)authRuleCustomerIdList) || !authRuleCustomerIdList.contains(customerId)) {
                        itemAuthConfigFlag = true;
                        logger.info("\u5ba2\u6237\u672a\u914d\u7f6e\u5546\u54c1\u6388\u6743\u89c4\u5219");
                        continue;
                    }
                    CustomerAuthItemPageReqDto customerAuthItemPageReqDto = new CustomerAuthItemPageReqDto();
                    customerAuthItemPageReqDto.setCustomerId(customerId);
                    customerAuthItemPageReqDto.setNeedLimit(Integer.valueOf(2));
                    customerAuthItemPageReqDto.setProhibiteStatus(Integer.valueOf(1));
                    customerAuthItemPageReqDto.setShopId(shopId);
                    PageInfo<CustomerAuthItemRespDto> pageInfo = this.customerAuthItemService.queryAuthItemPage(customerAuthItemPageReqDto);
                    if (pageInfo != null && CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
                        authSkuIds.addAll(pageInfo.getList().stream().map(CustomerAuthItemRespDto::getSkuId).collect(Collectors.toSet()));
                        continue;
                    }
                    logger.info("\u5ba2\u6237\u5546\u54c1\u672a\u5728\u7ecf\u9500\u5546\u6709\u6388\u6743\u5546\u54c1\u6216\u672a\u542f\u7528");
                }
            }
            logger.info("[\u6388\u6743\u5546\u54c1]\uff1aitemAuthConfigFlag={}", (Object)itemAuthConfigFlag);
            if (itemAuthConfigFlag) {
                customerItemAuthReqDto = new ItemAuthQueryReqDto();
                BeanUtil.copyProperties((Object)itemAuthQueryReqDto, (Object)customerItemAuthReqDto, (String[])new String[0]);
                customerItemAuthReqDto.setTargetIdList(itemAuthQueryReqDto.getTargetIdList());
                customerItemAuthReqDto.setTargetType(ItemAuthEnum.TargetType.CUSTOMER.getCode());
                itemAuthQueryRespDtos = this.itemAuthDas.queryItemAuthList(customerItemAuthReqDto);
                if (CollectionUtils.isNotEmpty((Collection)itemAuthQueryRespDtos)) {
                    authSkuIds.addAll(itemAuthQueryRespDtos.stream().map(ItemAuthQueryRespDto::getBusinessId).collect(Collectors.toSet()));
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)authSkuIds)) {
                customerItemAuthReqDto = new ItemAuthQueryReqDto();
                BeanUtil.copyProperties((Object)itemAuthQueryReqDto, (Object)customerItemAuthReqDto, (String[])new String[0]);
                customerItemAuthReqDto.setBusinessIds(new ArrayList(authSkuIds));
                customerItemAuthReqDto.setTargetType(ItemAuthEnum.TargetType.SHOP.getCode());
                customerItemAuthReqDto.setTargetIdList(shopDtos.stream().map(ShopDto::getId).collect(Collectors.toList()));
                PageHelper.startPage((int)customerItemAuthReqDto.getPageNum(), (int)customerItemAuthReqDto.getPageSize());
                itemAuthQueryRespDtos = this.itemAuthDas.queryItemAuthList(customerItemAuthReqDto);
                if (CollectionUtils.isNotEmpty((Collection)itemAuthQueryRespDtos)) {
                    for (ItemAuthQueryRespDto itemAuthQueryRespDto : itemAuthQueryRespDtos) {
                        Long shopOrgId = shopOrgIdMap.get(itemAuthQueryRespDto.getTargetId());
                        CustomerRespDto customerRespDto = (CustomerRespDto)customerOrgMap.get(shopOrgId);
                        if (customerRespDto == null) continue;
                        itemAuthQueryRespDto.setTargetType(ItemAuthEnum.TargetType.CUSTOMER.getCode());
                        itemAuthQueryRespDto.setTargetId(customerRespDto.getId());
                        list.add(itemAuthQueryRespDto);
                    }
                }
            }
        } else {
            PageHelper.startPage((int)itemAuthQueryReqDto.getPageNum(), (int)itemAuthQueryReqDto.getPageSize());
            list = this.itemAuthDas.queryItemAuthList(itemAuthQueryReqDto);
        }
        if (CollUtil.isEmpty((Collection)list)) {
            return new PageInfo(list);
        }
        List targetIdList = list.stream().map(ItemAuthQueryRespDto::getTargetId).collect(Collectors.toList());
        if (Objects.equals(targetType, ItemAuthEnum.TargetType.SHOP.getCode())) {
            shopDtos = (List)RestResponseHelper.extractData((RestResponse)this.shopQueryApi.queryByIdsOnPost(new HashSet(targetIdList)));
            Map shopMap = shopDtos.stream().collect(Collectors.toMap(ShopDto::getId, Function.identity(), (o1, o2) -> o2));
            list.forEach(item -> {
                Long targetId = item.getTargetId();
                if (shopMap.containsKey(targetId)) {
                    ShopDto shopDto = (ShopDto)shopMap.get(targetId);
                    item.setTargetCode(shopDto.getCode());
                    item.setTargetName(shopDto.getName());
                }
            });
        } else {
            SellerQueryReqDto sellerQueryReqDto = new SellerQueryReqDto();
            sellerQueryReqDto.setOrganizationIds((List)orgIdList);
            sellerQueryReqDto.setTenantId(itemAuthQueryReqDto.getTenantId());
            sellerQueryReqDto.setInstanceId(itemAuthQueryReqDto.getInstanceId());
            List sellerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.sellerQueryApi.queryList(sellerQueryReqDto));
            Map sellerMap = sellerRespDtos.stream().collect(Collectors.toMap(SellerRespDto::getOrganizationId, Function.identity(), (o1, o2) -> o2));
            Map<Object, Object> finalCustomerMap = customerMap;
            list.forEach(item -> {
                Long targetId = item.getTargetId();
                if (finalCustomerMap.containsKey(targetId)) {
                    CustomerRespDto customerDto = (CustomerRespDto)finalCustomerMap.get(targetId);
                    item.setTargetCode(customerDto.getCode());
                    item.setTargetName(customerDto.getName());
                    Long merchantId = customerDto.getMerchantId();
                    if (Objects.nonNull(merchantId) && sellerMap.containsKey(merchantId)) {
                        SellerRespDto sellerRespDto = (SellerRespDto)sellerMap.get(merchantId);
                        item.setSellerId(sellerRespDto.getId());
                        item.setSellerName(sellerRespDto.getName());
                        item.setSellerCode(sellerRespDto.getCode());
                    }
                }
            });
        }
        try {
            Map<Long, String> mediaMapFutureMap = this.itemMediasDas.getMapper().selectList((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{StdItemMediasEo::getItemId, StdItemMediasEo::getPath1}).in(StdItemMediasEo::getItemId, (Collection)list.stream().map(ItemAuthQueryRespDto::getItemId).distinct().collect(Collectors.toList()))).stream().filter(media -> StringUtils.isNotEmpty((CharSequence)media.getPath1())).collect(Collectors.toMap(StdItemMediasEo::getItemId, StdItemMediasEo::getPath1, (o1, o2) -> o1));
            list.forEach(item -> item.setMainPic((String)mediaMapFutureMap.get(item.getItemId())));
        }
        catch (Exception e3) {
            logger.error(e3.getMessage(), (Throwable)e3);
        }
        try {
            this.setDirPath(list);
        }
        catch (Exception e4) {
            logger.error(e4.getMessage(), (Throwable)e4);
        }
        return new PageInfo(list);
    }

    private void setDirPath(List<ItemAuthQueryRespDto> list) {
        if (CollUtil.isEmpty(list)) {
            return;
        }
        List dirIdList = list.stream().filter(item -> Objects.nonNull(item.getDirId())).map(ItemAuthQueryRespDto::getDirId).distinct().collect(Collectors.toList());
        if (CollUtil.isEmpty(dirIdList)) {
            return;
        }
        List dirEos = this.dirDas.selectByIds(dirIdList);
        if (CollUtil.isEmpty((Collection)dirEos)) {
            return;
        }
        List rootIdList = dirEos.stream().filter(item -> Objects.nonNull(item.getRootId())).map(StdDirEo::getRootId).distinct().collect(Collectors.toList());
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(DirEo.class).in(StdDirEo::getRootId, rootIdList)).eq(BaseEo::getDr, (Object)0)).ne(StdDirEo::getParentId, (Object)0);
        List dirEoList = this.dirDas.getMapper().selectList((Wrapper)queryWrapper);
        Map dirEoMap = dirEoList.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity()));
        list.forEach(item -> {
            Long dirId = item.getDirId();
            ArrayList<String> dirNameList = new ArrayList<String>();
            while (dirEoMap.containsKey(dirId)) {
                DirEo dirEo = (DirEo)dirEoMap.get(dirId);
                dirNameList.add(dirEo.getName());
                dirId = dirEo.getParentId();
            }
            if (CollUtil.isNotEmpty(dirNameList)) {
                Collections.reverse(dirNameList);
                item.setDirName(dirNameList.stream().collect(Collectors.joining(">")));
            }
        });
    }

    private List<Long> getShopId(Long shopId, List<Long> organizationIdList, Long userId, Integer channel) {
        if (Objects.nonNull(shopId)) {
            return ListUtil.toList((Object[])new Long[]{shopId});
        }
        ArrayList orgIds = organizationIdList;
        if (CollUtil.isEmpty(organizationIdList)) {
            Long currentUserOrgId = this.getCurrentUserOrgId();
            orgIds = ListUtil.toList((Object[])new Long[]{currentUserOrgId});
            if (Objects.equals(channel, ItemAuthEnum.Channel.BRAND.getCode())) {
                List ids = ((List)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.querySubCustomerListPostByOrgIds((List)orgIds))).stream().map(CustomerRespDto::getOrgInfoId).collect(Collectors.toList());
                orgIds.addAll(ids);
            }
            if (CollUtil.isEmpty((Collection)orgIds)) {
                return ListUtil.empty();
            }
        }
        ShopToBQueryReqDto shopToBQueryReqDto = new ShopToBQueryReqDto();
        shopToBQueryReqDto.setOrganizationIdList(orgIds);
        shopToBQueryReqDto.setPageNum(1);
        shopToBQueryReqDto.setPageSize(10000);
        RestResponse shopRestResponse = this.shopExtQueryApi.queryOnPostPage(shopToBQueryReqDto);
        return ((PageInfo)RestResponseHelper.extractData((RestResponse)shopRestResponse)).getList().stream().map(ShopToBListRespDto::getId).collect(Collectors.toList());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void state(ItemAuthStateReqDto itemAuthReqDto) {
        Integer status = itemAuthReqDto.getStatus();
        List ids = itemAuthReqDto.getIds();
        if (Objects.isNull(status) || CollUtil.isEmpty((Collection)ids)) {
            return;
        }
        status = Objects.equals(status, ItemAuthEnum.Status.ENABLE.getCode()) ? ItemAuthEnum.Status.ENABLE.getCode() : ItemAuthEnum.Status.DISABLE.getCode();
        List itemAuthEos = this.itemAuthDas.selectByIds(ids);
        for (ItemAuthEo itemAuthEo : itemAuthEos) {
            if (Objects.equals(itemAuthEo.getDr(), 1)) continue;
            itemAuthEo.setStatus(status);
            this.itemAuthDas.update((BaseEo)itemAuthEo);
        }
        itemAuthReqDto.getIds().forEach(id -> this.cacheService.delCache("COMMON", authPre + id));
    }

    private boolean limitCustomer(ItemAuthQueryReqDto itemAuthQueryReqDto, List<Long> customerIdList) {
        if (CollUtil.isEmpty(customerIdList)) {
            return Boolean.TRUE;
        }
        Long customerId = itemAuthQueryReqDto.getCustomerId();
        if (Objects.nonNull(customerId) && !customerIdList.contains(customerId)) {
            return Boolean.TRUE;
        }
        String customerCode = itemAuthQueryReqDto.getCustomerCode();
        if (StrUtil.isNotBlank((CharSequence)customerCode)) {
            CustomerSearchReqDto searchReqDto = new CustomerSearchReqDto();
            searchReqDto.setCode(customerCode);
            searchReqDto.setTenantId(itemAuthQueryReqDto.getTenantId());
            searchReqDto.setInstanceId(itemAuthQueryReqDto.getInstanceId());
            List customerRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryByList(JSON.toJsonString((Object)searchReqDto)));
            if (CollUtil.isEmpty((Collection)customerRespDtoList)) {
                return Boolean.TRUE;
            }
            List customerIds = customerRespDtoList.stream().map(BaseRespDto::getId).collect(Collectors.toList());
            if (Objects.nonNull(customerId)) {
                if (!customerIds.contains(customerId)) {
                    return Boolean.TRUE;
                }
            } else {
                customerIdList.retainAll(customerIds);
                if (CollUtil.isEmpty(customerIdList)) {
                    return Boolean.TRUE;
                }
                itemAuthQueryReqDto.setTargetIdList(customerIdList);
                return Boolean.FALSE;
            }
        }
        if (Objects.isNull(customerId)) {
            itemAuthQueryReqDto.setTargetIdList(customerIdList);
            return Boolean.FALSE;
        }
        itemAuthQueryReqDto.setTargetIdList((List)ListUtil.toList((Object[])new Long[]{customerId}));
        return Boolean.FALSE;
    }

    private boolean limitSeller(ItemAuthQueryReqDto itemAuthQueryReqDto) {
        String sellerCode;
        Long sellerId = itemAuthQueryReqDto.getSellerId();
        ArrayList<Long> orgIdList = new ArrayList<Long>();
        if (Objects.nonNull(sellerId)) {
            SellerRespDto sellerRespDto = (SellerRespDto)RestResponseHelper.extractData((RestResponse)this.sellerQueryApi.queryById(sellerId));
            if (Objects.isNull(sellerRespDto) || Objects.isNull(sellerRespDto.getOrganizationId())) {
                return Boolean.TRUE;
            }
            orgIdList.add(sellerRespDto.getOrganizationId());
        }
        if (StrUtil.isNotBlank((CharSequence)(sellerCode = itemAuthQueryReqDto.getSellerCode()))) {
            SellerQueryReqDto sellerQueryReqDto = new SellerQueryReqDto();
            sellerQueryReqDto.setCode(sellerCode);
            sellerQueryReqDto.setTenantId(itemAuthQueryReqDto.getTenantId());
            sellerQueryReqDto.setInstanceId(itemAuthQueryReqDto.getInstanceId());
            List sellerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.sellerQueryApi.queryList(sellerQueryReqDto));
            if (CollUtil.isEmpty((Collection)sellerRespDtos)) {
                return Boolean.TRUE;
            }
            if (Objects.nonNull(sellerId)) {
                if (!sellerRespDtos.stream().map(SellerRespDto::getId).collect(Collectors.toList()).contains(sellerId)) {
                    return Boolean.TRUE;
                }
            } else {
                orgIdList.addAll(sellerRespDtos.stream().map(SellerRespDto::getOrganizationId).collect(Collectors.toList()));
            }
        }
        if (CollUtil.isEmpty(orgIdList)) {
            return Boolean.FALSE;
        }
        List customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.querySubCustomerListPostByOrgIds(orgIdList));
        if (CollUtil.isEmpty((Collection)customerRespDtos)) {
            return Boolean.TRUE;
        }
        List ids = customerRespDtos.stream().map(BaseRespDto::getId).collect(Collectors.toList());
        itemAuthQueryReqDto.getTargetIdList().retainAll(ids);
        if (CollUtil.isEmpty((Collection)itemAuthQueryReqDto.getTargetIdList())) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private boolean limitShop(ItemAuthQueryReqDto itemAuthQueryReqDto, List<Long> shopIdList) {
        Long shopId = itemAuthQueryReqDto.getShopId();
        String shopCode = itemAuthQueryReqDto.getShopCode();
        if (Objects.nonNull(shopId) && !shopIdList.contains(shopId)) {
            return Boolean.TRUE;
        }
        if (StrUtil.isNotBlank((CharSequence)shopCode)) {
            ShopQueryDto queryCondition = new ShopQueryDto();
            queryCondition.setCode(shopCode);
            queryCondition.setTenantId(itemAuthQueryReqDto.getTenantId());
            queryCondition.setInstanceId(itemAuthQueryReqDto.getInstanceId());
            List shopDtos = (List)RestResponseHelper.extractData((RestResponse)this.shopQueryApi.queryShopList(queryCondition));
            if (CollUtil.isEmpty((Collection)shopDtos)) {
                return Boolean.TRUE;
            }
            List shopIds = shopDtos.stream().map(ShopDto::getId).collect(Collectors.toList());
            if (Objects.nonNull(shopId)) {
                if (!shopIds.contains(shopId)) {
                    return Boolean.TRUE;
                }
            } else {
                shopIdList.retainAll(shopIds);
                if (CollUtil.isEmpty(shopIdList)) {
                    return Boolean.TRUE;
                }
                itemAuthQueryReqDto.setTargetIdList(shopIdList);
                return Boolean.FALSE;
            }
        }
        if (Objects.isNull(shopId)) {
            itemAuthQueryReqDto.setTargetIdList(shopIdList);
            return Boolean.FALSE;
        }
        itemAuthQueryReqDto.setTargetIdList((List)ListUtil.toList((Object[])new Long[]{shopId}));
        return Boolean.FALSE;
    }

    @Override
    public Long addItemAuth(ItemAuthReqDto addReqDto) {
        ItemAuthEo itemAuthEo = new ItemAuthEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)itemAuthEo);
        this.itemAuthDas.insert((BaseEo)itemAuthEo);
        return itemAuthEo.getId();
    }

    @Override
    public void modifyItemAuth(ItemAuthReqDto modifyReqDto) {
        ItemAuthEo itemAuthEo = new ItemAuthEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)itemAuthEo);
        this.itemAuthDas.updateSelective((BaseEo)itemAuthEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeItemAuth(String ids, Long instanceId) {
        String[] removeIds = ids.split(",");
        List authIds = Stream.of(removeIds).map(Long::valueOf).collect(Collectors.toList());
        List itemAuthEos = this.itemAuthDas.selectByIds(authIds);
        for (String id2 : removeIds) {
            this.itemAuthDas.logicDeleteById(Long.valueOf(id2));
        }
        if (CollectionUtils.isNotEmpty((Collection)itemAuthEos) && Objects.equals(((ItemAuthEo)itemAuthEos.get(0)).getTargetType(), ItemAuthEnum.TargetType.SHOP.getCode()) && Objects.equals(((ItemAuthEo)itemAuthEos.get(0)).getBusinessType(), ItemAuthEnum.BusinessType.SKU.getCode())) {
            List skuIds = itemAuthEos.stream().map(ItemAuthEo::getBusinessId).collect(Collectors.toList());
            List itemSkuEos = this.itemSkuService.queryItemSkuByIds(skuIds);
            Map<Long, Long> itemIdMap = itemSkuEos.stream().collect(Collectors.toMap(BaseEo::getId, StdItemSkuEo::getItemId, (e1, e2) -> e1));
            ArrayList<OffItemReqDto> offItemReqDtos = new ArrayList<OffItemReqDto>(itemAuthEos.size());
            ArrayList<Long> offSkuIds = new ArrayList<Long>();
            for (ItemAuthEo itemAuthEo : itemAuthEos) {
                Long shopId;
                Long skuId;
                Long itemId = itemIdMap.get(itemAuthEo.getBusinessId());
                if (this.itemShelfService.isOnShelf(itemId, skuId = itemAuthEo.getBusinessId(), shopId = itemAuthEo.getTargetId())) {
                    OffItemReqDto offItemReqDto = new OffItemReqDto();
                    offItemReqDto.setBusType(ItemBusTypeEnum.ORDINARY.getType());
                    offItemReqDto.setItemId(itemId);
                    offItemReqDto.setSkuId(skuId);
                    offItemReqDto.setShopId(shopId);
                    offItemReqDto.setShopAuth(Integer.valueOf(1));
                    offItemReqDtos.add(offItemReqDto);
                    continue;
                }
                offSkuIds.add(skuId);
            }
            if (CollectionUtils.isNotEmpty(offItemReqDtos)) {
                this.itemShelfService.offShelfItem(offItemReqDtos);
            }
            if (CollectionUtils.isNotEmpty(offSkuIds)) {
                ShelfModifyShopAuthReqDto modifyShopAuthReqDto = new ShelfModifyShopAuthReqDto();
                modifyShopAuthReqDto.setShopAuth(Integer.valueOf(1));
                modifyShopAuthReqDto.setShopId(((ItemAuthEo)itemAuthEos.get(0)).getTargetId());
                modifyShopAuthReqDto.setSkuIds(offSkuIds);
                this.itemShelfService.batchModifyShelfShopAuth(modifyShopAuthReqDto);
            }
        }
        itemAuthEos.stream().map(ItemAuthEo::getTargetId).distinct().forEach(id -> this.cacheService.delCache("COMMON", authPre + id));
    }

    @Override
    public ItemAuthRespDto queryById(Long id) {
        ItemAuthEo itemAuthEo = (ItemAuthEo)this.itemAuthDas.selectByPrimaryKey(id);
        ItemAuthRespDto itemAuthRespDto = new ItemAuthRespDto();
        DtoHelper.eo2Dto((BaseEo)itemAuthEo, (BaseVo)itemAuthRespDto);
        return itemAuthRespDto;
    }

    @Override
    public PageInfo<ItemAuthRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        ItemAuthReqDto itemAuthReqDto = (ItemAuthReqDto)JSON.parseObject((String)filter, ItemAuthReqDto.class);
        ItemAuthEo itemAuthEo = new ItemAuthEo();
        DtoHelper.dto2Eo((BaseVo)itemAuthReqDto, (BaseEo)itemAuthEo);
        PageInfo eoPageInfo = this.itemAuthDas.selectPage((BaseEo)itemAuthEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, ItemAuthRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<ItemAuthRespDto> list(ItemAuthReqDto itemAuthReqDto) {
        logger.info("ItemAuthServiceImpl.list==>{}", (Object)JSON.toJsonString((Object)itemAuthReqDto));
        boolean itemAuthConfigFlag = true;
        if (ItemAuthEnum.TargetType.CUSTOMER.getCode().equals(itemAuthReqDto.getTargetType())) {
            itemAuthReqDto.setTargetIdList(itemAuthReqDto.getTargetIdList().stream().distinct().collect(Collectors.toList()));
            List customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryListOnPostByCustomerIds(itemAuthReqDto.getTargetIdList()));
            List orgIdList = customerRespDtos.stream().map(CustomerRespDto::getMerchantId).collect(Collectors.toList());
            Map customerRespDtoMap = customerRespDtos.stream().collect(Collectors.toMap(BaseRespDto::getId, Function.identity(), (o1, o2) -> o2));
            Set thirdParentPartyIdList = customerRespDtos.stream().map(CustomerRespDto::getThirdParentPartyId).collect(Collectors.toSet());
            ItemAuthConfigReqDto itemAuthConfigReqDto = new ItemAuthConfigReqDto();
            itemAuthConfigReqDto.setThirdPartyIdList(new ArrayList(thirdParentPartyIdList));
            List<ItemAuthConfigRespDto> respDtos = this.itemAuthConfigService.queryParam(itemAuthConfigReqDto);
            if (CollectionUtils.isNotEmpty(respDtos)) {
                itemAuthConfigFlag = false;
                AuthItemRuleReqDto authItemRuleReqDto = new AuthItemRuleReqDto();
                authItemRuleReqDto.setCustomerIdList(itemAuthReqDto.getTargetIdList());
                List<AuthItemRuleRespDto> authItemRuleRespDtos = this.authItemRuleService.queryParam(authItemRuleReqDto);
                List<Object> authRuleCustomerIdList = Lists.newArrayList();
                if (CollectionUtils.isNotEmpty(authItemRuleRespDtos)) {
                    authRuleCustomerIdList = authItemRuleRespDtos.stream().map(AuthItemRuleRespDto::getCustomerId).collect(Collectors.toList());
                }
                ShopQueryDto shopQueryDto = new ShopQueryDto();
                shopQueryDto.setOrganizationIdList(orgIdList);
                List shopDtos = (List)RestResponseHelper.extractData((RestResponse)this.shopQueryApi.queryShopListNew(shopQueryDto));
                Map<Long, Long> orgIdShopIdMap = shopDtos.stream().collect(Collectors.toMap(ShopDto::getOrganizationId, ShopDto::getId, (e1, e2) -> e1));
                ArrayList itemAuthRespDtos = Lists.newArrayList();
                for (Long customerId : itemAuthReqDto.getTargetIdList()) {
                    CustomerRespDto customerRespDto = (CustomerRespDto)customerRespDtoMap.get(customerId);
                    if (customerRespDto == null) {
                        logger.info("\u5ba2\u6237\u4fe1\u606f\u4e0d\u5b58\u5728");
                        continue;
                    }
                    Long shopId = orgIdShopIdMap.get(customerRespDto.getMerchantId());
                    if (shopId == null) {
                        logger.info("\u5e97\u94fa\u4fe1\u606f\u4e0d\u5b58\u5728");
                        continue;
                    }
                    if (CollectionUtils.isEmpty((Collection)authRuleCustomerIdList) || !authRuleCustomerIdList.contains(customerId)) {
                        itemAuthConfigFlag = true;
                        logger.info("\u5ba2\u6237\u672a\u914d\u7f6e\u5546\u54c1\u6388\u6743\u89c4\u5219");
                        continue;
                    }
                    CustomerAuthItemPageReqDto customerAuthItemPageReqDto = new CustomerAuthItemPageReqDto();
                    customerAuthItemPageReqDto.setCustomerId(customerId);
                    customerAuthItemPageReqDto.setNeedLimit(Integer.valueOf(2));
                    customerAuthItemPageReqDto.setProhibiteStatus(Integer.valueOf(1));
                    customerAuthItemPageReqDto.setShopId(shopId);
                    PageInfo<CustomerAuthItemRespDto> pageInfo = this.customerAuthItemService.queryAuthItemPage(customerAuthItemPageReqDto);
                    if (pageInfo != null && CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
                        for (CustomerAuthItemRespDto customerAuthItemRespDto : pageInfo.getList()) {
                            ItemAuthRespDto itemAuthRespDto = new ItemAuthRespDto();
                            itemAuthRespDto.setTargetId(customerId);
                            itemAuthRespDto.setTargetType(ItemAuthEnum.TargetType.CUSTOMER.getCode());
                            itemAuthRespDto.setBusinessId(customerAuthItemRespDto.getSkuId());
                            itemAuthRespDto.setBusinessType(ItemAuthEnum.BusinessType.SKU.getCode());
                            itemAuthRespDtos.add(itemAuthRespDto);
                        }
                        continue;
                    }
                    logger.info("\u5ba2\u6237\u5546\u54c1\u672a\u5728\u7ecf\u9500\u5546\u6709\u6388\u6743\u5546\u54c1\u6216\u672a\u542f\u7528");
                }
                return itemAuthRespDtos;
            }
        }
        logger.info("\u5546\u54c1\u6388\u6743\u89c4\u5219\u914d\u7f6e=itemAuthConfigFlag={}", (Object)itemAuthConfigFlag);
        if (itemAuthConfigFlag) {
            Integer authEndTimeState;
            ItemAuthEo itemAuthEo = new ItemAuthEo();
            DtoHelper.dto2Eo((BaseVo)itemAuthReqDto, (BaseEo)itemAuthEo);
            itemAuthEo.setDr(0);
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper((Object)itemAuthEo);
            boolean idEmpty = false;
            boolean timeEmpty = false;
            if (CollUtil.isNotEmpty((Collection)itemAuthReqDto.getTargetIdList())) {
                queryWrapper.in(ItemAuthEo::getTargetId, (Collection)itemAuthReqDto.getTargetIdList());
            } else {
                idEmpty = true;
            }
            if (CollUtil.isNotEmpty((Collection)itemAuthReqDto.getBusinessIdList())) {
                queryWrapper.in(ItemAuthEo::getBusinessId, (Collection)itemAuthReqDto.getBusinessIdList());
            }
            if (Objects.equals(authEndTimeState = itemAuthReqDto.getAuthEndTimeState(), 1)) {
                queryWrapper.and(wrapper -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.ge(ItemAuthEo::getAuthEndTime, (Object)DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"))).or()).isNull(ItemAuthEo::getAuthEndTime);
                });
            } else {
                timeEmpty = true;
            }
            if (idEmpty && timeEmpty) {
                throw new BizException("-1", "id\u548ctime\u6761\u4ef6\u4e0d\u5141\u8bb8\u540c\u65f6\u4e3a\u7a7a");
            }
            List itemAuthEos = this.itemAuthDas.getMapper().selectList((Wrapper)queryWrapper);
            ArrayList<ItemAuthRespDto> dtoList = new ArrayList<ItemAuthRespDto>();
            DtoHelper.eoList2DtoList((Collection)itemAuthEos, dtoList, ItemAuthRespDto.class);
            return dtoList;
        }
        return Lists.newArrayList();
    }

    @Override
    public PageInfo<ItemAuthRespDto> listByPage(ItemAuthPageReqDto itemAuthPageReqDto) {
        Integer authEndTimeState;
        ItemAuthEo itemAuthEo = new ItemAuthEo();
        DtoHelper.dto2Eo((BaseVo)itemAuthPageReqDto, (BaseEo)itemAuthEo);
        itemAuthEo.setDr(0);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper((Object)itemAuthEo);
        if (CollUtil.isNotEmpty((Collection)itemAuthPageReqDto.getTargetIdList())) {
            queryWrapper.in(ItemAuthEo::getTargetId, (Collection)itemAuthPageReqDto.getTargetIdList());
        }
        if (Objects.equals(authEndTimeState = itemAuthPageReqDto.getAuthEndTimeState(), 1)) {
            queryWrapper.and(wrapper -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.ge(ItemAuthEo::getAuthEndTime, (Object)DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"))).or()).isNull(ItemAuthEo::getAuthEndTime);
            });
        }
        Page page = new Page((long)itemAuthPageReqDto.getPageNum().intValue(), (long)itemAuthPageReqDto.getPageSize().intValue(), false);
        IPage itemAuthEos = this.itemAuthDas.getMapper().selectPage((IPage)page, (Wrapper)queryWrapper);
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)itemAuthEos.getRecords(), dtoList, ItemAuthRespDto.class);
        PageInfo pageInfo = new PageInfo(dtoList);
        pageInfo.setTotal(itemAuthEos.getTotal());
        pageInfo.setPageNum(itemAuthPageReqDto.getPageNum().intValue());
        return new PageInfo(dtoList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<Long> batchItemAuth(ItemAuthAddBatchRespDto itemAuthAddBatchRespDto) {
        List businessIdList = itemAuthAddBatchRespDto.getBusinessIdList();
        if (CollUtil.isEmpty((Collection)businessIdList)) {
            return ListUtil.empty();
        }
        ItemAuthEo itemAuthEo = new ItemAuthEo();
        DtoHelper.dto2Eo((BaseVo)itemAuthAddBatchRespDto, (BaseEo)itemAuthEo);
        itemAuthEo.setTenantId(this.context.tenantId());
        itemAuthEo.setInstanceId(this.context.instanceId());
        itemAuthEo.setDr(0);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper((Object)itemAuthEo);
        queryWrapper.in(ItemAuthEo::getBusinessId, (Collection)businessIdList);
        List list = this.itemAuthDas.getMapper().selectList((Wrapper)queryWrapper);
        if (CollUtil.isNotEmpty((Collection)list)) {
            List existIds = list.stream().map(ItemAuthEo::getBusinessId).collect(Collectors.toList());
            businessIdList.removeAll(existIds);
        }
        if (CollUtil.isEmpty((Collection)businessIdList)) {
            return ListUtil.empty();
        }
        List itemAuthEoList = businessIdList.stream().map(businessId -> {
            ItemAuthEo itemAuth = new ItemAuthEo();
            DtoHelper.dto2Eo((BaseVo)itemAuthAddBatchRespDto, (BaseEo)itemAuth);
            itemAuth.setTenantId(this.context.tenantId());
            itemAuth.setInstanceId(this.context.instanceId());
            itemAuth.setDr(0);
            itemAuth.setBusinessId(businessId);
            itemAuth.setStatus(ItemAuthEnum.Status.ENABLE.getCode());
            return itemAuth;
        }).collect(Collectors.toList());
        this.itemAuthDas.insertBatch(itemAuthEoList);
        if (Objects.equals(itemAuthAddBatchRespDto.getTargetType(), ItemAuthEnum.TargetType.SHOP.getCode()) && Objects.equals(itemAuthAddBatchRespDto.getBusinessType(), ItemAuthEnum.BusinessType.SKU.getCode())) {
            ShelfModifyShopAuthReqDto modifyShopAuthReqDto = new ShelfModifyShopAuthReqDto();
            modifyShopAuthReqDto.setShopAuth(Integer.valueOf(0));
            modifyShopAuthReqDto.setShopId(itemAuthAddBatchRespDto.getTargetId());
            modifyShopAuthReqDto.setSkuIds(itemAuthAddBatchRespDto.getBusinessIdList());
            this.itemShelfService.batchModifyShelfShopAuth(modifyShopAuthReqDto);
            this.cacheService.delCache("COMMON", authPre + itemAuthAddBatchRespDto.getTargetId());
        }
        itemAuthEoList.stream().map(ItemAuthEo::getTargetId).distinct().forEach(id -> this.cacheService.delCache("COMMON", authPre + id));
        return itemAuthEoList.stream().map(BaseEo::getId).collect(Collectors.toList());
    }

    @Override
    public List<ItemAuthRespDto> queryByTargetIds(ItemAuthReqDto itemAuthReqDto) {
        logger.info("ItemAuthServiceImpl.queryByTargetIds==>{}", (Object)JSON.toJsonString((Object)itemAuthReqDto));
        boolean itemAuthConfigFlag = true;
        ArrayList<ItemAuthRespDto> dtoList = new ArrayList<ItemAuthRespDto>();
        if (ItemAuthEnum.TargetType.CUSTOMER.getCode().equals(itemAuthReqDto.getTargetType())) {
            if (CollectionUtils.isEmpty((Collection)itemAuthReqDto.getTargetIdList())) {
                logger.info("\u4f20\u5165\u7684targetId\u96c6\u5408\u4e3a\u7a7a");
                return dtoList;
            }
            List customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryListOnPostByCustomerIds(itemAuthReqDto.getTargetIdList()));
            List orgIdList = customerRespDtos.stream().map(CustomerRespDto::getMerchantId).collect(Collectors.toList());
            Map customerRespDtoMap = customerRespDtos.stream().collect(Collectors.toMap(BaseRespDto::getId, Function.identity(), (o1, o2) -> o2));
            Set thirdParentPartyIdList = customerRespDtos.stream().map(CustomerRespDto::getThirdParentPartyId).collect(Collectors.toSet());
            ItemAuthConfigReqDto itemAuthConfigReqDto = new ItemAuthConfigReqDto();
            itemAuthConfigReqDto.setThirdPartyIdList(new ArrayList(thirdParentPartyIdList));
            List<ItemAuthConfigRespDto> respDtos = this.itemAuthConfigService.queryParam(itemAuthConfigReqDto);
            if (CollectionUtils.isNotEmpty(respDtos)) {
                itemAuthConfigFlag = false;
                AuthItemRuleReqDto authItemRuleReqDto = new AuthItemRuleReqDto();
                authItemRuleReqDto.setCustomerIdList(itemAuthReqDto.getTargetIdList());
                List<AuthItemRuleRespDto> authItemRuleRespDtos = this.authItemRuleService.queryParam(authItemRuleReqDto);
                List<Object> authRuleCustomerIdList = Lists.newArrayList();
                if (CollectionUtils.isNotEmpty(authItemRuleRespDtos)) {
                    authRuleCustomerIdList = authItemRuleRespDtos.stream().map(AuthItemRuleRespDto::getCustomerId).collect(Collectors.toList());
                }
                ShopQueryDto shopQueryDto = new ShopQueryDto();
                shopQueryDto.setOrganizationIdList(orgIdList);
                List shopDtos = (List)RestResponseHelper.extractData((RestResponse)this.shopQueryApi.queryShopListNew(shopQueryDto));
                Map<Long, Long> orgIdShopIdMap = shopDtos.stream().collect(Collectors.toMap(ShopDto::getOrganizationId, ShopDto::getId, (e1, e2) -> e1));
                for (Long customerId : itemAuthReqDto.getTargetIdList()) {
                    CustomerRespDto customerRespDto = (CustomerRespDto)customerRespDtoMap.get(customerId);
                    if (customerRespDto == null) {
                        logger.info("\u5ba2\u6237\u4fe1\u606f\u4e0d\u5b58\u5728");
                        continue;
                    }
                    Long shopId = orgIdShopIdMap.get(customerRespDto.getMerchantId());
                    if (shopId == null) {
                        logger.info("\u5e97\u94fa\u4fe1\u606f\u4e0d\u5b58\u5728");
                        continue;
                    }
                    if (CollectionUtils.isEmpty((Collection)authRuleCustomerIdList) || !authRuleCustomerIdList.contains(customerId)) {
                        itemAuthConfigFlag = true;
                        logger.info("\u5ba2\u6237\u672a\u914d\u7f6e\u5546\u54c1\u6388\u6743\u89c4\u5219");
                        continue;
                    }
                    CustomerAuthItemPageReqDto customerAuthItemPageReqDto = new CustomerAuthItemPageReqDto();
                    customerAuthItemPageReqDto.setShopId(shopId);
                    customerAuthItemPageReqDto.setCustomerId(customerId);
                    customerAuthItemPageReqDto.setNeedLimit(Integer.valueOf(2));
                    customerAuthItemPageReqDto.setProhibiteStatus(Integer.valueOf(1));
                    customerAuthItemPageReqDto.setMatchSkuIds(itemAuthReqDto.getBusinessIdList());
                    PageInfo<CustomerAuthItemRespDto> pageInfo = this.customerAuthItemService.queryAuthItemPage(customerAuthItemPageReqDto);
                    if (pageInfo != null && CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
                        for (CustomerAuthItemRespDto customerAuthItemRespDto : pageInfo.getList()) {
                            ItemAuthRespDto itemAuthRespDto = new ItemAuthRespDto();
                            itemAuthRespDto.setTargetId(customerId);
                            itemAuthRespDto.setTargetType(ItemAuthEnum.TargetType.CUSTOMER.getCode());
                            itemAuthRespDto.setBusinessId(customerAuthItemRespDto.getSkuId());
                            itemAuthRespDto.setBusinessType(ItemAuthEnum.BusinessType.SKU.getCode());
                            dtoList.add(itemAuthRespDto);
                        }
                        continue;
                    }
                    logger.info("\u5ba2\u6237\u5546\u54c1\u672a\u5728\u7ecf\u9500\u5546\u6709\u6388\u6743\u5546\u54c1\u6216\u672a\u542f\u7528");
                }
                return dtoList;
            }
        }
        if (itemAuthConfigFlag) {
            ItemAuthEo itemAuthEo = new ItemAuthEo();
            DtoHelper.dto2Eo((BaseVo)itemAuthReqDto, (BaseEo)itemAuthEo);
            itemAuthEo.setDr(0);
            QueryWrapper queryWrapper = new QueryWrapper((Object)itemAuthEo);
            if (CollUtil.isEmpty((Collection)itemAuthReqDto.getTargetIdList()) && CollUtil.isEmpty((Collection)itemAuthReqDto.getBusinessIdList())) {
                throw new BizException("-1", "\u5165\u53c2targetIdList\u548cbusinessIdList\u4e0d\u5141\u8bb8\u540c\u65f6\u4e3a\u7a7a");
            }
            if (CollUtil.isNotEmpty((Collection)itemAuthReqDto.getTargetIdList())) {
                queryWrapper.in((Object)"target_id", (Collection)itemAuthReqDto.getTargetIdList());
            }
            if (CollUtil.isNotEmpty((Collection)itemAuthReqDto.getBusinessIdList())) {
                queryWrapper.in((Object)"business_id", (Collection)itemAuthReqDto.getBusinessIdList());
            }
            List itemAuthEos = this.itemAuthDas.getMapper().selectList((Wrapper)queryWrapper);
            DtoHelper.eoList2DtoList((Collection)itemAuthEos, dtoList, ItemAuthRespDto.class);
        }
        return dtoList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchOnShelfItem(ItemOnShelfListTobReqDto itemOnShelfListReqDto) {
        if (CollectionUtils.isNotEmpty((Collection)itemOnShelfListReqDto.getOnItemList())) {
            this.onShelfOperation(itemOnShelfListReqDto.getOnItemList());
        }
    }

    private void onShelfOperation(List<OnItemTobReqDto> onItemList) {
        HashSet itemIds = Sets.newHashSet();
        ArrayList onDirItems = Lists.newArrayList();
        for (OnItemTobReqDto onItemTobReqDto : onItemList) {
            if (onItemTobReqDto.getItemId() == null) {
                throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_PARAM);
            }
            itemIds.add(onItemTobReqDto.getItemId());
            ItemEo itemEo = this.itemService.queryById(onItemTobReqDto.getItemId());
            if (itemEo == null) continue;
            DirItemRelationEo dirItemRelationEo = DirItemRelationEo.newInstance();
            dirItemRelationEo.setItemId(itemEo.getId());
            dirItemRelationEo.setSkuId(onItemTobReqDto.getSkuId());
            dirItemRelationEo.setShopId(onItemTobReqDto.getShopId());
            dirItemRelationEo.setDirId(onItemTobReqDto.getDirId());
            dirItemRelationEo.setStatus(ItemStatus.ITEM_OFFSHELF.getStatus());
            dirItemRelationEo.setTenantId(onItemTobReqDto.getTenantId());
            dirItemRelationEo.setInstanceId(onItemTobReqDto.getInstanceId());
            dirItemRelationEo.setBusType(onItemTobReqDto.getBusType());
            List relations = this.dirItemRelationDas.select((BaseEo)dirItemRelationEo);
            for (DirItemRelationEo e : relations) {
                DirItemRelationEo updateEo = DirItemRelationEo.newInstance();
                updateEo.setId(e.getId());
                updateEo.setStatus(ItemStatus.ITEM_ONSHELF.getStatus());
                this.dirItemRelationDas.updateSelective((BaseEo)updateEo);
                onDirItems.add(e);
            }
        }
        ArrayList shelfReqDtos = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)shelfReqDtos, onItemList, ShelfReqDto.class);
        this.iItemShelfService.saveShelf((List)shelfReqDtos, ItemStatus.ITEM_ONSHELF.getStatus());
        this.itemSearchService.asyncItemIndex(onItemList.get(0).getBusType(), (List)onDirItems);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<Long> batchAddItemAuth(List<ItemAuthReqDto> itemAuthReqDtoList) {
        if (CollectionUtils.isEmpty(itemAuthReqDtoList)) {
            return null;
        }
        ArrayList itemAuthEoList = Lists.newArrayList();
        DtoHelper.dtoList2EoList(itemAuthReqDtoList, (Collection)itemAuthEoList, ItemAuthEo.class);
        this.itemAuthDas.insertBatch((List)itemAuthEoList);
        itemAuthEoList.stream().map(ItemAuthEo::getTargetId).distinct().forEach(id -> this.cacheService.delCache("COMMON", authPre + id));
        return itemAuthEoList.stream().map(BaseEo::getId).collect(Collectors.toList());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchNewAddItemAuth(List<ItemAuthReqDto> itemAuthReqDtoList) {
        if (CollectionUtils.isEmpty(itemAuthReqDtoList)) {
            return;
        }
        ItemAuthEo itemAuthEo = new ItemAuthEo();
        itemAuthEo.setTargetType(Integer.valueOf(1));
        ArrayList sqlFilterList = Lists.newArrayList();
        sqlFilterList.add(SqlFilter.in((String)"target_id", itemAuthReqDtoList.stream().distinct().filter(e -> e.getTargetId() != null).map(ItemAuthReqDto::getTargetIdList).collect(Collectors.toList())));
        sqlFilterList.add(SqlFilter.in((String)"business_id", itemAuthReqDtoList.stream().distinct().filter(e -> e.getBusinessId() != null).map(ItemAuthReqDto::getBusinessId).collect(Collectors.toList())));
        itemAuthEo.setSqlFilters((List)sqlFilterList);
        this.itemAuthDas.deleteByExample((BaseEo)itemAuthEo);
        this.batchAddItemAuth(itemAuthReqDtoList);
        itemAuthReqDtoList.stream().map(ItemAuthReqDto::getTargetId).filter(Objects::nonNull).distinct().forEach(id -> this.cacheService.delCache("COMMON", authPre + id));
    }
}

