/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.b2b.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.huieryun.opensearch.vo.SearchResultVo;
import com.dtyunxi.util.IdGenrator;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.item.api.b2b.constants.AuthItemRuleTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.AuthItemRuleReqDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.BlackAuthItemReqDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.CustomerAuthItemReqDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.MatchAuthItemRuleReqDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.response.AuthItemRuleRespDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.response.BlackAuthItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.response.CustomerAuthItemRespDto;
import com.dtyunxi.yundt.cube.center.item.biz.b2b.service.IAuthItemRuleService;
import com.dtyunxi.yundt.cube.center.item.biz.b2b.service.impl.SyncAuthRuleService;
import com.dtyunxi.yundt.cube.center.item.dao.b2b.das.AuthItemRuleDas;
import com.dtyunxi.yundt.cube.center.item.dao.b2b.das.BlackAuthItemDas;
import com.dtyunxi.yundt.cube.center.item.dao.b2b.das.CustomerAuthItemDas;
import com.dtyunxi.yundt.cube.center.item.dao.b2b.vo.BlackAuthItemVo;
import com.dtyunxi.yundt.cube.center.item.dao.b2b.vo.CustomerAuthItemVo;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemMediasDas;
import com.dtyunxi.yundt.cube.center.item.dao.eo.b2b.AuthItemRuleEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.b2b.CustomerAuthItemEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemMediasEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StdItemMediasEo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AuthItemRuleServiceImpl
implements IAuthItemRuleService {
    private static final DefaultConversionService CONVERSION_SERVICE = new DefaultConversionService();
    @Resource
    private AuthItemRuleDas authItemRuleDas;
    @Autowired
    private BlackAuthItemDas blackAuthItemDas;
    @Autowired
    private CustomerAuthItemDas customerAuthItemDas;
    @Autowired
    private SyncAuthRuleService syncAuthRuleService;
    @Autowired
    private ItemMediasDas itemMediasDas;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addAuthItemRule(AuthItemRuleReqDto addReqDto) {
        this.verifyParam(addReqDto);
        AuthItemRuleEo queryEo = new AuthItemRuleEo();
        queryEo.setCustomerId(addReqDto.getCustomerId());
        queryEo = (AuthItemRuleEo)this.authItemRuleDas.selectOne((BaseEo)queryEo);
        if (queryEo != null) {
            throw new BizException("\u5df2\u5b58\u5728\u6388\u6743\u8bb0\u5f55\uff0c\u5237\u65b0\u9875\u9762\u540e\u8fdb\u884c\u64cd\u4f5c");
        }
        AuthItemRuleEo authItemRuleEo = new AuthItemRuleEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)authItemRuleEo);
        if (CollectionUtil.isNotEmpty((Collection)addReqDto.getBlackAuthItemReqDtos())) {
            List blackItemIds = addReqDto.getBlackAuthItemReqDtos().stream().map(BlackAuthItemReqDto::getItemId).distinct().collect(Collectors.toList());
            String blackItemIdStr = StringUtils.join(blackItemIds, (String)",");
            authItemRuleEo.setBlackItemId(blackItemIdStr);
        }
        this.authItemRuleDas.insert((BaseEo)authItemRuleEo);
        this.saveRelDetail(addReqDto, authItemRuleEo.getId());
        this.syncAuthRuleService.syncRule2Es(authItemRuleEo.getId());
        return authItemRuleEo.getId();
    }

    private void saveRelDetail(AuthItemRuleReqDto authItemRuleReqDto, Long ruleId) {
        if (AuthItemRuleTypeEnum.ITEM.getRuleType().equals(authItemRuleReqDto.getAuthType()) && CollectionUtil.isNotEmpty((Collection)authItemRuleReqDto.getCustomerAuthItemReqDtos())) {
            ArrayList customerAuthItemEos = Lists.newArrayList();
            for (CustomerAuthItemReqDto customerAuthItemReqDto : authItemRuleReqDto.getCustomerAuthItemReqDtos()) {
                CustomerAuthItemEo customerAuthItemEo = new CustomerAuthItemEo();
                DtoHelper.dto2Eo((BaseVo)customerAuthItemReqDto, (BaseEo)customerAuthItemEo);
                customerAuthItemEo.setRuleId(ruleId);
                customerAuthItemEo.setCustomerId(authItemRuleReqDto.getCustomerId());
                customerAuthItemEos.add(customerAuthItemEo);
            }
            this.customerAuthItemDas.insertBatch((List)customerAuthItemEos);
        }
    }

    private void verifyParam(AuthItemRuleReqDto addReqDto) {
        if (addReqDto.getCustomerId() == null) {
            throw new BizException("\u5ba2\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (addReqDto.getAuthType() == null) {
            throw new BizException("\u6388\u6743\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (AuthItemRuleTypeEnum.ITEM.getRuleType().equals(addReqDto.getAuthType()) && CollectionUtil.isEmpty((Collection)addReqDto.getCustomerAuthItemReqDtos())) {
            throw new BizException("\u6307\u5b9a\u6388\u6743\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyAuthItemRule(AuthItemRuleReqDto modifyReqDto) {
        this.verifyParam(modifyReqDto);
        AuthItemRuleEo eo = (AuthItemRuleEo)this.authItemRuleDas.selectByPrimaryKey(modifyReqDto.getId());
        if (eo == null) {
            throw new BizException("\u5ba2\u6237\u5546\u54c1\u6388\u6743\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        CustomerAuthItemEo customerAuthItemEo = new CustomerAuthItemEo();
        customerAuthItemEo.setRuleId(modifyReqDto.getId());
        customerAuthItemEo.setCustomerId(modifyReqDto.getCustomerId());
        this.customerAuthItemDas.deleteByExample((BaseEo)customerAuthItemEo);
        AuthItemRuleEo authItemRuleEo = new AuthItemRuleEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)authItemRuleEo);
        String blackItemIdStr = "";
        if (CollectionUtil.isNotEmpty((Collection)modifyReqDto.getBlackAuthItemReqDtos())) {
            List blackItemIds = modifyReqDto.getBlackAuthItemReqDtos().stream().map(BlackAuthItemReqDto::getItemId).distinct().collect(Collectors.toList());
            blackItemIdStr = StringUtils.join(blackItemIds, (String)",");
        }
        authItemRuleEo.setCreatePerson(eo.getCreatePerson());
        authItemRuleEo.setCreateTime(eo.getCreateTime());
        authItemRuleEo.setDr(eo.getDr());
        authItemRuleEo.setBlackItemId(blackItemIdStr);
        this.authItemRuleDas.update((BaseEo)authItemRuleEo);
        this.saveRelDetail(modifyReqDto, modifyReqDto.getId());
        this.syncAuthRuleService.refreshEs(modifyReqDto.getId());
    }

    @Override
    public AuthItemRuleRespDto queryById(Long id) {
        AuthItemRuleRespDto authItemRuleRespDto = null;
        AuthItemRuleEo authItemRuleEo = (AuthItemRuleEo)this.authItemRuleDas.selectByPrimaryKey(id);
        if (authItemRuleEo != null) {
            authItemRuleRespDto = new AuthItemRuleRespDto();
            DtoHelper.eo2Dto((BaseEo)authItemRuleEo, (BaseVo)authItemRuleRespDto);
            this.queryRelDetail(authItemRuleRespDto, authItemRuleEo);
        }
        return authItemRuleRespDto;
    }

    @Override
    public AuthItemRuleRespDto queryByCustomerId(Long customerId) {
        AuthItemRuleRespDto authItemRuleRespDto = null;
        AuthItemRuleEo eo = new AuthItemRuleEo();
        eo.setCustomerId(customerId);
        eo = (AuthItemRuleEo)this.authItemRuleDas.selectOne((BaseEo)eo);
        if (eo != null) {
            authItemRuleRespDto = new AuthItemRuleRespDto();
            DtoHelper.eo2Dto((BaseEo)eo, (BaseVo)authItemRuleRespDto);
            this.queryRelDetail(authItemRuleRespDto, eo);
        }
        return authItemRuleRespDto;
    }

    private void queryRelDetail(AuthItemRuleRespDto authItemRuleRespDto, AuthItemRuleEo authItemRuleEo) {
        List customerAuthItemVos;
        if (AuthItemRuleTypeEnum.CATEGORY.getRuleType().equals(authItemRuleRespDto.getAuthType())) {
            String[] blackItemIdArr;
            List blackAuthItemVos;
            if (StringUtils.isNotBlank((String)authItemRuleEo.getBlackItemId()) && CollectionUtils.isNotEmpty((Collection)(blackAuthItemVos = this.authItemRuleDas.queryBlackItemByItemIds(blackItemIdArr = authItemRuleEo.getBlackItemId().split(","))))) {
                List blackItemIds = blackAuthItemVos.stream().map(BlackAuthItemVo::getItemId).collect(Collectors.toList());
                List itemMediasEos = this.itemMediasDas.selectByItemIds(blackItemIds);
                Map<Long, ItemMediasEo> itemMediasEoMap = itemMediasEos.stream().collect(Collectors.toMap(StdItemMediasEo::getItemId, e -> e, (e1, e2) -> e1));
                ArrayList blackAuthItemRespDtos = Lists.newArrayList();
                for (BlackAuthItemVo blackAuthItemVo : blackAuthItemVos) {
                    BlackAuthItemRespDto blackAuthItemRespDto = new BlackAuthItemRespDto();
                    BeanUtil.copyProperties((Object)blackAuthItemVo, (Object)blackAuthItemRespDto, (String[])new String[0]);
                    ItemMediasEo itemMediasEo = itemMediasEoMap.get(blackAuthItemVo.getItemId());
                    if (itemMediasEo != null) {
                        blackAuthItemRespDto.setImgPath(itemMediasEo.getPath1());
                    }
                    blackAuthItemRespDtos.add(blackAuthItemRespDto);
                }
                authItemRuleRespDto.setBlackAuthItemRespDtos((List)blackAuthItemRespDtos);
            }
        } else if (AuthItemRuleTypeEnum.ITEM.getRuleType().equals(authItemRuleRespDto.getAuthType()) && CollectionUtils.isNotEmpty((Collection)(customerAuthItemVos = this.customerAuthItemDas.selectAuthItem(authItemRuleRespDto.getId(), authItemRuleRespDto.getCustomerId())))) {
            List itemIds = customerAuthItemVos.stream().map(CustomerAuthItemVo::getItemId).collect(Collectors.toList());
            List itemMediasEos = this.itemMediasDas.selectByItemIds(itemIds);
            Map<Long, ItemMediasEo> itemMediasEoMap = itemMediasEos.stream().collect(Collectors.toMap(StdItemMediasEo::getItemId, e -> e, (e1, e2) -> e1));
            ArrayList customerAuthItemRespDtos = Lists.newArrayList();
            for (CustomerAuthItemVo customerAuthItemVo : customerAuthItemVos) {
                CustomerAuthItemRespDto customerAuthItemRespDto = new CustomerAuthItemRespDto();
                BeanUtil.copyProperties((Object)customerAuthItemVo, (Object)customerAuthItemRespDto, (String[])new String[0]);
                ItemMediasEo itemMediasEo = itemMediasEoMap.get(customerAuthItemVo.getItemId());
                if (itemMediasEo != null) {
                    customerAuthItemRespDto.setImgPath(itemMediasEo.getPath1());
                }
                customerAuthItemRespDtos.add(customerAuthItemRespDto);
            }
            authItemRuleRespDto.setCustomerAuthItemRespDtos((List)customerAuthItemRespDtos);
        }
    }

    @Override
    public PageInfo<AuthItemRuleRespDto> queryByPage(AuthItemRuleReqDto authItemRuleReqDto) {
        AuthItemRuleEo authItemRuleEo = new AuthItemRuleEo();
        DtoHelper.dto2Eo((BaseVo)authItemRuleReqDto, (BaseEo)authItemRuleEo);
        PageInfo eoPageInfo = this.authItemRuleDas.selectPage((BaseEo)authItemRuleEo, authItemRuleReqDto.getPageNum(), authItemRuleReqDto.getPageSize());
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, AuthItemRuleRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public PageInfo<AuthItemRuleRespDto> queryRulePageByCondition(MatchAuthItemRuleReqDto matchAuthItemRuleReqDto) {
        BoolQueryBuilder boolQueryBuilder = this.syncAuthRuleService.buildConflictQuery(matchAuthItemRuleReqDto);
        SearchResultVo searchResultVo = this.syncAuthRuleService.doQuery(boolQueryBuilder, matchAuthItemRuleReqDto.getPageNum(), matchAuthItemRuleReqDto.getPageSize());
        List<AuthItemRuleRespDto> list = this.convert(searchResultVo.getDocValues());
        PageInfo pageInfo = new PageInfo();
        pageInfo.setPageNum(matchAuthItemRuleReqDto.getPageNum().intValue());
        pageInfo.setPageSize(matchAuthItemRuleReqDto.getPageSize().intValue());
        pageInfo.setSize(list.size());
        pageInfo.setPages(searchResultVo.getTotalPageNum().intValue());
        pageInfo.setTotal(searchResultVo.getTotalSize());
        pageInfo.setList(list);
        return pageInfo;
    }

    private List<AuthItemRuleRespDto> convert(List<Map<String, Object>> docValues) {
        if (CollectionUtils.isEmpty(docValues)) {
            return com.google.common.collect.Lists.newArrayList();
        }
        List<AuthItemRuleRespDto> authItemRuleRespDtos = docValues.stream().map(doc -> {
            AuthItemRuleRespDto authItemRuleRespDto = new AuthItemRuleRespDto();
            authItemRuleRespDto.setCustomerId((Long)CONVERSION_SERVICE.convert(doc.get("customerId"), Long.class));
            authItemRuleRespDto.setCustomerCode((String)CONVERSION_SERVICE.convert(doc.get("customerCode"), String.class));
            authItemRuleRespDto.setCustomerName((String)CONVERSION_SERVICE.convert(doc.get("customerName"), String.class));
            return authItemRuleRespDto;
        }).collect(Collectors.toList());
        return authItemRuleRespDtos;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void syncRuleToEsByRuleId(Long ruleId) {
        if (ruleId == null) {
            throw new BizException("\u89c4\u5219ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.syncAuthRuleService.syncRule2Es(ruleId);
    }

    @Override
    public List<AuthItemRuleRespDto> queryParam(AuthItemRuleReqDto authItemRuleReqDto) {
        AuthItemRuleEo authItemRuleEo = new AuthItemRuleEo();
        DtoHelper.dto2Eo((BaseVo)authItemRuleReqDto, (BaseEo)authItemRuleEo);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper((Object)authItemRuleEo);
        if (CollectionUtils.isNotEmpty((Collection)authItemRuleReqDto.getOrganizationIdList())) {
            queryWrapper.in(AuthItemRuleEo::getOrganizationId, (Collection)authItemRuleReqDto.getOrganizationIdList());
        }
        if (CollectionUtils.isNotEmpty((Collection)authItemRuleReqDto.getCustomerIdList())) {
            queryWrapper.in(AuthItemRuleEo::getCustomerId, (Collection)authItemRuleReqDto.getCustomerIdList());
        }
        if (CollectionUtils.isNotEmpty((Collection)authItemRuleReqDto.getCustomerCodeList())) {
            queryWrapper.in(AuthItemRuleEo::getCustomerCode, (Collection)authItemRuleReqDto.getCustomerCodeList());
        }
        List list = this.authItemRuleDas.getMapper().selectList((Wrapper)queryWrapper);
        ArrayList<AuthItemRuleRespDto> dtoList = new ArrayList<AuthItemRuleRespDto>();
        DtoHelper.eoList2DtoList((Collection)list, dtoList, AuthItemRuleRespDto.class);
        return dtoList;
    }

    @Override
    public void syncAllRuleToEs() {
        this.syncAuthRuleService.syncAllRule2Es();
    }

    @Override
    public List<AuthItemRuleRespDto> findAll() {
        List authItemRuleEos = this.authItemRuleDas.getMapper().findAll();
        ArrayList<AuthItemRuleRespDto> dtoList = new ArrayList<AuthItemRuleRespDto>();
        DtoHelper.eoList2DtoList((Collection)authItemRuleEos, dtoList, AuthItemRuleRespDto.class);
        return dtoList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void initAuthItemRule(List<AuthItemRuleReqDto> authItemRuleReqDtoList) {
        ArrayList itemRuleEoList = Lists.newArrayList();
        for (AuthItemRuleReqDto authItemRuleReqDto : authItemRuleReqDtoList) {
            AuthItemRuleEo authItemRuleEo = new AuthItemRuleEo();
            DtoHelper.dto2Eo((BaseVo)authItemRuleReqDto, (BaseEo)authItemRuleEo);
            long id = IdGenrator.getDistributedId();
            authItemRuleEo.setId(Long.valueOf(id));
            itemRuleEoList.add(authItemRuleEo);
        }
        this.authItemRuleDas.insertBatch((List)itemRuleEoList);
        List<Long> ids = itemRuleEoList.stream().map(BaseEo::getId).collect(Collectors.toList());
        this.syncAuthRuleService.batchSyncRule2Es(ids);
    }

    @Override
    public List<AuthItemRuleRespDto> queryByIds(List<Long> ids) {
        List itemRuleEoList = this.authItemRuleDas.selectByIds(ids);
        ArrayList authItemRuleReqDtoList = Lists.newArrayList();
        if (CollectionUtil.isNotEmpty((Collection)itemRuleEoList)) {
            Map authItemRuleEoMap = itemRuleEoList.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity()));
            DtoHelper.eoList2DtoList((Collection)itemRuleEoList, (Collection)authItemRuleReqDtoList, AuthItemRuleRespDto.class);
            for (AuthItemRuleRespDto authItemRuleRespDto : authItemRuleReqDtoList) {
                if (!authItemRuleEoMap.containsKey(authItemRuleRespDto.getId())) continue;
                this.queryRelDetail(authItemRuleRespDto, (AuthItemRuleEo)authItemRuleEoMap.get(authItemRuleRespDto.getId()));
            }
        }
        return authItemRuleReqDtoList;
    }
}

