package com.dtyunxi.yundt.cube.center.trade.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.ReturnAuditReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.ReturnConfirmRefundReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.ReturnItemConfirmReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.ReturnModTobReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

@Api(tags = {"交易中心:B端售后服务"})
@FeignClient(name = "${yundt.cube.center.trade.api.name:yundt-cube-center-trade}", path = "/v1/afterSales", url = "${yundt.cube.center.trade.api:}")
public interface IAfterSalesTobApi {
    @PutMapping("/return/modify_info")
    @ApiOperation(value = " 修改退货信息", notes = "该接口修改退货信息")
    RestResponse<Void> modifyReturnInfo(@RequestBody ReturnModTobReqDto returnModTobReqDto);

    @PutMapping("/return/{returnNo}/auditRefactor")
    @ApiOperation(value = "退货审核,目前主要B端使用，C端的咨询相关人员",notes = "退货审核,目前主要B端使用，C端的咨询相关人员")
    RestResponse<String> auditReturnRefactor(@PathVariable("returnNo") String returnNo, @RequestBody ReturnAuditReqDto returnAuditReqDto);

    /**
     * 退货商品入库
     * @return
     */
    @PostMapping("/return/item/confirm")
    @ApiOperation(value = "退货商品入库",notes = "退货商品入库")
    RestResponse<String> confirmReturnItem(@RequestBody ReturnItemConfirmReqDto returnItemConfirmReqDto);

    @PostMapping("/return/confirmRefund")
    @ApiOperation(value = "确认退款",notes = "确认退款")
    RestResponse<String> confirmRefund(@RequestBody ReturnConfirmRefundReqDto returnConfirmRefundReqDto);

    @DeleteMapping("/refund")
    @ApiOperation(value = "删除退款单",notes = "删除退款单")
    RestResponse<Void> removeRefund(@RequestBody ReturnConfirmRefundReqDto returnConfirmRefundReqDto);
}
