package com.dtyunxi.yundt.cube.center.trade.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.OrderDeliveryTobReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@Api(tags = {"交易中心:B端发货记录"})
@FeignClient(name = "${yundt.cube.center.trade.api.name:yundt-cube-center-trade}", path = "/v1/delivery", url = "${yundt.cube.center.trade.api:}")
public interface IOrderDeliveryTobApi {
    /**
     * 创建发货单（B端）
     *
     * @param orderDeliveryTobReqDto
     * @return
     */
    @PostMapping("/createDeliveryOrder")
    @ApiOperation(value = "订单出库（B端）", notes = "订单出库（B端）")
    RestResponse<String> createDeliveryOrder(@RequestBody OrderDeliveryTobReqDto orderDeliveryTobReqDto);
}
