package com.dtyunxi.yundt.cube.center.trade.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.OrderDeliveryTobReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.OrderModTobReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

@Api(tags = {"交易中心: B端订单服务"})
@FeignClient(name = "${yundt.cube.center.trade.api.name:yundt-cube-center-trade}", path = "/v1/order", url = "${yundt.cube.center.trade.api:}")
public interface IOrderTobApi {
    /**
     * 支持修改订单的信息
     * @param orderModTobReq
     * @return
     */
    @PutMapping("/modify_all")
    @ApiOperation(value = "修改订单信息", notes = "该接口支持修改订单信息")
    RestResponse<Void> modifyOrderInfo(@RequestBody OrderModTobReqDto orderModTobReq);

    /**
     * 出库
     * @param orderDeliveryTobReqDto
     * @return
     */
    @PostMapping("/outStorage")
    RestResponse<Void> outStorage(@RequestBody OrderDeliveryTobReqDto orderDeliveryTobReqDto);
}
