package com.dtyunxi.yundt.cube.center.trade.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.tob.PayMethodRecordTobRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;

import java.util.List;

@Api(tags = {"交易中心:B端支付服务"})
@FeignClient(name = "${yundt.cube.center.trade.api.name:yundt-cube-center-trade}", path = "/v1/pay", url = "${yundt.cube.center.trade.api:}")
public interface IPayTobApi {
    @PutMapping(value = "/{payNo}/abandon")
    @ApiOperation(value = "废弃收费记录", notes = "废弃收费记录")
    RestResponse<Void> abandonPayRecord(@PathVariable("payNo") String payNo);

    /**
     * 通过订单号查询支付方式对应的支付记录
     *
     * @param orderNo
     * @return
     */
    @GetMapping(value = "/method-list/{orderNo}")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "orderNo", value = "订单流水号 ", dataType = "String", paramType = "path", required = true)})
    @ApiOperation(value = "根据订单流水号查询支付方式对应的支付记录", notes = "根据订单流水号查询支付方式对应的支付记录")
    RestResponse<List<PayMethodRecordTobRespDto>> queryPayMethodRecordByOrderNo(@PathVariable("orderNo") String orderNo);
}
