package com.dtyunxi.yundt.cube.center.trade.api.constants;

/**
 * 售后单状态
 *
 * @author zhuiming
 */
public enum ReturnStatusToBEnum {

    /**
     * 退订单状态
     */
    WAIT_IN_STORAGE("WAIT_IN_STORAGE", "待入库"),
    PART_IN_STORAGE("PART_IN_STORAGE", "部分入库"),
    ALL_IN_STORAGE("ALL_IN_STORAGE", "已入库"),
    WAIT_REFUND("WAIT_REFUND", "待退款"),
    PART_REFUND("PART_REFUND", "部分退款"),
    COMPLETE("COMPLETE", "已完成"),
    CANCEL("CANCEL", "已取消"),
    WAIT_AUDIT("WAIT_AUDIT", "待审核"),

    ;

    private final String code;
    private final String name;

    ReturnStatusToBEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public static ReturnStatusToBEnum fromCode(String status) {
        for (ReturnStatusToBEnum typeEnum : ReturnStatusToBEnum.values()) {
            if (typeEnum.getCode().equals(status)) {
                return typeEnum;
            }
        }
        return null;
    }

    public static String toCode(String status) {
        ReturnStatusToBEnum newEnum = fromCode(status);
        return newEnum == null ? null : newEnum.getCode();
    }

    public static String toName(String status) {
        ReturnStatusToBEnum newEnum = fromCode(status);
        return newEnum == null ? null : newEnum.getName();
    }

    public String getCode() {
        return code;
    }

    public String getName() {
        return name;
    }
}
