package com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob;

import com.dtyunxi.yundt.cube.center.trade.api.dto.request.BaseReqDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;

/**
 * @author: liuji
 * @Date: 2020-11-09 13:47
 * @since 2.0.0
 */
@ApiModel(value = "OptLogReqDto", description = "OptLogReqDto对象")
public class OptLogReqDto extends BaseReqDto {

    /**
     *  主键ID
     *
     */
    @ApiModelProperty(name = "id", value = " 主键ID  ")
    private Long id;

    /**
     *  业务类型(订货单、退订单)
     *
     */
    @ApiModelProperty(name = "bizType", value = " 业务类型(订货单、退订单)  ")
    private String bizType;

    /**
     *  业务单号（订货单号、退订单号）
     *
     */
    @ApiModelProperty(name = "bizNo", value = " 业务单号（订货单号、退订单号）  ")
    private String bizNo;

    /**
     *  操作类型（创建订货单、提交订货单、审核订货单、订货单出库、订货单收款、订货单签收、订货单完成、创建退订单、提交退订单、审核、入库、退订单退款、退订单完成）
     *
     */
    @ApiModelProperty(name = "optType", value = " 操作类型（创建订货单、提交订货单、审核订货单、订货单出库、订货单收款、订货单签收、订货单完成、创建退订单、提交退订单、审核、入库、退订单退款、退订单完成）  ")
    private String optType;

    /**
     *  操作人
     *
     */
    @ApiModelProperty(name = "optPerson", value = " 操作人  ")
    private String optPerson;

    /**
     *  操作时间
     *
     */
    @ApiModelProperty(name = "optTime", value = " 操作时间  ")
    private Date optTime;

    /**
     *  描述
     *
     */
    @ApiModelProperty(name = "Description", value = " 描述  ")
    private String description;

    /**
     *  创建人
     *
     */
    @ApiModelProperty(name = "createPerson", value = " 创建人  ")
    private String createPerson;

    /**
     *  创建时间
     *
     */
    @ApiModelProperty(name = "createTime", value = " 创建时间  ")
    private Date createTime;

    /**
     *  修改人
     *
     */
    @ApiModelProperty(name = "updatePerson", value = " 修改人  ")
    private String updatePerson;

    /**
     *  最近一次修改时间
     *
     */
    @ApiModelProperty(name = "updateTime", value = " 最近一次修改时间  ")
    private Date updateTime;


    public void setId(Long id){
        this.id = id;
    }
    public Long getId(){
        return this.id;
    }

    public void setBizType(String bizType){
        this.bizType = bizType;
    }
    public String getBizType(){
        return this.bizType;
    }

    public void setBizNo(String bizNo){
        this.bizNo = bizNo;
    }
    public String getBizNo(){
        return this.bizNo;
    }

    public void setOptType(String optType){
        this.optType = optType;
    }
    public String getOptType(){
        return this.optType;
    }

    public String getOptPerson() {
        return optPerson;
    }

    public void setOptPerson(String optPerson) {
        this.optPerson = optPerson;
    }

    public void setOptTime(Date optTime){
        this.optTime = optTime;
    }
    public Date getOptTime(){
        return this.optTime;
    }

    public void setDescription(String description){
        this.description = description;
    }
    public String getDescription(){
        return this.description;
    }

    public void setCreatePerson(String createPerson){
        this.createPerson = createPerson;
    }
    public String getCreatePerson(){
        return this.createPerson;
    }

    public void setCreateTime(Date createTime){
        this.createTime = createTime;
    }
    public Date getCreateTime(){
        return this.createTime;
    }

    public void setUpdatePerson(String updatePerson){
        this.updatePerson = updatePerson;
    }
    public String getUpdatePerson(){
        return this.updatePerson;
    }

    public void setUpdateTime(Date updateTime){
        this.updateTime = updateTime;
    }
    public Date getUpdateTime(){
        return this.updateTime;
    }

}
