package com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob;

import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderAddressReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderReqDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * @author: liuji
 * @Date: 2020-11-02 16:51
 * @since 2.0.0
 */
@ApiModel(value = "OrderBReqDto", description = "B端交易订单，创建订单专用")
public class OrderBReqDto extends OrderReqDto{
    @ApiModelProperty(name = "customerId", value = "客户ID")
    private String customerId;
    @ApiModelProperty(name = "deliveryDate", value = "交货日期")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date deliveryDate;
    @ApiModelProperty(name = "placeType", value = "下单方式（经销商下单、代客下单）1:经销商下单 2:代客下单")
    private String placeType;
    @ApiModelProperty(name = "obsoletePerson", value = "作废人")
    private String obsoletePerson;
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(name = "obsoleteTime", value = "作废时间")
    private Date obsoleteTime;
    @ApiModelProperty(name = "obsoleteReason", value = "作废原因")
    private String obsoleteReason;
    @ApiModelProperty(name = "payStatus", value = "收款状态（未收款、部分收款、已收款）")
    private String payStatus;
    @ApiModelProperty(name = "payType", value = "支付类型（在线支付online、线下转账offline）")
    private String payType;

    @ApiModelProperty(name = "creditAccountNo", value = "信用账号编码")
    private String creditAccountNo;

    @ApiModelProperty(name = "attachements", value = "附件列表")
    private List<AttachementReqDto> attachements;

    /**
     * 收票地址
     */
    @ApiModelProperty(name = "invoiceAddress", value = "收票地址")
    private OrderAddressReqDto invoiceAddress;

    public String getPayType() {
        return payType;
    }

    public void setPayType(String payType) {
        this.payType = payType;
    }

    public OrderAddressReqDto getInvoiceAddress() {
        return invoiceAddress;
    }

    public void setInvoiceAddress(OrderAddressReqDto invoiceAddress) {
        this.invoiceAddress = invoiceAddress;
    }

    public String getCustomerId() {
        return customerId;
    }

    public void setCustomerId(String customerId) {
        this.customerId = customerId;
    }

    public Date getDeliveryDate() {
        return deliveryDate;
    }

    public void setDeliveryDate(Date deliveryDate) {
        this.deliveryDate = deliveryDate;
    }

    public String getPlaceType() {
        return placeType;
    }

    public void setPlaceType(String placeType) {
        this.placeType = placeType;
    }

    public String getObsoletePerson() {
        return obsoletePerson;
    }

    public void setObsoletePerson(String obsoletePerson) {
        this.obsoletePerson = obsoletePerson;
    }

    public Date getObsoleteTime() {
        return obsoleteTime;
    }

    public void setObsoleteTime(Date obsoleteTime) {
        this.obsoleteTime = obsoleteTime;
    }

    public String getObsoleteReason() {
        return obsoleteReason;
    }

    public void setObsoleteReason(String obsoleteReason) {
        this.obsoleteReason = obsoleteReason;
    }

    public String getPayStatus() {
        return payStatus;
    }

    public void setPayStatus(String payStatus) {
        this.payStatus = payStatus;
    }

    public List<AttachementReqDto> getAttachements() {
        return attachements;
    }

    public void setAttachements(List<AttachementReqDto> attachements) {
        this.attachements = attachements;
    }

    public String getCreditAccountNo() {
        return creditAccountNo;
    }

    public void setCreditAccountNo(String creditAccountNo) {
        this.creditAccountNo = creditAccountNo;
    }
}
