package com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob;

import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderDeliveryReqDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * @author: liuji
 * @Date: 2020-11-13 09:17
 * @since 2.0.0
 */
@ApiModel(value = "OrderDeliveryTobReqDto", description = "B端发货dto")
public class OrderDeliveryTobReqDto extends OrderDeliveryReqDto {

    @ApiModelProperty(name = "warehouseSerial", value = "出库仓")
    private String warehouseSerial;

    @ApiModelProperty(name = "deliveryItemTobReqDtos", value = "出库明细")
    private List<DeliveryItemTobReqDto> deliveryItemTobReqDtos;

    @ApiModelProperty(name = "shippingTime", value = "物流时间")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date shippingTime;

    @ApiModelProperty(name = "shippingCompanyCode", value = "物流公司编码，" +
            "SF=顺丰、EMS=标准快递、EYB=经济快件、ZJS=宅急送、YTO=圆通、ZTO=中通 (ZTO)、HTKY=百世汇通、BSKY=百世快运、BSKY=百世快运、UC=优速、STO=申通、TTKDEX=天天快递、" +
            "QFKD=全峰、FAST=快捷、POSTB=邮政小包、GTO=国通、YUNDA=韵达、JD=京东配送、DD=当当宅配、AMAZON=亚马逊物流、DBWL=德邦物流、DBKD=德邦快递、DBKY=德邦快运、RRS=日日顺、OTHER=其他，(只传英文编码)")
    private String shippingCompanyCode;

    @ApiModelProperty(name = "shippingCompany", value = "物流公司名称")
    private String shippingCompany;

    @ApiModelProperty(name = "expressCode", value = "物流单号")
    private String expressCode;

    @ApiModelProperty(name = "outStorageIds", value = "出库单号,可多个用逗号隔开")
    private String outStorageIds;

    public Date getShippingTime() {
        return shippingTime;
    }

    public void setShippingTime(Date shippingTime) {
        this.shippingTime = shippingTime;
    }

    @Override
    public String getWarehouseSerial() {
        return warehouseSerial;
    }

    @Override
    public void setWarehouseSerial(String warehouseSerial) {
        this.warehouseSerial = warehouseSerial;
    }

    public List<DeliveryItemTobReqDto> getDeliveryItemTobReqDtos() {
        return deliveryItemTobReqDtos;
    }

    public void setDeliveryItemTobReqDtos(List<DeliveryItemTobReqDto> deliveryItemTobReqDtos) {
        this.deliveryItemTobReqDtos = deliveryItemTobReqDtos;
    }

    public String getShippingCompanyCode() {
        return shippingCompanyCode;
    }

    public void setShippingCompanyCode(String shippingCompanyCode) {
        this.shippingCompanyCode = shippingCompanyCode;
    }

    public String getShippingCompany() {
        return shippingCompany;
    }

    public void setShippingCompany(String shippingCompany) {
        this.shippingCompany = shippingCompany;
    }

    public String getExpressCode() {
        return expressCode;
    }

    public void setExpressCode(String expressCode) {
        this.expressCode = expressCode;
    }

    public String getOutStorageIds() {
        return outStorageIds;
    }

    public void setOutStorageIds(String outStorageIds) {
        this.outStorageIds = outStorageIds;
    }
}
