package com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.Date;
import java.util.List;

@ApiModel(value = "OrderStatisticsReqDto", description = "业务员订单统计")
public class OrderStatisticsReqDto extends RequestDto {
    @ApiModelProperty(name = "salesmanId", value = "业务员id")
    @NotNull(message = "业务员id不能为空")
    private String salesmanId;

    @ApiModelProperty(name = "startTime", value = "开始时间")
    @NotNull(message = "开始时间不能为空")
    private Date startTime;

    @ApiModelProperty(name = "endTime", value = "结束时间")
    @NotNull(message = "结束时间不能为空")
    private Date endTime;

    @ApiModelProperty(name = "customerIds", value = "客户id集合")
    @NotEmpty(message = "客户id集合不能为空")
    private List<String> customerIds;

    @ApiModelProperty(name = "type", value = "查询类型0：首页查询，1：详细查询")
    private String type = "0";

    @ApiModelProperty(name = "sortFiled", value = "排序字段：0：订单金额，1：最后下单时间，默认订单金额排序")
    private String sortFiled = "0";

    @ApiModelProperty(name = "sortType", value = "排序类型：0：降序，1：升序，默认降序")
    private String sortType = "0";

    /**
     * 每页数
     */
    @ApiModelProperty(name = "pageSize", value = "每页数，默认10")
    private Integer pageSize=10;

    /**
     * 页码
     */
    @ApiModelProperty(name = "pageNum", value = "页码，默认1")
    private Integer pageNum=1;

    public String getSalesmanId() {
        return salesmanId;
    }

    public void setSalesmanId(String salesmanId) {
        this.salesmanId = salesmanId;
    }

    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public List<String> getCustomerIds() {
        return customerIds;
    }

    public void setCustomerIds(List<String> customerIds) {
        this.customerIds = customerIds;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getSortFiled() {
        return sortFiled;
    }

    public void setSortFiled(String sortFiled) {
        this.sortFiled = sortFiled;
    }

    public String getSortType() {
        return sortType;
    }

    public void setSortType(String sortType) {
        this.sortType = sortType;
    }
}
