package com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob;

import com.dtyunxi.yundt.cube.center.trade.api.dto.request.PayMethodReqDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @author: liuji
 * @Date: 2020-11-05 15:01
 * @since 2.0.0
 */
@ApiModel(value = "PayMethodTobReqDto", description = "修改支付方式")
public class PayMethodTobReqDto extends PayMethodReqDto{

    /**
     * 付款时间
     */
    @ApiModelProperty(name = "payTime", value = "付款时间")
    @DateTimeFormat(pattern="yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date payTime;

    /**
     * 确认时间
     */
    @ApiModelProperty(name = "confirmTime", value = "确认时间")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date confirmTime;

    /**
     * 备注
     */
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;

    /**
     * 收款账户
     */
    @ApiModelProperty(name = "account", value = "收款账户")
    private String account;

    /**
     * 储值付款金额
     */
    @ApiModelProperty(name = "storeAmout", value = "储值付款金额")
    private BigDecimal storeAmount;

    @ApiModelProperty(name = "creditAmout", value = "信用付款金额")
    private BigDecimal creditAmount;

    @ApiModelProperty(name = "payAmount", value = "付款金额")
    private BigDecimal payAmount;

    @ApiModelProperty(name = "attachements", value = "附件列表")
    private List<AttachementReqDto> attachements;

    public Date getPayTime() {
        return payTime;
    }

    public void setPayTime(Date payTime) {
        this.payTime = payTime;
    }

    public Date getConfirmTime() {
        return confirmTime;
    }

    public void setConfirmTime(Date confirmTime) {
        this.confirmTime = confirmTime;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getAccount() {
        return account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public BigDecimal getStoreAmount() {
        return storeAmount;
    }

    public void setStoreAmount(BigDecimal storeAmount) {
        this.storeAmount = storeAmount;
    }

    public BigDecimal getCreditAmount() {
        return creditAmount;
    }

    public void setCreditAmount(BigDecimal creditAmount) {
        this.creditAmount = creditAmount;
    }

    public List<AttachementReqDto> getAttachements() {
        return attachements;
    }

    public void setAttachements(List<AttachementReqDto> attachements) {
        this.attachements = attachements;
    }

    public BigDecimal getPayAmount() {
        return payAmount;
    }

    public void setPayAmount(BigDecimal payAmount) {
        this.payAmount = payAmount;
    }
}
