package com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob;

import com.dtyunxi.yundt.cube.center.trade.api.dto.request.BaseReqDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;

/**
 * @author: liuji
 * @Date: 2020-11-20 15:51
 * @since 2.0.0
 */
@ApiModel(value = "RefundDetailTobReqDto", description = "退款明细对象")
public class RefundDetailTobReqDto extends BaseReqDto {

    @ApiModelProperty(name = "refundAmount", value = "本次退款金额")
    private BigDecimal refundAmount;

    @ApiModelProperty(name = "payMethod", value = "支付方式")
    private String payMethod;

    @ApiModelProperty(name = "payAmount", value = "支付金额")
    private BigDecimal payAmount;

    @ApiModelProperty(name = "refundedAmount", value = "已退款金额")
    private BigDecimal refundedAmount;

    public String getPayMethod() {
        return payMethod;
    }

    public void setPayMethod(String payMethod) {
        this.payMethod = payMethod;
    }

    public BigDecimal getPayAmount() {
        return payAmount;
    }

    public void setPayAmount(BigDecimal payAmount) {
        this.payAmount = payAmount;
    }

    public BigDecimal getRefundedAmount() {
        return refundedAmount;
    }

    public void setRefundedAmount(BigDecimal refundedAmount) {
        this.refundedAmount = refundedAmount;
    }

    public BigDecimal getRefundAmount() {
        return refundAmount;
    }

    public void setRefundAmount(BigDecimal refundAmount) {
        this.refundAmount = refundAmount;
    }
}
