package com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob;

import com.dtyunxi.yundt.cube.center.trade.api.dto.request.RefundReqDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * @author: liuji
 * @Date: 2020-11-20 11:10
 * @since 2.0.0
 */
@ApiModel(value = "RefundTobReqDto", description = "B端订单退款申请")
public class RefundTobReqDto extends RefundReqDto {

    @ApiModelProperty(name = "returnNo", value = "退货交易号 returnNo")
    private String returnNo;

    @ApiModelProperty(name = "refundPerson", value = "退款执行人")
    private String refundPerson;

    @ApiModelProperty(name = "refundPerson", value = "备注")
    private String remark;

    @ApiModelProperty(name = "attachements", value = "附件列表")
    private List<AttachementReqDto> attachements;

    @ApiModelProperty(name = "refundDetails", value = "退款明细详情")
    private List<RefundDetailTobReqDto> refundDetails;

    @Override
    public String getReturnNo() {
        return returnNo;
    }

    @Override
    public void setReturnNo(String returnNo) {
        this.returnNo = returnNo;
    }

    public String getRefundPerson() {
        return refundPerson;
    }

    public void setRefundPerson(String refundPerson) {
        this.refundPerson = refundPerson;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public List<AttachementReqDto> getAttachements() {
        return attachements;
    }

    public void setAttachements(List<AttachementReqDto> attachements) {
        this.attachements = attachements;
    }

    public List<RefundDetailTobReqDto> getRefundDetails() {
        return refundDetails;
    }

    public void setRefundDetails(List<RefundDetailTobReqDto> refundDetails) {
        this.refundDetails = refundDetails;
    }
}
