package com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob;

import com.dtyunxi.yundt.cube.center.trade.api.dto.request.BaseReqDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;

/**
 * @author: liuji
 * @Date: 2020-11-18 19:56
 * @since 2.0.0
 */
@ApiModel(value = "ReturnAuditReqDto", description = "售后审核Dto")
public class ReturnAuditReqDto extends BaseReqDto {

    @ApiModelProperty(name = "returnNo", value = "退货交易号 returnNo")
    private String returnNo;

    @ApiModelProperty(name = "refundNo", value = "退款号")
    private String refundNo;

    @ApiModelProperty(name = "auditType", value = "审核类型（1:客服审核、2:财务审核、3：退货审核、4：退款审核）,默认是客服审核")
    private String auditType;

    @ApiModelProperty(name = "auditStatus", value = "审核状态（pass:通过、reject:不通过）")
    private String auditStatus;

    @ApiModelProperty(name = "auditTime", value = "审核时间")
    private Date auditTime;

    @ApiModelProperty(name = "auditDesc", value = "审核说明")
    private String auditDesc;

    @ApiModelProperty(name = "auditor", value = "审核人")
    private String auditor;

    public String getReturnNo() {
        return returnNo;
    }

    public void setReturnNo(String returnNo) {
        this.returnNo = returnNo;
    }

    public String getAuditType() {
        return auditType;
    }

    public void setAuditType(String auditType) {
        this.auditType = auditType;
    }

    public String getAuditStatus() {
        return auditStatus;
    }

    public void setAuditStatus(String auditStatus) {
        this.auditStatus = auditStatus;
    }

    public Date getAuditTime() {
        return auditTime;
    }

    public void setAuditTime(Date auditTime) {
        this.auditTime = auditTime;
    }

    public String getAuditDesc() {
        return auditDesc;
    }

    public void setAuditDesc(String auditDesc) {
        this.auditDesc = auditDesc;
    }

    public String getAuditor() {
        return auditor;
    }

    public void setAuditor(String auditor) {
        this.auditor = auditor;
    }

    public String getRefundNo() {
        return refundNo;
    }

    public void setRefundNo(String refundNo) {
        this.refundNo = refundNo;
    }
}
