package com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob;

import com.dtyunxi.yundt.cube.center.trade.api.dto.request.ReturnReqDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @author: liuji
 * @Date: 2020-11-17 17:03
 * @since 2.0.0
 */
@ApiModel(value = "ReturnTobReqDto", description = "订单退货申请")
public class ReturnTobReqDto extends ReturnReqDto{

    @ApiModelProperty(name = "refundStatus", value = "退款状态（待退款、部分退款、已退款）")
    private String refundStatus;

    @ApiModelProperty(name = "totalAmount", value = "退款合计金额")
    private BigDecimal totalAmount;

    @ApiModelProperty(name = "placeUserId", value = "下单人")
    private String placeUserId;

    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(name = "placeTime", value = "下单时间")
    private Date placeTime;

    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;

    @ApiModelProperty(name = "returnDesc", value = "退款信息")
    private String returnDesc;

    @ApiModelProperty(name = "attachements", value = "附件列表")
    private List<AttachementReqDto> attachements;

    @ApiModelProperty(name = "customerId", value = "客户ID")
    private String customerId;

    public String getRefundStatus() {
        return refundStatus;
    }

    public void setRefundStatus(String refundStatus) {
        this.refundStatus = refundStatus;
    }

    public BigDecimal getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    public String getPlaceUserId() {
        return placeUserId;
    }

    public void setPlaceUserId(String placeUserId) {
        this.placeUserId = placeUserId;
    }

    public Date getPlaceTime() {
        return placeTime;
    }

    public void setPlaceTime(Date placeTime) {
        this.placeTime = placeTime;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getReturnDesc() {
        return returnDesc;
    }

    public void setReturnDesc(String returnDesc) {
        this.returnDesc = returnDesc;
    }

    public List<AttachementReqDto> getAttachements() {
        return attachements;
    }

    public void setAttachements(List<AttachementReqDto> attachements) {
        this.attachements = attachements;
    }

    public String getCustomerId() {
        return customerId;
    }

    public void setCustomerId(String customerId) {
        this.customerId = customerId;
    }
}
