
/*
 * @(#) PayRecordRespDto.java 1.0 2018-09-21
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.trade.api.dto.response.tob;

import com.dtyunxi.yundt.cube.center.trade.api.dto.response.BaseRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 支付方式对应的支付记录 RespDto
 *
 * @author zhuiming
 * @since 2.0.0
 */
@ApiModel(value = "PayMethodRecordTobRespDto", description = "支付方式对应的支付记录")
public class PayMethodRecordTobRespDto {

    /**
     * 支付方式
     */
    @ApiModelProperty(name = "payMethod", value = "支付方式")
    private String payMethod;
    /**
     * 支付金额
     */
    @ApiModelProperty(name = "payAmount", value = "支付金额")
    private BigDecimal payAmount;
    /**
     *已退金额
     */
    @ApiModelProperty(name = "alreadyReturnAmount", value = "已退金额")
    private BigDecimal alreadyReturnAmount;

    public String getPayMethod() {
        return payMethod;
    }

    public void setPayMethod(String payMethod) {
        this.payMethod = payMethod;
    }

    public BigDecimal getPayAmount() {
        return payAmount;
    }

    public void setPayAmount(BigDecimal payAmount) {
        this.payAmount = payAmount;
    }

    public BigDecimal getAlreadyReturnAmount() {
        return alreadyReturnAmount;
    }

    public void setAlreadyReturnAmount(BigDecimal alreadyReturnAmount) {
        this.alreadyReturnAmount = alreadyReturnAmount;
    }
}
