package com.dtyunxi.yundt.cube.center.trade.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.tob.ReturnCountTobRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Api(tags = {"交易中心: B端售后单查询服务"})
@FeignClient(name = "${yundt.cube.center.trade.api.name:yundt-cube-center-trade}", path = "/v1/afterSales", url = "${yundt.cube.center.trade.api:}")
public interface IAfterSalesQueryTobApi {

    /**
     * B端统计不同状态售后单的数量
     *
     * @param filter
     * @return
     */
    @GetMapping("/return/status/count")
    @ApiOperation(value = "B端统计客户不同状态售后单数量", notes = "B端统计客户不同状态售后单数量")
    RestResponse<ReturnCountTobRespDto> queryReturnCountTob(@RequestParam(name = "filter") String filter);
}
