package com.dtyunxi.yundt.cube.center.trade.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.OrderStatisticsReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.tob.OrderStatisticsRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;

@Api(tags = {"交易中心: B端订单查询服务"})
@FeignClient(name = "${yundt.cube.center.trade.api.name:yundt-cube-center-trade}", path = "/v1/order", url = "${yundt.cube.center.trade.api:}")
public interface IOrderQueryTobApi {

    /**
     * 根据客户id统计订单信息
     * @param orderStatisticsReqDto
     * @return
     */
    @PostMapping("/statistics_with_cust")
    @ApiOperation(value="根据客户id统计订单信息" , notes = "根据客户id统计订单信息")
    RestResponse<PageInfo<OrderStatisticsRespDto>> statisticsOrder(@Valid @RequestBody OrderStatisticsReqDto orderStatisticsReqDto);
}
