package com.dtyunxi.yundt.cube.center.trade.api.tob;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.AttachementReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

/**
 * @author: liuji
 * @Date: 2020-11-09 16:59
 * @since 2.0.0
 */
@Api(tags = {"交易中心:附件服务"})
@FeignClient(name = "${yundt.cube.center.trade.api.name:yundt-cube-center-trade}", path = "/v1/attachement", url = "${yundt.cube.center.trade.api:}")
public interface IAttachementApi {

    /**
     * 新增附件
     *
     * @param attachementDto 附件请求对象
     * @return 处理结果
     */
    @PostMapping("/add")
    @ApiOperation(value = "新增附件", notes = "新增附件")
    RestResponse<Long> addAttachement(@RequestBody AttachementReqDto attachementDto);

    /**
     * 修改附件
     *
     * @param attachementDto 附件请求对象
     * @return 处理结果
     */
    @PutMapping("/modify")
    @ApiOperation(value = "修改附件", notes = "修改附件")
    RestResponse<Void> modifyAttachement(@RequestBody AttachementReqDto attachementDto);

    /**
     * 删除附件
     *
     * @param ids        附件删除数据ID
     * @return 处理结果
     */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除附件", notes = "删除附件")
    RestResponse<Void> removeAttachement(@PathVariable("ids") String ids );

}