package com.dtyunxi.yundt.cube.center.trade.api.tob;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.OptLogReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

/**
 * @author: liuji
 * @Date: 2020-11-09 13:42
 * @since 2.0.0
 */
@Api(tags = {"交易中心:订货、退货操作日志服务"})
@FeignClient(name = "${yundt.cube.center.trade.api.name:yundt-cube-center-trade}", path = "/v1/optLog", url = "${yundt.cube.center.trade.api:}")
public interface IOptLogApi {

    /**
     * 新增订货、退货操作日志
     *
     * @param optLogDto 订货、退货操作日志请求对象
     * @return 处理结果
     */
    @PostMapping("/add")
    @ApiOperation(value = "新增订货、退货操作日志", notes = "新增订货、退货操作日志")
    RestResponse<Long> addBoOptLog(@RequestBody OptLogReqDto optLogDto);

    /**
     * 修改订货、退货操作日志
     *
     * @param optLogDto 订货、退货操作日志请求对象
     * @return 处理结果
     */
    @PutMapping("/modify")
    @ApiOperation(value = "修改订货、退货操作日志", notes = "修改订货、退货操作日志")
    RestResponse<Void> modifyBoOptLog(@RequestBody OptLogReqDto optLogDto);

    /**
     * 删除订货、退货操作日志
     *
     * @param ids        订货、退货操作日志删除数据ID
     * @return 处理结果
     */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除订货、退货操作日志", notes = "删除订货、退货操作日志")
    RestResponse<Void> removeBoOptLog(@PathVariable("ids") String ids );

}
