package com.dtyunxi.yundt.cube.center.trade.api.tob.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.AttachementReqDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author: liuji
 * @Date: 2020-11-09 17:13
 * @since 2.0.0
 */
@Api(tags = {"交易中心:附件查询服务"})
@FeignClient(name = "${yundt.cube.center.trade.api.name:yundt-cube-center-trade}", path = "/v1/attachement", url = "${yundt.cube.center.trade.api:}")
public interface IAttachementQueryApi {

    /**
     * 根据id查询附件
     *
     * @param id 附件id
     * @return   附件数据
     */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询附件", notes = "根据id查询附件")
    RestResponse<AttachementReqDto> queryById(@PathVariable("id") Long id);

    /**
     * 根据idS查询附件
     *
     * @return   附件数据
     */
    @PostMapping("/queryByIds")
    @ApiOperation(value = "根据ids查询附件", notes = "根据ids查询附件")
    RestResponse<List<AttachementReqDto>> queryByIds(@RequestBody List<Long> attachementIds);

    /**
     * 附件分页数据
     *
     * @param attachementReqDto  附件查询条件
     * @param pageNum  当前页
     * @param pageSize 页大小
     * @return 附件分页数据
     */
    @GetMapping("/page")
    @ApiOperation(value = "附件分页数据", notes = "根据filter查询条件查询附件数据，filter=attachementDto")
    RestResponse<PageInfo<AttachementReqDto>> queryByPage(@SpringQueryMap AttachementReqDto attachementReqDto
            , @RequestParam(name = "pageNum", defaultValue = "1") Integer pageNum
            , @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize);


    /**
     * 根据业务号和业务类型查询附件
     * @param bizNo
     * @param bizType
     * @return
     */
    @GetMapping("/queryByNoAndType")
    @ApiOperation(value = "根据业务号和业务类型查询附件", notes = "根据业务号和业务类型查询数据")
    RestResponse<List<AttachementReqDto>> queryByNoAndType(@RequestParam(name = "bizNo") String bizNo,@RequestParam(name = "bizType") String bizType);

}
