package com.dtyunxi.yundt.cube.center.trade.api.tob.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.OptLogReqDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author: liuji
 * @Date: 2020-11-09 13:51
 * @since 2.0.0
 */
@Api(tags = {"交易中心:订货、退货操作日志查询服务"})
@FeignClient(name = "${yundt.cube.center.trade.api.name:yundt-cube-center-trade}", path = "/v1/optLog", url = "${yundt.cube.center.trade.api:}")
public interface IOptLogQueryApi {

    /**
     * 根据id查询订货、退货操作日志
     *
     * @param id 订货、退货操作日志id
     * @return   订货、退货操作日志数据
     */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询订货、退货操作日志", notes = "根据id查询订货、退货操作日志")
    RestResponse<OptLogReqDto> queryById(@PathVariable("id") Long id);

    /**
     * 根据idS查询订货、退货操作日志
     *
     * @param optLogIds 配件id
     * @return   订货、退货操作日志数据
     */
    @PostMapping("/queryByIds")
    @ApiOperation(value = "根据ids查询订货、退货操作日志", notes = "根据ids查询订货、退货操作日志")
    RestResponse<List<OptLogReqDto>> queryByIds(@RequestBody List<Long> optLogIds);

    /**
     * 订货、退货操作日志分页数据
     *
     * @param optLogReqDto   订货、退货操作日志查询条件
     * @param pageNum  当前页
     * @param pageSize 页大小
     * @return 订货、退货操作日志分页数据
     */
    @GetMapping("/page")
    @ApiOperation(value = "订货、退货操作日志分页数据", notes = "根据filter查询条件查询订货、退货操作日志数据，filter=boOptLogDto")
    RestResponse<PageInfo<OptLogReqDto>> queryByPage(@SpringQueryMap OptLogReqDto optLogReqDto
            , @RequestParam(name = "pageNum", defaultValue = "1") Integer pageNum
            , @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize);

    /**
     * 根据业务号和业务类型查询操作日志
     * @param bizNo
     * @param bizType
     * @return
     */
    @GetMapping("/queryByNoAndType")
    @ApiOperation(value = "根据业务号和业务类型查询操作日志", notes = "根据业务号和业务类型查询操作日志")
    RestResponse<List<OptLogReqDto>> queryByNoAndType(@RequestParam(name = "bizNo") String bizNo, @RequestParam(name = "bizType") String bizType);

}