/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.flow.action;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.enhance.flow.ActionNode;
import com.dtyunxi.cube.enhance.flow.ActionNodeComponent;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.IStorageOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.api.constants.StorageCategoryEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.StorageOrderCreateDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.StorageOrderDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.StorageOrderReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopBaseDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISellerQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.constants.BasicConfigEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.OptTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.tob.OptBizTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.DeliveryItemTobReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.OrderDeliveryTobReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.BasicConfigRespDto;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.action.ReturnFlowTobAction;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.dto.OrderBo;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.dto.OrderPayedEvent;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IBasicConfigService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.tob.IOptLogService;
import com.dtyunxi.yundt.cube.center.trade.conf.ext.domain.OrderDeliveryCreateTobBo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderEo;
import com.dtyunxi.yundt.cube.center.trade.ext.api.constants.OrderBizStatusTobEnum;
import com.dtyunxi.yundt.cube.center.trade.ext.order.domain.CheckOutStorageBo;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@ActionNodeComponent
@Service(value="orderFlowTobAction")
public class OrderFlowTobAction {
    private static Logger logger = LoggerFactory.getLogger(ReturnFlowTobAction.class);
    @Resource
    private IStorageOrderApi storageOrderApi;
    @Resource
    private IOptLogService optLogService;
    @Autowired
    private IBasicConfigService basicConfigService;
    @Resource
    private IOrganizationQueryApi organizationQueryApi;
    @Autowired
    private ICustomerExtQueryApi customerExtQueryApi;
    @Autowired
    private IContext context;
    @Autowired
    private IShopQueryApi shopQueryApi;
    @Autowired
    private ISellerQueryApi sellerQueryApi;

    @ActionNode(entity=OrderEo.class, name="\u51fa\u5e93")
    @Transactional
    public OrderDeliveryCreateTobBo outStorage(OrderDeliveryCreateTobBo orderDeliveryCreateBo) {
        OrderDeliveryTobReqDto orderDeliveryTobReqDto = orderDeliveryCreateBo.getOrderDeliveryTobReqDto();
        StorageOrderCreateDto requestDto = new StorageOrderCreateDto();
        StorageOrderReqDto storageOrderReqDto = new StorageOrderReqDto();
        CubeBeanUtils.copyProperties((Object)storageOrderReqDto, (Object)orderDeliveryTobReqDto, (String[])new String[0]);
        storageOrderReqDto.setWarehouseId(StringUtils.isEmpty((String)orderDeliveryTobReqDto.getWarehouseSerial()) ? null : Long.valueOf(Long.parseLong(orderDeliveryTobReqDto.getWarehouseSerial())));
        storageOrderReqDto.setOrderNo(orderDeliveryTobReqDto.getOrderNo());
        storageOrderReqDto.setBusinessId(orderDeliveryTobReqDto.getOrderNo());
        storageOrderReqDto.setType(Integer.valueOf(3));
        storageOrderReqDto.setCategory(StorageCategoryEnum.CATEGORY_OUT.getCategory());
        requestDto.setStorageOrderReqDto(storageOrderReqDto);
        List storageOrderDetailReqDtos = orderDeliveryTobReqDto.getDeliveryItemTobReqDtos().stream().map(bean -> {
            StorageOrderDetailReqDto storageOrderDetailReqDto = new StorageOrderDetailReqDto();
            storageOrderDetailReqDto.setNum(Long.valueOf(bean.getItemNum().intValue()));
            storageOrderDetailReqDto.setWarehouseId(StringUtils.isEmpty((String)orderDeliveryTobReqDto.getWarehouseSerial()) ? null : Long.valueOf(Long.parseLong(orderDeliveryTobReqDto.getWarehouseSerial())));
            if (StringUtils.isNotEmpty((String)bean.getCargoSerial())) {
                storageOrderDetailReqDto.setCargoId(Long.valueOf(Long.parseLong(bean.getCargoSerial())));
            }
            storageOrderDetailReqDto.setStatus("VERIFIED");
            HashMap<String, String> extFields = new HashMap<String, String>();
            extFields.put("extension", bean.getSkuSerial() + "_" + bean.getGift());
            storageOrderDetailReqDto.setExtFields(extFields);
            return storageOrderDetailReqDto;
        }).collect(Collectors.toList());
        requestDto.setStorageOrderDetailReqDtoList(storageOrderDetailReqDtos);
        this.storageOrderApi.addStorageOrder(requestDto);
        return orderDeliveryCreateBo;
    }

    @ActionNode(entity=OrderEo.class, name="\u5224\u65ad\u662f\u5426\u5168\u90e8\u51fa\u5e93")
    @Transactional
    public CheckOutStorageBo checkOutStorage(OrderDeliveryCreateTobBo createBo) {
        OrderDeliveryTobReqDto orderDeliveryTobReqDto;
        CheckOutStorageBo checkOutStorageBo = new CheckOutStorageBo();
        boolean flag = true;
        String result = "part";
        OrderEo orderEo = createBo.getOrderEo();
        if (null != orderEo) {
            String orderTradeStatus = orderEo.getOrderTradeStatus();
            if (OrderBizStatusTobEnum.ALL_OUT_STORAGE.getCode().equals(orderTradeStatus) || OrderBizStatusTobEnum.PART_DELIVERY.getCode().equals(orderTradeStatus) || OrderBizStatusTobEnum.ALL_DELIVERY.getCode().equals(orderTradeStatus) || OrderBizStatusTobEnum.PART_CONFIRM.getCode().equals(orderTradeStatus) || OrderBizStatusTobEnum.CONFIRM.getCode().equals(orderTradeStatus)) {
                checkOutStorageBo.setResult("default");
                checkOutStorageBo.setOrderNo(orderEo.getOrderNo());
                return checkOutStorageBo;
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(orderDeliveryTobReqDto = createBo.getOrderDeliveryTobReqDto()).getDeliveryItemTobReqDtos())) {
            for (DeliveryItemTobReqDto bean : orderDeliveryTobReqDto.getDeliveryItemTobReqDtos()) {
                if (bean.getPayNum() == bean.getDeliveredNum() + bean.getItemNum()) continue;
                flag = false;
                break;
            }
        }
        if (flag) {
            result = "all";
        }
        checkOutStorageBo.setResult(result);
        checkOutStorageBo.setOrderNo(createBo.getOrderEo().getOrderNo());
        return checkOutStorageBo;
    }

    @ActionNode(entity=OrderEo.class, name="\u5168\u90e8\u53d1\u8d27")
    public OrderBo deliveryForAll(OrderBo orderBo) {
        orderBo.getOrderEo().setUpdateTime(new Date());
        orderBo.getOrderEo().setDeliveryTime(new Date());
        this.optLogService.saveOptLog(OptBizTypeEnum.ORDER.getType(), orderBo.getOrderEo().getOrderNo(), OptTypeEnum.DELIVERY_ORDER_DELIVER.getType(), "\u3010\u5f85\u6536\u8d27\u3011\u8ba2\u8d27\u5355\u5df2\u53d1\u8d27\uff0c\u8bf7\u7559\u610f\u6536\u8d27\uff0c\u53ef\u5230\u8ba2\u5355\u5217\u8868\u67e5\u770b\u53d1\u8d27\u6e05\u5355");
        return orderBo;
    }

    @ActionNode(entity=OrderEo.class, name="\u5224\u65ad\u662f\u5426\u81ea\u52a8\u5ba2\u670d\u5ba1\u6838")
    public String isCSAudit(OrderPayedEvent payedEvent) {
        logger.info("\u5224\u65ad\u662f\u5426\u81ea\u52a8\u5ba2\u670d\u5ba1\u6838,action\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)payedEvent));
        OrderEo orderEo = payedEvent.getOrderEo();
        ShopBaseDto shopBaseDto = (ShopBaseDto)RestResponseHelper.extractData((RestResponse)this.shopQueryApi.queryBaseById(Long.valueOf(orderEo.getShopId())));
        if (shopBaseDto == null) {
            return "FALSE";
        }
        SellerRespDto sellerRespDto = (SellerRespDto)RestResponseHelper.extractData((RestResponse)this.sellerQueryApi.queryById(shopBaseDto.getSellerId()));
        if (sellerRespDto == null) {
            return "FALSE";
        }
        logger.info("\u5224\u65ad\u662f\u5426\u81ea\u52a8\u5ba2\u670d\u5ba1\u6838\uff0c\u5ba2\u6237\u5bf9\u5e94\u7ec4\u7ec7id\u4fe1\u606f\uff1a{}", (Object)sellerRespDto.getOrganizationId());
        if (sellerRespDto.getOrganizationId() == null) {
            return "FALSE";
        }
        BasicConfigRespDto basicConfigRespDto = this.basicConfigService.queryByCodeAndType(BasicConfigEnum.CREATE_ORDER_CS_AUDIT.getCode(), BasicConfigEnum.CREATE_ORDER_CS_AUDIT.getType(), sellerRespDto.getOrganizationId());
        return basicConfigRespDto != null && "2".equals(basicConfigRespDto.getValue()) ? "TRUE" : "FALSE";
    }

    @ActionNode(entity=OrderEo.class, name="\u5224\u65ad\u662f\u5426\u81ea\u52a8\u8d22\u52a1\u5ba1\u6838")
    public String isFinanceAudit(OrderPayedEvent payedEvent) {
        logger.info("\u5224\u65ad\u662f\u5426\u81ea\u52a8\u8d22\u52a1\u5ba1\u6838,action\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)payedEvent));
        OrderEo orderEo = payedEvent.getOrderEo();
        ShopBaseDto shopBaseDto = (ShopBaseDto)RestResponseHelper.extractData((RestResponse)this.shopQueryApi.queryBaseById(Long.valueOf(orderEo.getShopId())));
        if (shopBaseDto == null) {
            return "FALSE";
        }
        SellerRespDto sellerRespDto = (SellerRespDto)RestResponseHelper.extractData((RestResponse)this.sellerQueryApi.queryById(shopBaseDto.getSellerId()));
        if (sellerRespDto == null) {
            return "FALSE";
        }
        logger.info("\u5224\u65ad\u662f\u5426\u81ea\u52a8\u8d22\u52a1\u5ba1\u6838\uff0c\u5ba2\u6237\u5bf9\u5e94\u7ec4\u7ec7id\u4fe1\u606f\uff1a{}", (Object)sellerRespDto.getOrganizationId());
        if (sellerRespDto.getOrganizationId() == null) {
            return "FALSE";
        }
        BasicConfigRespDto basicConfigRespDto = this.basicConfigService.queryByCodeAndType(BasicConfigEnum.CREATE_ORDER_FINANCE_AUDIT.getCode(), BasicConfigEnum.CREATE_ORDER_FINANCE_AUDIT.getType(), sellerRespDto.getOrganizationId());
        return basicConfigRespDto != null && "2".equals(basicConfigRespDto.getValue()) ? "TRUE" : "FALSE";
    }
}

