/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.mq.process;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.api.IOrderApi;
import com.dtyunxi.yundt.cube.center.trade.api.constants.OrderCancelTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.CancelReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.query.IPayQueryApi;
import com.dtyunxi.yundt.cube.center.trade.biz.mq.vo.OrderCloseMessageVo;
import com.dtyunxi.yundt.cube.center.trade.biz.service.extl.IContextService;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderEo;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class B2BOrderCloseProcessor
implements IMessageProcessor<OrderCloseMessageVo> {
    private static final Logger logger = LoggerFactory.getLogger(B2BOrderCloseProcessor.class);
    @Resource(name="payQueryApiImpl")
    private IPayQueryApi iPayQueryApi;
    @Resource(name="orderApiImpl")
    private IOrderApi orderApi;
    @Resource
    private IContext context;
    @Resource
    private IContextService contextService;

    public MessageResponse process(OrderCloseMessageVo message) {
        logger.info("\u8ba2\u5355\u5173\u95ed\u6d88\u606f\u5904\u7406: {}", (Object)JSON.toJSONString((Object)message));
        if (message.getInstanceId() != null) {
            this.contextService.getAndSetInstanceInfo(Long.valueOf(message.getInstanceId()));
        } else if (message.getAppKey() != null) {
            this.contextService.getAndSetInstanceInfo(Long.valueOf(message.getAppKey()));
        }
        try {
            if (message != null) {
                String orderTradeNum = message.getOrderTradeNum();
                logger.info("\u8d85\u65f6\u5173\u95ed\u4fee\u590d\u8ba2\u5355\u72b6\u6001,\u8ba2\u5355\u53f7={}", (Object)orderTradeNum);
                JSONObject json = new JSONObject();
                json.put("instanceId", (Object)this.context.instanceId());
                json.put("tenantId", (Object)this.context.tenantId());
                json.put("orderNo", (Object)orderTradeNum);
                RestResponse payRecordRespDtoRestResponse = this.iPayQueryApi.queryByPage(json.toJSONString(), Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE));
                List list = ((PageInfo)RestResponseHelper.extractData((RestResponse)payRecordRespDtoRestResponse)).getList();
                logger.info("\u83b7\u53d6\u6240\u6709\u652f\u4ed8\u8bb0\u5f55,\u4ed8\u6b3e\u8bb0\u5f55[{}]", (Object)JSON.toJSONString((Object)list));
                ArrayList paySuccess = CollectionUtils.isEmpty((Collection)list) ? new ArrayList() : list.stream().filter(data -> "SUCCESS".equals(data.getPayStatus())).collect(Collectors.toList());
                logger.info("\u6210\u529f\u652f\u4ed8\u8bb0\u5f55,\u4ed8\u6b3e\u8bb0\u5f55[{}]", (Object)JSON.toJSONString(paySuccess));
                if (CollectionUtils.isEmpty(paySuccess)) {
                    this.contextService.getAndSetInstanceInfo(message.getInstanceId());
                    CancelReqDto cancelReqDto = new CancelReqDto();
                    cancelReqDto.setCancelType(OrderCancelTypeEnum.SYSTEM_CANCLE.getName());
                    cancelReqDto.setCancelDesc("\u8ba2\u5355\u8fc7\u671f\u81ea\u52a8\u53d6\u6d88");
                    logger.info("[\u6267\u884c\u53d6\u6d88\u8ba2\u5355],\u4ed8\u6b3e\u8bb0\u5f55orderTradeNum[{}],cancelReqDto[{}]", (Object)orderTradeNum, (Object)JSON.toJSONString((Object)cancelReqDto));
                    this.orderApi.cancelOrder(orderTradeNum, cancelReqDto);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u5904\u7406\u5173\u95ed\u8ba2\u5355\u7684\u6d88\u606f\u5931\u8d25: {}", (Object)e.getMessage(), (Object)e);
            return MessageResponse.ERROR;
        }
        return MessageResponse.SUCCESS;
    }

    private void releaseCouponAndInventoryBeforePay(OrderEo orderEo) {
        String orderNo = orderEo.getOrderNo();
        this.contextService.getAndSetInstanceInfo(orderEo.getInstanceId());
        CancelReqDto cancelReqDto = new CancelReqDto();
        cancelReqDto.setCancelType(OrderCancelTypeEnum.BUYER_CANCLE.getName());
        cancelReqDto.setCancelDesc("\u8ba2\u5355\u8fc7\u671f\u81ea\u52a8\u53d6\u6d88");
        this.orderApi.cancelOrder(orderNo, cancelReqDto);
    }
}

