/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.service.tob.query.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.yundt.cube.center.trade.api.constants.IndexQueryConstant;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.IndexQueryReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.OrderTobReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.tob.CategoryRankingRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.tob.ItemRankingRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.tob.SalesOverViewRespDto;
import com.dtyunxi.yundt.cube.center.trade.biz.service.tob.query.IOrderTobQueryService;
import com.dtyunxi.yundt.cube.center.trade.dao.das.OrderTobDas;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class OrderTobQueryServiceImpl
implements IOrderTobQueryService {
    private static final Logger logger = LoggerFactory.getLogger(OrderTobQueryServiceImpl.class);
    @Resource
    private OrderTobDas orderTobDas;
    @Resource
    private IContext context;
    private String startTime;
    private String endTime;

    @Override
    public SalesOverViewRespDto overview(IndexQueryReqDto indexQueryReqDto) {
        SalesOverViewRespDto result = new SalesOverViewRespDto();
        this.createTimeConditionFactory(indexQueryReqDto.getType());
        Long tenantId = this.context.tenantId();
        OrderTobReqDto ordertoBReqDto = new OrderTobReqDto(this.startTime, this.endTime, indexQueryReqDto.getShopId(), tenantId, indexQueryReqDto.getSellerId(), true);
        QueryWrapper queryWrapper = new QueryWrapper();
        if (ObjectUtil.isNotEmpty((Object)indexQueryReqDto.getShopId())) {
            queryWrapper.eq((Object)"shop_id", (Object)indexQueryReqDto.getShopId());
        }
        if (ObjectUtil.isNotEmpty((Object)indexQueryReqDto.getSellerId())) {
            queryWrapper.eq((Object)"seller_id", (Object)indexQueryReqDto.getSellerId());
        }
        queryWrapper.between((Object)"create_time", (Object)this.startTime, (Object)this.endTime);
        queryWrapper.eq((Object)"dr", (Object)0);
        if (ObjectUtil.isNotEmpty((Object)tenantId)) {
            queryWrapper.eq((Object)"tenant_id", (Object)tenantId);
        }
        int orderTotalNum = this.orderTobDas.count((Wrapper)queryWrapper);
        result.setOrderTotalNum(Integer.valueOf(orderTotalNum));
        SalesOverViewRespDto payTotal = this.orderTobDas.queryPayTotal(ordertoBReqDto);
        result.setPayTotalAmount(payTotal.getPayTotalAmount());
        result.setPayTotalNum(payTotal.getPayTotalNum());
        SalesOverViewRespDto refundTotal = this.orderTobDas.queryRefundTotal(ordertoBReqDto);
        result.setRefundTotalAmount(refundTotal.getRefundTotalAmount());
        result.setRefundTotalNum(refundTotal.getRefundTotalNum());
        result.setCountTime(this.getLastTime());
        return result;
    }

    @Override
    public PageInfo<ItemRankingRespDto> itemRanking(IndexQueryReqDto indexQueryReqDto, Integer pageNum, Integer pageSize) {
        this.createTimeConditionFactory(indexQueryReqDto.getType());
        OrderTobReqDto ordertoBReqDto = new OrderTobReqDto(this.startTime, this.endTime, indexQueryReqDto.getShopId(), this.context.tenantId(), indexQueryReqDto.getSellerId(), indexQueryReqDto.getSortType().booleanValue());
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List rankingRespDtos = this.orderTobDas.queryItemPay(ordertoBReqDto);
        PageInfo pageInfo = PageInfo.of((List)rankingRespDtos);
        BigDecimal totalAmount = rankingRespDtos.stream().map(ItemRankingRespDto::getPayTotalAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        for (ItemRankingRespDto total : rankingRespDtos) {
            if (total.getPayTotalAmount().compareTo(BigDecimal.ZERO) == 0) continue;
            total.setProportion(total.getPayTotalAmount().divide(totalAmount, 4, 4).multiply(BigDecimal.valueOf(IndexQueryConstant.WHOLE_NUMBER)));
        }
        rankingRespDtos.stream().forEach(itemrankingrespdto -> itemrankingrespdto.setId(this.createId()));
        Long[] arr = new Long[]{this.createIndexNo(pageNum, pageSize)};
        List result = rankingRespDtos.stream().peek(e -> {
            Long l = arr[0];
            Long l2 = arr[0] = Long.valueOf(arr[0] + 1L);
            e.setIndexNo(l);
        }).collect(Collectors.toList());
        pageInfo.setList(result);
        return pageInfo;
    }

    @Override
    public PageInfo<CategoryRankingRespDto> categoryRanking(IndexQueryReqDto indexQueryReqDto, Integer pageNum, Integer pageSize) {
        this.createTimeConditionFactory(indexQueryReqDto.getType());
        OrderTobReqDto ordertoBReqDto = new OrderTobReqDto(this.startTime, this.endTime, indexQueryReqDto.getShopId(), this.context.tenantId(), indexQueryReqDto.getSellerId(), indexQueryReqDto.getSortType().booleanValue());
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List categoryRankingRespDtos = this.orderTobDas.queryCategoryPay(ordertoBReqDto);
        PageInfo pageInfo = PageInfo.of((List)categoryRankingRespDtos);
        BigDecimal totalAmount = categoryRankingRespDtos.stream().map(CategoryRankingRespDto::getPayTotalAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        for (CategoryRankingRespDto total : categoryRankingRespDtos) {
            if (total.getPayTotalAmount().compareTo(BigDecimal.ZERO) == 0) continue;
            total.setProportion(total.getPayTotalAmount().divide(totalAmount, 4, 4).multiply(BigDecimal.valueOf(IndexQueryConstant.WHOLE_NUMBER)));
        }
        categoryRankingRespDtos.stream().forEach(categoryrankingrespdto -> categoryrankingrespdto.setId(this.createId()));
        Long[] arr = new Long[]{this.createIndexNo(pageNum, pageSize)};
        List result = categoryRankingRespDtos.stream().peek(e -> {
            Long l = arr[0];
            Long l2 = arr[0] = Long.valueOf(arr[0] + 1L);
            e.setIndexNo(l);
        }).collect(Collectors.toList());
        pageInfo.setList(result);
        return pageInfo;
    }

    private String getLastTime() {
        return DateUtil.now();
    }

    private void createTimeConditionFactory(Integer type) {
        DateTime start = null;
        DateTime end = null;
        if (type.equals(IndexQueryConstant.TODAY)) {
            start = DateUtil.beginOfDay((Date)DateTime.now());
            end = DateTime.now();
        } else if (type.equals(IndexQueryConstant.YESTERDAY)) {
            start = DateUtil.beginOfDay((Date)DateUtil.yesterday());
            end = DateUtil.endOfDay((Date)DateUtil.yesterday());
        } else if (type.equals(IndexQueryConstant.THIS_MONTH)) {
            start = DateUtil.beginOfMonth((Date)DateTime.now());
            end = DateTime.now();
        } else if (type.equals(IndexQueryConstant.LAST_MONTH)) {
            start = DateUtil.beginOfMonth((Date)DateUtil.lastMonth());
            end = DateUtil.endOfMonth((Date)DateUtil.lastMonth());
        } else if (type.equals(IndexQueryConstant.THIS_QUARTER)) {
            start = DateUtil.beginOfQuarter((Date)DateTime.now());
            end = DateTime.now();
        } else if (type.equals(IndexQueryConstant.LAST_QUARTER)) {
            DateTime dateTime = DateUtil.beginOfQuarter((Date)DateTime.now());
            Calendar calendar = dateTime.toCalendar();
            calendar.add(5, -1);
            Date time = calendar.getTime();
            start = DateUtil.beginOfQuarter((Date)time);
            end = DateUtil.endOfQuarter((Date)time);
        }
        this.startTime = DateUtil.formatDateTime((Date)start);
        this.endTime = DateUtil.formatDateTime((Date)end);
        logger.info("\u751f\u6210\u7684\u65f6\u95f4\u8303\u56f4\u662f[{}]-[{}]", (Object)this.startTime, (Object)this.endTime);
    }

    private Long createId() {
        return IdUtil.getSnowflake((long)1L, (long)1L).nextId();
    }

    private Long createIndexNo(Integer pageNum, Integer pageSize) {
        Long firstPage = 1L;
        if (pageNum.equals(firstPage)) {
            return firstPage;
        }
        return (pageNum - 1) * pageSize + 1;
    }
}

