/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.base.apiimpl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.item.api.base.IDirectoryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ChildrenDirReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.DirectoryCreateReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.DirectoryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.DirectorySortUpdateDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.PropGroupReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.RootDirectoryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.exception.ItemBusinessRuntimeException;
import com.dtyunxi.yundt.cube.center.item.api.base.exception.ItemExceptionCode;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IDirPropRelationService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IDirectoryItemService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IDirectoryService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemShelfService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.cache.ClearDirectoryCache;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.DirDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.DirPropRelationDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemDas;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.DirEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.DirIndexEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemEo;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="directoryItemApi")
public class DirectoryApiImpl
implements IDirectoryApi {
    @Resource
    private IDirectoryItemService directoryItemService;
    @Resource
    private IDirectoryService directoryService;
    @Resource
    private IItemShelfService dirsItemsService;
    @Resource
    private DirDas dirDas;
    @Resource
    private ItemDas itemDas;
    @Resource
    private DirPropRelationDas dirPropRelationDas;
    @Resource
    private IDirPropRelationService dirPropRelationService;
    @Resource
    private ClearDirectoryCache clearDirectoryCache;

    public RestResponse<Long> addDirectory(DirectoryReqDto directoryReqDto) {
        DirEo directoryItemEo = DirEo.newInstance((Map)directoryReqDto.getExtFields());
        DtoHelper.dto2Eo((BaseVo)directoryReqDto, (BaseEo)directoryItemEo);
        directoryItemEo.setAttrs(directoryReqDto.getAttrs());
        this.directoryItemService.saveDirectoryItem(directoryItemEo, directoryReqDto.getLinks());
        this.clearDirectoryCache.clearDirTree();
        return new RestResponse((Object)directoryItemEo.getId());
    }

    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Void> addDirList(List<DirectoryCreateReqDto> directoryCreateReqDtos) {
        if (CollectionUtils.isEmpty(directoryCreateReqDtos)) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_PARAM);
        }
        for (DirectoryCreateReqDto dto : directoryCreateReqDtos) {
            RootDirectoryReqDto rootDir = dto.getRootDir();
            if (rootDir == null) {
                throw new ItemBusinessRuntimeException("\u6839\u76ee\u5f55\u4e0d\u80fd\u4e3a\u7a7a");
            }
            Long rootId = (Long)this.addRootDirectory(rootDir).getData();
            List childrenDirs = dto.getChildrenDirs();
            this.addChildrenDir(childrenDirs, rootId, rootId);
        }
        this.clearDirectoryCache.clearDirTree();
        return RestResponse.VOID;
    }

    private void addChildrenDir(List<ChildrenDirReqDto> childrenDirs, Long rootId, Long parentId) {
        if (!CollectionUtils.isEmpty(childrenDirs)) {
            for (ChildrenDirReqDto childrenDir : childrenDirs) {
                childrenDir.setRootId(rootId);
                childrenDir.setParentId(parentId);
                Long subParentId = (Long)this.addDirectory((DirectoryReqDto)childrenDir).getData();
                if (CollectionUtils.isEmpty((Collection)childrenDir.getChildrenDirs())) continue;
                this.addChildrenDir(childrenDir.getChildrenDirs(), rootId, subParentId);
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Void> removeDirectory(Long dirId) {
        int i = this.dirsItemsService.countByDirId(null, null, dirId);
        if (i > 0) {
            throw new ItemBusinessRuntimeException("10200", "\u6b64\u76ee\u5f55\u5b58\u5728\u5546\u54c1\uff0c\u4e0d\u80fd\u5220\u9664");
        }
        ItemEo itemEoParam = ItemEo.newInstance();
        itemEoParam.setDirId(dirId);
        List itemEoList = this.itemDas.select((BaseEo)itemEoParam);
        if (CollectionUtils.isNotEmpty((Collection)itemEoList)) {
            throw new BizException("\u7c7b\u76ee\u88ab\u5546\u54c1\u5f15\u7528, \u65e0\u6cd5\u5220\u9664");
        }
        this.directoryItemService.deleteDirectoryItem(dirId);
        this.clearDirectoryCache.clearDirTree();
        return RestResponse.VOID;
    }

    public RestResponse<Void> modifyDirectory(DirectoryReqDto directoryReqDto) {
        if (directoryReqDto == null) {
            throw new ItemBusinessRuntimeException("\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DirEo directoryItemEo = DirEo.newInstance((Map)directoryReqDto.getExtFields());
        DtoHelper.dto2Eo((BaseVo)directoryReqDto, (BaseEo)directoryItemEo);
        this.directoryItemService.updateDirectoryItem(directoryItemEo, directoryReqDto.getLinks());
        this.clearDirectoryCache.clearDirTree();
        return RestResponse.VOID;
    }

    public RestResponse<Void> modifyDirStatus(Long id, Integer status) {
        DirEo directoryItemEo = DirEo.newInstance();
        directoryItemEo.setId(id);
        directoryItemEo.setStatus(status);
        this.directoryItemService.updateDirectoryItem(directoryItemEo, null);
        this.clearDirectoryCache.clearDirTree();
        return RestResponse.VOID;
    }

    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Long> addRootDirectory(RootDirectoryReqDto dirReqDto) {
        DirIndexEo directoryEo = DirIndexEo.newInstance((Map)dirReqDto.getExtFields());
        dirReqDto.setId(null);
        DtoHelper.dto2Eo((BaseVo)dirReqDto, (BaseEo)directoryEo);
        Long rootId = dirReqDto.getLink();
        if (null == rootId) {
            DirEo dirEo = DirEo.newInstance();
            dirEo.setName(dirReqDto.getName());
            dirEo.setCode(dirReqDto.getCode());
            dirEo.setAttrs(dirReqDto.getAttrs());
            dirEo.setExtension(dirReqDto.getExtension());
            dirEo.setInstanceId(dirReqDto.getInstanceId());
            dirEo.setTenantId(dirReqDto.getTenantId());
            dirEo.setStatus(dirReqDto.getStatus());
            dirEo.setDescription(dirReqDto.getDescription());
            this.directoryItemService.saveDirectoryItem(dirEo, null);
            rootId = dirEo.getId();
        } else {
            DirEo directoryItemEo = (DirEo)this.dirDas.selectByPrimaryKey(rootId);
            if (directoryItemEo == null) {
                throw new ItemBusinessRuntimeException(ItemExceptionCode.LINK_NOT_EXISTS);
            }
        }
        directoryEo.setRootId(rootId);
        this.directoryService.saveDirectory(directoryEo);
        this.clearDirectoryCache.clearDirTree();
        return new RestResponse((Object)rootId);
    }

    public RestResponse<Void> removeRootDirectory(Long id) {
        if (id == null) {
            throw new ItemBusinessRuntimeException("\u76ee\u5f55id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.directoryService.removeDirIndex(id);
        this.clearDirectoryCache.clearDirTree();
        return RestResponse.VOID;
    }

    public RestResponse<Void> removeRootDirectoryByRootId(Long rootId) {
        if (rootId == null) {
            throw new ItemBusinessRuntimeException("\u76ee\u5f55id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.directoryService.removeDirIndexByRootId(rootId);
        this.clearDirectoryCache.clearDirTree();
        return RestResponse.VOID;
    }

    public RestResponse<Void> modifyRootDirectory(RootDirectoryReqDto directoryReqDto) {
        if (directoryReqDto == null) {
            throw new ItemBusinessRuntimeException("\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DirIndexEo directoryEo = DirIndexEo.newInstance((Map)directoryReqDto.getExtFields());
        DtoHelper.dto2Eo((BaseVo)directoryReqDto, (BaseEo)directoryEo);
        directoryEo.setRootId(directoryReqDto.getLink());
        this.directoryService.modifyDirectory(directoryEo);
        this.clearDirectoryCache.clearDirTree();
        return RestResponse.VOID;
    }

    public RestResponse<Void> mergeDirectory(Long dirId, String merDirIds) {
        this.directoryItemService.mergeDir(dirId, merDirIds);
        this.clearDirectoryCache.clearDirTree();
        return RestResponse.VOID;
    }

    public RestResponse<Void> initDirTree() {
        this.directoryItemService.initTree();
        return RestResponse.VOID;
    }

    public RestResponse<Void> sortDirectory(Long id, DirectorySortUpdateDto directorySortUpdateDto) {
        this.directoryItemService.sortDirectory(id, directorySortUpdateDto);
        this.clearDirectoryCache.clearDirTree();
        return RestResponse.VOID;
    }

    public RestResponse<Void> compatSortDirectory(@NotNull(message="\u76ee\u5f55ID\u4e0d\u5141\u8bb8\u4e3a\u7a7a") @NotNull(message="\u76ee\u5f55ID\u4e0d\u5141\u8bb8\u4e3a\u7a7a") Long id, DirectorySortUpdateDto directorySortUpdateDto) {
        this.directoryItemService.compatSortDirectory(id, directorySortUpdateDto);
        this.clearDirectoryCache.clearDirTree();
        return RestResponse.VOID;
    }

    public RestResponse<Void> sortDirectory(DirectorySortUpdateDto directorySortUpdateDto) {
        this.directoryItemService.sortDirectory(directorySortUpdateDto);
        this.clearDirectoryCache.clearDirTree();
        return RestResponse.VOID;
    }

    public RestResponse<Void> saveDirPropGroup(Long dirId, List<PropGroupReqDto> propGroupReqDtos) {
        this.dirPropRelationService.saveDirPropGroup(dirId, propGroupReqDtos);
        return new RestResponse();
    }

    public RestResponse<Void> addDirPropGroup(Long dirId, Set<Long> propGroupIds) {
        this.dirPropRelationService.addDirPropGroup(dirId, propGroupIds);
        return new RestResponse();
    }

    public RestResponse<Void> updateDirPropGroupUsage(Long dirId, Long propGroupId, Integer usage) {
        this.dirPropRelationService.updateDirPropGroupUsage(dirId, propGroupId, usage);
        return new RestResponse();
    }

    public RestResponse<Void> removeDirPropGroup(Long dirId, Set<Long> propGroupIds) {
        this.dirPropRelationService.removeDirPropGroup(dirId, propGroupIds);
        return new RestResponse();
    }

    public RestResponse<Void> updateDirPropGroupSort(Long dirId, Long propGroupId, String action) {
        this.dirPropRelationService.updateDirPropGroupSort(dirId, propGroupId, action);
        return new RestResponse();
    }

    public RestResponse<Void> copyDirPropGroup(Long sourceDirId, Long targetDirId) {
        this.dirPropRelationService.copyDirPropGroup(sourceDirId, targetDirId);
        return new RestResponse();
    }
}

