/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.base.apiimpl.query;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.dto.TreeDto;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.DirTreeReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.DirectoryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.RootDirectoryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.DirIndexRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.DirectoryItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.PropGroupRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.exception.ItemBusinessRuntimeException;
import com.dtyunxi.yundt.cube.center.item.api.base.exception.ItemExceptionCode;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IDirectoryQueryApi;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IDirPropRelationService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IDirectoryItemService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IDirectoryService;
import com.dtyunxi.yundt.cube.center.item.biz.base.util.QueryParamUtils;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.DirDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.DirRelationDas;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.DirEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.DirIndexEo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="directoryItemQueryApi")
public class DirectoryQueryApiImpl
implements IDirectoryQueryApi {
    @Resource
    private IDirectoryItemService directoryItemService;
    @Resource
    private IDirectoryService directoryService;
    @Resource
    private DirDas dirDas;
    @Resource
    private DirRelationDas dirRelationDas;
    @Resource
    private IDirPropRelationService dirPropRelationService;

    public RestResponse<List<DirectoryItemRespDto>> queryDirectoryItem(String filters) {
        DirectoryReqDto directoryReqDto = new DirectoryReqDto();
        if (StringUtils.isNotBlank((CharSequence)filters)) {
            directoryReqDto = (DirectoryReqDto)JSON.parseObject((String)filters, DirectoryReqDto.class);
        }
        DirEo dirEo = DirEo.newInstance((Map)directoryReqDto.getExtFields());
        DtoHelper.dto2Eo((BaseVo)directoryReqDto, (BaseEo)dirEo);
        QueryParamUtils.columnLike((BaseEo)dirEo, "name", dirEo.getName());
        List<DirEo> directoryItemEos = this.directoryItemService.queryDirectoryItem(dirEo);
        ArrayList directoryItemRepsDtoList = new ArrayList();
        DtoHelper.eoList2DtoList(directoryItemEos, directoryItemRepsDtoList, DirectoryItemRespDto.class);
        return new RestResponse(directoryItemRepsDtoList);
    }

    public RestResponse<DirectoryItemRespDto> queryDirById(Long id) {
        return new RestResponse((Object)this.directoryItemService.queryById(id, true));
    }

    public RestResponse<TreeDto<DirectoryItemRespDto>> queryDirectoryTree(Long id, String filters) {
        if (StringUtils.isNotBlank((CharSequence)filters)) {
            DirectoryReqDto directoryReqDto = (DirectoryReqDto)JSON.parseObject((String)filters, DirectoryReqDto.class);
            ArrayList<Long> idsList = new ArrayList<Long>();
            idsList.add(id);
            List<TreeDto<DirectoryItemRespDto>> treeDtos = this.directoryItemService.queryDirByRootIds(idsList, directoryReqDto.getStatus());
            if (CollectionUtils.isEmpty(treeDtos)) {
                throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_DIR.getCode(), ItemExceptionCode.NON_EXIST_DIR.getMsg());
            }
            return new RestResponse(treeDtos.get(0));
        }
        throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR.getCode(), ItemExceptionCode.EMPTY_PARAM_ERROR.getMsg());
    }

    public RestResponse<List<TreeDto<DirIndexRespDto>>> queryDirTreeDetail(String filter) {
        if (StringUtils.isBlank((CharSequence)filter)) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR);
        }
        RootDirectoryReqDto reqDto = (RootDirectoryReqDto)JSON.parseObject((String)filter, RootDirectoryReqDto.class);
        if (reqDto == null || reqDto.getInstanceId() == null || reqDto.getTenantId() == null) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_PARAM);
        }
        return new RestResponse(this.directoryItemService.queryDirTreeDetail(reqDto));
    }

    public RestResponse<List<TreeDto<DirectoryItemRespDto>>> queryDirectoryTreeByFilter(String filter) {
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            RootDirectoryReqDto reqDto = (RootDirectoryReqDto)JSON.parseObject((String)filter, RootDirectoryReqDto.class);
            DirIndexEo example = DirIndexEo.newInstance((Map)reqDto.getExtFields());
            DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)example);
            QueryParamUtils.columnLike((BaseEo)example, "name", example.getName());
            List<DirIndexEo> directoryEos = this.directoryService.queryDirectory(example);
            ArrayList<Long> idsList = new ArrayList<Long>();
            for (DirIndexEo directoryEo : directoryEos) {
                idsList.add(directoryEo.getRootId());
            }
            List<TreeDto<DirectoryItemRespDto>> treeDtos = this.directoryItemService.queryDirByRootIds(idsList, null);
            return new RestResponse(treeDtos);
        }
        throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR.getCode(), ItemExceptionCode.EMPTY_PARAM_ERROR.getMsg());
    }

    public RestResponse<List<DirectoryItemRespDto>> queryDirByIds(String dirIds) {
        String[] ids;
        ArrayList<Long> dirIdList = new ArrayList<Long>();
        for (String id : ids = dirIds.trim().split(",")) {
            dirIdList.add(Long.parseLong(id));
        }
        return new RestResponse(this.directoryService.queryByIds(dirIdList, null));
    }

    public RestResponse<List<PropGroupRespDto>> queryPropGroupListByDirId(Long dirId, Integer usage) {
        return new RestResponse(this.dirPropRelationService.queryPropGroupByDirId(dirId, usage));
    }

    public RestResponse<DirectoryItemRespDto> queryBaseInfo(Long id) {
        return new RestResponse((Object)this.directoryItemService.queryById(id, false));
    }

    public RestResponse<List<TreeDto<DirectoryItemRespDto>>> queryDirTree(DirTreeReqDto dirTreeReqDto) {
        return new RestResponse(this.directoryItemService.queryDirTree(dirTreeReqDto));
    }
}

