/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.base.service.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.DirectoryItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.exception.ItemBusinessRuntimeException;
import com.dtyunxi.yundt.cube.center.item.api.base.exception.ItemExceptionCode;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IDirectoryItemService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IDirectoryService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemShelfService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.contants.ItemConstant;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.DirDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.DirIndexDas;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.DirEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.DirIndexEo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DirectoryServiceImpl
implements IDirectoryService {
    private static Logger logger = LoggerFactory.getLogger(DirectoryServiceImpl.class);
    @Resource
    private DirIndexDas dirIndexDas;
    @Resource
    private IItemShelfService itemShelfService;
    @Resource
    private IDirectoryItemService directoryItemService;
    @Resource
    private DirDas dirDas;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void createDefaultItemShelf(DirIndexEo directoryEo) {
        DirIndexEo queryDto = DirIndexEo.newInstance();
        queryDto.setDirUsage("DEFAULT_SHELF");
        queryDto.setInstanceId(directoryEo.getInstanceId());
        if (CollectionUtils.isNotEmpty((Collection)this.dirIndexDas.select((BaseEo)queryDto))) {
            logger.info("\u9ed8\u8ba4\u8d27\u67b6\u5df2\u5b58\u5728\uff0c \u4e0d\u9700\u8981\u521b\u5efa");
            return;
        }
        DirEo dirItem = DirEo.newInstance();
        dirItem.setParentId(ItemConstant.ROOT_NODE);
        dirItem.setName("\u9ed8\u8ba4\u8d27\u67b6");
        dirItem.setCode("DEFAULT_SHELF");
        dirItem.setInstanceId(directoryEo.getInstanceId());
        this.directoryItemService.saveDirectoryItem(dirItem, null);
        directoryEo.setDirUsage("DEFAULT_SHELF");
        directoryEo.setRootId(dirItem.getId());
        directoryEo.setName("\u9ed8\u8ba4\u8d27\u67b6");
        directoryEo.setOwnerId(Long.valueOf(0L));
        this.dirIndexDas.insert((BaseEo)directoryEo);
    }

    @Override
    public int saveDirectory(DirIndexEo directoryEo) {
        if (directoryEo == null) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR.getCode(), ItemExceptionCode.EMPTY_PARAM_ERROR.getMsg());
        }
        directoryEo.setId(null);
        return this.dirIndexDas.insert((BaseEo)directoryEo);
    }

    @Override
    public List<DirIndexEo> queryDirectory(DirIndexEo directoryEo) {
        if (directoryEo == null) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_DIR.getCode(), ItemExceptionCode.NON_EXIST_DIR.getMsg());
        }
        return this.dirIndexDas.select((BaseEo)directoryEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeDirIndex(Long id) {
        if (id == null) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR.getCode(), ItemExceptionCode.EMPTY_PARAM_ERROR.getMsg());
        }
        this.dirIndexDas.logicDeleteById(id);
        this.itemShelfService.offShelfByDirId(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyDirectory(DirIndexEo directoryEo) {
        if (directoryEo == null) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR.getCode(), ItemExceptionCode.EMPTY_PARAM_ERROR.getMsg());
        }
        this.dirIndexDas.updateSelective((BaseEo)directoryEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeDirIndexByRootId(Long rootId) {
        if (rootId == null) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR.getCode(), ItemExceptionCode.EMPTY_PARAM_ERROR.getMsg());
        }
        DirIndexEo temp = new DirIndexEo();
        temp.setRootId(rootId);
        DirIndexEo indexEo = (DirIndexEo)this.dirIndexDas.selectOne((BaseEo)temp);
        if (indexEo != null) {
            this.dirIndexDas.logicDeleteById(indexEo.getId());
            this.itemShelfService.offShelfByDirId(indexEo.getId());
        }
    }

    @Override
    public DirIndexEo queryDefaultItemShelf(Long instanceId) {
        DirIndexEo exam = DirIndexEo.newInstance();
        exam.setDirUsage("DEFAULT_SHELF");
        exam.setInstanceId(instanceId);
        List dirs = this.dirIndexDas.select((BaseEo)exam);
        if (CollectionUtils.isNotEmpty((Collection)dirs)) {
            return (DirIndexEo)dirs.get(0);
        }
        DirIndexEo createElement = DirIndexEo.newInstance();
        createElement.setInstanceId(instanceId);
        this.createDefaultItemShelf(createElement);
        return createElement;
    }

    @Override
    public DirIndexEo queryDirectoryById(Long id) {
        return (DirIndexEo)this.dirIndexDas.selectByPrimaryKey(id);
    }

    @Override
    public List<DirectoryItemRespDto> queryByIds(List<Long> ids, String orderBy) {
        DirEo dirEo = DirEo.newInstance();
        if (StringUtils.isBlank((CharSequence)orderBy)) {
            dirEo.setOrderBy("id");
        } else {
            dirEo.setOrderBy(orderBy);
        }
        ArrayList sqlFilters = Lists.newArrayList();
        sqlFilters.add(SqlFilter.in((String)"id", (Object)StringUtils.join(ids, (String)",")));
        dirEo.setSqlFilters((List)sqlFilters);
        List dirEoList = this.dirDas.select((BaseEo)dirEo);
        ArrayList dirRespDtoList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)dirEoList, (Collection)dirRespDtoList, DirectoryItemRespDto.class);
        return dirRespDtoList;
    }
}

