/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.base.service.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.util.SpringBeanUtil;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemBusTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemStatus;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemShelfQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ShelfQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ShelfReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemPriceRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemShelfQueryRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemShelfRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemShelfSkuRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.PointsDeductionRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ShelfIntegralRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ShelfQueryRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.exception.ItemBusinessRuntimeException;
import com.dtyunxi.yundt.cube.center.item.api.base.exception.ItemExceptionCode;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IShelfCacheService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IShelfIntegralService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IShelfService;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemMediasDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemPriceDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemSkuDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemStorageDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ShelfDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ShelfPointsDeductionDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.vo.ShelfItemSkuVo;
import com.dtyunxi.yundt.cube.center.item.dao.base.vo.ShelfItemVo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemMediasEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemSkuEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemStorageEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ShelfEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ShelfPointsDeductionEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StdItemMediasEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StdShelfEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class IIShelfServiceImpl
implements IShelfService {
    @Resource
    private ShelfDas shelfDas;
    @Resource
    private ItemMediasDas itemMediasDas;
    @Resource
    private ItemPriceDas itemPriceDas;
    public static final String SHELF_ITEM = "SHELF_ITEM";
    @Resource
    private ShelfPointsDeductionDas shelfPointsDeductionDas;
    @Resource
    private ItemSkuDas itemSkuDas;
    @Resource
    private ItemStorageDas itemStorageDas;
    @Autowired
    private IShelfCacheService shelfCacheService;

    @Override
    public PageInfo<ItemShelfQueryRespDto> getItemShelfPage(ItemShelfQueryReqDto itemShelfQueryReqDto, Integer pageNum, Integer pageSize) {
        PageInfo pageInfo;
        LinkedList dtoList = Lists.newLinkedList();
        ShelfItemVo shelfItemVo = new ShelfItemVo();
        CubeBeanUtils.copyProperties((Object)shelfItemVo, (Object)itemShelfQueryReqDto, (String[])new String[0]);
        if (itemShelfQueryReqDto.getGroupBy() == null) {
            shelfItemVo.setGroupBy(Integer.valueOf(1));
        }
        if (ItemStatus.ITEM_SALE_OUT.getStatus().equals(itemShelfQueryReqDto.getItemStatus())) {
            shelfItemVo.setSellOut(Boolean.valueOf(true));
            shelfItemVo.setItemStatus(null);
        }
        if ((pageInfo = this.shelfDas.selectSelfItemByPage(shelfItemVo, pageNum, pageSize)) != null && CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
            List voList = pageInfo.getList();
            CubeBeanUtils.copyCollection((Collection)dtoList, (Collection)voList, ItemShelfQueryRespDto.class);
            List<Long> shopIdList = dtoList.stream().map(ItemShelfQueryRespDto::getShopId).distinct().collect(Collectors.toList());
            List<Long> itemIdList = dtoList.stream().map(ItemShelfQueryRespDto::getItemId).distinct().collect(Collectors.toList());
            Integer busType = itemShelfQueryReqDto.getBusType();
            Map<String, List<ItemShelfSkuRespDto>> itemShelfSkuRespDtoMap = this.queryItemShelfSkuMap(shopIdList, itemIdList, busType);
            Map<Object, Object> itemMediaMap = Maps.newHashMap();
            List itemMediasEoList = this.itemMediasDas.selectByItemIds(itemIdList);
            if (CollectionUtils.isNotEmpty((Collection)itemMediasEoList)) {
                itemMediaMap = itemMediasEoList.stream().collect(Collectors.groupingBy(StdItemMediasEo::getItemId));
            }
            HashMap finalItemMediaMap = itemMediaMap;
            dtoList.forEach(dto -> {
                List itemMediasEos = (List)finalItemMediaMap.get(dto.getItemId());
                if (CollectionUtils.isNotEmpty((Collection)itemMediasEos)) {
                    dto.setImgPath(((ItemMediasEo)itemMediasEos.get(0)).getPath1());
                }
                List skuList = (List)itemShelfSkuRespDtoMap.get("" + dto.getShopId() + dto.getItemId());
                dto.setSkuList(skuList);
            });
        }
        PageInfo resultPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)resultPageInfo, (Object)pageInfo, (String[])new String[]{"list", "navigatepageNums"});
        resultPageInfo.setList((List)dtoList);
        return resultPageInfo;
    }

    static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap seen = new ConcurrentHashMap();
        return t -> seen.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }

    @Override
    public List<ItemShelfSkuRespDto> queryShelfItemSkuList(Long shopId, Long itemId, Integer busType) {
        ArrayList itemShelfSkuRespDtoList = Lists.newArrayList();
        List list = this.shelfDas.selectSelfItemSkuList(shopId, itemId, busType);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            CubeBeanUtils.copyCollection((Collection)itemShelfSkuRespDtoList, (Collection)list, ItemShelfSkuRespDto.class);
            List skuIds = list.stream().map(ShelfItemSkuVo::getId).collect(Collectors.toList());
            List itemPriceEoList = this.itemPriceDas.selectBySkuIds(skuIds);
            ArrayList itemPriceRespDtoList = Lists.newArrayList();
            DtoHelper.eoList2DtoList((Collection)itemPriceEoList, (Collection)itemPriceRespDtoList, ItemPriceRespDto.class);
            Map group = itemPriceRespDtoList.stream().collect(Collectors.groupingBy(ItemPriceRespDto::getSkuId, Collectors.toList()));
            itemShelfSkuRespDtoList.forEach(sku -> sku.setItemPriceList((List)group.get(sku.getId())));
        }
        List<ItemShelfSkuRespDto> collect = itemShelfSkuRespDtoList.stream().filter(itemShelfSkuRespDto -> itemShelfSkuRespDto.getId() != null).filter(IIShelfServiceImpl.distinctByKey(itemShelfSkuRespDto -> itemShelfSkuRespDto.getId())).collect(Collectors.toList());
        return collect;
    }

    private Map<String, List<ItemShelfSkuRespDto>> queryItemShelfSkuMap(List<Long> shopIdList, List<Long> itemIdList, Integer busType) {
        Map<Object, Object> itemShelfSkuMap = Maps.newHashMap();
        List shelfEoList = this.shelfDas.selectByParam(shopIdList, itemIdList, null, busType);
        if (CollectionUtils.isNotEmpty((Collection)shelfEoList)) {
            List itemPriceEoList;
            List itemStorageEoList;
            List<ItemShelfSkuRespDto> itemShelfSkuRespDtoList = shelfEoList.stream().map(shelfEo -> {
                ItemShelfSkuRespDto itemShelfSkuRespDto = new ItemShelfSkuRespDto();
                itemShelfSkuRespDto.setShopId(shelfEo.getShopId());
                itemShelfSkuRespDto.setItemId(shelfEo.getItemId());
                itemShelfSkuRespDto.setId(shelfEo.getSkuId());
                itemShelfSkuRespDto.setPrice(shelfEo.getPrice());
                return itemShelfSkuRespDto;
            }).collect(Collectors.toList());
            List skuIdList = shelfEoList.stream().map(StdShelfEo::getSkuId).distinct().collect(Collectors.toList());
            List itemSkuEoList = this.itemSkuDas.selectItemSkuByIds(skuIdList);
            if (CollectionUtils.isNotEmpty((Collection)itemSkuEoList)) {
                Map itemSkuEoMap = itemSkuEoList.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity()));
                itemShelfSkuRespDtoList.forEach(itemShelfSkuRespDto -> {
                    ItemSkuEo itemSkuEo = (ItemSkuEo)itemSkuEoMap.get(itemShelfSkuRespDto.getId());
                    if (itemSkuEo != null) {
                        itemShelfSkuRespDto.setCode(itemSkuEo.getCode());
                        itemShelfSkuRespDto.setName(itemSkuEo.getName());
                        itemShelfSkuRespDto.setCspuid(itemSkuEo.getCspuid());
                        itemShelfSkuRespDto.setAttr(itemSkuEo.getAttr());
                    }
                });
            }
            if (CollectionUtils.isNotEmpty((Collection)(itemStorageEoList = this.itemStorageDas.selectByParam(shopIdList, itemIdList, skuIdList)))) {
                Map<String, List<ItemStorageEo>> itemStorageEoMap = itemStorageEoList.stream().filter(itemStorageEo -> itemStorageEo.getShopId() != null && itemStorageEo.getItemId() != null && itemStorageEo.getSkuId() != null).collect(Collectors.groupingBy(itemStorageEo -> "" + itemStorageEo.getShopId() + itemStorageEo.getItemId() + itemStorageEo.getSkuId()));
                itemShelfSkuRespDtoList.forEach(itemShelfSkuRespDto -> {
                    List itemStorageEos = (List)itemStorageEoMap.get("" + itemShelfSkuRespDto.getShopId() + itemShelfSkuRespDto.getItemId() + itemShelfSkuRespDto.getId());
                    if (CollectionUtils.isNotEmpty((Collection)itemStorageEos)) {
                        itemShelfSkuRespDto.setBalance(((ItemStorageEo)itemStorageEos.get(0)).getBalance());
                    }
                });
            }
            if (CollectionUtils.isNotEmpty((Collection)(itemPriceEoList = this.itemPriceDas.selectBySkuIds(skuIdList)))) {
                ArrayList itemPriceRespDtoList = Lists.newArrayList();
                DtoHelper.eoList2DtoList((Collection)itemPriceEoList, (Collection)itemPriceRespDtoList, ItemPriceRespDto.class);
                Map itemPriceRespDtoMap = itemPriceRespDtoList.stream().collect(Collectors.groupingBy(ItemPriceRespDto::getSkuId, Collectors.toList()));
                itemShelfSkuRespDtoList.forEach(itemShelfSkuRespDto -> itemShelfSkuRespDto.setItemPriceList((List)itemPriceRespDtoMap.get(itemShelfSkuRespDto.getId())));
            }
            itemShelfSkuMap = itemShelfSkuRespDtoList.stream().collect(Collectors.groupingBy(itemShelfSkuRespDto -> "" + itemShelfSkuRespDto.getShopId() + itemShelfSkuRespDto.getItemId()));
        }
        return itemShelfSkuMap;
    }

    @Override
    public Long countItemShelf(ItemShelfQueryReqDto itemShelfQueryReqDto) {
        ShelfItemVo shelfItemVo = new ShelfItemVo();
        CubeBeanUtils.copyProperties((Object)shelfItemVo, (Object)itemShelfQueryReqDto, (String[])new String[0]);
        if (ItemStatus.ITEM_SALE_OUT.getStatus().equals(itemShelfQueryReqDto.getItemStatus())) {
            shelfItemVo.setSellOut(Boolean.valueOf(true));
            shelfItemVo.setItemStatus(null);
        }
        return this.shelfDas.selectSelfItemCount(shelfItemVo);
    }

    @Override
    @Cacheable(value={"SHELF_ITEM"}, key="#itemShelfQueryReqDto.shopId+'_'+#itemShelfQueryReqDto.skuId+'_'+#itemShelfQueryReqDto.busType", unless="#result == null")
    public ItemShelfRespDto queryItemShelf(ShelfReqDto itemShelfQueryReqDto) {
        ShelfEo shelfEo = new ShelfEo();
        shelfEo.setSkuId(itemShelfQueryReqDto.getSkuId());
        shelfEo.setShopId(itemShelfQueryReqDto.getShopId());
        shelfEo.setBusType(itemShelfQueryReqDto.getBusType());
        List select = this.shelfDas.select((BaseEo)shelfEo);
        if (CollectionUtils.isNotEmpty((Collection)select)) {
            IShelfIntegralService shelfIntegralService;
            ItemShelfRespDto itemShelfSkuRespDto = new ItemShelfRespDto();
            ShelfEo shelf = (ShelfEo)select.get(0);
            BeanUtils.copyProperties((Object)shelf, (Object)itemShelfSkuRespDto);
            if (shelf.getBusType() != null && shelf.getBusType().equals(ItemBusTypeEnum.INTEGRAL.getType()) && null != (shelfIntegralService = (IShelfIntegralService)SpringBeanUtil.getBean(IShelfIntegralService.class))) {
                ShelfIntegralRespDto shelfIntegralRespDto = shelfIntegralService.queryByShelfId(shelf.getId());
                itemShelfSkuRespDto.setShelfIntegral(shelfIntegralRespDto);
            }
            return itemShelfSkuRespDto;
        }
        return null;
    }

    @Override
    public void clearItemShelfCache(ShelfReqDto itemShelfQueryReqDto) {
        this.shelfCacheService.clearItemShelfCache(itemShelfQueryReqDto);
    }

    @Override
    public void removeItemShelf(Long id) {
        ShelfEo shelfEo = (ShelfEo)this.shelfDas.selectByPrimaryKey(id);
        if (Objects.isNull(shelfEo)) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_ITEM.getCode(), ItemExceptionCode.NON_EXIST_ITEM.getMsg());
        }
        this.shelfDas.logicDeleteByExample((BaseEo)shelfEo);
    }

    @Override
    public void batchRemoveShelf(String ids) {
        String[] idList;
        for (String id : idList = ids.split(",")) {
            this.removeItemShelf(Long.valueOf(id));
        }
    }

    @Override
    public List<PointsDeductionRespDto> queryShelfItemPointsDeduction(Set<Long> shelfIds) {
        ArrayList list = Lists.newArrayList();
        ShelfPointsDeductionEo paramEo = ShelfPointsDeductionEo.newInstance();
        ArrayList sqlFilterList = Lists.newArrayList();
        SqlFilter sqlFilter = SqlFilter.in((String)"shelfId", shelfIds);
        sqlFilterList.add(sqlFilter);
        paramEo.setSqlFilters((List)sqlFilterList);
        List shelfPointsDeductionEos = this.shelfPointsDeductionDas.select((BaseEo)paramEo);
        if (CollectionUtils.isNotEmpty((Collection)shelfPointsDeductionEos)) {
            DtoHelper.eoList2DtoList((Collection)shelfPointsDeductionEos, (Collection)list, PointsDeductionRespDto.class);
        }
        return list;
    }

    @Override
    public List<ShelfQueryRespDto> queryShelfList(ShelfQueryReqDto shelfQueryReqDto) {
        ArrayList list = Lists.newArrayList();
        ShelfEo shelfParam = ShelfEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)shelfQueryReqDto, (BaseEo)shelfParam);
        ArrayList sqlFilters = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)shelfQueryReqDto.getItemIds())) {
            sqlFilters.add(SqlFilter.in((String)"item_id", (Object)shelfQueryReqDto.getItemIds()));
            shelfParam.setItemId(null);
        }
        if (CollectionUtils.isNotEmpty((Collection)shelfQueryReqDto.getShopIds())) {
            sqlFilters.add(SqlFilter.in((String)"shop_id", (Object)shelfQueryReqDto.getShopIds()));
            shelfParam.setShopId(null);
        }
        if (CollectionUtils.isNotEmpty((Collection)shelfQueryReqDto.getSkuIds())) {
            sqlFilters.add(SqlFilter.in((String)"sku_id", (Object)shelfQueryReqDto.getSkuIds()));
            shelfParam.setSkuId(null);
        }
        shelfParam.setSqlFilters((List)sqlFilters);
        List shelfEoList = this.shelfDas.select((BaseEo)shelfParam);
        if (CollectionUtils.isNotEmpty((Collection)shelfEoList)) {
            DtoHelper.eoList2DtoList((Collection)shelfEoList, (Collection)list, ShelfQueryRespDto.class);
            list.forEach(shelfQueryRespDto -> {
                List itemStorageEoList = this.itemStorageDas.selectListByParam(shelfQueryRespDto.getShopId(), shelfQueryRespDto.getItemId(), (List)Lists.newArrayList((Object[])new Long[]{shelfQueryRespDto.getSkuId()}));
                if (CollectionUtils.isNotEmpty((Collection)itemStorageEoList)) {
                    shelfQueryRespDto.setShelfAmount(((ItemStorageEo)itemStorageEoList.get(0)).getBalance());
                }
            });
        }
        return list;
    }

    @Override
    @Cacheable(value={"ITEM_SHELF_CACHE"}, key="#itemId", unless="#result== null")
    public List<ItemShelfRespDto> queryByItemId(Long itemId) {
        ShelfEo shelfEo = ShelfEo.newInstance();
        shelfEo.setItemId(itemId);
        List shelfEos = this.shelfDas.select((BaseEo)shelfEo);
        ArrayList shelfRespDtos = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)shelfRespDtos, (Collection)shelfEos, ItemShelfRespDto.class);
        return shelfRespDtos;
    }
}

