/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.base.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.huieryun.opensearch.api.IIndicesAdminService;
import com.dtyunxi.huieryun.opensearch.api.IOpenSearchService;
import com.dtyunxi.huieryun.opensearch.api.ISearchIndexService;
import com.dtyunxi.huieryun.opensearch.enums.LogicalSymbol;
import com.dtyunxi.huieryun.opensearch.enums.ShapeType;
import com.dtyunxi.huieryun.opensearch.enums.SortOrder;
import com.dtyunxi.huieryun.opensearch.utils.CustomBeanUtils;
import com.dtyunxi.huieryun.opensearch.vo.FilterFieldVo;
import com.dtyunxi.huieryun.opensearch.vo.GeoShapeFieldVo;
import com.dtyunxi.huieryun.opensearch.vo.IndexDocContentVo;
import com.dtyunxi.huieryun.opensearch.vo.IndexDocumentVo;
import com.dtyunxi.huieryun.opensearch.vo.OSSearchVo;
import com.dtyunxi.huieryun.opensearch.vo.QueryFieldVo;
import com.dtyunxi.huieryun.opensearch.vo.SearchResultVo;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.IdGenrator;
import com.dtyunxi.util.SpringBeanUtil;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemStatus;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.DistributionFeeDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemSearchQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ShelfReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.CoordinateDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSearchRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemShelfRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemShopRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.LocationDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.TemplateRegionRespDto;
import com.dtyunxi.yundt.cube.center.item.biz.base.mq.vo.ItemSearchIndexMessageVo;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IDistributionSetService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemSearchService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemService;
import com.dtyunxi.yundt.cube.center.item.biz.base.util.ConvertUtil;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.DirItemRelationDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemAttributesDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.StatDas;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemAttributesEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StatEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StdStatEo;
import com.dtyunxi.yundt.cube.center.shop.api.IShopApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDeliveryDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.GeoDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ResourceUtils;

@Component
@MQDesc(tag="ITEM_SEARCH_INDEX")
public class ItemSearchServiceImpl
implements IItemSearchService,
IMessageProcessor {
    private Logger logger = LoggerFactory.getLogger(ItemSearchServiceImpl.class);
    @Value(value="${huieryun.searchindexbuilder.indexname.prefix}")
    private String INDEX_ITEM;
    @Value(value="${cube.global.profile:dev}")
    private String globalProfile;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private ItemDas itemDas;
    @Resource
    private IItemService itemService;
    @Resource
    private StatDas statDas;
    @Resource
    private ItemAttributesDas itemAttributesDas;
    @Resource
    private DirItemRelationDas dirItemRelationDas;
    @Resource
    private IShopQueryApi shopQueryApi;
    @Resource
    private IOpenSearchService openSearchService;
    @Resource
    private ISearchIndexService searchIndexService;
    @Resource
    private IIndicesAdminService indicesAdminService;
    @Resource
    private IShopApi shopApi;

    @Deprecated
    public void initIndex() {
        if (this.indicesAdminService.existsIndex(new String[]{this.getIndexName()})) {
            this.logger.info("\u5546\u54c1\u4e2d\u5fc3\u7d22\u5f15{}\u5df2\u5b58\u5728\uff0c\u4e0d\u518d\u8fdb\u884c\u81ea\u52a8\u521b\u5efa=====", (Object)this.getIndexName());
        }
        String mapping = null;
        try {
            File jsonFile = ResourceUtils.getFile((String)"classpath:item_index_mapping.json");
            mapping = FileUtils.readFileToString((File)jsonFile, (String)"utf-8");
        }
        catch (Exception e) {
            this.logger.info("\u5546\u54c1\u4e2d\u5fc3\u7d22\u5f15\u6587\u4ef6\u52a0\u8f7d\u5931\u8d25", (Throwable)e);
        }
        this.logger.info("\u5546\u54c1\u4e2d\u5fc3\u7d22\u5f15\u6587\u4ef6\u5185\u5bb9 {}", (Object)mapping);
        if (StringUtils.isBlank((CharSequence)mapping)) {
            this.logger.info("\u5546\u54c1\u4e2d\u5fc3\u7d22\u5f15mapping\u4e3a\u7a7a\uff0c\u81ea\u52a8\u521b\u5efa\u5931\u8d25\uff0c\u8bf7\u624b\u52a8\u521d\u59cb\u5316es\u76f8\u5173\u64cd\u4f5c=====", (Object)this.getIndexName());
            return;
        }
        try {
            this.logger.info("\u5546\u54c1\u4e2d\u5fc3\u7d22\u5f15{}\u81ea\u52a8\u521b\u5efa\u6210\u529f=====", (Object)this.getIndexName());
        }
        catch (Exception e) {
            this.logger.error("\u5546\u54c1\u4e2d\u5fc3\u7d22\u5f15{}\u81ea\u52a8\u521b\u5efa\u5931\u8d25", (Throwable)e);
        }
        try {
            this.indicesAdminService.putMapping(this.getIndexName() + "ws", "item_search", mapping.toString());
        }
        catch (Exception e) {
            this.logger.error("\u5546\u54c1\u4e2d\u5fc3\u7d22\u5f15mapping\u8bbe\u7f6e\u5931\u8d25", (Throwable)e);
        }
    }

    private String getIndexName() {
        return this.INDEX_ITEM + "_" + "item_search";
    }

    @Override
    public void index(long sellerId, long itemId, int busType, String operation) {
        this.logger.info("\u540c\u6b65\u5546\u54c1\u4fe1\u606f\u5230ES,sellerId:{},itemId:{},busType:{},operation:{}", new Object[]{sellerId, itemId, busType, operation});
        this.index(sellerId, itemId, busType, operation, 0);
    }

    private void index(Long sellerId, Long itemId, Integer busType, String operation, int retry) {
        if (retry > 3) {
            this.logger.error("\u7d22\u5f15\u91cd\u590d\u6784\u5efa\u8d85\u8fc73\u6b21\uff0c\u5546\u54c1ID\u4e3a:{}\u8bf7\u68c0\u67e5", (Object)itemId);
            return;
        }
        ItemSearchIndexMessageVo itemSearchIndexMessageVo = new ItemSearchIndexMessageVo(sellerId, itemId, busType, operation, retry);
        itemSearchIndexMessageVo.setMessageId(this.generateId());
        this.logger.info("\u5f00\u59cb\u53d1\u9001es\u540c\u6b65\u6d88\u606f\uff0cmessage:{}", (Object)JSON.toJSONString((Object)itemSearchIndexMessageVo));
        this.commonsMqService.sendSingleMessage("ITEM_SEARCH_INDEX", (Object)JSON.toJSONString((Object)itemSearchIndexMessageVo));
    }

    @Override
    public ItemSearchRespDto query(ItemSearchQueryReqDto itemSearchQueryReqDto, Integer pageNum, Integer pageSize) {
        if (itemSearchQueryReqDto.getType() == null) {
            itemSearchQueryReqDto.setType(itemSearchQueryReqDto.getItemType());
        }
        if (pageNum == null) {
            pageNum = 1;
        }
        if (pageSize == null) {
            pageSize = 10;
        }
        OSSearchVo osSearchVo = new OSSearchVo();
        osSearchVo.setPage(pageNum.intValue());
        osSearchVo.setPageSize(pageSize.intValue());
        if (itemSearchQueryReqDto.getTenantId() != null) {
            osSearchVo.addEqualFilter("tenantId", String.valueOf(itemSearchQueryReqDto.getTenantId()));
        }
        if (itemSearchQueryReqDto.getInstanceId() != null) {
            osSearchVo.addEqualFilter("instanceId", String.valueOf(itemSearchQueryReqDto.getInstanceId()));
        }
        if (StringUtils.isNotBlank((CharSequence)itemSearchQueryReqDto.getKeyword())) {
            QueryFieldVo queryFieldVo = QueryFieldVo.query((String)itemSearchQueryReqDto.getKeyword(), (String[])new String[]{"name", "displayName", "brand"});
            queryFieldVo.setEscape(true);
            osSearchVo.addQueries(new QueryFieldVo[]{queryFieldVo});
        }
        if (itemSearchQueryReqDto.getType() != null) {
            osSearchVo.addEqualFilter("type", String.valueOf(itemSearchQueryReqDto.getType()));
        }
        if (itemSearchQueryReqDto.getType() == null && itemSearchQueryReqDto.getNeType() != null) {
            osSearchVo.addNonEqualFilter("type", String.valueOf(itemSearchQueryReqDto.getType()));
        }
        if (CollectionUtils.isEmpty((Collection)itemSearchQueryReqDto.getBusTypeList())) {
            if (itemSearchQueryReqDto.getBusType() != null) {
                osSearchVo.addEqualFilter("busType", String.valueOf(itemSearchQueryReqDto.getBusType()));
            }
        } else {
            String[] buyTypes = ConvertUtil.convert2Array(itemSearchQueryReqDto.getBusTypeList());
            osSearchVo.addInFilter("busType", buyTypes);
        }
        if (itemSearchQueryReqDto.getBrandId() != null) {
            osSearchVo.addEqualFilter("brandId", String.valueOf(itemSearchQueryReqDto.getBrandId()));
        }
        if (!CollectionUtils.isEmpty((Collection)itemSearchQueryReqDto.getInBrandIds())) {
            String[] inBrandIds = ConvertUtil.convert2Array(itemSearchQueryReqDto.getInBrandIds());
            String[] compound = FilterFieldVo.compound((LogicalSymbol)LogicalSymbol.AND);
            FilterFieldVo in = FilterFieldVo.in((String)"brandId", (String[])inBrandIds);
            in.setLogicalSymbol(LogicalSymbol.OR);
            FilterFieldVo equal = FilterFieldVo.equal((String)"brandId", (String)"0");
            equal.setLogicalSymbol(LogicalSymbol.OR);
            compound.addSubFilterFieldVos(new FilterFieldVo[]{in, equal});
            osSearchVo.addFilters(new FilterFieldVo[]{compound});
        }
        if (!CollectionUtils.isEmpty((Collection)itemSearchQueryReqDto.getItemIds())) {
            String[] itemIds = ConvertUtil.convert2Array(itemSearchQueryReqDto.getItemIds());
            osSearchVo.addInFilter("dirsItemsList.itemId", itemIds);
        }
        if (!CollectionUtils.isEmpty((Collection)itemSearchQueryReqDto.getInItemIds())) {
            String[] inItemIds = ConvertUtil.convert2Array(itemSearchQueryReqDto.getInItemIds());
            osSearchVo.addInFilter("dirsItemsList.itemId", inItemIds);
        }
        if (!CollectionUtils.isEmpty((Collection)itemSearchQueryReqDto.getOutItemIds())) {
            String[] outInItemIds = ConvertUtil.convert2Array(itemSearchQueryReqDto.getOutItemIds());
            osSearchVo.addNonInFilter("dirsItemsList.itemId", outInItemIds);
        }
        if (itemSearchQueryReqDto.getSellerId() != null) {
            String sellerId = String.valueOf(itemSearchQueryReqDto.getSellerId());
            osSearchVo.addEqualFilter("dirsItemsList.sellerId", sellerId);
        }
        if (itemSearchQueryReqDto.getShopId() != null) {
            String shopId = String.valueOf(itemSearchQueryReqDto.getShopId());
            osSearchVo.addEqualFilter("dirsItemsList.shopId", shopId);
        }
        if (itemSearchQueryReqDto.getShopIds() != null) {
            String[] shopIds = ConvertUtil.convert2Array(itemSearchQueryReqDto.getShopIds());
            osSearchVo.addInFilter("dirsItemsList.shopId", shopIds);
        }
        if (!CollectionUtils.isEmpty((Collection)itemSearchQueryReqDto.getDirIds())) {
            String[] dirIds = ConvertUtil.convert2Array(itemSearchQueryReqDto.getDirIds());
            osSearchVo.addInFilter("dirsItemsList.dirId", dirIds);
        }
        if (StringUtils.isNotBlank((CharSequence)itemSearchQueryReqDto.getProp())) {
            String[] props;
            for (String prop : props = itemSearchQueryReqDto.getProp().split(";")) {
                String[] searchData = prop.split(":");
                osSearchVo.addInFilter("searchAttr.searchAttr.name", searchData);
            }
        }
        if (itemSearchQueryReqDto.getLat() != null && itemSearchQueryReqDto.getLon() != null) {
            GeoShapeFieldVo.PointType pointType = new GeoShapeFieldVo.PointType(itemSearchQueryReqDto.getLat().doubleValue(), itemSearchQueryReqDto.getLon().doubleValue());
            GeoShapeFieldVo geoShapeFieldVo = new GeoShapeFieldVo("itemShopList.templateRegionList", ShapeType.POINT, pointType);
            osSearchVo.addGeoShapeQuery(new GeoShapeFieldVo[]{geoShapeFieldVo});
        }
        if (itemSearchQueryReqDto.getMinPrice() != null || itemSearchQueryReqDto.getMaxPrice() != null) {
            if (itemSearchQueryReqDto.getMinPrice() != null && itemSearchQueryReqDto.getMaxPrice() != null) {
                osSearchVo.addRangeFilter("minPrice", String.valueOf(itemSearchQueryReqDto.getMinPrice()), String.valueOf(itemSearchQueryReqDto.getMaxPrice()));
            } else {
                osSearchVo.addRangeFilter("minPrice", String.valueOf(itemSearchQueryReqDto.getMinPrice()), String.valueOf(itemSearchQueryReqDto.getMaxPrice()), LogicalSymbol.OR);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)itemSearchQueryReqDto.getOrderByDesc())) {
            if ("sales".equalsIgnoreCase(itemSearchQueryReqDto.getOrderByDesc())) {
                osSearchVo.addSort("salesCount");
            } else if ("price".equalsIgnoreCase(itemSearchQueryReqDto.getOrderByDesc())) {
                osSearchVo.addSort("minPrice");
            } else if ("shelfTime".equalsIgnoreCase(itemSearchQueryReqDto.getOrderByDesc())) {
                osSearchVo.addSort("itemShelfInfoList.shelfTime");
            }
        } else if (StringUtils.isNotBlank((CharSequence)itemSearchQueryReqDto.getOrderBy())) {
            if ("sales".equalsIgnoreCase(itemSearchQueryReqDto.getOrderBy())) {
                osSearchVo.addSort("salesCount", SortOrder.ASC);
            } else if ("price".equalsIgnoreCase(itemSearchQueryReqDto.getOrderBy())) {
                osSearchVo.addSort("minPrice", SortOrder.ASC);
            } else if ("shelfTime".equalsIgnoreCase(itemSearchQueryReqDto.getOrderByDesc())) {
                osSearchVo.addSort("itemShelfInfoList.shelfTime", SortOrder.ASC);
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("\u5546\u54c1\u641c\u7d22\u53c2\u6570osSearchVo={}", (Object)JSON.toJSONString((Object)osSearchVo));
        }
        SearchResultVo searchResultVo = this.search(osSearchVo);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("\u5546\u54c1\u641c\u7d22\u7ed3\u679csearchResultVo={}", (Object)JSON.toJSONString((Object)searchResultVo));
        }
        ItemSearchRespDto itemSearchRespDto = new ItemSearchRespDto();
        if (searchResultVo == null) {
            return itemSearchRespDto;
        }
        List itemRespDtoList = searchResultVo.getDocValues(docValue -> (ItemRespDto)BeanUtil.mapToBean((Map)docValue, ItemRespDto.class, (boolean)true));
        this.handleItemShop(itemRespDtoList, itemSearchRespDto, itemSearchQueryReqDto);
        itemRespDtoList = itemRespDtoList.stream().filter(itemRespDto -> null != itemRespDto.getShopId()).peek(itemRespDto -> {
            try {
                this.setShelfType((ItemRespDto)itemRespDto);
                this.setMinDistributionInfo((ItemRespDto)itemRespDto);
            }
            catch (Exception e) {
                this.logger.info("\u8bbe\u7f6e\u5f02\u5e38", (Throwable)e);
            }
        }).collect(Collectors.toList());
        PageInfo pageInfo = new PageInfo();
        pageInfo.setPageNum(pageNum.intValue());
        pageInfo.setPageSize(pageSize.intValue());
        pageInfo.setSize(itemRespDtoList.size());
        pageInfo.setPages(searchResultVo.getTotalPageNum().intValue());
        pageInfo.setTotal(searchResultVo.getTotalSize());
        pageInfo.setList(itemRespDtoList);
        itemSearchRespDto.setPageInfo(pageInfo);
        return itemSearchRespDto;
    }

    private void handleItemShop(List<ItemRespDto> itemRespDtoList, ItemSearchRespDto searchRespDto, ItemSearchQueryReqDto searchQueryReqDto) {
        if (null != searchQueryReqDto.getShopId()) {
            itemRespDtoList.forEach(itemRespDto -> itemRespDto.setShopId(searchQueryReqDto.getShopId()));
            return;
        }
        if (searchQueryReqDto.getLat() != null && searchQueryReqDto.getLon() != null) {
            List<ItemShopRespDto> rangeShopList = this.getRangeShopList(searchQueryReqDto.getLon(), searchQueryReqDto.getLat());
            if (!CollectionUtils.isEmpty(rangeShopList)) {
                searchRespDto.setRangeShopList(rangeShopList.stream().map(ItemShopRespDto::getShopId).collect(Collectors.toList()));
            }
            itemRespDtoList.forEach(itemRespDto -> this.setMiniDistantShop((ItemRespDto)itemRespDto, rangeShopList));
        } else {
            itemRespDtoList.forEach(itemRespDto -> itemRespDto.setShopId(((ItemShopRespDto)itemRespDto.getItemShopList().get(0)).getShopId()));
        }
    }

    private void setMinDistributionInfo(ItemRespDto itemRespDto) {
        if (!CollectionUtils.isEmpty((Collection)itemRespDto.getItemShelfInfoList())) {
            List shelfRespDtos = itemRespDto.getItemShelfInfoList().stream().filter(shelfDto -> shelfDto.getShopId().equals(itemRespDto.getShopId())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(shelfRespDtos)) {
                if (Integer.valueOf(1).equals(((ItemShelfRespDto)shelfRespDtos.get(0)).getDistribution())) {
                    itemRespDto.setDistribution(Integer.valueOf(1));
                    if (!CollectionUtils.isEmpty((Collection)itemRespDto.getDistributionFeeList())) {
                        BigDecimal min = itemRespDto.getDistributionFeeList().stream().filter(feeDto -> feeDto.getShopId() != null && feeDto.getShopId().equals(itemRespDto.getShopId())).map(DistributionFeeDto::getAmount).sorted().findFirst().orElse(BigDecimal.ZERO);
                        itemRespDto.setDistributionFee(min);
                    } else {
                        this.logger.info("\u5546\u54c1\u5206\u9500\u4f63\u91d1\u4e3a\u7a7a\uff0citemId={}, shopId={}", (Object)itemRespDto.getItemId(), (Object)itemRespDto.getShopId());
                    }
                }
            } else {
                this.logger.info("\u5546\u54c1\u4e0a\u67b6\u8bb0\u5f55\u4e3a\u7a7a\uff0citemId={}, shopId={}", (Object)itemRespDto.getItemId(), (Object)itemRespDto.getShopId());
            }
        }
    }

    private Long getMiniDistanceShopId(Map<Long, List<ItemShopRespDto>> shopRespDtoMap, List<ItemShopRespDto> sortShopList) {
        for (ItemShopRespDto itemShopRespDto : sortShopList) {
            if (shopRespDtoMap.get(itemShopRespDto.getShopId()) == null) continue;
            return itemShopRespDto.getShopId();
        }
        return null;
    }

    private Long getShippingShopId(List<ItemShopRespDto> itemShopList) {
        for (ItemShopRespDto itemShopRespDto : itemShopList) {
            if (itemShopRespDto.getBusinessType() == null || !itemShopRespDto.getBusinessType().equals(1)) continue;
            return itemShopRespDto.getShopId();
        }
        return null;
    }

    private List<ItemShopRespDto> getRangeShopList(Double lon, Double lat) {
        List shopEsDtos = (List)this.shopApi.queryRangeShopListByGeo(String.valueOf(lat), String.valueOf(lon), Boolean.valueOf(true)).getData();
        if (CollectionUtils.isEmpty((Collection)shopEsDtos)) {
            return Collections.EMPTY_LIST;
        }
        ArrayList shopRespDtos = Lists.newArrayList();
        shopEsDtos.forEach(shopEsDto -> {
            ItemShopRespDto itemShopRespDto = new ItemShopRespDto();
            CubeBeanUtils.copyProperties((Object)itemShopRespDto, (Object)shopEsDto, (String[])new String[]{"location", "templateRegionList"});
            if (!CollectionUtils.isEmpty((Collection)shopEsDto.getLocation())) {
                ArrayList location = Lists.newArrayList();
                shopEsDto.getLocation().forEach(locationDto -> {
                    LocationDto respDto = new LocationDto();
                    respDto.setLat(locationDto.getLat());
                    respDto.setLon(locationDto.getLon());
                });
                itemShopRespDto.setLocation((List)location);
            }
            if (!CollectionUtils.isEmpty((Collection)shopEsDto.getTemplateRegionList())) {
                ArrayList templateRegionList = Lists.newArrayList();
                shopEsDto.getTemplateRegionList().forEach(templateRegionRespDto -> {
                    TemplateRegionRespDto regionRespDto = new TemplateRegionRespDto();
                    regionRespDto.setCoordinates(templateRegionRespDto.getCoordinates());
                    regionRespDto.setType(templateRegionRespDto.getType());
                    regionRespDto.setWarehouseId(templateRegionRespDto.getWarehouseId());
                    templateRegionList.add(regionRespDto);
                });
                itemShopRespDto.setTemplateRegionList((List)templateRegionList);
            }
            shopRespDtos.add(itemShopRespDto);
        });
        return shopRespDtos;
    }

    private Long getShopId(List<ItemShopRespDto> itemShopList, Map<Long, List<ItemShopRespDto>> shopRespDtoMap, List<ItemShopRespDto> sortShop) {
        Long miniDistanceShopId = null;
        if (!CollectionUtils.isEmpty(sortShop)) {
            miniDistanceShopId = this.getMiniDistanceShopId(shopRespDtoMap, sortShop);
        }
        if (miniDistanceShopId == null) {
            return this.getShippingShopId(itemShopList);
        }
        return miniDistanceShopId;
    }

    private void setMiniDistantShop(ItemRespDto itemRespDto, List<ItemShopRespDto> sortShopList) {
        List itemShopList = itemRespDto.getItemShopList();
        Map<Long, List<ItemShopRespDto>> shopRespDtoMap = itemShopList.stream().collect(Collectors.groupingBy(ItemShopRespDto::getShopId));
        itemRespDto.setShopId(this.getShopId(itemShopList, shopRespDtoMap, sortShopList));
    }

    private void setShelfType(ItemRespDto itemRespDto) {
        List<ItemShopRespDto> itemShopRespDtos;
        Map<Long, List<ItemShopRespDto>> shopRespDtoMap = itemRespDto.getItemShopList().stream().collect(Collectors.groupingBy(ItemShopRespDto::getShopId));
        if (itemRespDto.getShopId() != null && !CollectionUtils.isEmpty(itemShopRespDtos = shopRespDtoMap.get(itemRespDto.getShopId()))) {
            itemRespDto.setShelfType(itemShopRespDtos.get(0).getShelfType());
        }
    }

    @Override
    public void sync() {
        this.logger.info("\u5546\u54c1\u6570\u636e\u5168\u91cf\u540c\u6b65\u8d5e\u672a\u5b9e\u73b0=====");
    }

    @Override
    public MessageResponse process(Object object) {
        if (object == null) {
            this.logger.error("\u63a5\u53d7\u5230\u7a7a\u7684MQ\u6d88\u606f");
            return MessageResponse.SUCCESS;
        }
        try {
            ItemSearchIndexMessageVo itemSearchIndexMessageVo = (ItemSearchIndexMessageVo)JSON.parseObject((String)object.toString(), ItemSearchIndexMessageVo.class);
            this.logger.info("\u5f00\u59cb\u5904\u7406es\u540c\u6b65\u6d88\u606f\uff0cmessageId\uff1a{}", (Object)itemSearchIndexMessageVo.getMessageId());
            switch (itemSearchIndexMessageVo.getOperation()) {
                case "ON_SHELF": {
                    this.refreshIndex(itemSearchIndexMessageVo);
                    break;
                }
                case "OFF_SHELF": {
                    this.refreshIndex(itemSearchIndexMessageVo);
                    break;
                }
                case "SALES_COUNT": {
                    this.refreshIndex(itemSearchIndexMessageVo);
                    break;
                }
                default: {
                    this.logger.error("\u672a\u77e5\u7684\u6d88\u606f\u5904\u7406\u7c7b\u578b:{}", (Object)JSON.toJSONString((Object)itemSearchIndexMessageVo));
                    break;
                }
            }
        }
        catch (Exception e) {
            this.logger.error("\u5546\u54c1\u540c\u6b65\u5230es\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            return MessageResponse.ERROR;
        }
        return MessageResponse.SUCCESS;
    }

    private List<ItemShopRespDto> getShopList(Set<Long> shopIds, List<ItemShelfRespDto> itemShelfRespDtos) {
        Map<Long, List<ItemShelfRespDto>> shopItemShelfMap = itemShelfRespDtos.stream().collect(Collectors.groupingBy(ItemShelfRespDto::getShopId));
        ArrayList<ItemShopRespDto> itemShopList = new ArrayList<ItemShopRespDto>();
        for (Long shopId : shopIds) {
            GeoDto geoDto;
            ShopDto shopDto = (ShopDto)RestResponseHelper.extractData((RestResponse)this.shopQueryApi.queryById(shopId.longValue(), new String[0]));
            ItemShopRespDto itemShopRespDto = new ItemShopRespDto();
            itemShopRespDto.setShopId(shopId);
            itemShopRespDto.setBusinessType(shopDto.getBusinessType());
            List<ItemShelfRespDto> shopItemSelfList = shopItemShelfMap.get(shopId);
            if (!CollectionUtils.isEmpty(shopItemSelfList)) {
                Integer type = shopItemSelfList.get(0).getType();
                itemShopRespDto.setShelfType(type);
            }
            if (itemShopRespDto.getBusinessType() == null) {
                itemShopRespDto.setBusinessType(Integer.valueOf(shopDto.getType().intValue()));
            }
            ArrayList<LocationDto> locationDtos = new ArrayList<LocationDto>();
            if (2 == itemShopRespDto.getBusinessType()) {
                geoDto = this.getShopDeliveryGeo(shopDto);
            } else {
                geoDto = new GeoDto();
                geoDto.setLongitude("-99.140625");
                geoDto.setLatitude("-40.044438");
            }
            if (null != geoDto) {
                LocationDto locationDto = new LocationDto();
                locationDto.setLon(Double.valueOf(geoDto.getLongitude()));
                locationDto.setLat(Double.valueOf(geoDto.getLatitude()));
                locationDtos.add(locationDto);
            }
            itemShopRespDto.setLocation(locationDtos);
            List<TemplateRegionRespDto> templateRegionList = 2 == itemShopRespDto.getBusinessType() ? this.getTemplateRegionRespDtoList(shopDto) : this.getRegionShippingList();
            itemShopRespDto.setTemplateRegionList(templateRegionList);
            itemShopList.add(itemShopRespDto);
        }
        return itemShopList;
    }

    private void createOrUpdateIndexGroupBySeller(ItemSearchIndexMessageVo itemSearchIndexMessageVo, ItemEo itemEo, List<ItemShelfRespDto> itemShelfRespDtos) {
        Long sellerId = itemSearchIndexMessageVo.getSellerId();
        this.logger.info("\u5546\u5bb6-\u5546\u54c1-\u4e1a\u52a1\u7c7b\u578b\u7ef4\u5ea6\u6784\u5efaES\u5546\u54c1\u6570\u636esellerId:{}\uff0citemId:{}, busType:{}", new Object[]{sellerId, itemSearchIndexMessageVo.getItemId(), itemSearchIndexMessageVo.getBusType()});
        List<ItemRespDto> itemRespDtoList = this.itemService.queryItemRespDto(Lists.newArrayList((Object[])new ItemEo[]{itemEo}), sellerId);
        if (CollectionUtils.isEmpty(itemRespDtoList)) {
            this.logger.error("\u6784\u5efa\u5546\u54c1\u6570\u636e\u5931\u8d25\uff0c\u5546\u54c1ID:{}\u4fe1\u606f\u4e0d\u5b58\u5728", (Object)itemSearchIndexMessageVo.getItemId());
            return;
        }
        ItemRespDto itemRespDto = itemRespDtoList.get(0);
        itemRespDto.setItemShelfInfoList(itemShelfRespDtos);
        this.buildSaleCount(itemRespDto);
        this.buildSearchAttr(itemRespDto);
        this.buildPrice(itemRespDto, itemShelfRespDtos);
        Set<Long> itemShopIdSet = itemShelfRespDtos.stream().map(ItemShelfRespDto::getShopId).collect(Collectors.toSet());
        itemRespDto.setItemShopList(this.getShopList(itemShopIdSet, itemShelfRespDtos));
        itemRespDto.setType(itemShelfRespDtos.get(0).getItemType());
        itemRespDto.setBusType(itemShelfRespDtos.get(0).getBusType());
        itemRespDto.setItemId(itemRespDto.getId());
        String groupKey = this.getIndexDocId(itemSearchIndexMessageVo.getSellerId(), itemSearchIndexMessageVo.getItemId(), itemSearchIndexMessageVo.getBusType());
        itemRespDto.setGroupKey(groupKey);
        IDistributionSetService distributionSetService = (IDistributionSetService)SpringBeanUtil.getBean(IDistributionSetService.class);
        if (null != distributionSetService) {
            List<DistributionFeeDto> feeDtos = distributionSetService.calculateFee(itemShelfRespDtos);
            itemRespDto.setDistributionFeeList(feeDtos);
        }
        this.logger.info("\u6784\u9020\u5546\u54c1es\u53c2\u6570itemRespDto={}", JSON.toJSON((Object)itemRespDto));
        try {
            long totalSize;
            OSSearchVo osSearchVo = new OSSearchVo();
            osSearchVo.addEqualFilter("id", itemRespDto.getGroupKey());
            SearchResultVo searchResultVo = this.search(osSearchVo);
            long l = totalSize = searchResultVo == null ? 0L : searchResultVo.getTotalSize();
            if (totalSize == 0L) {
                this.create(itemRespDto);
            } else {
                this.update(itemRespDto);
            }
        }
        catch (Exception e) {
            this.logger.error("\u5546\u54c1\u540c\u6b65\u5230ES\u51fa\u73b0\u5f02\u5e38,\u5e76\u4e14\u91cd\u65b0\u53d1\u9001MQ", (Throwable)e);
            this.index(itemSearchIndexMessageVo.getSellerId(), itemSearchIndexMessageVo.getItemId(), itemSearchIndexMessageVo.getBusType(), itemSearchIndexMessageVo.getOperation(), itemSearchIndexMessageVo.getRetry() + 1);
        }
    }

    private SearchResultVo search(OSSearchVo osSearchVo) {
        osSearchVo.setIndexName(this.INDEX_ITEM + "_" + "item_search");
        osSearchVo.setTypeName("item_search");
        return this.openSearchService.search(osSearchVo);
    }

    private void buildPrice(ItemRespDto itemRespDto, List<ItemShelfRespDto> itemShelfDtos) {
        BigDecimal max = BigDecimal.ZERO;
        BigDecimal min = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty(itemShelfDtos)) {
            List priceList = itemShelfDtos.stream().map(ItemShelfRespDto::getPrice).collect(Collectors.toList());
            max = (BigDecimal)priceList.stream().max(BigDecimal::compareTo).get();
            min = (BigDecimal)priceList.stream().min(BigDecimal::compareTo).get();
        }
        itemRespDto.setMinPrice(Double.valueOf(min.doubleValue()));
        itemRespDto.setMaxPrice(Double.valueOf(max.doubleValue()));
    }

    private void buildSaleCount(ItemRespDto itemRespDto) {
        StatEo statEo = new StatEo();
        statEo.setItemId(itemRespDto.getId());
        List statEoList = this.statDas.select((BaseEo)statEo);
        long salesCount = 0L;
        if (!CollectionUtils.isEmpty((Collection)statEoList)) {
            salesCount = statEoList.stream().mapToLong(StdStatEo::getSalesCount).sum();
        }
        itemRespDto.setSalesCount(Long.valueOf(salesCount));
    }

    private void buildSearchAttr(ItemRespDto itemRespDto) {
        String searchAttr;
        ItemAttributesEo itemAttributesEo = new ItemAttributesEo();
        itemAttributesEo.setItemId(itemRespDto.getId());
        itemAttributesEo = (ItemAttributesEo)this.itemAttributesDas.selectOne((BaseEo)itemAttributesEo);
        if (itemAttributesEo != null && StringUtils.isNotBlank((CharSequence)(searchAttr = itemAttributesEo.getSearchAttrs())) && searchAttr.startsWith("{")) {
            JSONObject jsonObject = JSON.parseObject((String)searchAttr);
            ArrayList searchAttrList = new ArrayList();
            for (String name : jsonObject.keySet()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("name", name);
                map.put("value", String.valueOf(jsonObject.get((Object)name)));
                searchAttrList.add(map);
            }
            itemRespDto.setSearchAttr(searchAttrList);
        }
    }

    private String getIndexDocId(Long sellerId, Long itemId, Integer busType) {
        return String.valueOf(sellerId) + itemId + busType;
    }

    private void refreshIndex(ItemSearchIndexMessageVo itemSearchIndexMessageVo) {
        this.logger.info("\u6839\u636e\u6d88\u606f\u5237\u65b0\u5546\u54c1\u7d22\u5f15ItemSearchIndexMessageVo\uff1a{}", JSON.toJSON((Object)itemSearchIndexMessageVo));
        ItemEo itemEo = (ItemEo)this.itemDas.selectByPrimaryKey(itemSearchIndexMessageVo.getItemId());
        if (null == itemEo) {
            this.logger.info("\u5546\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728itemId\uff1a{}", (Object)itemSearchIndexMessageVo.getItemId());
            return;
        }
        ShelfReqDto shelfReqDto = new ShelfReqDto();
        shelfReqDto.setItemId(itemSearchIndexMessageVo.getItemId());
        shelfReqDto.setSellerId(itemSearchIndexMessageVo.getSellerId());
        shelfReqDto.setStatus(ItemStatus.ITEM_ONSHELF.getStatus());
        shelfReqDto.setBusType(Integer.valueOf(itemSearchIndexMessageVo.getBusType()));
        List<ItemShelfRespDto> itemShelfRespDtos = this.itemService.queryItemShelfList(shelfReqDto);
        if (!CollectionUtils.isEmpty(itemShelfRespDtos)) {
            this.logger.info("\u67e5\u8be2\u5230\u5546\u54c1\u4e0a\u67b6\u6570\u91cf\uff1a{}", (Object)itemShelfRespDtos.size());
            Map<Long, List<ItemShelfRespDto>> sellerMap = itemShelfRespDtos.stream().collect(Collectors.groupingBy(ItemShelfRespDto::getSellerId));
            for (Long sellerId : sellerMap.keySet()) {
                List<ItemShelfRespDto> itemShelfList = sellerMap.get(sellerId);
                Map<Integer, List<ItemShelfRespDto>> bizTypeMap = itemShelfList.stream().collect(Collectors.groupingBy(ItemShelfRespDto::getBusType));
                for (Integer bizType : bizTypeMap.keySet()) {
                    this.createOrUpdateIndexGroupBySeller(itemSearchIndexMessageVo, itemEo, bizTypeMap.get(bizType));
                }
            }
        } else {
            this.logger.info("\u67e5\u8be2\u4e0d\u5230\u5546\u54c1\u4e0a\u67b6\u8bb0\u5f55");
            this.deleteByIndexId(this.getIndexDocId(itemSearchIndexMessageVo.getSellerId(), itemSearchIndexMessageVo.getItemId(), itemSearchIndexMessageVo.getBusType()));
        }
    }

    private List<TemplateRegionRespDto> getRegionShippingList() {
        List coordinateDtoList;
        ArrayList<TemplateRegionRespDto> templateRegionList = new ArrayList<TemplateRegionRespDto>();
        TemplateRegionRespDto templateRegionRespDto = new TemplateRegionRespDto();
        templateRegionRespDto.setWarehouseId(Long.valueOf(0L));
        templateRegionRespDto.setType("polygon");
        String geo = "[{\"lng\":62.929688,\"lat\":55.279115},{\"lng\":137.812500,\"lat\":57.704147},{\"lng\":136.582031,\"lat\":17.978733},{\"lng\":62.578125,\"lat\":19.145168},{\"lng\":62.929688,\"lat\":55.279115}]";
        if (StringUtils.isNotBlank((CharSequence)geo) && !CollectionUtils.isEmpty((Collection)(coordinateDtoList = JSON.parseArray((String)geo, CoordinateDto.class)))) {
            ArrayList list1 = new ArrayList();
            ArrayList list2 = new ArrayList();
            for (CoordinateDto coordinateDto : coordinateDtoList) {
                ArrayList<Double> list3 = new ArrayList<Double>();
                list3.add(coordinateDto.getLng());
                list3.add(coordinateDto.getLat());
                list2.add(list3);
            }
            list1.add(list2);
            templateRegionRespDto.setCoordinates(list1);
        }
        templateRegionList.add(templateRegionRespDto);
        return templateRegionList;
    }

    private GeoDto getShopDeliveryGeo(ShopDto shopDto) {
        ShopDeliveryDto shopDeliveryDto = shopDto.getShopDeliveryDto();
        GeoDto geoDto = null;
        if (shopDeliveryDto != null) {
            String[] geo = StringUtils.split((String)shopDeliveryDto.getGeo(), (String)",");
            geoDto = new GeoDto();
            geoDto.setLongitude(geo[0]);
            geoDto.setLatitude(geo[1]);
        }
        return geoDto;
    }

    private List<TemplateRegionRespDto> getTemplateRegionRespDtoList(ShopDto shopDto) {
        List geoList;
        String geoFence;
        ArrayList templateRegionRespDtoList = Lists.newArrayList();
        ShopDeliveryDto shopDeliveryDto = shopDto.getShopDeliveryDto();
        if (shopDeliveryDto != null && StringUtils.isNotBlank((CharSequence)(geoFence = shopDeliveryDto.getGeoFence())) && org.apache.commons.collections.CollectionUtils.isNotEmpty(geoList = Stream.of(StringUtils.split((String)geoFence, (String)";")).map(geo -> {
            String[] geoPoints = StringUtils.split((String)geo, (String)",");
            if (geoPoints != null && geoPoints.length > 1) {
                return new CoordinateDto(Double.valueOf(Double.parseDouble(geoPoints[0])), Double.valueOf(Double.parseDouble(geoPoints[1])));
            }
            return null;
        }).collect(Collectors.toList()))) {
            CoordinateDto startPoint = (CoordinateDto)geoList.get(0);
            CoordinateDto endPoint = (CoordinateDto)geoList.get(geoList.size() - 1);
            if (startPoint.getLng().compareTo(endPoint.getLng()) != 0 || startPoint.getLat().compareTo(endPoint.getLat()) != 0) {
                geoList.add(startPoint);
            }
            ArrayList geoFenceList = new ArrayList();
            for (CoordinateDto coordinateDto : geoList) {
                ArrayList<Double> pointsList = new ArrayList<Double>();
                pointsList.add(coordinateDto.getLng());
                pointsList.add(coordinateDto.getLat());
                geoFenceList.add(pointsList);
            }
            ArrayList coordinates = new ArrayList();
            coordinates.add(geoFenceList);
            templateRegionRespDtoList.add(new TemplateRegionRespDto(coordinates));
        }
        return templateRegionRespDtoList;
    }

    private void create(ItemRespDto itemRespDto) {
        IndexDocumentVo indexDocumentVo = this.newInstance();
        ArrayList contents = Lists.newArrayList();
        IndexDocContentVo indexDocContentVo = new IndexDocContentVo();
        indexDocContentVo.setIndexId(String.valueOf(itemRespDto.getGroupKey()));
        Map describe = CustomBeanUtils.describe((Object)itemRespDto);
        indexDocContentVo.setDocValueMap(describe);
        contents.add(indexDocContentVo);
        indexDocumentVo.setContents((List)contents);
        this.logger.info("\u65b0\u589e\u7d22\u5f15\u6570\u636e:{}", (Object)JSON.toJSONString((Object)indexDocumentVo));
        this.searchIndexService.addData(indexDocumentVo);
    }

    private void update(ItemRespDto itemRespDto) {
        IndexDocumentVo indexDocumentVo = this.newInstance();
        ArrayList contents = Lists.newArrayList();
        IndexDocContentVo indexDocContentVo = new IndexDocContentVo();
        indexDocContentVo.setIndexId(String.valueOf(itemRespDto.getGroupKey()));
        Map describe = CustomBeanUtils.describe((Object)itemRespDto);
        indexDocContentVo.setDocValueMap(describe);
        contents.add(indexDocContentVo);
        indexDocumentVo.setContents((List)contents);
        this.logger.info("\u66f4\u65b0\u7d22\u5f15\u6570\u636e:{}", (Object)JSON.toJSONString((Object)indexDocumentVo));
        this.searchIndexService.updateData(indexDocumentVo);
    }

    private void deleteByIndexId(String indexId) {
        IndexDocumentVo indexDocumentVo = this.newInstance();
        ArrayList contents = Lists.newArrayList();
        IndexDocContentVo indexDocContentVo = new IndexDocContentVo();
        indexDocContentVo.setIndexId(indexId);
        contents.add(indexDocContentVo);
        indexDocumentVo.setContents((List)contents);
        this.logger.info("\u6839\u636eindexId\u5220\u9664\u6570\u636e:{}", (Object)JSON.toJSONString((Object)indexDocumentVo));
        this.searchIndexService.deleteData(indexDocumentVo);
    }

    private Long generateId() {
        Long tenantCode = ServiceContext.getContext().getRequestTenantCode();
        Long workerId = IdGenrator.getWorkerId();
        return IdGenrator.nextId((long)workerId, (long)tenantCode);
    }

    private IndexDocumentVo newInstance() {
        return new IndexDocumentVo(this.INDEX_ITEM + "_" + "item_search", "item_search");
    }
}

