/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.base.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.UnitTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.UnitReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.UnitRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.exception.ItemBusinessRuntimeException;
import com.dtyunxi.yundt.cube.center.item.api.base.exception.ItemExceptionCode;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IUnitService;
import com.dtyunxi.yundt.cube.center.item.biz.base.util.QueryParamUtils;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.UnitDas;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.UnitEo;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="unitService")
public class UnitServiceImpl
implements IUnitService {
    @Resource
    private UnitDas unitDas;
    @Resource
    private IContext context;

    @Override
    public Long addUnit(UnitReqDto reqDto) {
        UnitEo unitEo = UnitEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)unitEo);
        unitEo.setTenantId(this.context.tenantId());
        unitEo.setInstanceId(this.context.instanceId());
        this.checkUnitCode(unitEo.getCode(), unitEo.getInstanceId(), unitEo.getTenantId());
        unitEo.setTenantId(this.context.tenantId());
        unitEo.setInstanceId(this.context.instanceId());
        this.unitDas.insert((BaseEo)unitEo);
        return unitEo.getId();
    }

    @Override
    public void modifyUnit(UnitReqDto reqDto) {
        UnitEo unitEo = (UnitEo)this.unitDas.selectByPrimaryKey(reqDto.getId());
        if (unitEo == null) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.RECORD_NOT_EXIST);
        }
        if (!unitEo.getCode().equals(reqDto.getCode())) {
            this.checkUnitCode(reqDto.getCode(), unitEo.getInstanceId(), unitEo.getTenantId());
        }
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)unitEo);
        this.unitDas.updateSelective((BaseEo)unitEo);
    }

    @Override
    public void modifyStatus(Long id, Integer status) {
        UnitEo unitEo = UnitEo.newInstance();
        unitEo.setId(id);
        unitEo.setStatus(status);
        this.unitDas.updateSelective((BaseEo)unitEo);
    }

    @Override
    public void removeById(String ids) {
        String[] id_array;
        for (String id : id_array = StringUtils.split((String)ids)) {
            this.unitDas.deleteById(Long.valueOf(id));
        }
    }

    @Override
    public UnitRespDto queryById(Long id) {
        UnitEo unitEo = (UnitEo)this.unitDas.selectByPrimaryKey(id);
        UnitRespDto unitRespDto = new UnitRespDto();
        DtoHelper.eo2Dto((BaseEo)unitEo, (BaseVo)unitRespDto);
        return unitRespDto;
    }

    @Override
    public PageInfo<UnitRespDto> queryByPage(String filters, Integer pageNum, Integer pageSize) {
        UnitReqDto dto = new UnitReqDto();
        if (StringUtils.isNotBlank((CharSequence)filters)) {
            dto = (UnitReqDto)JSON.parseObject((String)filters, UnitReqDto.class);
        }
        UnitEo unitEo = UnitEo.newInstance((Map)dto.getExtFields());
        DtoHelper.dto2Eo((BaseVo)dto, (BaseEo)unitEo);
        unitEo.setTenantId(this.context.tenantId());
        unitEo.setInstanceId(this.context.instanceId());
        QueryParamUtils.columnLike((BaseEo)unitEo, "code", unitEo.getCode());
        QueryParamUtils.columnLike((BaseEo)unitEo, "name", unitEo.getName());
        QueryParamUtils.fillQueryUpdateStartTime(dto.getUpdateTimeStart(), (BaseEo)unitEo);
        QueryParamUtils.fillQueryUpdateEndTime(dto.getUpdateTimeEnd(), (BaseEo)unitEo);
        if (StringUtils.isBlank((CharSequence)unitEo.getOrderByDesc())) {
            unitEo.setOrderByDesc("update_time");
        }
        PageInfo unitEoPageInfo = this.unitDas.selectPage((BaseEo)unitEo, pageNum, pageSize);
        ArrayList list = Lists.newArrayList();
        PageInfo pageInfo = new PageInfo((List)list);
        DtoHelper.eoList2DtoList((Collection)unitEoPageInfo.getList(), (Collection)list, UnitRespDto.class);
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)unitEoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        pageInfo.setList((List)list);
        return pageInfo;
    }

    @Override
    public List<UnitRespDto> queryList(String filters) {
        UnitReqDto dto = new UnitReqDto();
        if (StringUtils.isNotBlank((CharSequence)filters)) {
            dto = (UnitReqDto)JSON.parseObject((String)filters, UnitReqDto.class);
        }
        UnitEo unitEo = UnitEo.newInstance((Map)dto.getExtFields());
        DtoHelper.dto2Eo((BaseVo)dto, (BaseEo)unitEo);
        unitEo.setStatus(Integer.valueOf(1));
        unitEo.setTenantId(this.context.tenantId());
        unitEo.setInstanceId(this.context.instanceId());
        QueryParamUtils.columnLike((BaseEo)unitEo, "code", unitEo.getCode());
        QueryParamUtils.columnLike((BaseEo)unitEo, "name", unitEo.getName());
        QueryParamUtils.fillQueryUpdateStartTime(dto.getUpdateTimeStart(), (BaseEo)unitEo);
        QueryParamUtils.fillQueryUpdateEndTime(dto.getUpdateTimeEnd(), (BaseEo)unitEo);
        if (StringUtils.isBlank((CharSequence)unitEo.getOrderByDesc())) {
            unitEo.setOrderByDesc("update_time");
        }
        List unitEoList = this.unitDas.select((BaseEo)unitEo);
        ArrayList res = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)unitEoList, (Collection)res, UnitRespDto.class);
        return res;
    }

    @Override
    public List<UnitRespDto> queryByType(String type) {
        UnitEo unitEo = UnitEo.newInstance();
        unitEo.setType(type);
        unitEo.setStatus(Integer.valueOf(1));
        unitEo.setTenantId(this.context.tenantId());
        unitEo.setInstanceId(this.context.instanceId());
        List unitEos = this.unitDas.select((BaseEo)unitEo);
        ArrayList<UnitRespDto> unitRespDtoList = new ArrayList<UnitRespDto>();
        DtoHelper.eoList2DtoList((Collection)unitEos, unitRespDtoList, UnitRespDto.class);
        return unitRespDtoList;
    }

    @Override
    public List<UnitTypeEnum> queryUnitType() {
        List<UnitTypeEnum> res = Arrays.stream(UnitTypeEnum.values()).collect(Collectors.toList());
        return res;
    }

    @Override
    public List<UnitRespDto> queryByIds(List<Long> ids) {
        UnitEo unitEo = UnitEo.newInstance();
        unitEo.setOrderBy("id");
        ArrayList sqlFilters = Lists.newArrayList();
        sqlFilters.add(SqlFilter.in((String)"id", (Object)StringUtils.join(ids, (String)",")));
        unitEo.setSqlFilters((List)sqlFilters);
        List unitEoList = this.unitDas.select((BaseEo)unitEo);
        ArrayList unitRespDtoList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)unitEoList, (Collection)unitRespDtoList, UnitRespDto.class);
        return unitRespDtoList;
    }

    private void checkUnitCode(String code, Long instanceId, Long tenantId) {
        UnitEo unitEo = new UnitEo();
        unitEo.setCode(code);
        unitEo.setInstanceId(instanceId);
        unitEo.setTenantId(tenantId);
        if (this.unitDas.count((BaseEo)unitEo) > 0) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.CODE_EXISTS);
        }
    }
}

