/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.base.service.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.excel.ExcelUtils;
import com.dtyunxi.cube.framework.das.ComBaseDas;
import com.dtyunxi.cube.utils.FileUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.DirPropRelationModifyReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.DirPropRelationReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemPropRelationReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.PropGroupReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.PropNameCreateReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.PropNameReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.DirPropDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.DirPropRelationRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemPropRelationRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.PropGroupDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.PropGroupRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.PropGroupSearchRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.PropNameRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.PropNameSearchRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.exception.ItemBusinessRuntimeException;
import com.dtyunxi.yundt.cube.center.item.api.base.exception.ItemExceptionCode;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IPropService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.cache.ClearItemPropCache;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.dto.PropNameExcelDto;
import com.dtyunxi.yundt.cube.center.item.biz.base.util.QueryParamUtils;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.DirDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.DirPropRelationDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemPropRelationDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.PropGroupDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.PropGroupRelationDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.PropNameDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.PropValueDas;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.DirEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.DirPropRelationEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemPropRelationEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.PropGroupEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.PropGroupRelationEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.PropNameEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.PropValueEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StdDirPropRelationEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StdItemPropRelationEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StdPropGroupRelationEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StdPropValueEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

@Service(value="iPropService")
public class PropServiceImpl
implements IPropService {
    private static Logger logger = LoggerFactory.getLogger(PropServiceImpl.class);
    @Resource
    private PropGroupDas propGroupDas;
    @Resource
    private PropNameDas propNameDas;
    @Resource
    private PropValueDas propValueDas;
    @Resource
    private PropGroupRelationDas propGroupRelationDas;
    @Resource
    private DirPropRelationDas dirPropRelationDas;
    @Resource
    private DirDas dirDas;
    @Resource
    private ItemPropRelationDas itemPropRelationDas;
    @Resource
    private ItemDas itemDas;
    @Resource
    private ClearItemPropCache clearItemPropCache;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addProp(PropNameCreateReqDto propNameCreateReqDto) {
        Integer inputType;
        PropNameEo propNameEo = PropNameEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)propNameCreateReqDto, (BaseEo)propNameEo);
        propNameEo.setId(null);
        this.propNameDas.insert((BaseEo)propNameEo);
        if (propNameEo.getInputType() != null && (inputType = propNameEo.getInputType()) == 1) {
            Long id = propNameEo.getId();
            this.addPropValue(id, propNameCreateReqDto.getPropValueList(), propNameEo.getInstanceId(), propNameEo.getTenantId(), propNameEo.getSellerId());
        }
        return propNameEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchAddProp(List<PropNameCreateReqDto> propNameCreateReqDtoList) {
        if (CollectionUtils.isEmpty(propNameCreateReqDtoList)) {
            throw new ItemBusinessRuntimeException("10002", "\u8bf7\u5b8c\u5584\u5c5e\u6027\u4fe1\u606f");
        }
        for (PropNameCreateReqDto dto : propNameCreateReqDtoList) {
            this.addProp(dto);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyProp(Long propNameId, PropNameReqDto propNameReqDto) {
        PropNameEo propNameEo = (PropNameEo)this.propNameDas.selectByPrimaryKey(propNameId);
        if (propNameEo == null) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_PROPNAME.getCode(), ItemExceptionCode.NON_EXIST_PROPNAME.getMsg());
        }
        PropNameEo updatePropNameEo = PropNameEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)propNameReqDto, (BaseEo)updatePropNameEo);
        updatePropNameEo.setId(propNameId);
        this.propNameDas.updateSelective((BaseEo)updatePropNameEo);
        PropValueEo propValueEo = PropValueEo.newInstance();
        propValueEo.setPropNameId(propNameId);
        List queryList = this.propValueDas.select((BaseEo)propValueEo);
        if (CollectionUtils.isEmpty((Collection)propNameReqDto.getPropValueList())) {
            this.propValueDas.delete((BaseEo)propValueEo);
        } else {
            if (queryList.size() != 0) {
                this.propValueDas.delete((BaseEo)propValueEo);
            }
            if (propNameReqDto.getInputType() == 1) {
                this.addPropValue(propNameId, propNameReqDto.getPropValueList(), propNameEo.getInstanceId(), propNameEo.getTenantId(), propNameEo.getSellerId());
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyPropGroup(Long propGroupId, PropGroupReqDto propGroupReqDto) {
        PropGroupEo propGroupEo = PropGroupEo.newInstance();
        PropGroupEo queryEo = (PropGroupEo)this.propGroupDas.selectByPrimaryKey(propGroupId);
        if (null != queryEo) {
            DtoHelper.dto2Eo((BaseVo)propGroupReqDto, (BaseEo)propGroupEo);
            propGroupEo.setId(propGroupId);
            this.validPropGroupName(propGroupEo);
            this.propGroupRelationDas.deleteByPropGroupId(propGroupId);
            if (!CollectionUtils.isEmpty((Collection)propGroupReqDto.getPropNameReqDtos())) {
                List propNameIdList = propGroupReqDto.getPropNameReqDtos().stream().map(PropNameReqDto::getId).distinct().collect(Collectors.toList());
                List propGroupRelationEoList = propNameIdList.stream().map(propNameId -> {
                    PropGroupRelationEo eo = new PropGroupRelationEo();
                    eo.setPropNameId(propNameId);
                    eo.setPropGroupId(propGroupId);
                    eo.setInstanceId(queryEo.getInstanceId());
                    eo.setTenantId(queryEo.getTenantId());
                    eo.setSellerId(queryEo.getSellerId());
                    return eo;
                }).collect(Collectors.toList());
                this.propGroupRelationDas.insertBatch(propGroupRelationEoList);
            }
        } else {
            logger.error("\u8be5\u5c5e\u6027\u7ec4\u4e0d\u5b58\u5728");
            throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_PROPGROUP.getCode(), ItemExceptionCode.NON_EXIST_PROPGROUP.getMsg());
        }
        this.propGroupDas.updateSelective((BaseEo)propGroupEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addPropGroup(PropGroupReqDto propGroupReqDto) {
        PropGroupEo propGroupEo = PropGroupEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)propGroupReqDto, (BaseEo)propGroupEo);
        propGroupEo.setId(null);
        this.validPropGroupName(propGroupEo);
        this.propGroupDas.insert((BaseEo)propGroupEo);
        if (!CollectionUtils.isEmpty((Collection)propGroupReqDto.getPropNameReqDtos())) {
            List<PropNameReqDto> propNameReqDtos = this.removeRePropName(propGroupReqDto.getPropNameReqDtos());
            ArrayList<PropGroupRelationEo> propGroupRelationEoList = new ArrayList<PropGroupRelationEo>();
            for (PropNameReqDto propNameReqDto : propNameReqDtos) {
                PropGroupRelationEo propGroupRelationEo = PropGroupRelationEo.newInstance();
                propGroupRelationEo.setPropNameId(propNameReqDto.getId());
                propGroupRelationEo.setPropGroupId(propGroupEo.getId());
                propGroupRelationEo.setInstanceId(propGroupEo.getInstanceId());
                propGroupRelationEo.setTenantId(propGroupEo.getTenantId());
                propGroupRelationEo.setSellerId(propGroupEo.getSellerId());
                propGroupRelationEoList.add(propGroupRelationEo);
            }
            this.propGroupRelationDas.insertBatch(propGroupRelationEoList);
        }
        return propGroupEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchAddPropGroup(List<PropGroupReqDto> propGroupReqDtoList) {
        if (CollectionUtils.isEmpty(propGroupReqDtoList)) {
            throw new ItemBusinessRuntimeException("10002", "\u8bf7\u5b8c\u5584\u5c5e\u6027\u7ec4\u4fe1\u606f");
        }
        for (PropGroupReqDto dto : propGroupReqDtoList) {
            this.addPropGroup(dto);
        }
    }

    private void addPropValue(Long id, List<String> propValues, Long instanceId, Long tenantId, Long sellerId) {
        ArrayList<PropValueEo> propValueEoList = new ArrayList<PropValueEo>();
        for (String name : propValues) {
            PropValueEo propValueEo = PropValueEo.newInstance();
            propValueEo.setName(name);
            propValueEo.setPropNameId(id);
            propValueEo.setInstanceId(instanceId);
            propValueEo.setTenantId(tenantId);
            propValueEo.setSellerId(sellerId);
            propValueEoList.add(propValueEo);
        }
        this.propValueDas.insertBatch(propValueEoList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeProp(Long id) {
        if (!CollectionUtils.isEmpty((Collection)this.propGroupRelationDas.selectByPropNameId(id))) {
            throw new BizException("\u5c5e\u6027\u5df2\u7ecf\u88ab\u5c5e\u6027\u7ec4\u5f15\u7528, \u65e0\u6cd5\u5220\u9664");
        }
        if (!CollectionUtils.isEmpty((Collection)this.dirPropRelationDas.selectByPropNameId(id))) {
            throw new BizException("\u5c5e\u6027\u5df2\u7ecf\u88ab\u7c7b\u76ee\u5f15\u7528, \u65e0\u6cd5\u5220\u9664");
        }
        PropValueEo propValueEo = PropValueEo.newInstance();
        propValueEo.setPropNameId(id);
        this.propValueDas.logicDelete((BaseEo)propValueEo);
        this.propNameDas.logicDeleteById(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removePropGroup(Long id) {
        PropGroupRelationEo propGroupRelationEo = PropGroupRelationEo.newInstance();
        propGroupRelationEo.setPropGroupId(id);
        this.propGroupRelationDas.delete((BaseEo)propGroupRelationEo);
        this.propGroupDas.deleteById(id);
        DirPropRelationEo dirPropRelationEoParam = DirPropRelationEo.newInstance();
        dirPropRelationEoParam.setPropGroupId(id);
        this.dirPropRelationDas.delete((BaseEo)dirPropRelationEoParam);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addDirPropRelation(List<DirPropRelationReqDto> dirPropRelationReqDtos) {
        ArrayList dirPropRelationEos = new ArrayList();
        DtoHelper.dtoList2EoList(dirPropRelationReqDtos, dirPropRelationEos, DirPropRelationEo.class);
        for (DirPropRelationEo eo : dirPropRelationEos) {
            if (eo.getDirId() == null) {
                throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_PARAM.getCode(), ItemExceptionCode.NON_EXIST_PARAM.getMsg());
            }
            DirEo dirEo = (DirEo)this.dirDas.selectByPrimaryKey(eo.getDirId());
            if (dirEo == null) {
                throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_DIR.getCode(), ItemExceptionCode.NON_EXIST_DIR.getMsg());
            }
            if (1 == eo.getPropType()) {
                if (eo.getPropGroupId() == null) {
                    logger.error("PropGroupId is null");
                    throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_PARAM.getCode(), ItemExceptionCode.NON_EXIST_PARAM.getMsg());
                }
                PropGroupEo propGroupEo = (PropGroupEo)this.propGroupDas.selectByPrimaryKey(eo.getPropGroupId());
                if (propGroupEo == null) {
                    logger.error("\u8be5id\u5bf9\u5e94\u7684\u5c5e\u6027\u7ec4\u4e0d\u5b58\u5728");
                    throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_PROPGROUP.getCode(), ItemExceptionCode.NON_EXIST_PROPGROUP.getMsg());
                }
                eo.setPropNameId(Long.valueOf(0L));
            } else if (2 == eo.getPropType()) {
                if (eo.getPropNameId() == null) {
                    logger.error("PropNameId is null");
                    throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_PARAM.getCode(), ItemExceptionCode.NON_EXIST_PARAM.getMsg());
                }
                PropNameEo propNameEo = (PropNameEo)this.propNameDas.selectByPrimaryKey(eo.getPropNameId());
                if (propNameEo == null) {
                    logger.error("\u8be5id\u5bf9\u5e94\u7684\u5c5e\u6027\u540d\u4e0d\u5b58\u5728");
                    throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_PROPNAME.getCode(), ItemExceptionCode.NON_EXIST_PROPNAME.getMsg());
                }
                eo.setPropGroupId(Long.valueOf(0L));
            } else {
                logger.error("\u5c5e\u6027\u7c7b\u578b\u5fc5\u987b\u4e3a\u5c5e\u6027\u7ec4\u6216\u8005\u5c5e\u6027\u540d");
                throw new ItemBusinessRuntimeException(ItemExceptionCode.PROPTYPE_ERROR.getCode(), ItemExceptionCode.PROPTYPE_ERROR.getMsg());
            }
            if (this.dirPropRelationDas.count((BaseEo)eo) != 0) continue;
            this.dirPropRelationDas.insert((BaseEo)eo);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeDirPropRelation(List<Long> dirIdList) {
        if (CollectionUtils.isEmpty(dirIdList)) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR.getCode(), ItemExceptionCode.EMPTY_PARAM_ERROR.getMsg());
        }
        for (Long dirId : dirIdList) {
            DirPropRelationEo eo = DirPropRelationEo.newInstance();
            eo.setDirId(dirId);
            this.dirPropRelationDas.delete((BaseEo)eo);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyDirPropRelation(Long dirId, List<DirPropRelationReqDto> dirPropRelationReqDtos) {
        DirPropRelationEo eo = DirPropRelationEo.newInstance();
        eo.setDirId(dirId);
        if (!CollectionUtils.isEmpty((Collection)this.dirPropRelationDas.select((BaseEo)eo))) {
            this.dirPropRelationDas.delete((BaseEo)eo);
        }
        if (!CollectionUtils.isEmpty(dirPropRelationReqDtos)) {
            this.addDirPropRelation(dirPropRelationReqDtos);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyDirPropRelation(List<DirPropRelationModifyReqDto> dirPropRelationModifyReqDtoList) {
        if (CollectionUtils.isEmpty(dirPropRelationModifyReqDtoList)) {
            return;
        }
        for (DirPropRelationModifyReqDto dirPropRelationModifyReqDto : dirPropRelationModifyReqDtoList) {
            if (dirPropRelationModifyReqDto.getId() == null) {
                throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_PARAM);
            }
            DirEo dirEo = (DirEo)this.dirDas.selectByPrimaryKey(dirPropRelationModifyReqDto.getDirId());
            if (dirEo == null) {
                throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_DIR);
            }
            DirPropRelationEo dirPropRelationEo = new DirPropRelationEo();
            DtoHelper.dto2Eo((BaseVo)dirPropRelationModifyReqDto, (BaseEo)dirPropRelationEo);
            if (dirPropRelationModifyReqDto.getPropType() == 1) {
                if (dirPropRelationModifyReqDto.getPropGroupId() == null) {
                    throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_PARAM);
                }
                PropGroupEo propGroupEo = (PropGroupEo)this.propGroupDas.selectByPrimaryKey(dirPropRelationModifyReqDto.getPropGroupId());
                if (propGroupEo == null) {
                    throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_PROPGROUP);
                }
                dirPropRelationEo.setPropNameId(Long.valueOf(0L));
            } else if (dirPropRelationModifyReqDto.getPropType() == 2) {
                if (dirPropRelationModifyReqDto.getPropNameId() == null) {
                    throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_PARAM);
                }
                PropNameEo propNameEo = (PropNameEo)this.propNameDas.selectByPrimaryKey(dirPropRelationModifyReqDto.getPropNameId());
                if (propNameEo == null) {
                    throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_PROPNAME);
                }
                dirPropRelationEo.setPropGroupId(Long.valueOf(0L));
            } else {
                throw new ItemBusinessRuntimeException(ItemExceptionCode.PROPTYPE_ERROR);
            }
            this.dirPropRelationDas.updateSelective((BaseEo)dirPropRelationEo);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addPropNameByExcel(MultipartFile file) {
        try {
            InputStream in = file.getInputStream();
            String suffix = FileUtil.getFileExtension((String)file.getOriginalFilename());
            List propNameExcelDtoList = ExcelUtils.readExcel((InputStream)in, PropNameExcelDto.class, (int)2, (String)suffix);
            if (CollectionUtils.isEmpty((Collection)propNameExcelDtoList)) {
                throw new ItemBusinessRuntimeException("\u8868\u683c\u65e0\u6570\u636e");
            }
            ArrayList<PropNameCreateReqDto> propNameCreateReqDtoList = new ArrayList<PropNameCreateReqDto>();
            for (PropNameExcelDto dto : propNameExcelDtoList) {
                if (dto.getName() == null) {
                    throw new ItemBusinessRuntimeException("\u5c5e\u6027\u540d\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (dto.getInputType() != null) {
                    if (dto.getInputType() == 1 && dto.getPropValue() == null) {
                        throw new ItemBusinessRuntimeException("\u7f16\u8f91\u65b9\u5f0f\u4e3a\u591a\u9009\uff0c\u5c5e\u6027\u503c\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                } else {
                    throw new ItemBusinessRuntimeException("\u7f16\u8f91\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
                }
                PropNameCreateReqDto propNameCreateReqDto = new PropNameCreateReqDto();
                CubeBeanUtils.copyProperties((Object)propNameCreateReqDto, (Object)dto, (String[])new String[0]);
                String[] propValues = dto.getPropValue().trim().split(";");
                ArrayList propValueList = new ArrayList();
                Collections.addAll(propValueList, propValues);
                propNameCreateReqDto.setPropValueList(propValueList);
                propNameCreateReqDtoList.add(propNameCreateReqDto);
            }
            this.batchAddProp(propNameCreateReqDtoList);
        }
        catch (Exception e) {
            throw new ItemBusinessRuntimeException(e.getMessage() + "\u5bfc\u5165excel\u65b0\u589e\u6570\u636e\u5931\u8d25");
        }
    }

    @Override
    public void addItemPropRelation(List<ItemPropRelationReqDto> itemPropRelationReqDtos) {
        if (CollectionUtils.isEmpty(itemPropRelationReqDtos)) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR.getCode(), ItemExceptionCode.EMPTY_PARAM_ERROR.getMsg());
        }
        for (ItemPropRelationReqDto dto : itemPropRelationReqDtos) {
            if (this.itemDas.selectByPrimaryKey(dto.getItemId()) == null) {
                throw new ItemBusinessRuntimeException(ItemExceptionCode.RECORD_NOT_EXIST.getCode(), ItemExceptionCode.RECORD_NOT_EXIST.getMsg() + "ItemId:" + dto.getItemId());
            }
            if (this.propGroupDas.selectByPrimaryKey(dto.getPropGroupId()) == null) {
                throw new ItemBusinessRuntimeException(ItemExceptionCode.RECORD_NOT_EXIST.getCode(), ItemExceptionCode.RECORD_NOT_EXIST.getMsg() + "PropGroupId:" + dto.getPropGroupId());
            }
            ItemPropRelationEo itemPropRelationEo = ItemPropRelationEo.newInstance();
            DtoHelper.dto2Eo((BaseVo)dto, (BaseEo)itemPropRelationEo);
            itemPropRelationEo.setId(null);
            this.itemPropRelationDas.insert((BaseEo)itemPropRelationEo);
        }
    }

    @Override
    public PropNameRespDto queryPropNameById(Long propNameId) {
        PropNameEo propNameEo = (PropNameEo)this.propNameDas.selectByPrimaryKey(propNameId);
        if (propNameEo == null) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_PROPNAME.getCode(), ItemExceptionCode.NON_EXIST_PROPNAME.getMsg());
        }
        List<String> propValues = this.queryPropValue(propNameId);
        PropNameRespDto propNameRespDto = new PropNameRespDto();
        DtoHelper.eo2Dto((BaseEo)propNameEo, (BaseVo)propNameRespDto);
        propNameRespDto.setPropValueList(propValues);
        List<PropGroupDto> propGroupDtos = this.queryPropNameRelation(propNameEo);
        propNameRespDto.setPropGroupDtoList(propGroupDtos);
        List<DirPropDto> dirPropDtos = this.getDirPropDtos(propNameId, null);
        propNameRespDto.setDirPropDtoList(dirPropDtos);
        return propNameRespDto;
    }

    @Override
    public PropNameSearchRespDto queryPropNameByName(String keyword, Integer pageNum, Integer pageSize) {
        pageNum = null == pageNum ? ComBaseDas.DEFAULT_PAGE_NUMBER : pageNum;
        pageSize = null == pageSize ? ComBaseDas.DEFAULT_PAGE_SIZE : pageSize;
        PropNameSearchRespDto propNameSearchRespDto = new PropNameSearchRespDto();
        PropNameEo propNameEo = PropNameEo.newInstance();
        QueryParamUtils.columnLike((BaseEo)propNameEo, "name", keyword);
        PageInfo propNameEoPageInfo = this.propNameDas.selectPage((BaseEo)propNameEo, pageNum, pageSize);
        List propNameEoList = propNameEoPageInfo.getList();
        List<PropNameRespDto> propNameRespDtos = this.getPropNameRespDtos(propNameEoList);
        PageInfo propNameRespDtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)propNameRespDtoPageInfo, (Object)propNameEoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        propNameRespDtoPageInfo.setList(propNameRespDtos);
        propNameSearchRespDto.setPageInfo(propNameRespDtoPageInfo);
        return propNameSearchRespDto;
    }

    @Override
    public PageInfo<PropNameRespDto> queryPropNameByPage(PropNameReqDto propNameReqDto, Integer pageNum, Integer pageSize) {
        PropNameEo propNameEo = PropNameEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)propNameReqDto, (BaseEo)propNameEo);
        List<Object> propNameIds = new ArrayList();
        if (propNameReqDto.getDirId() != null) {
            DirPropRelationEo dirPropRelationEo = DirPropRelationEo.newInstance();
            dirPropRelationEo.setDirId(propNameReqDto.getDirId());
            List dirPropRelationEos = this.dirPropRelationDas.select((BaseEo)dirPropRelationEo);
            if (CollectionUtils.isEmpty((Collection)dirPropRelationEos)) {
                return new PageInfo();
            }
            propNameIds = dirPropRelationEos.stream().map(StdDirPropRelationEo::getPropNameId).collect(Collectors.toList());
        }
        if (!CollectionUtils.isEmpty(propNameIds)) {
            ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
            sqlFilters.add(SqlFilter.in((String)"id", (Object)StringUtils.join(propNameIds, (String)",")));
            propNameEo.setSqlFilters(sqlFilters);
        }
        QueryParamUtils.columnLike((BaseEo)propNameEo, "code", propNameEo.getCode());
        QueryParamUtils.columnLike((BaseEo)propNameEo, "name", propNameEo.getName());
        QueryParamUtils.fillQueryCreateStartTime(propNameReqDto.getCreateBeginTime(), (BaseEo)propNameEo, "ge");
        QueryParamUtils.fillQueryCreateEndTime(propNameReqDto.getCreateEndTime(), (BaseEo)propNameEo, "le");
        QueryParamUtils.fillQueryUpdateStartTime(propNameReqDto.getUpdateBeginTime(), (BaseEo)propNameEo, "ge");
        QueryParamUtils.fillQueryUpdateEndTime(propNameReqDto.getUpdateEndTime(), (BaseEo)propNameEo, "le");
        if (StringUtils.isBlank((CharSequence)propNameEo.getOrderByDesc())) {
            propNameEo.setOrderByDesc("update_time");
        }
        PageInfo propNameEoPageInfo = this.propNameDas.selectPage((BaseEo)propNameEo, pageNum, pageSize);
        List propNameEoList = propNameEoPageInfo.getList();
        ArrayList propNameRespDtos = Lists.newArrayList();
        if (!CollectionUtils.isEmpty((Collection)propNameEoList)) {
            CubeBeanUtils.copyCollection((Collection)propNameRespDtos, (Collection)propNameEoList, PropNameRespDto.class);
            propNameRespDtos.parallelStream().forEach(propNameRespDto -> {
                List<String> propValueList = this.queryPropValue(propNameRespDto.getId());
                propNameRespDto.setPropValueList(propValueList);
            });
        }
        PageInfo propNameRespDtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)propNameRespDtoPageInfo, (Object)propNameEoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        propNameRespDtoPageInfo.setList((List)propNameRespDtos);
        return propNameRespDtoPageInfo;
    }

    @Override
    public List<DirPropRelationRespDto> queryDirPropRelationById(Long dirId) {
        DirPropRelationEo eo = DirPropRelationEo.newInstance();
        eo.setDirId(dirId);
        List dirPropRelationEos = this.dirPropRelationDas.select((BaseEo)eo);
        ArrayList<DirPropRelationRespDto> dirPropRelationRespDtos = new ArrayList<DirPropRelationRespDto>();
        for (DirPropRelationEo dirPropRelationEo : dirPropRelationEos) {
            DirPropRelationRespDto dirPropRelationRespDto = new DirPropRelationRespDto();
            DtoHelper.eo2Dto((BaseEo)dirPropRelationEo, (BaseVo)dirPropRelationRespDto);
            if (dirPropRelationEo.getPropNameId() != 0L) {
                PropNameEo propNameEo = (PropNameEo)this.propNameDas.selectByPrimaryKey(dirPropRelationEo.getPropNameId());
                if (propNameEo == null) {
                    logger.error("\u67e5\u8be2\u76ee\u5f55\u5c5e\u6027\u5173\u8054\u5bf9\u5e94\u7684\u5c5e\u6027\u540d\u4e0d\u5b58\u5728");
                    throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_PROPNAME.getCode(), ItemExceptionCode.NON_EXIST_PROPNAME.getMsg());
                }
                PropNameRespDto propNameRespDto = new PropNameRespDto();
                DtoHelper.eo2Dto((BaseEo)propNameEo, (BaseVo)propNameRespDto);
                propNameRespDto.setPropValueList(this.queryPropValue(dirPropRelationEo.getPropNameId()));
                dirPropRelationRespDto.setPropNameRespDto(propNameRespDto);
            }
            if (dirPropRelationEo.getPropGroupId() != 0L) {
                PropGroupEo propGroupEo = (PropGroupEo)this.propGroupDas.selectByPrimaryKey(dirPropRelationEo.getPropGroupId());
                if (propGroupEo == null) {
                    logger.error("\u67e5\u8be2\u76ee\u5f55\u5c5e\u6027\u5173\u8054\u5bf9\u5e94\u7684\u5c5e\u6027\u7ec4\u4e0d\u5b58\u5728");
                    throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_PROPNAME.getCode(), ItemExceptionCode.NON_EXIST_PROPNAME.getMsg());
                }
                PropGroupRespDto propGroupRespDto = this.queryPropGroupRelation(propGroupEo);
                dirPropRelationRespDto.setPropGroupRespDto(propGroupRespDto);
            }
            dirPropRelationRespDtos.add(dirPropRelationRespDto);
        }
        return dirPropRelationRespDtos;
    }

    @Override
    public PropGroupRespDto queryPropGroupById(Long propGroupId) {
        PropGroupEo propGroupEo = (PropGroupEo)this.propGroupDas.selectByPrimaryKey(propGroupId);
        if (propGroupEo == null) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_PROPGROUP.getCode(), ItemExceptionCode.NON_EXIST_PROPGROUP.getMsg());
        }
        PropGroupRespDto propGroupRespDto = this.queryPropGroupRelation(propGroupEo);
        List<DirPropDto> dirPropDtos = this.getDirPropDtos(null, propGroupId);
        propGroupRespDto.setDirPropDtoList(dirPropDtos);
        return propGroupRespDto;
    }

    @Override
    public PropGroupSearchRespDto queryPropGroupByName(String keyword, Integer pageNum, Integer pageSize) {
        pageNum = null == pageNum ? ComBaseDas.DEFAULT_PAGE_NUMBER : pageNum;
        pageSize = null == pageSize ? ComBaseDas.DEFAULT_PAGE_SIZE : pageSize;
        PropGroupSearchRespDto propGroupSearchRespDto = new PropGroupSearchRespDto();
        PropGroupEo propGroupEo = PropGroupEo.newInstance();
        QueryParamUtils.columnLike((BaseEo)propGroupEo, "name", keyword);
        PageInfo propGroupEoPageInfo = this.propGroupDas.selectPage((BaseEo)propGroupEo, pageNum, pageSize);
        List propGroupEoList = propGroupEoPageInfo.getList();
        ArrayList<PropGroupRespDto> propGroupRespDtoList = new ArrayList<PropGroupRespDto>();
        for (PropGroupEo eo : propGroupEoList) {
            PropGroupRespDto propGroupRespDto = this.queryPropGroupRelation(eo);
            List<DirPropDto> dirPropDtos = this.getDirPropDtos(null, eo.getId());
            propGroupRespDto.setDirPropDtoList(dirPropDtos);
            propGroupRespDtoList.add(propGroupRespDto);
        }
        PageInfo propGroupRespDtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)propGroupRespDtoPageInfo, (Object)propGroupEoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        propGroupRespDtoPageInfo.setList(propGroupRespDtoList);
        propGroupSearchRespDto.setPageInfo(propGroupRespDtoPageInfo);
        return propGroupSearchRespDto;
    }

    @Override
    public PageInfo<PropGroupRespDto> queryPropGroupByPage(PropGroupReqDto propGroupReqDto, Integer pageNum, Integer pageSize) {
        PropGroupEo propGroupEo = PropGroupEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)propGroupReqDto, (BaseEo)propGroupEo);
        List<Object> propGroupIds = new ArrayList();
        if (propGroupReqDto.getDirId() != null) {
            DirPropRelationEo dirPropRelationEo = DirPropRelationEo.newInstance();
            dirPropRelationEo.setDirId(propGroupReqDto.getDirId());
            List dirPropRelationEos = this.dirPropRelationDas.select((BaseEo)dirPropRelationEo);
            if (CollectionUtils.isEmpty((Collection)dirPropRelationEos)) {
                return new PageInfo();
            }
            propGroupIds = dirPropRelationEos.stream().map(StdDirPropRelationEo::getPropGroupId).collect(Collectors.toList());
        }
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        if (!CollectionUtils.isEmpty(propGroupIds)) {
            sqlFilters.add(SqlFilter.in((String)"id", (Object)StringUtils.join(propGroupIds, (String)",")));
        }
        if (StringUtils.isNotBlank((CharSequence)propGroupReqDto.getPropName())) {
            PropNameEo propNameEoParam = PropNameEo.newInstance();
            propNameEoParam.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.like((String)"name", (Object)("%" + propGroupReqDto.getPropName() + "%"))}));
            List propNameEoList = this.propNameDas.select((BaseEo)propNameEoParam);
            if (!CollectionUtils.isEmpty((Collection)propNameEoList)) {
                List propNameIdList = propNameEoList.stream().map(BaseEo::getId).collect(Collectors.toList());
                PropGroupRelationEo propGroupRelationEoParam = PropGroupRelationEo.newInstance();
                ArrayList sqlFilters1 = Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.in((String)"prop_name_id", propNameIdList)});
                propGroupRelationEoParam.setSqlFilters((List)sqlFilters1);
                List propGroupRelationEoList = this.propGroupRelationDas.select((BaseEo)propGroupRelationEoParam);
                if (!CollectionUtils.isEmpty((Collection)propGroupRelationEoList)) {
                    List propGroupIdList = propGroupRelationEoList.stream().map(StdPropGroupRelationEo::getPropGroupId).distinct().collect(Collectors.toList());
                    sqlFilters.add(SqlFilter.in((String)"id", propGroupIdList));
                } else {
                    sqlFilters.add(SqlFilter.in((String)"id", (Object)0L));
                }
            } else {
                sqlFilters.add(SqlFilter.in((String)"id", (Object)0L));
            }
        }
        propGroupEo.setSqlFilters(sqlFilters);
        QueryParamUtils.columnLike((BaseEo)propGroupEo, "code", propGroupEo.getCode());
        QueryParamUtils.columnLike((BaseEo)propGroupEo, "name", propGroupEo.getName());
        QueryParamUtils.fillQueryCreateStartTime(propGroupReqDto.getCreateBeginTime(), (BaseEo)propGroupEo, "ge");
        QueryParamUtils.fillQueryCreateEndTime(propGroupReqDto.getCreateEndTime(), (BaseEo)propGroupEo, "le");
        QueryParamUtils.fillQueryUpdateStartTime(propGroupReqDto.getUpdateBeginTime(), (BaseEo)propGroupEo, "ge");
        QueryParamUtils.fillQueryUpdateEndTime(propGroupReqDto.getUpdateEndTime(), (BaseEo)propGroupEo, "le");
        propGroupEo.setOrderByDesc("update_time");
        PageInfo propGroupEoPageInfo = this.propGroupDas.selectPage((BaseEo)propGroupEo, pageNum, pageSize);
        ArrayList<PropGroupRespDto> propGroupRespDtoList = new ArrayList<PropGroupRespDto>();
        List propGroupEoList = propGroupEoPageInfo.getList();
        for (PropGroupEo eo : propGroupEoList) {
            PropGroupRespDto propGroupRespDto = this.queryPropGroupRelation(eo);
            List<DirPropDto> dirPropDtos = this.getDirPropDtos(null, eo.getId());
            propGroupRespDto.setDirPropDtoList(dirPropDtos);
            propGroupRespDtoList.add(propGroupRespDto);
        }
        PageInfo propGroupRespDtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)propGroupRespDtoPageInfo, (Object)propGroupEoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        propGroupRespDtoPageInfo.setList(propGroupRespDtoList);
        return propGroupRespDtoPageInfo;
    }

    @Override
    public List<ItemPropRelationRespDto> queryItemPropRelation(ItemPropRelationReqDto itemPropRelationReqDto) {
        ItemPropRelationEo itemPropRelationEo = ItemPropRelationEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)itemPropRelationReqDto, (BaseEo)itemPropRelationEo);
        itemPropRelationEo.setOrderBy("id");
        List itemPropRelationEoList = this.itemPropRelationDas.select((BaseEo)itemPropRelationEo);
        ArrayList<ItemPropRelationRespDto> itemPropRelationRespDtoList = new ArrayList<ItemPropRelationRespDto>();
        DtoHelper.eoList2DtoList((Collection)itemPropRelationEoList, itemPropRelationRespDtoList, ItemPropRelationRespDto.class);
        return itemPropRelationRespDtoList;
    }

    @Override
    @Cacheable(value={"ITEM_PROP_CACHE"}, key="#itemId", unless="#result== null")
    public List<ItemPropRelationRespDto> queryByItemId(Long itemId) {
        ItemPropRelationReqDto itemPropRelationReqDto = new ItemPropRelationReqDto();
        itemPropRelationReqDto.setItemId(itemId);
        return this.queryItemPropRelation(itemPropRelationReqDto);
    }

    public List<PropGroupDto> queryPropNameRelation(PropNameEo propNameEo) {
        PropGroupRelationEo propGroupRelationEo = PropGroupRelationEo.newInstance();
        propGroupRelationEo.setPropNameId(propNameEo.getId());
        List propGroupRelationEos = this.propGroupRelationDas.select((BaseEo)propGroupRelationEo);
        if (CollectionUtils.isEmpty((Collection)propGroupRelationEos)) {
            return new ArrayList<PropGroupDto>();
        }
        ArrayList<PropGroupDto> propGroupDtos = new ArrayList<PropGroupDto>();
        for (PropGroupRelationEo eo : propGroupRelationEos) {
            PropGroupEo propGroupEo = (PropGroupEo)this.propGroupDas.selectByPrimaryKey(eo.getPropGroupId());
            if (propGroupEo == null) continue;
            List<DirPropDto> dirPropDtos = this.getDirPropDtos(null, propGroupEo.getId());
            PropGroupDto propGroupDto = new PropGroupDto();
            DtoHelper.eo2Dto((BaseEo)propGroupEo, (BaseVo)propGroupDto);
            propGroupDto.setDirPropDtoList(dirPropDtos);
            propGroupDtos.add(propGroupDto);
        }
        return propGroupDtos;
    }

    public PropGroupRespDto queryPropGroupRelation(PropGroupEo propGroupEo) {
        List<PropNameEo> propNameEoList;
        PropGroupRespDto propGroupRespDto = new PropGroupRespDto();
        DtoHelper.eo2Dto((BaseEo)propGroupEo, (BaseVo)propGroupRespDto);
        List<Object> propNameRespDtoList = Lists.newArrayList();
        List propGroupRelationEos = this.propGroupRelationDas.selectByPropGroupId(propGroupEo.getId());
        if (!CollectionUtils.isEmpty((Collection)propGroupRelationEos) && !CollectionUtils.isEmpty(propNameEoList = propGroupRelationEos.stream().map(propGroupRelationEo -> (PropNameEo)this.propNameDas.selectByPrimaryKey(propGroupRelationEo.getPropNameId())).filter(Objects::nonNull).collect(Collectors.toList()))) {
            propNameRespDtoList = this.getPropNameRespDtos(propNameEoList);
        }
        propGroupRespDto.setPropNameRespDtos((List)propNameRespDtoList);
        return propGroupRespDto;
    }

    public List<String> queryPropValue(Long propNameId) {
        PropValueEo propValueEo = PropValueEo.newInstance();
        propValueEo.setPropNameId(propNameId);
        List propValueEoList = this.propValueDas.select((BaseEo)propValueEo);
        Collections.reverse(propValueEoList);
        ArrayList<String> propValues = new ArrayList<String>();
        for (PropValueEo eo : propValueEoList) {
            propValues.add(eo.getName());
        }
        return propValues;
    }

    public List<PropNameRespDto> getPropNameRespDtos(List<PropNameEo> propNameEoList) {
        ArrayList<PropNameRespDto> propNameRespDtos = new ArrayList<PropNameRespDto>();
        for (PropNameEo eo : propNameEoList) {
            List<String> propValues = this.queryPropValue(eo.getId());
            PropNameRespDto propNameRespDto = new PropNameRespDto();
            DtoHelper.eo2Dto((BaseEo)eo, (BaseVo)propNameRespDto);
            propNameRespDto.setPropValueList(propValues);
            List<PropGroupDto> propGroupDtos = this.queryPropNameRelation(eo);
            propNameRespDto.setPropGroupDtoList(propGroupDtos);
            List<DirPropDto> dirPropDtos = this.getDirPropDtos(eo.getId(), null);
            propNameRespDto.setDirPropDtoList(dirPropDtos);
            propNameRespDtos.add(propNameRespDto);
        }
        return propNameRespDtos;
    }

    private List<DirPropDto> getDirPropDtos(Long propNameId, Long propGroupId) {
        DirPropRelationEo dirPropRelationEo = DirPropRelationEo.newInstance();
        if (propNameId != null && propGroupId == null) {
            dirPropRelationEo.setPropNameId(propNameId);
        }
        if (propNameId == null && propGroupId != null) {
            dirPropRelationEo.setPropGroupId(propGroupId);
        }
        ArrayList<DirPropDto> dirPropDtos = new ArrayList<DirPropDto>();
        for (DirPropRelationEo eo : this.dirPropRelationDas.select((BaseEo)dirPropRelationEo)) {
            DirPropDto dirPropDto = new DirPropDto();
            DirEo dirEo = (DirEo)this.dirDas.selectByPrimaryKey(eo.getDirId());
            if (dirEo == null) {
                throw new ItemBusinessRuntimeException(ItemExceptionCode.RECORD_NOT_EXIST.getCode(), ItemExceptionCode.RECORD_NOT_EXIST.getMsg());
            }
            dirPropDto.setId(eo.getId());
            dirPropDto.setDirId(dirEo.getId());
            dirPropDto.setDirName(dirEo.getName());
            dirPropDto.setPropType(eo.getPropType());
            dirPropDto.setSellerId(eo.getSellerId());
            dirPropDtos.add(dirPropDto);
        }
        return dirPropDtos;
    }

    private void validPropGroupName(PropGroupEo propGroupEo) {
        if (propGroupEo.getName() != null) {
            PropGroupEo eo = PropGroupEo.newInstance();
            eo.setName(propGroupEo.getName());
            if (propGroupEo.getSellerId() != null) {
                eo.setSellerId(propGroupEo.getSellerId());
            }
            if (propGroupEo.getInstanceId() != null) {
                eo.setInstanceId(propGroupEo.getInstanceId());
            }
            if (propGroupEo.getTenantId() != null) {
                eo.setTenantId(propGroupEo.getTenantId());
            }
            if (propGroupEo.getId() == null) {
                if (this.propGroupDas.count((BaseEo)eo) > 0) {
                    throw new ItemBusinessRuntimeException(ItemExceptionCode.NAME_EXISTS.getCode(), ItemExceptionCode.NAME_EXISTS.getMsg() + "\u4e0d\u5141\u8bb8\u65b0\u589e");
                }
            } else {
                Long propGroupId = propGroupEo.getId();
                List propGroupEos = this.propGroupDas.select((BaseEo)eo);
                if (!CollectionUtils.isEmpty((Collection)propGroupEos)) {
                    if (propGroupEos.size() == 1) {
                        if (!((PropGroupEo)propGroupEos.get(0)).getId().equals(propGroupId)) {
                            throw new ItemBusinessRuntimeException(ItemExceptionCode.NAME_EXISTS.getCode(), ItemExceptionCode.NAME_EXISTS.getMsg() + "\u4e0d\u5141\u8bb8\u65b0\u589e");
                        }
                    } else {
                        throw new ItemBusinessRuntimeException(ItemExceptionCode.NAME_EXISTS.getCode(), ItemExceptionCode.NAME_EXISTS.getMsg() + "\u4e0d\u5141\u8bb8\u65b0\u589e");
                    }
                }
            }
        }
    }

    private List<PropNameReqDto> removeRePropName(List<PropNameReqDto> propNameReqDtos) {
        HashMap<Long, PropNameReqDto> propNameMap = new HashMap<Long, PropNameReqDto>();
        for (PropNameReqDto propNameReqDto : propNameReqDtos) {
            propNameMap.put(propNameReqDto.getId(), propNameReqDto);
        }
        ArrayList<PropNameReqDto> resultEos = new ArrayList<PropNameReqDto>();
        resultEos.addAll(propNameMap.values());
        return resultEos;
    }

    @Override
    public List<PropNameRespDto> queryPropNameListByDirId(Long dirId, Integer usageType) {
        ArrayList propNameRespDtoList = Lists.newArrayList();
        List dirPropRelationEoList = this.dirPropRelationDas.selectByDirId(dirId, Integer.valueOf(1), usageType);
        if (!CollectionUtils.isEmpty((Collection)dirPropRelationEoList)) {
            dirPropRelationEoList.forEach(dirPropRelationEo -> {
                List propNameEoList;
                List propGroupRelationEoList = this.propGroupRelationDas.selectByPropGroupId(dirPropRelationEo.getPropGroupId());
                if (!CollectionUtils.isEmpty((Collection)propGroupRelationEoList) && !CollectionUtils.isEmpty((Collection)(propNameEoList = this.propNameDas.selectByIdList(propGroupRelationEoList.stream().map(StdPropGroupRelationEo::getPropNameId).distinct().collect(Collectors.toList()))))) {
                    propNameEoList.forEach(propNameEo -> {
                        PropNameRespDto propNameRespDto = new PropNameRespDto();
                        DtoHelper.eo2Dto((BaseEo)propNameEo, (BaseVo)propNameRespDto);
                        List<Object> propValueList = Lists.newArrayList();
                        PropValueEo propValueEoParam = PropValueEo.newInstance();
                        propValueEoParam.setPropNameId(propNameEo.getId());
                        List propValueEoList = this.propValueDas.select((BaseEo)propValueEoParam);
                        if (!CollectionUtils.isEmpty((Collection)propValueEoList)) {
                            propValueList = propValueEoList.stream().map(StdPropValueEo::getName).collect(Collectors.toList());
                        }
                        propNameRespDto.setPropValueList((List)propValueList);
                        propNameRespDtoList.add(propNameRespDto);
                    });
                }
            });
        }
        return propNameRespDtoList;
    }

    @Override
    public List<PropNameRespDto> queryPropNameListByItemId(Long itemId) {
        ArrayList propNameRespDtoList = Lists.newArrayList();
        List itemPropRelationEoList = this.itemPropRelationDas.selectByParam(itemId, null);
        if (!CollectionUtils.isEmpty((Collection)itemPropRelationEoList)) {
            List propNameIdList = itemPropRelationEoList.stream().filter(itemPropRelationEo -> itemPropRelationEo.getPropNameId() != null).map(StdItemPropRelationEo::getPropNameId).collect(Collectors.toList());
            List propNameEoList = this.propNameDas.selectByIdList(propNameIdList);
            if (!CollectionUtils.isEmpty((Collection)propNameEoList)) {
                Map propNameEoMap = propNameEoList.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity()));
                itemPropRelationEoList.forEach(itemPropRelationEo -> {
                    PropNameRespDto propNameRespDto = new PropNameRespDto();
                    PropNameEo propNameEo = (PropNameEo)propNameEoMap.get(itemPropRelationEo.getPropNameId());
                    if (propNameEo != null) {
                        CubeBeanUtils.copyProperties((Object)propNameRespDto, (Object)propNameEo, (String[])new String[0]);
                        propNameRespDtoList.add(propNameRespDto);
                    }
                });
            }
            Map<Long, List<ItemPropRelationEo>> itemPropRelationEoMap = itemPropRelationEoList.stream().filter(itemPropRelationEo -> itemPropRelationEo.getPropNameId() != null).collect(Collectors.groupingBy(StdItemPropRelationEo::getPropNameId));
            propNameRespDtoList.forEach(propNameRespDto -> {
                List itemPropRelationEoList1 = (List)itemPropRelationEoMap.get(propNameRespDto.getId());
                if (!CollectionUtils.isEmpty((Collection)itemPropRelationEoList1) && StringUtils.isNotBlank((CharSequence)((ItemPropRelationEo)itemPropRelationEoList1.get(0)).getPropValue())) {
                    propNameRespDto.setPropValueList((List)Lists.newArrayList((Object[])StringUtils.split((String)((ItemPropRelationEo)itemPropRelationEoList1.get(0)).getPropValue(), (String)",")));
                }
            });
        }
        return propNameRespDtoList;
    }
}

